/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.subsystems.files.dstore.model;

import java.util.ArrayList;
import org.eclipse.dstore.core.model.DataElement;
import org.eclipse.rse.connectorservice.dstore.DStoreConnectorService;
import org.eclipse.rse.core.subsystems.IConnectorService;
import org.eclipse.rse.services.dstore.files.DStoreHostFile;
import org.eclipse.rse.services.dstore.files.DStoreVirtualHostFile;
import org.eclipse.rse.services.files.IHostFile;
import org.eclipse.rse.subsystems.files.core.servicesubsystem.FileServiceSubSystem;
import org.eclipse.rse.subsystems.files.core.subsystems.IHostFileToRemoteFileAdapter;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFile;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFileContext;
import org.eclipse.rse.subsystems.files.dstore.model.DStoreFile;
import org.eclipse.rse.subsystems.files.dstore.model.DStoreVirtualFile;
import org.eclipse.rse.subsystems.files.dstore.subsystem.RemoteFilePropertyChangeListener;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.swt.widgets.Shell;

public class DStoreFileAdapter
implements IHostFileToRemoteFileAdapter {
    private RemoteFilePropertyChangeListener _listener;

    private void registerFilePropertyChangeListener(FileServiceSubSystem ss) {
        if (this._listener == null) {
            DStoreConnectorService connectorService = (DStoreConnectorService)ss.getConnectorService();
            Shell shell = FileServiceSubSystem.getActiveWorkbenchShell();
            this._listener = new RemoteFilePropertyChangeListener(shell, (IConnectorService)connectorService, connectorService.getDataStore(), ss);
        }
    }

    public IRemoteFile[] convertToRemoteFiles(FileServiceSubSystem ss, IRemoteFileContext context, IRemoteFile parent, IHostFile[] nodes) {
        this.registerFilePropertyChangeListener(ss);
        boolean showHidden = RSEUIPlugin.getDefault().getPreferenceStore().getBoolean("org.eclipse.rse.preferences.showhidden");
        ArrayList<DStoreFile> results = new ArrayList<DStoreFile>();
        int i = 0;
        while (i < nodes.length) {
            DStoreHostFile node = (DStoreHostFile)nodes[i];
            if (showHidden || !node.isHidden()) {
                DStoreFile lfile = null;
                lfile = node instanceof DStoreVirtualHostFile ? new DStoreVirtualFile(ss, context, parent, (DStoreVirtualHostFile)node) : new DStoreFile(ss, context, parent, node);
                results.add(lfile);
                ss.cacheRemoteFile((IRemoteFile)lfile);
            }
            ++i;
        }
        return results.toArray(new IRemoteFile[results.size()]);
    }

    public IRemoteFile convertToRemoteFile(FileServiceSubSystem ss, IRemoteFileContext context, IRemoteFile parent, IHostFile node) {
        this.registerFilePropertyChangeListener(ss);
        DStoreFile file = null;
        file = node instanceof DStoreVirtualHostFile ? new DStoreVirtualFile(ss, context, parent, (DStoreVirtualHostFile)node) : new DStoreFile(ss, context, parent, (DStoreHostFile)node);
        ss.cacheRemoteFile((IRemoteFile)file);
        return file;
    }

    public IRemoteFile convertToRemoteFile(FileServiceSubSystem ss, IRemoteFileContext context, IRemoteFile parent, String name, boolean isDirectory, boolean isRoot) {
        return null;
    }

    public IRemoteFile convertToRemoteFile(FileServiceSubSystem ss, IRemoteFileContext context, IRemoteFile parent, Object object) {
        this.registerFilePropertyChangeListener(ss);
        if (object instanceof DataElement) {
            DStoreHostFile hostFile = new DStoreHostFile((DataElement)object);
            DStoreFile file = null;
            file = new DStoreFile(ss, context, parent, hostFile);
            ss.cacheRemoteFile((IRemoteFile)file);
            return file;
        }
        return null;
    }
}

