/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.subsystems.files.dstore.old;

import java.util.List;
import java.util.Vector;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.dstore.core.model.DataElement;
import org.eclipse.dstore.core.model.DataStore;
import org.eclipse.dstore.extra.internal.extra.DomainEvent;
import org.eclipse.dstore.extra.internal.extra.IDomainListener;
import org.eclipse.rse.connectorservice.dstore.util.ICommunicationsDiagnostic;
import org.eclipse.rse.connectorservice.dstore.util.ICommunicationsDiagnosticFactory;
import org.eclipse.rse.core.SystemBasePlugin;
import org.eclipse.rse.core.subsystems.CommunicationsEvent;
import org.eclipse.rse.core.subsystems.ICommunicationsListener;
import org.eclipse.rse.core.subsystems.IConnectorService;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class StatusChangeListener
implements IDomainListener,
ICommunicationsListener {
    protected DataElement target;
    protected Shell shell;
    protected IProgressMonitor monitor;
    protected IConnectorService system;
    protected boolean _networkDown = false;
    protected boolean done = false;
    protected boolean cancelled = false;
    protected Vector historyOfTargets;

    public StatusChangeListener(Shell shell, IProgressMonitor monitor, IConnectorService system, DataElement target) {
        this.shell = shell;
        this.monitor = monitor;
        this.target = target;
        this.system = system;
        system.addCommunicationsListener((ICommunicationsListener)this);
        this.historyOfTargets = new Vector();
    }

    public StatusChangeListener(Shell shell, IProgressMonitor monitor, IConnectorService system) {
        this(shell, monitor, system, null);
    }

    public StatusChangeListener(IConnectorService system) {
        this(null, null, system, null);
    }

    public void setStatus(DataElement p_target) {
        this.target = p_target;
        int i = 0;
        while (i < this.historyOfTargets.size()) {
            if (this.target == this.historyOfTargets.elementAt(i)) {
                this.setDone(true);
                this.historyOfTargets.clear();
                return;
            }
            ++i;
        }
        this.historyOfTargets.clear();
    }

    public DataElement getStatus() {
        return this.target;
    }

    public boolean listeningTo(DomainEvent event) {
        if (this.target == null) {
            return true;
        }
        return this.target == event.getParent();
    }

    public void domainChanged(DomainEvent event) {
        boolean isStatusDone;
        if (this.target == null && this.historyOfTargets.size() < 1000) {
            this.historyOfTargets.addElement(event.getParent());
        }
        if (this.target == event.getParent() && (isStatusDone = this.determineStatusDone())) {
            this.setDone(true);
        }
    }

    public void setDone(boolean done) {
        this.done = done;
    }

    public Shell getShell() {
        if (this.shell == null || this.shell.isDisposed()) {
            FindShell findShell = new FindShell();
            Display.getDefault().syncExec((Runnable)findShell);
            this.shell = findShell.shell;
        }
        return this.shell;
    }

    public boolean wasCancelled() {
        return this.cancelled;
    }

    public void communicationsStateChange(CommunicationsEvent e) {
        if (e.getState() == 5) {
            this._networkDown = true;
        }
    }

    public DataElement waitForUpdate() throws InterruptedException {
        return this.waitForUpdate(null, 0);
    }

    public DataElement waitForUpdate(ICommunicationsDiagnosticFactory factory) throws InterruptedException {
        return this.waitForUpdate(factory, 0);
    }

    /*
     * Unable to fully structure code
     */
    public DataElement waitForUpdate(ICommunicationsDiagnosticFactory factory, int wait) throws InterruptedException {
        block18: {
            block17: {
                statusDone = this.determineStatusDone();
                if (!statusDone) break block17;
                this.setDone(true);
                break block18;
            }
            display = Display.getCurrent();
            WaitThreshold = 600;
            if (wait > 0) {
                WaitThreshold = wait * 10;
            } else if (wait == -1) {
                WaitThreshold = -1;
            }
            diagnostic = null;
            diagnosticStarted = false;
            if (display == null) ** GOTO lbl72
            if (this.shell == null || this.shell.isDisposed()) {
                this.shell = Display.getDefault().getActiveShell();
            }
            while (!this.done && !this.cancelled) {
                while (display.readAndDispatch()) {
                }
                if (this.monitor != null && this.monitor.isCanceled()) {
                    this.cancelled = true;
                    this.target.getDataStore().getDomainNotifier().removeDomainListener((IDomainListener)this);
                    this.system.removeCommunicationsListener((ICommunicationsListener)this);
                    throw new InterruptedException();
                }
                statusDone = this.determineStatusDone();
                if (statusDone) {
                    this.setDone(true);
                    continue;
                }
                Thread.sleep(100L);
                if (factory != null) {
                    if (WaitThreshold > 0) {
                        --WaitThreshold;
                    }
                    if (WaitThreshold < 1 && !diagnosticStarted && diagnostic == null) {
                        diagnosticStarted = true;
                        diagnostic = this.whatIsGoingOn(factory, false);
                        continue;
                    }
                    if (!diagnosticStarted || diagnostic == null || 1 != diagnostic.diagnosticStatus()) continue;
                    this.cancelled = true;
                    SystemBasePlugin.logError((String)"StatusChangeListener.waitForUpdate cancelled by user.");
                    continue;
                }
                if (!this._networkDown) continue;
                this.target.getDataStore().getDomainNotifier().removeDomainListener((IDomainListener)this);
                this.system.removeCommunicationsListener((ICommunicationsListener)this);
                throw new InterruptedException();
            }
            break block18;
lbl-1000:
            // 1 sources

            {
                if (this.monitor != null && this.monitor.isCanceled()) {
                    this.cancelled = true;
                    this.target.getDataStore().getDomainNotifier().removeDomainListener((IDomainListener)this);
                    this.system.removeCommunicationsListener((ICommunicationsListener)this);
                    throw new InterruptedException();
                }
                statusDone = this.determineStatusDone();
                if (statusDone) {
                    this.setDone(true);
                    continue;
                }
                Thread.sleep(100L);
                if (factory != null) {
                    if (WaitThreshold > 0) {
                        --WaitThreshold;
                    }
                    if (WaitThreshold < 1 && !diagnosticStarted && diagnostic == null) {
                        diagnosticStarted = true;
                        diagnostic = this.whatIsGoingOn(factory, false);
                        continue;
                    }
                    if (!diagnosticStarted || diagnostic == null || 1 != diagnostic.diagnosticStatus()) continue;
                    this.cancelled = true;
                    SystemBasePlugin.logError((String)"StatusChangeListener.waitForUpdate cancelled by user.");
                    continue;
                }
                if (!this._networkDown) continue;
                this.target.getDataStore().getDomainNotifier().removeDomainListener((IDomainListener)this);
                this.system.removeCommunicationsListener((ICommunicationsListener)this);
                throw new InterruptedException();
lbl72:
                // 6 sources

                ** while (!this.done && !this.cancelled)
            }
        }
        this.done = false;
        this.system.removeCommunicationsListener((ICommunicationsListener)this);
        return this.target;
    }

    protected boolean determineStatusDone() {
        return this.getStatus().getAttribute(3).equals("done") || this.getStatus().getAttribute(2).equals("done");
    }

    public boolean isPassiveCommunicationsListener() {
        return false;
    }

    public ICommunicationsDiagnostic whatIsGoingOn(ICommunicationsDiagnosticFactory factory, boolean quiet) throws InterruptedException {
        if (this.target == null) {
            return null;
        }
        ICommunicationsDiagnostic d = null;
        DataStore ds = null;
        try {
            String name = this.getStatus().getName();
            SystemBasePlugin.logError((String)("StatusChangeListener." + name + ": " + "Communications Diagnostic started"));
            SystemBasePlugin.logError((String)("StatusChangeListener." + name + ": done = " + this.done + "; cancelled = " + this.cancelled + "; _networkDown = " + this._networkDown));
            ds = this.target.getDataStore();
            SystemBasePlugin.logError((String)("StatusChangeListener." + name + "(DataStore): " + " isConnected = " + ds.isConnected() + "; isWaiting = " + ds.isWaiting(this.target)));
            List deList = this.target.getParent().getNestedData();
            if (deList != null && !deList.isEmpty()) {
                int num = deList.size();
                int i = 0;
                while (i < num) {
                    DataElement child = (DataElement)deList.get(i);
                    if (child != null) {
                        SystemBasePlugin.logError((String)("StatusChangeListener." + name + ".child" + i + "(DataElement): " + child.toString()));
                        DataElement descriptor = child.getDescriptor();
                        if (descriptor != null) {
                            SystemBasePlugin.logError((String)("StatusChangeListener." + name + ".child" + i + "(Descriptor):  " + descriptor.toString()));
                        }
                    }
                    ++i;
                }
            }
            if (factory != null) {
                d = factory.createInstance();
                d.setUp(name, quiet, ds.getName(), this.system, null, null, null);
                new Thread((Runnable)d).start();
            }
        }
        catch (Exception e) {
            SystemBasePlugin.logError((String)"StatusChangeListener.ICommunicationsDiagnostic exception: ", (Throwable)e);
        }
        return d;
    }

    public boolean isNetworkDown() {
        return this._networkDown;
    }

    protected class FindShell
    implements Runnable {
        private Shell shell;

        protected FindShell() {
        }

        public void run() {
            try {
                Shell[] shells = Display.getCurrent().getShells();
                int loop = 0;
                while (loop < shells.length && this.shell == null) {
                    if (shells[loop].isEnabled()) {
                        this.shell = shells[loop];
                    }
                    ++loop;
                }
            }
            catch (Exception e) {
                SystemBasePlugin.logError((String)"StatusChangeListener.FindShell exception: ", (Throwable)e);
            }
        }
    }
}

