/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.services.processes;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.rse.services.clientserver.messages.SystemMessage;
import org.eclipse.rse.services.clientserver.messages.SystemMessageException;
import org.eclipse.rse.services.clientserver.processes.HostProcessFilterImpl;
import org.eclipse.rse.services.clientserver.processes.IHostProcess;
import org.eclipse.rse.services.clientserver.processes.IHostProcessFilter;
import org.eclipse.rse.services.processes.IProcessService;

public abstract class AbstractProcessService
implements IProcessService {
    public IHostProcess[] listAllProcesses(IProgressMonitor monitor, String exeNameFilter, String userNameFilter, String stateFilter) throws SystemMessageException {
        HostProcessFilterImpl rpfs = new HostProcessFilterImpl();
        rpfs.setName(exeNameFilter);
        rpfs.setUsername(userNameFilter);
        rpfs.setSpecificState(stateFilter);
        return this.listAllProcesses(monitor, rpfs);
    }

    public IHostProcess[] listAllProcesses(IProgressMonitor monitor) throws SystemMessageException {
        HostProcessFilterImpl rpfs = new HostProcessFilterImpl();
        return this.listAllProcesses(monitor, rpfs);
    }

    public IHostProcess[] listRootProcesses(IProgressMonitor monitor) throws SystemMessageException {
        IHostProcess[] roots = new IHostProcess[]{this.getProcess(monitor, 1L)};
        return roots;
    }

    public IHostProcess[] listChildProcesses(IProgressMonitor monitor, long parentPID) throws SystemMessageException {
        String pPidString = "" + parentPID;
        HostProcessFilterImpl rpfs = new HostProcessFilterImpl();
        rpfs.setPpid(pPidString);
        return this.listAllProcesses(monitor, rpfs);
    }

    public IHostProcess[] listChildProcesses(IProgressMonitor monitor, long parentPID, IHostProcessFilter filter) throws SystemMessageException {
        String pPidString = "" + parentPID;
        filter.setPpid(pPidString);
        return this.listAllProcesses(monitor, filter);
    }

    public IHostProcess getParentProcess(IProgressMonitor monitor, long PID) throws SystemMessageException {
        return this.getProcess(monitor, this.getProcess(monitor, PID).getPPid());
    }

    public IHostProcess getProcess(IProgressMonitor monitor, long PID) throws SystemMessageException {
        String pidString = "" + PID;
        HostProcessFilterImpl rpfs = new HostProcessFilterImpl();
        rpfs.setPid(pidString);
        IHostProcess[] results = this.listAllProcesses(monitor, rpfs);
        if (results == null) {
            return null;
        }
        return results[0];
    }

    public SystemMessage getMessage(String messageID) {
        return null;
    }
}

