/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.services.dstore.files;

import java.io.File;
import org.eclipse.dstore.core.model.DataElement;
import org.eclipse.rse.services.clientserver.PathUtility;
import org.eclipse.rse.services.clientserver.archiveutils.ArchiveHandlerManager;
import org.eclipse.rse.services.files.IHostFile;

public class DStoreHostFile
implements IHostFile {
    public static final int ATTRIBUTE_MODIFIED_DATE = 1;
    public static final int ATTRIBUTE_SIZE = 2;
    public static final int ATTRIBUTE_CLASSIFICATION = 11;
    protected DataElement _element;
    protected boolean _isArchive;

    public DStoreHostFile(DataElement element) {
        this._element = element;
        this._isArchive = this.internalIsArchive();
    }

    public DataElement getDataElement() {
        return this._element;
    }

    public static String getNameFromPath(String path) {
        int lastSlash = path.lastIndexOf(47);
        if (lastSlash > 0 && lastSlash != path.length() - 1) {
            return path.substring(lastSlash);
        }
        return path;
    }

    public static String getParentPathFromPath(String path) {
        int lastSlash = path.lastIndexOf(47);
        if (lastSlash > 0 && lastSlash != path.length() - 1) {
            return path.substring(0, lastSlash);
        }
        return path;
    }

    public String getName() {
        String type = this._element.getType();
        if (type.equals("universal.FilterObject")) {
            String path = this._element.getName();
            return DStoreHostFile.getNameFromPath(path);
        }
        String name = this._element.getName();
        String parentPath = this.getParentPath();
        if (name.length() == 0 && (parentPath.equals("/") || parentPath.endsWith(":\\"))) {
            return this.getParentPath();
        }
        return name;
    }

    public String getParentPath() {
        String type = this._element.getType();
        if (type.equals("universal.FilterObject")) {
            String path = this._element.getName();
            return DStoreHostFile.getParentPathFromPath(path);
        }
        return this._element.getValue();
    }

    public boolean isHidden() {
        String name = this.getName();
        if (name == null || name.length() == 0) {
            return false;
        }
        return name.charAt(0) == '.';
    }

    public boolean isDirectory() {
        String type = this._element.getType();
        return type.equals("universal.FolderObject") || type.equals("universal.VirtualFolderObject");
    }

    public boolean isRoot() {
        String parentPath = this.getParentPath();
        String name = this._element.getName();
        return parentPath == null || parentPath.length() == 0 || name.length() == 0 && (parentPath.equals("/") || parentPath.endsWith(":\\"));
    }

    public boolean isFile() {
        String type = this._element.getType();
        return type.equals("universal.FileObject") || type.equals("universal.VirtualFileObject") || type.equals("universal.ArchiveFileObject");
    }

    public boolean exists() {
        String type = this._element.getType();
        return type.equals("universal.FileObject") || type.equals("universal.FolderObject") || type.equals("universal.VirtualFileObject") || type.equals("universal.VirtualFolderObject") || type.equals("universal.ArchiveFileObject");
    }

    public String getAbsolutePath() {
        String parentPath = this.getParentPath();
        String name = this._element.getName();
        String type = this._element.getType();
        if (type.equals("universal.FilterObject")) {
            return name;
        }
        if (name.length() == 0) {
            return PathUtility.normalizeUnknown((String)parentPath);
        }
        return PathUtility.normalizeUnknown((String)(String.valueOf(parentPath) + "/" + name));
    }

    public long getSize() {
        return DStoreHostFile.getFileLength(this._element.getSource());
    }

    public long getModifiedDate() {
        return DStoreHostFile.getModifiedDate(this._element.getSource());
    }

    public String getClassification() {
        String classification = DStoreHostFile.getClassification(this._element.getSource());
        if (classification == null) {
            classification = this.isFile() ? "file" : "directory";
        }
        return classification;
    }

    protected static String getClassification(String attributes) {
        return DStoreHostFile.getAttribute(attributes, 11);
    }

    protected static long getFileLength(String attributes) {
        String str = DStoreHostFile.getAttribute(attributes, 2);
        return Long.parseLong(str);
    }

    protected static long getModifiedDate(String attributes) {
        String str = DStoreHostFile.getAttribute(attributes, 1);
        return Long.parseLong(str);
    }

    protected static String getAttribute(String attributes, int index) {
        String[] str = attributes.split("\\|");
        if (str.length > index) {
            return str[index];
        }
        return null;
    }

    public void renameTo(String newAbsolutePath) {
        this._element.setAttribute(2, newAbsolutePath);
        this._isArchive = this.internalIsArchive();
    }

    protected boolean internalIsArchive() {
        String path = this.getAbsolutePath();
        return ArchiveHandlerManager.getInstance().isArchive(new File(path)) && !ArchiveHandlerManager.isVirtual((String)path);
    }

    public boolean isArchive() {
        return this._isArchive;
    }
}

