/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.subsystems.shells.core.subsystems.servicesubsystem;

import org.eclipse.rse.internal.subsystems.shells.servicesubsystem.OutputRefreshJob;
import org.eclipse.rse.internal.subsystems.shells.subsystems.RemoteCommandShell;
import org.eclipse.rse.internal.subsystems.shells.subsystems.RemoteError;
import org.eclipse.rse.internal.subsystems.shells.subsystems.RemoteOutput;
import org.eclipse.rse.services.shells.IHostShell;
import org.eclipse.rse.services.shells.IHostShellChangeEvent;
import org.eclipse.rse.subsystems.shells.core.ShellStrings;
import org.eclipse.rse.subsystems.shells.core.subsystems.ICandidateCommand;
import org.eclipse.rse.subsystems.shells.core.subsystems.IRemoteCmdSubSystem;
import org.eclipse.rse.subsystems.shells.core.subsystems.IRemoteOutput;
import org.eclipse.rse.subsystems.shells.core.subsystems.servicesubsystem.IServiceCommandShell;

public class ServiceCommandShell
extends RemoteCommandShell
implements IServiceCommandShell {
    protected IHostShell _hostShell;
    protected OutputRefreshJob _lastRefreshJob;

    public ServiceCommandShell(IRemoteCmdSubSystem cmdSS, IHostShell hostShell) {
        super(cmdSS);
        this._hostShell = hostShell;
        this.setType(ShellStrings.RESID_SHELLS_COMMAND_SHELL_LABEL);
    }

    public String getTitle() {
        return this.getId();
    }

    public boolean isActive() {
        return this._hostShell.isActive();
    }

    public IHostShell getHostShell() {
        return this._hostShell;
    }

    public void shellOutputChanged(IHostShellChangeEvent event) {
        Object[] lines = event.getLines();
        IRemoteOutput[] outputs = new IRemoteOutput[lines.length];
        int i = 0;
        while (i < lines.length) {
            String line;
            RemoteOutput output = null;
            Object lineObj = lines[i];
            if (lineObj instanceof String && (line = (String)lineObj) != null) {
                String type = event.isError() ? "stderr" : "stdout";
                output = event.isError() ? new RemoteError(this, type) : new RemoteOutput(this, type);
                output.setText(line);
                this.addOutput(output);
                outputs[i] = output;
            }
            ++i;
        }
        if (this._lastRefreshJob == null || this._lastRefreshJob.isComplete()) {
            this._lastRefreshJob = new OutputRefreshJob(this, outputs, false);
            this._lastRefreshJob.schedule();
        }
    }

    public ICandidateCommand[] getCandidateCommands() {
        return null;
    }

    public void writeToShell(String cmd) {
        this._hostShell.writeToShell(cmd);
    }
}

