/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.services.local.files;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.rse.services.clientserver.ISystemFileTypes;
import org.eclipse.rse.services.clientserver.NamePatternMatcher;
import org.eclipse.rse.services.clientserver.SystemEncodingUtil;
import org.eclipse.rse.services.clientserver.archiveutils.AbsoluteVirtualPath;
import org.eclipse.rse.services.clientserver.archiveutils.ArchiveHandlerManager;
import org.eclipse.rse.services.clientserver.archiveutils.ISystemArchiveHandler;
import org.eclipse.rse.services.clientserver.archiveutils.VirtualChild;
import org.eclipse.rse.services.clientserver.messages.SystemMessage;
import org.eclipse.rse.services.clientserver.messages.SystemMessageException;
import org.eclipse.rse.services.files.AbstractFileService;
import org.eclipse.rse.services.files.IFileService;
import org.eclipse.rse.services.files.IHostFile;
import org.eclipse.rse.services.local.ILocalService;
import org.eclipse.rse.services.local.files.LocalHostFile;
import org.eclipse.rse.services.local.files.LocalServiceResources;
import org.eclipse.rse.services.local.files.LocalVirtualHostFile;

public class LocalFileService
extends AbstractFileService
implements IFileService,
ILocalService {
    private static final String[] ALLDRIVES = new String[]{"c:\\", "d:\\", "e:\\", "f:\\", "g:\\", "h:\\", "i:\\", "j:\\", "k:\\", "l:\\", "m:\\", "n:\\", "o:\\", "p:\\", "q:\\", "r:\\", "s:\\", "t:\\", "u:\\", "v:\\", "w:\\", "x:\\", "y:\\", "z:\\"};
    private boolean _checkedOS = false;
    private boolean _isWindows = false;
    private boolean _isWin95 = false;
    private boolean _isWinNT = false;
    private String _osCmdShell = null;
    protected ISystemFileTypes _fileTypeRegistry;

    public LocalFileService(ISystemFileTypes fileTypeRegistry) {
        this._fileTypeRegistry = fileTypeRegistry;
    }

    public String getName() {
        return LocalServiceResources.Local_File_Service_Name;
    }

    public String getDescription() {
        return LocalServiceResources.Local_File_Service_Description;
    }

    public boolean isWindows() {
        if (!this._checkedOS) {
            String osName = System.getProperty("os.name").toLowerCase();
            this._isWindows = osName.startsWith("win");
            this._isWin95 = this._isWindows && (osName.indexOf("95") >= 0 || osName.indexOf("98") >= 0 || osName.indexOf("me") >= 0);
            boolean bl = this._isWinNT = this._isWindows && (osName.indexOf("nt") >= 0 || osName.indexOf("2000") >= 0 || osName.indexOf("xp") >= 0);
            if (this._isWinNT) {
                this._osCmdShell = "cmd /C ";
            } else if (this._isWin95) {
                this._osCmdShell = "start /B ";
            }
            this._checkedOS = true;
        }
        return this._isWindows;
    }

    /*
     * Exception decompiling
     */
    public boolean upload(IProgressMonitor monitor, InputStream stream, String remoteParent, String remoteFile, boolean isBinary, String hostEncoding) throws SystemMessageException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 6[TRYBLOCK] [12 : 478->481)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public boolean download(IProgressMonitor monitor, String remoteParent, String remoteFile, File destinationFile, boolean isBinary, String hostEncoding) throws SystemMessageException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 5[TRYBLOCK] [5 : 473->476)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean copyToArchive(File file, File destination, String newName, IProgressMonitor monitor, String sourceEncoding, String targetEncoding, boolean isText) throws SystemMessageException {
        boolean ok = false;
        if (ArchiveHandlerManager.isVirtual((String)destination.getAbsolutePath())) {
            ISystemArchiveHandler handler;
            VirtualChild virtualChild = ArchiveHandlerManager.getInstance().getVirtualObject(destination.getAbsolutePath());
            String path = virtualChild.fullName;
            if (!virtualChild.isDirectory) {
                path = virtualChild.path;
            }
            if ((handler = virtualChild.getHandler()) == null) {
                this.throwCorruptArchiveException(this.getClass() + ".copyToArchive()");
            }
            ok = file.isDirectory() ? handler.add(file, path, newName, sourceEncoding, targetEncoding, this._fileTypeRegistry) : handler.add(file, path, newName, sourceEncoding, targetEncoding, isText);
        } else if (ArchiveHandlerManager.getInstance().isArchive(destination)) {
            ISystemArchiveHandler handler = ArchiveHandlerManager.getInstance().getRegisteredHandler(destination);
            if (handler == null) {
                this.throwCorruptArchiveException(this.getClass() + ".copyToArchive()");
            }
            ok = file.isDirectory() ? handler.add(file, "", newName, sourceEncoding, targetEncoding, this._fileTypeRegistry) : handler.add(file, "", newName, sourceEncoding, targetEncoding, isText);
        }
        if (!ok) {
            SystemMessage msg = this.getMessage("RSEF5006");
            msg.makeSubstitution((Object)destination.getName(), (Object)"localhost");
            throw new SystemMessageException(msg);
        }
        return true;
    }

    /*
     * Exception decompiling
     */
    public boolean upload(IProgressMonitor monitor, File localFile, String remoteParent, String remoteFile, boolean isBinary, String srcEncoding, String hostEncoding) throws SystemMessageException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 4[TRYBLOCK] [4 : 471->474)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected IHostFile[] internalFetch(IProgressMonitor monitor, String remoteParent, String fileFilter, int type) {
        LocalFileNameFilter fFilter = new LocalFileNameFilter(fileFilter);
        File localParent = new File(remoteParent);
        if (remoteParent.endsWith("#virtual#/")) {
            remoteParent = remoteParent.substring(0, remoteParent.length() - "#virtual#/".length());
        }
        boolean isVirtual = ArchiveHandlerManager.isVirtual((String)remoteParent);
        boolean isArchive = ArchiveHandlerManager.getInstance().isArchive(localParent);
        if (isVirtual || isArchive) {
            VirtualChild[] contents;
            block11: {
                contents = null;
                File theFile = this.getContainingArchive(localParent);
                if (isArchive) {
                    contents = ArchiveHandlerManager.getInstance().getContents(localParent, "");
                } else if (isVirtual) {
                    AbsoluteVirtualPath avp = new AbsoluteVirtualPath(remoteParent);
                    contents = ArchiveHandlerManager.getInstance().getContents(theFile, avp.getVirtualPart());
                }
                if (contents != null) break block11;
                return null;
            }
            try {
                IHostFile[] results = new LocalVirtualHostFile[contents.length];
                int i = 0;
                while (i < contents.length) {
                    results[i] = new LocalVirtualHostFile(contents[i]);
                    ++i;
                }
                return results;
            }
            catch (IOException iOException) {
                return null;
            }
        }
        if (!fFilter.isGeneric()) {
            File file = new File(localParent, fileFilter);
            return this.convertToHostFiles(new File[]{file}, type);
        }
        if (localParent.exists()) {
            File[] files = localParent.listFiles(fFilter);
            return this.convertToHostFiles(files, type);
        }
        return new IHostFile[0];
    }

    protected IHostFile[] convertToHostFiles(File[] files, int type) {
        ArrayList<LocalHostFile> results = new ArrayList<LocalHostFile>();
        if (files != null) {
            int i = 0;
            while (i < files.length) {
                File file = files[i];
                if (file.isDirectory()) {
                    if (type == 0 || type == 2) {
                        results.add(new LocalHostFile(file));
                    }
                } else if (file.isFile()) {
                    if (type == 0 || type == 1) {
                        results.add(new LocalHostFile(file));
                    }
                } else if (!file.exists()) {
                    results.add(new LocalHostFile(file));
                }
                ++i;
            }
        }
        return results.toArray(new IHostFile[results.size()]);
    }

    public IHostFile getUserHome() {
        String userHome = System.getProperty("user.home");
        File userHomeFile = new File(userHome);
        return new LocalHostFile(userHomeFile);
    }

    public IHostFile[] getRoots(IProgressMonitor monitor) {
        ArrayList<File> v = new ArrayList<File>();
        if (this.isWindows()) {
            int idx = 0;
            while (idx < ALLDRIVES.length) {
                File drive = new File(ALLDRIVES[idx]);
                if (drive.exists()) {
                    try {
                        v.add(drive.getAbsoluteFile());
                    }
                    catch (Exception exception) {}
                }
                ++idx;
            }
        } else {
            v.add(new File("/"));
        }
        IHostFile[] fileObjs = new LocalHostFile[v.size()];
        int idx = 0;
        while (idx < v.size()) {
            fileObjs[idx] = new LocalHostFile((File)v.get(idx), true);
            ++idx;
        }
        return fileObjs;
    }

    public IHostFile getFile(IProgressMonitor monitor, String remoteParent, String name) {
        if (name.endsWith("#virtual#/")) {
            name = name.substring(0, name.length() - "#virtual#/".length());
        }
        boolean isVirtualParent = ArchiveHandlerManager.isVirtual((String)remoteParent);
        boolean isArchiveParent = ArchiveHandlerManager.getInstance().isArchive(new File(remoteParent));
        if (!isVirtualParent && !isArchiveParent) {
            File file = null;
            file = remoteParent == null ? new File(name) : new File(remoteParent, name);
            file.getParentFile();
            return new LocalHostFile(file);
        }
        String fullpath = remoteParent;
        fullpath = isArchiveParent ? String.valueOf(fullpath) + "#virtual#/" : String.valueOf(fullpath) + "/";
        VirtualChild vc = ArchiveHandlerManager.getInstance().getVirtualObject(String.valueOf(fullpath) + name);
        LocalVirtualHostFile results = new LocalVirtualHostFile(vc);
        return results;
    }

    public IHostFile createFile(IProgressMonitor monitor, String remoteParent, String fileName) throws SystemMessageException {
        File parentFile = new File(remoteParent);
        File fileToCreate = new File(parentFile, fileName);
        if (!fileToCreate.exists()) {
            if (ArchiveHandlerManager.isVirtual((String)fileToCreate.getAbsolutePath())) {
                return this.createFileInArchive(fileToCreate);
            }
            if (!parentFile.exists()) {
                parentFile.mkdirs();
            } else {
                try {
                    fileToCreate.createNewFile();
                    if (ArchiveHandlerManager.getInstance().isArchive(fileToCreate) && !ArchiveHandlerManager.getInstance().createEmptyArchive(fileToCreate)) {
                        throw new SystemMessageException(this.getMessage("RSEG1122"));
                    }
                }
                catch (Exception exception) {}
            }
        }
        return new LocalHostFile(fileToCreate);
    }

    protected LocalVirtualHostFile createFileInArchive(File newFile) throws SystemMessageException {
        VirtualChild child = ArchiveHandlerManager.getInstance().getVirtualObject(newFile.getAbsolutePath());
        ISystemArchiveHandler handler = child.getHandler();
        if (handler == null) {
            this.throwCorruptArchiveException(this.getClass() + ".createFileInArchive()");
        }
        if (!handler.createFile(child.fullName)) {
            throw new SystemMessageException(this.getMessage("RSEG1124").makeSubstitution((Object)newFile));
        }
        return new LocalVirtualHostFile(child);
    }

    private void throwCorruptArchiveException(String classAndMethod) throws SystemMessageException {
        throw new SystemMessageException(this.getMessage("RSEG1122"));
    }

    protected File getContainingArchive(File file) {
        String absPath = file.getAbsolutePath();
        AbsoluteVirtualPath avp = new AbsoluteVirtualPath(absPath);
        return new File(avp.getContainingArchiveString());
    }

    protected String getVirtualPart(String absPath) {
        AbsoluteVirtualPath avp = new AbsoluteVirtualPath(absPath);
        return avp.getVirtualPart();
    }

    public IHostFile createFolder(IProgressMonitor monitor, String remoteParent, String folderName) throws SystemMessageException {
        File folderToCreate = new File(remoteParent, folderName);
        if (!folderToCreate.exists()) {
            if (ArchiveHandlerManager.isVirtual((String)folderToCreate.getAbsolutePath())) {
                return this.createFolderInArchive(folderToCreate);
            }
            folderToCreate.mkdirs();
        }
        return new LocalHostFile(folderToCreate);
    }

    protected LocalVirtualHostFile createFolderInArchive(File newFolder) throws SystemMessageException {
        VirtualChild child = ArchiveHandlerManager.getInstance().getVirtualObject(newFolder.getAbsolutePath());
        ISystemArchiveHandler handler = child.getHandler();
        if (handler == null) {
            this.throwCorruptArchiveException(this.getClass() + ".createFolderInArchive()");
        }
        if (!handler.createFolder(child.fullName)) {
            throw new SystemMessageException(this.getMessage("RSEG1124").makeSubstitution((Object)newFolder));
        }
        return new LocalVirtualHostFile(child);
    }

    public boolean delete(IProgressMonitor monitor, String remoteParent, String fileName) throws SystemMessageException {
        File fileToDelete;
        if (fileName.endsWith("#virtual#/")) {
            fileName = fileName.substring(0, fileName.length() - "#virtual#/".length());
        }
        if (ArchiveHandlerManager.isVirtual((String)(fileToDelete = new File(remoteParent, fileName)).getAbsolutePath())) {
            return this.deleteFromArchive(fileToDelete);
        }
        if (ArchiveHandlerManager.getInstance().isArchive(fileToDelete)) {
            return this.deleteArchive(fileToDelete);
        }
        if (fileToDelete.isDirectory()) {
            return this.deleteContents(monitor, fileToDelete);
        }
        return fileToDelete.delete();
    }

    private boolean deleteContents(IProgressMonitor monitor, File folder) {
        boolean result = true;
        File[] files = folder.listFiles();
        int i = 0;
        while (i < files.length && result) {
            File file = files[i];
            result = file.isDirectory() ? this.deleteContents(monitor, file) : file.delete();
            ++i;
        }
        if (result) {
            result = folder.delete();
        }
        return result;
    }

    protected boolean deleteFromArchive(File destination) throws SystemMessageException {
        VirtualChild child = ArchiveHandlerManager.getInstance().getVirtualObject(destination.getAbsolutePath());
        ISystemArchiveHandler handler = child.getHandler();
        if (handler == null) {
            this.throwCorruptArchiveException(this.getClass() + ".deleteFromArchive()");
        }
        if (!handler.delete(child.fullName)) {
            throw new SystemMessageException(this.getMessage("RSEG1125").makeSubstitution((Object)destination));
        }
        return true;
    }

    protected boolean deleteArchive(File file) {
        ArchiveHandlerManager.getInstance().disposeOfRegisteredHandlerFor(file);
        return file.delete();
    }

    public boolean rename(IProgressMonitor monitor, String remoteParent, String oldName, String newName) throws SystemMessageException {
        File fileToRename = new File(remoteParent, oldName);
        if (ArchiveHandlerManager.isVirtual((String)fileToRename.getAbsolutePath())) {
            return this.renameVirtualFile(fileToRename, newName);
        }
        File newFile = new File(remoteParent, newName);
        return fileToRename.renameTo(newFile);
    }

    public boolean rename(IProgressMonitor monitor, String remoteParent, String oldName, String newName, IHostFile oldFile) throws SystemMessageException {
        boolean retVal = this.rename(monitor, remoteParent, oldName, newName);
        File newFile = new File(remoteParent, newName);
        oldFile.renameTo(newFile.getAbsolutePath());
        return retVal;
    }

    protected boolean renameVirtualFile(File destination, String newName) throws SystemMessageException {
        boolean retval;
        VirtualChild child = ArchiveHandlerManager.getInstance().getVirtualObject(destination.getAbsolutePath());
        ISystemArchiveHandler handler = child.getHandler();
        if (handler == null) {
            this.throwCorruptArchiveException(this.getClass() + ".renameVirtualFile()");
        }
        if (!(retval = handler.rename(child.fullName, newName))) {
            throw new SystemMessageException(this.getMessage("RSEG1127").makeSubstitution((Object)child.fullName));
        }
        return retval;
    }

    public boolean move(IProgressMonitor monitor, String srcParent, String srcName, String tgtParent, String tgtName) throws SystemMessageException {
        File sourceFolderOrFile = new File(srcParent, srcName);
        File targetFolder = new File(tgtParent, tgtName);
        boolean sourceIsVirtual = ArchiveHandlerManager.isVirtual((String)sourceFolderOrFile.getAbsolutePath());
        boolean targetIsVirtual = ArchiveHandlerManager.isVirtual((String)targetFolder.getAbsolutePath());
        boolean targetIsArchive = ArchiveHandlerManager.getInstance().isArchive(targetFolder);
        if (sourceIsVirtual || targetIsVirtual || targetIsArchive) {
            if (this.copy(monitor, srcParent, srcName, tgtParent, tgtName)) {
                return this.delete(monitor, srcParent, srcName);
            }
            return false;
        }
        File fileToMove = new File(srcParent, srcName);
        File newFile = new File(tgtParent, tgtName);
        return fileToMove.renameTo(newFile);
    }

    public boolean copy(IProgressMonitor monitor, String srcParent, String srcName, String tgtParent, String tgtName) throws SystemMessageException {
        File srcFile = new File(srcParent, srcName);
        File tgtFile = new File(tgtParent, tgtName);
        String command = null;
        boolean folderCopy = srcFile.isDirectory();
        String src = srcFile.getAbsolutePath();
        String target = tgtFile.getAbsolutePath();
        boolean sourceIsVirtual = ArchiveHandlerManager.isVirtual((String)src);
        boolean targetIsVirtual = ArchiveHandlerManager.isVirtual((String)target);
        boolean targetIsArchive = ArchiveHandlerManager.getInstance().isArchive(new File(tgtParent));
        if (sourceIsVirtual) {
            return this.copyFromArchive(srcFile, new File(tgtParent), tgtName, monitor, SystemEncodingUtil.ENCODING_UTF_8, SystemEncodingUtil.ENCODING_UTF_8, false);
        }
        if (targetIsVirtual || targetIsArchive) {
            return this.copyToArchive(srcFile, new File(tgtParent), tgtName, monitor, SystemEncodingUtil.ENCODING_UTF_8, SystemEncodingUtil.ENCODING_UTF_8, false);
        }
        if (src.indexOf(32) >= 0) {
            src = "\"" + src + "\"";
        }
        if (target.indexOf(32) >= 0) {
            target = "\"" + target + "\"";
        }
        command = System.getProperty("os.name").toLowerCase().startsWith("win") ? (folderCopy ? "xcopy " + src + " " + target + " /S /E /K /Q /H /I" : String.valueOf(this._osCmdShell) + "copy " + src + " " + target) : (folderCopy ? "cp  -r " + src + " " + target : "cp " + src + " " + target);
        int rc = -1;
        try {
            Process p = Runtime.getRuntime().exec(command);
            rc = p.waitFor();
        }
        catch (Exception exception) {}
        return rc == 0;
    }

    public boolean copyFromArchive(File sourceFolderOrFile, File targetFolder, String newName, IProgressMonitor monitor, String sourceEncoding, String targetEncoding, boolean isText) throws SystemMessageException {
        if (sourceEncoding == null) {
            sourceEncoding = SystemEncodingUtil.ENCODING_UTF_8;
        }
        if (sourceEncoding == null) {
            isText = this._fileTypeRegistry.isText(sourceFolderOrFile);
        }
        if (!ArchiveHandlerManager.isVirtual((String)sourceFolderOrFile.getAbsolutePath())) {
            return false;
        }
        String command = null;
        boolean folderCopy = sourceFolderOrFile.isDirectory();
        String src = sourceFolderOrFile.getAbsolutePath();
        VirtualChild child = ArchiveHandlerManager.getInstance().getVirtualObject(sourceFolderOrFile.getAbsolutePath());
        if (!ArchiveHandlerManager.isVirtual((String)targetFolder.getAbsolutePath()) && !ArchiveHandlerManager.getInstance().isArchive(targetFolder)) {
            return child.getExtractedFile(new File(targetFolder, child.name), sourceEncoding, isText);
        }
        src = child.getExtractedFile(sourceEncoding, isText).getAbsolutePath();
        if (child.isDirectory) {
            File tempSource = null;
            try {
                tempSource = File.createTempFile(child.name, "virtual");
                tempSource.deleteOnExit();
            }
            catch (IOException iOException) {
                throw new SystemMessageException(this.getMessage("Copy failed"));
            }
            tempSource.delete();
            if (!tempSource.mkdir()) {
                throw new SystemMessageException(this.getMessage("RSEG1306").makeSubstitution((Object)sourceFolderOrFile));
            }
            ISystemArchiveHandler handler = child.getHandler();
            if (handler == null) {
                this.throwCorruptArchiveException(this.getClass() + ".copy()");
            }
            handler.extractVirtualDirectory(child.fullName, tempSource, sourceEncoding, isText);
            src = String.valueOf(tempSource.getAbsolutePath()) + File.separatorChar + child.name;
        }
        if (ArchiveHandlerManager.isVirtual((String)targetFolder.getAbsolutePath()) || ArchiveHandlerManager.getInstance().isArchive(targetFolder)) {
            File source = new File(src);
            return this.copyToArchive(source, targetFolder, newName, monitor, SystemEncodingUtil.ENCODING_UTF_8, targetEncoding, isText);
        }
        String target = String.valueOf(targetFolder.getAbsolutePath()) + File.separator + newName;
        if (src.indexOf(32) >= 0) {
            src = "\"" + src + "\"";
        }
        if (target.indexOf(32) >= 0) {
            target = "\"" + target + "\"";
        }
        command = System.getProperty("os.name").toLowerCase().startsWith("win") ? (folderCopy ? "xcopy " + src + " " + target + " /S /E /K /Q /H /I" : String.valueOf(this._osCmdShell) + "copy " + src + " " + target) : (folderCopy ? "cp  -r " + src + " " + target : "cp " + src + " " + target);
        int rc = -1;
        try {
            Process p = Runtime.getRuntime().exec(command);
            rc = p.exitValue();
        }
        catch (Exception exception) {}
        return rc == 0;
    }

    public void initService(IProgressMonitor monitor) {
    }

    public void uninitService(IProgressMonitor monitor) {
    }

    public boolean isCaseSensitive() {
        return true;
    }

    public boolean copyBatch(IProgressMonitor monitor, String[] srcParents, String[] srcNames, String tgtParent) throws SystemMessageException {
        boolean ok = true;
        int i = 0;
        while (i < srcParents.length) {
            ok = ok && this.copy(monitor, srcParents[i], srcNames[i], tgtParent, srcNames[i]);
            ++i;
        }
        return ok;
    }

    public class LocalFileNameFilter
    implements FilenameFilter {
        private NamePatternMatcher _matcher;

        public LocalFileNameFilter(String filter) {
            this._matcher = new NamePatternMatcher(filter);
        }

        public boolean accept(File dir, String name) {
            return this._matcher.matches(name);
        }

        public boolean isGeneric() {
            return this._matcher.isGeneric();
        }
    }
}

