/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.services.local.files;

import java.io.File;
import org.eclipse.rse.services.clientserver.archiveutils.ArchiveHandlerManager;
import org.eclipse.rse.services.files.IHostFile;

public class LocalHostFile
implements IHostFile {
    private File _file;
    private boolean _isRoot = false;
    private boolean _isArchive = false;

    public LocalHostFile(File file) {
        this._file = file;
        this._isArchive = ArchiveHandlerManager.getInstance().isArchive(this._file);
    }

    public LocalHostFile(File file, boolean isRoot) {
        this._file = file;
        this._isRoot = isRoot;
        this._isArchive = ArchiveHandlerManager.getInstance().isArchive(this._file);
    }

    public String getName() {
        if (this._isRoot) {
            return this._file.getPath();
        }
        return this._file.getName();
    }

    public boolean isHidden() {
        String name = this.getName();
        return name.charAt(0) == '.';
    }

    public String getParentPath() {
        return this._file.getParent();
    }

    public boolean isDirectory() {
        return this._file.isDirectory();
    }

    public boolean isRoot() {
        return this._isRoot;
    }

    public boolean isFile() {
        return this._file.isFile();
    }

    public File getFile() {
        return this._file;
    }

    public boolean exists() {
        return this._file.exists();
    }

    public String getAbsolutePath() {
        return this._file.getAbsolutePath();
    }

    public long getSize() {
        return this._file.length();
    }

    public long getModifiedDate() {
        return this._file.lastModified();
    }

    public void renameTo(String newAbsolutePath) {
        this._file = new File(newAbsolutePath);
        this._isArchive = ArchiveHandlerManager.getInstance().isArchive(this._file);
    }

    public boolean isArchive() {
        return this._isArchive;
    }
}

