/********************************************************************************
 * Copyright (c) 2002, 2006 IBM Corporation. All rights reserved.
 * This program and the accompanying materials are made available under the terms
 * of the Eclipse Public License v1.0 which accompanies this distribution, and is 
 * available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Initial Contributors:
 * The following IBM employees contributed to the Remote System Explorer
 * component that contains this file: David McKnight, Kushal Munir, 
 * Michael Berger, David Dykstal, Phil Coulthard, Don Yantzi, Eric Simpson, 
 * Emily Bruner, Mazen Faraj, Adrian Storisteanu, Li Ding, and Kent Hawley.
 * 
 * Contributors:
 * {Name} (company) - description of contribution.
 ********************************************************************************/

package org.eclipse.rse.ui;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
//import org.eclipse.ui.views.properties.*;

/**
 * In order to populate the PropertySheet, an object must implement the
 * IAdaptable interface. Thus, this is the minimum requirement for any
 * object that we wish to represent in a tree or table viewer. We simply
 * defer the request for an adapter to the platform, assuming that the
 * adapter has been registered with it.
 */
public class AbstractElement implements IAdaptable 
{
	
	/**
	 * @see IAdaptable#getAdapter(Class)
	 */
	public Object getAdapter(Class adapterType) 
	{
   	    return Platform.getAdapterManager().getAdapter(this, adapterType);	
	}

}