/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dstore.core.client;

import java.util.ArrayList;
import org.eclipse.dstore.core.java.IRemoteClassInstance;
import org.eclipse.dstore.core.model.CommandHandler;
import org.eclipse.dstore.core.model.DataElement;
import org.eclipse.dstore.core.model.DataStore;
import org.eclipse.dstore.core.model.DataStoreResources;
import org.eclipse.dstore.core.util.Sender;

public class ClientCommandHandler
extends CommandHandler {
    private Sender _sender;
    protected DataElement _requestClassDocumentElement;
    protected DataElement _keepAliveDocumentElement;
    protected DataElement _confirmKeepAliveDocumentElement;
    protected DataElement _pendingKeepAliveRequest;
    protected DataElement _pendingKeepAliveConfirmation;
    private static String[] _docAttributes = new String[]{DataStoreResources.DOCUMENT_TYPE, "client.doc.root.id", "client.document", "doc", "", "", DataStoreResources.FALSE, "2"};
    private static String[] _fileAttributes = new String[]{DataStoreResources.FILE_TYPE, "client.file.root.id", "client.file", "doc", "", "", DataStoreResources.FALSE, "2"};
    private static String[] _classAttributes = new String[]{DataStoreResources.CLASS_TYPE, "client.class.root.id", "client.class", "doc", "", "", DataStoreResources.FALSE, "2"};
    private static String[] _serializeAttributes = new String[]{DataStoreResources.SERIALIZED_TYPE, "client.serialized.root.id", "client.serialized", "doc", "", "", DataStoreResources.FALSE, "2"};
    private static String[] _requestClassAttributes = new String[]{DataStoreResources.REQUEST_CLASS_TYPE, "client.requestclass.root.id", "client.requestclass", "doc", "", "", DataStoreResources.FALSE, "2"};
    private static String[] _keepAliveAttributes = new String[]{DataStoreResources.KEEPALIVE_TYPE, "client.keepalive.root.id", "server.keepalive", "doc", "", "", DataStoreResources.FALSE, "2"};
    private static String[] _confirmKeepAliveAttributes = new String[]{DataStoreResources.KEEPALIVECONFIRM_TYPE, "client.keepalive.confirm.root.id", "server.confirmkeepalive", "doc", "", "", DataStoreResources.FALSE, "2"};
    protected DataElement _fileDocumentElement;
    protected DataElement _docDocumentElement;
    protected DataElement _classDocumentElement;
    protected DataElement _serializedDocumentElement;

    public ClientCommandHandler(Sender sender) {
        this._sender = sender;
    }

    public void setDataStore(DataStore dataStore) {
        super.setDataStore(dataStore);
        this._fileDocumentElement = dataStore.createTransientObject(_fileAttributes);
        this._docDocumentElement = dataStore.createObject(null, _docAttributes);
        this._classDocumentElement = dataStore.createTransientObject(_classAttributes);
        this._serializedDocumentElement = dataStore.createTransientObject(_serializeAttributes);
        this._requestClassDocumentElement = dataStore.createTransientObject(_requestClassAttributes);
        this._keepAliveDocumentElement = dataStore.createTransientObject(_keepAliveAttributes);
        this._confirmKeepAliveDocumentElement = dataStore.createTransientObject(_confirmKeepAliveAttributes);
    }

    public synchronized void sendFile(String fileName, byte[] bytes, int size, boolean binary, String byteStreamHandlerId) {
        if (this._commands.size() > 0) {
            this.sendCommands();
        }
        DataElement document = this._fileDocumentElement;
        document.setAttribute(2, byteStreamHandlerId);
        document.setAttribute(3, byteStreamHandlerId);
        document.setAttribute(4, fileName);
        document.setPendingTransfer(true);
        document.setParent(null);
        this._sender.sendFile(document, bytes, size, binary);
    }

    public synchronized void sendFile(String fileName, byte[] bytes, int size, boolean binary) {
        this.sendFile(fileName, bytes, size, binary, "default");
    }

    public synchronized void sendAppendFile(String fileName, byte[] bytes, int size, boolean binary, String byteStreamHandlerId) {
        if (this._commands.size() > 0) {
            this.sendCommands();
        }
        DataElement document = this._fileDocumentElement;
        document.setAttribute(2, byteStreamHandlerId);
        document.setAttribute(3, byteStreamHandlerId);
        document.setAttribute(4, fileName);
        document.setPendingTransfer(true);
        document.setParent(null);
        this._sender.sendAppendFile(document, bytes, size, binary);
    }

    public synchronized void sendAppendFile(String fileName, byte[] bytes, int size, boolean binary) {
        this.sendAppendFile(fileName, bytes, size, binary, "default");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void sendCommands() {
        DataElement commandRoot = this._docDocumentElement;
        commandRoot.removeNestedData();
        commandRoot.setPendingTransfer(true);
        commandRoot.setParent(null);
        while (this._commands.size() > 0) {
            DataElement command = null;
            command = (DataElement)this._commands.remove(0);
            commandRoot.addNestedData(command, false);
        }
        this._sender.sendDocument(commandRoot, 3);
        if (this._pendingKeepAliveConfirmation != null) {
            this._sender.sendKeepAliveConfirmation(this._pendingKeepAliveConfirmation);
            this._pendingKeepAliveConfirmation = null;
        }
        if (this._pendingKeepAliveRequest != null) {
            this._sender.sendKeepAliveRequest(this._pendingKeepAliveRequest);
            this._pendingKeepAliveRequest = null;
        }
        while (this._classesToSend != null && this._classesToSend.size() > 0) {
            DataElement document = null;
            ArrayList arrayList = this._classesToSend;
            synchronized (arrayList) {
                document = (DataElement)this._classesToSend.remove(0);
            }
            this._sender.sendClass(document);
        }
    }

    public void handle() {
        if (!this._commands.isEmpty() || this._pendingKeepAliveConfirmation != null || this._pendingKeepAliveRequest != null || !this._classesToSend.isEmpty()) {
            this.sendCommands();
        }
    }

    public synchronized void sendClass(String className, String classbyteStreamHandlerId) {
        if (this._commands.size() > 0) {
            this.sendCommands();
        }
        DataElement document = this._classDocumentElement;
        document.setAttribute(2, className);
        document.setAttribute(4, classbyteStreamHandlerId);
        document.setPendingTransfer(true);
        document.setParent(null);
        this.addClassToSend(document);
    }

    public synchronized void sendClass(String className) {
        this.sendClass(className, "default");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addClassToSend(DataElement classElement) {
        ArrayList arrayList = this._classesToSend;
        synchronized (arrayList) {
            if (!this._classesToSend.contains(classElement)) {
                this._classesToSend.add(classElement);
            }
        }
        this.notifyInput();
    }

    public synchronized void sendClassInstance(IRemoteClassInstance runnable, String deserializebyteStreamHandlerId) {
        if (this._commands.size() > 0) {
            this.sendCommands();
        }
        DataElement document = this._serializedDocumentElement;
        document.setAttribute(2, runnable.toString());
        document.setAttribute(4, deserializebyteStreamHandlerId);
        document.setPendingTransfer(true);
        document.setParent(null);
        this._sender.sendRemoteClassRunnable(document, runnable);
    }

    public void requestClass(String className) {
        DataElement document = this._requestClassDocumentElement;
        document.setPendingTransfer(true);
        document.setAttribute(2, className);
        document.setAttribute(3, className);
        document.setParent(null);
        this._sender.requestClass(document);
    }

    public void sendKeepAliveConfirmation() {
        DataElement document = this._confirmKeepAliveDocumentElement;
        document.setPendingTransfer(true);
        document.setAttribute(2, "confirm");
        document.setAttribute(3, "confirm");
        document.setParent(null);
        this._pendingKeepAliveConfirmation = document;
    }

    public void sendKeepAliveRequest() {
        DataElement document = this._keepAliveDocumentElement;
        document.setPendingTransfer(true);
        document.setAttribute(2, "request");
        document.setAttribute(3, "request");
        document.setParent(null);
        this._pendingKeepAliveRequest = document;
    }
}

