/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.services.clientserver;

import org.eclipse.rse.services.clientserver.archiveutils.AbsoluteVirtualPath;
import org.eclipse.rse.services.clientserver.archiveutils.ArchiveHandlerManager;

public class PathUtility {
    public static String normalizeWindows(String path) {
        boolean needsNormalizing;
        if (path == null || path.length() < 2) {
            return path;
        }
        boolean containsForwardSlash = false;
        boolean containsDoubleSlashes = false;
        boolean endsWithSlash = false;
        if (path.indexOf("/") != -1) {
            containsForwardSlash = true;
        }
        if (path.indexOf("\\\\") != -1) {
            containsDoubleSlashes = true;
        }
        if (path.endsWith("\\") || path.endsWith("/")) {
            endsWithSlash = true;
        }
        boolean bl = needsNormalizing = containsForwardSlash || containsDoubleSlashes || endsWithSlash;
        if (!needsNormalizing) {
            return path;
        }
        if (containsForwardSlash) {
            boolean bl2 = containsDoubleSlashes = (path = path.replace('/', '\\')).indexOf("\\\\") != -1;
        }
        if (endsWithSlash && path.length() != 3) {
            path = path.substring(0, path.length() - 1);
        }
        return path;
    }

    public static String normalizeUnix(String path) {
        boolean needsNormalizing;
        if (path == null || path.length() < 2) {
            return path;
        }
        boolean containsBackSlash = false;
        boolean containsDoubleSlashes = false;
        boolean endsWithSlash = false;
        if (path.indexOf("\\") != -1) {
            containsBackSlash = true;
        }
        if (path.indexOf("//") != -1) {
            containsDoubleSlashes = true;
        }
        if (path.endsWith("\\") || path.endsWith("/")) {
            endsWithSlash = true;
        }
        boolean bl = needsNormalizing = containsBackSlash || containsDoubleSlashes || endsWithSlash;
        if (!needsNormalizing) {
            return path;
        }
        if (containsBackSlash) {
            containsDoubleSlashes = (path = path.replaceAll("\\", "/")).indexOf("//") != -1;
        }
        while (containsDoubleSlashes) {
            boolean bl2 = containsDoubleSlashes = (path = path.replaceAll("//", "/")).indexOf("//") != -1;
        }
        if (endsWithSlash && path.length() != 1) {
            path = path.substring(0, path.length() - 1);
        }
        return path;
    }

    public static String normalizeVirtualWindows(String path) {
        if (path == null || path.length() < 2) {
            return path;
        }
        AbsoluteVirtualPath avp = new AbsoluteVirtualPath(path);
        String realPart = avp.getContainingArchiveString();
        realPart = ArchiveHandlerManager.isVirtual(realPart) ? PathUtility.normalizeVirtualWindows(realPart) : PathUtility.normalizeWindows(realPart);
        return String.valueOf(realPart) + "#virtual#/" + avp.getVirtualPart();
    }

    public static String normalizeVirtualUnix(String path) {
        if (path == null || path.length() < 2) {
            return path;
        }
        AbsoluteVirtualPath avp = new AbsoluteVirtualPath(path);
        String realPart = avp.getContainingArchiveString();
        realPart = ArchiveHandlerManager.isVirtual(realPart) ? PathUtility.normalizeVirtualUnix(realPart) : PathUtility.normalizeUnix(realPart);
        return String.valueOf(realPart) + "#virtual#/" + avp.getVirtualPart();
    }

    public static String normalizeUnknown(String path) {
        if (path == null || path.length() < 2) {
            return path;
        }
        if (path.charAt(1) == ':') {
            if (path.indexOf("#virtual#") == -1) {
                return PathUtility.normalizeWindows(path);
            }
            return PathUtility.normalizeVirtualWindows(path);
        }
        if (path.charAt(0) == '/') {
            if (path.indexOf("#virtual#") == -1) {
                return PathUtility.normalizeUnix(path);
            }
            return PathUtility.normalizeVirtualUnix(path);
        }
        return path;
    }

    public static String getSeparator(String path) {
        if (path.length() > 1 && path.charAt(1) == ':') {
            return "\\";
        }
        return "/";
    }
}

