/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dstore.core.util;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.net.Socket;
import java.net.UnknownHostException;
import org.eclipse.dstore.core.model.DataElement;
import org.eclipse.dstore.core.model.DataStore;
import org.eclipse.dstore.core.util.XMLparser;

public abstract class Receiver
extends Thread {
    private Socket _socket;
    protected DataStore _dataStore;
    private XMLparser _xmlParser;
    private BufferedInputStream _in;
    protected boolean _canExit;

    public Receiver(Socket socket, DataStore dataStore) {
        this._socket = socket;
        this._dataStore = dataStore;
        this._canExit = false;
        this._xmlParser = new XMLparser(dataStore);
        try {
            this._in = new BufferedInputStream(socket.getInputStream());
        }
        catch (UnknownHostException unknownHostException) {
        }
        catch (IOException iOException) {}
    }

    public void finish() {
        this._canExit = true;
    }

    public boolean canExit() {
        return this._canExit;
    }

    public void run() {
        try {
            while (!this._canExit) {
                this.handleInput();
            }
        }
        catch (Exception e) {
            this._canExit = true;
            e.printStackTrace();
            this.handleError(e);
        }
    }

    public void handleInput() {
        try {
            DataElement rootObject = this._xmlParser.parseDocument(this._in, this._socket);
            if (rootObject != null) {
                String type = rootObject.getType();
                if (!type.equals("FILE")) {
                    this.handleDocument(rootObject);
                }
            } else {
                this._canExit = true;
                if (this._xmlParser.getPanicException() != null) {
                    this.handleError(this._xmlParser.getPanicException());
                }
            }
        }
        catch (IOException ioe) {
            this._canExit = true;
            this.handleError(ioe);
        }
        catch (Exception e) {
            this.handleError(e);
        }
    }

    public Socket socket() {
        return this._socket;
    }

    public abstract void handleDocument(DataElement var1);

    public abstract void handleError(Throwable var1);
}

