/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dstore.core.util.ssl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;

public class DStoreKeyStore {
    public static DStoreKeyStore _instance = null;

    public DStoreKeyStore() {
        _instance = this;
    }

    public static DStoreKeyStore getInstance() {
        if (_instance == null) {
            new DStoreKeyStore();
        }
        return _instance;
    }

    public static KeyStore getKeyStore(String filePath, String password) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException, NoSuchProviderException {
        KeyStore keyStore = null;
        if (filePath != null) {
            File keyStoreFile = new File(filePath);
            if (!keyStoreFile.exists()) {
                keyStore = KeyStore.getInstance("JKS");
                keyStore.load(null, password.toCharArray());
                DStoreKeyStore.persistKeyStore(keyStore, filePath, password);
            } else {
                keyStore = DStoreKeyStore.loadKeyStore(filePath, password);
            }
        }
        return keyStore;
    }

    public static KeyStore loadKeyStore(String pathname, String password) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException, NoSuchProviderException {
        KeyStore ks = null;
        File file = new File(pathname);
        if (file.exists()) {
            ks = KeyStore.getInstance("JKS");
            FileInputStream is = new FileInputStream(file);
            ks.load(is, password.toCharArray());
            is.close();
        }
        return ks;
    }

    public static Certificate loadCertificate(String certFilename) throws CertificateException, FileNotFoundException {
        CertificateFactory factory = CertificateFactory.getInstance("X.509");
        return factory.generateCertificate(new FileInputStream(certFilename));
    }

    public static void addCertificateToKeyStore(KeyStore ks, Certificate cert, String alias) throws KeyStoreException {
        ks.setCertificateEntry(alias, cert);
    }

    public static void persistKeyStore(KeyStore ks, String pathname, String password) throws KeyStoreException, FileNotFoundException, NoSuchAlgorithmException, CertificateException, IOException {
        FileOutputStream os = new FileOutputStream(pathname);
        ks.store(os, password.toCharArray());
        os.close();
    }
}

