/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.dstore.universal.miners.filesystem;

import java.io.File;
import org.eclipse.dstore.core.model.DataElement;
import org.eclipse.dstore.core.model.DataStore;
import org.eclipse.dstore.core.server.SecuredThread;
import org.eclipse.rse.dstore.universal.miners.ICancellableHandler;
import org.eclipse.rse.dstore.universal.miners.UniversalFileSystemMiner;
import org.eclipse.rse.dstore.universal.miners.UniversalServerUtilities;
import org.eclipse.rse.services.clientserver.ISystemOperationMonitor;
import org.eclipse.rse.services.clientserver.SystemOperationMonitor;
import org.eclipse.rse.services.clientserver.archiveutils.AbsoluteVirtualPath;
import org.eclipse.rse.services.clientserver.archiveutils.ArchiveHandlerManager;
import org.eclipse.rse.services.clientserver.archiveutils.ISystemArchiveHandler;
import org.eclipse.rse.services.clientserver.messages.SystemMessageException;

public class RenameThread
extends SecuredThread
implements ICancellableHandler {
    protected DataElement _subject;
    protected DataElement _status;
    protected UniversalFileSystemMiner _miner;
    protected boolean _isCancelled = false;
    protected boolean _isDone = false;
    protected SystemOperationMonitor systemOperationMonitor = new SystemOperationMonitor();
    public static final String CLASSNAME = "RenameThread";

    public RenameThread(DataElement theElement, UniversalFileSystemMiner miner, DataStore dataStore, DataElement status) {
        super(dataStore);
        this._subject = theElement;
        this._miner = miner;
        this._status = status;
    }

    public void cancel() {
        this._isCancelled = true;
        if (this.systemOperationMonitor != null) {
            this.systemOperationMonitor.setCancelled(true);
        }
    }

    public boolean isCancelled() {
        return this._isCancelled;
    }

    public boolean isDone() {
        return this._isDone;
    }

    public void run() {
        super.run();
        try {
            this.handleRename();
        }
        catch (SystemMessageException e) {
            this._status.setAttribute(4, "failed");
            this._miner.statusDone(this._status);
        }
        this._isDone = true;
    }

    private DataElement handleRename() throws SystemMessageException {
        File fileoldname = new File(String.valueOf(this._subject.getAttribute(3)) + File.separatorChar + this._subject.getName());
        File filerename = new File(this._subject.getAttribute(4));
        if (ArchiveHandlerManager.isVirtual((String)fileoldname.getAbsolutePath())) {
            AbsoluteVirtualPath oldAbsPath = new AbsoluteVirtualPath(fileoldname.getAbsolutePath());
            AbsoluteVirtualPath newAbsPath = new AbsoluteVirtualPath(filerename.getAbsolutePath());
            ArchiveHandlerManager archiveHandlerManager = ArchiveHandlerManager.getInstance();
            ISystemArchiveHandler handler = archiveHandlerManager.getRegisteredHandler(new File(oldAbsPath.getContainingArchiveString()));
            if (handler != null) {
                handler.fullRename(oldAbsPath.getVirtualPart(), newAbsPath.getVirtualPart(), (ISystemOperationMonitor)this.systemOperationMonitor);
                this._subject.setAttribute(2, filerename.getName());
                this._subject.setAttribute(4, this._miner.setProperties(handler.getVirtualFile(newAbsPath.getVirtualPart(), (ISystemOperationMonitor)this.systemOperationMonitor)));
                this._status.setAttribute(4, "success");
                this._dataStore.update(this._subject);
            } else if (this.systemOperationMonitor.isCancelled()) {
                this._subject.setAttribute(4, this._miner.setProperties(handler.getVirtualFile(oldAbsPath.getVirtualPart(), (ISystemOperationMonitor)this.systemOperationMonitor)));
            } else {
                this._status.setAttribute(4, "failed");
            }
            this._dataStore.refresh(this._subject);
            return this._miner.statusDone(this._status);
        }
        if (filerename.exists()) {
            this._status.setAttribute(4, "failed with exist");
        } else {
            try {
                boolean done = fileoldname.renameTo(filerename);
                if (done) {
                    this._subject.setAttribute(2, filerename.getName());
                    this._subject.setAttribute(4, this._miner.setProperties(filerename));
                    this._status.setAttribute(4, "success");
                    if (filerename.isDirectory()) {
                        this.updateChildProperties(this._subject, filerename);
                    }
                    this._dataStore.update(this._subject);
                } else {
                    this._status.setAttribute(4, "failed");
                }
            }
            catch (Exception e) {
                this._status.setAttribute(4, "failed");
                UniversalServerUtilities.logError(CLASSNAME, "handleRename failed", e, this._dataStore);
            }
        }
        this._dataStore.refresh(this._subject);
        return this._miner.statusDone(this._status);
    }

    private void updateChildProperties(DataElement subject, File filerename) {
        int nestedSize = subject.getNestedSize();
        int i = 0;
        while (i < nestedSize) {
            DataElement child = subject.get(i);
            child.setAttribute(3, filerename.getAbsolutePath());
            if (child.getNestedSize() > 0) {
                File childFile = new File(filerename, child.getName());
                this.updateChildProperties(child, childFile);
            }
            ++i;
        }
    }
}

