/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.tests.core.passwords;

import java.util.List;
import org.eclipse.rse.core.IRSESystemType;
import org.eclipse.rse.core.PasswordPersistenceManager;
import org.eclipse.rse.core.RSEPreferencesManager;
import org.eclipse.rse.core.model.SystemSignonInformation;
import org.eclipse.rse.internal.core.RSECoreRegistry;
import org.eclipse.rse.tests.core.RSECoreTestCase;
import org.eclipse.rse.tests.core.passwords.OriginalPasswordPersistenceManager;

public class PasswordsTest
extends RSECoreTestCase {
    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testAddRemove() {
        if (this.isTestDisabled()) {
            return;
        }
        if ("false".equals(System.getProperty("rse.enableSecureStoreAccess"))) {
            return;
        }
        IRSESystemType systemType = RSECoreRegistry.getInstance().getSystemType("org.eclipse.rse.systemtype.unix");
        IRSESystemType defaultSystemType = PasswordPersistenceManager.DEFAULT_SYSTEM_TYPE;
        String hostAddress = "somesystem.mycompany.com";
        boolean deny = RSEPreferencesManager.getDenyPasswordSave((IRSESystemType)systemType, (String)hostAddress);
        PasswordsTest.assertFalse((String)"the initial value of this preference should be false", (boolean)deny);
        String password = "password";
        String userId = "me";
        SystemSignonInformation info = new SystemSignonInformation(hostAddress, userId, password, systemType);
        PasswordPersistenceManager ppm = PasswordPersistenceManager.getInstance();
        int result = ppm.add(info, true, true);
        PasswordsTest.assertEquals((String)"result of add was not what was expected", (int)0, (int)result);
        SystemSignonInformation returnedInfo = ppm.find(systemType, hostAddress, userId);
        PasswordsTest.assertEquals((String)"passwords are not equal", (String)password, (String)returnedInfo.getPassword());
        PasswordsTest.assertEquals((String)"system type not what was expected", (Object)systemType, (Object)returnedInfo.getSystemType());
        ppm.remove(systemType, hostAddress, userId);
        returnedInfo = ppm.find(systemType, hostAddress, userId, true);
        PasswordsTest.assertEquals((String)"passwords are not equal", (String)password, (String)returnedInfo.getPassword());
        PasswordsTest.assertEquals((String)"system type not what was expected", (Object)defaultSystemType, (Object)returnedInfo.getSystemType());
        returnedInfo = ppm.find(systemType, hostAddress, userId, false);
        PasswordsTest.assertNull((String)"signon info was found but should not be", (Object)returnedInfo);
        ppm.remove(defaultSystemType, hostAddress, userId);
        returnedInfo = ppm.find(systemType, hostAddress, userId, true);
        PasswordsTest.assertNull((String)"signon info was found but should not be", (Object)returnedInfo);
        returnedInfo = ppm.find(systemType, hostAddress, userId, false);
        PasswordsTest.assertNull((String)"signon info was found but should not be", (Object)returnedInfo);
        result = ppm.add(info, true, false);
        PasswordsTest.assertEquals((String)"result of add was not what was expected", (int)0, (int)result);
        returnedInfo = ppm.find(systemType, hostAddress, userId);
        PasswordsTest.assertEquals((String)"passwords are not equal", (String)password, (String)returnedInfo.getPassword());
        PasswordsTest.assertEquals((String)"system type not what was expected", (Object)systemType, (Object)returnedInfo.getSystemType());
        returnedInfo = ppm.find(defaultSystemType, hostAddress, userId);
        PasswordsTest.assertNull((String)"signon info was found but should not be", (Object)returnedInfo);
        ppm.remove(systemType, hostAddress, userId);
        returnedInfo = ppm.find(systemType, hostAddress, userId, true);
        PasswordsTest.assertNull((String)"signon info was found but should not be", (Object)returnedInfo);
        returnedInfo = ppm.find(systemType, hostAddress, userId, false);
        PasswordsTest.assertNull((String)"signon info was found but should not be", (Object)returnedInfo);
    }

    public void testSaveDenial() {
        if (this.isTestDisabled()) {
            return;
        }
        if ("false".equals(System.getProperty("rse.enableSecureStoreAccess"))) {
            return;
        }
        IRSESystemType systemType = RSECoreRegistry.getInstance().getSystemType("org.eclipse.rse.systemtype.unix");
        String hostAddress = "somesystem.mycompany.com";
        boolean deny = RSEPreferencesManager.getDenyPasswordSave((IRSESystemType)systemType, (String)hostAddress);
        PasswordsTest.assertFalse((String)"the initial value of this preference should be false", (boolean)deny);
        String password = "password";
        String userId = "me";
        SystemSignonInformation info = new SystemSignonInformation(hostAddress, userId, password, systemType);
        PasswordPersistenceManager ppm = PasswordPersistenceManager.getInstance();
        int result = ppm.add(info, true, true);
        PasswordsTest.assertEquals((String)"result of add was not what was expected", (int)0, (int)result);
        SystemSignonInformation returnedInfo = ppm.find(systemType, hostAddress, userId);
        PasswordsTest.assertEquals((String)"passwords are not equal", (String)password, (String)returnedInfo.getPassword());
        PasswordsTest.assertEquals((String)"system type not what was expected", (Object)systemType, (Object)returnedInfo.getSystemType());
        RSEPreferencesManager.setDenyPasswordSave((IRSESystemType)systemType, (String)hostAddress, (boolean)true);
        returnedInfo = ppm.find(systemType, hostAddress, userId);
        PasswordsTest.assertNull((String)"signon info was found but should not be", (Object)returnedInfo);
        returnedInfo = ppm.find(systemType, hostAddress, userId, true);
        PasswordsTest.assertNull((String)"signon info was found but should not be", (Object)returnedInfo);
        returnedInfo = ppm.find(systemType, hostAddress, userId, false);
        PasswordsTest.assertNull((String)"signon info was found but should not be", (Object)returnedInfo);
        result = ppm.add(info, true, true);
        PasswordsTest.assertEquals((String)"result of add was not what was expected", (int)2, (int)result);
        returnedInfo = ppm.find(systemType, hostAddress, userId);
        PasswordsTest.assertNull((String)"signon info was found but should not be", (Object)returnedInfo);
        returnedInfo = ppm.find(systemType, hostAddress, userId, true);
        PasswordsTest.assertNull((String)"signon info was found but should not be", (Object)returnedInfo);
        returnedInfo = ppm.find(systemType, hostAddress, userId, false);
        PasswordsTest.assertNull((String)"signon info was found but should not be", (Object)returnedInfo);
    }

    public void testMigration() {
        if (this.isTestDisabled()) {
            return;
        }
        if ("false".equals(System.getProperty("rse.enableSecureStoreAccess"))) {
            return;
        }
        IRSESystemType systemType = RSECoreRegistry.getInstance().getSystemType("org.eclipse.rse.systemtype.local");
        PasswordPersistenceManager newPPM = PasswordPersistenceManager.getInstance();
        if (OriginalPasswordPersistenceManager.isActive()) {
            OriginalPasswordPersistenceManager oldPPM = OriginalPasswordPersistenceManager.getInstance();
            newPPM.reset(systemType);
            oldPPM.add(new SystemSignonInformation("myhost.mycompany.com", "me", "password", systemType), true, false);
            oldPPM.add(new SystemSignonInformation("yourhost.yourcompany.com", "you", "xxyyzz", systemType), true, false);
            oldPPM.add(new SystemSignonInformation("LOUDHOST.mycompany.com", "thatguy", "abc", systemType), true, false);
            SystemSignonInformation foundInfo = null;
            foundInfo = newPPM.find(systemType, "myhost.mycompany.com", "me");
            PasswordsTest.assertNotNull((Object)foundInfo);
            PasswordsTest.assertEquals((String)foundInfo.getPassword(), (String)"password");
            foundInfo = newPPM.find(systemType, "yourhost.yourcompany.com", "you");
            PasswordsTest.assertNotNull((Object)foundInfo);
            PasswordsTest.assertEquals((String)foundInfo.getPassword(), (String)"xxyyzz");
            foundInfo = newPPM.find(systemType, "LOUDHOST.mycompany.com", "thatguy");
            PasswordsTest.assertNotNull((Object)foundInfo);
            PasswordsTest.assertEquals((String)foundInfo.getPassword(), (String)"abc");
        }
    }

    public void testAliasing() {
        if (this.isTestDisabled()) {
            return;
        }
        if ("false".equals(System.getProperty("rse.enableSecureStoreAccess"))) {
            return;
        }
        IRSESystemType systemType = RSECoreRegistry.getInstance().getSystemType("org.eclipse.rse.systemtype.local");
        PasswordPersistenceManager ppm = PasswordPersistenceManager.getInstance();
        ppm.add(new SystemSignonInformation("LOUDHOST.mycompany.com", "thatguy", "abc", systemType), true, false);
        SystemSignonInformation foundInfo = ppm.find(systemType, "LOUDHOST.mycompany.com", "thatguy");
        PasswordsTest.assertNotNull((Object)foundInfo);
        PasswordsTest.assertEquals((String)foundInfo.getPassword(), (String)"abc");
        foundInfo = ppm.find(systemType, "loudhost.mycompany.com", "thatguy");
        PasswordsTest.assertNotNull((Object)foundInfo);
        PasswordsTest.assertEquals((String)foundInfo.getPassword(), (String)"abc");
        foundInfo = ppm.find(systemType, "loudhost.MyCompany.com", "thatguy");
        PasswordsTest.assertNotNull((Object)foundInfo);
        PasswordsTest.assertEquals((String)foundInfo.getPassword(), (String)"abc");
    }

    public void testBadArgs() {
        if (this.isTestDisabled()) {
            return;
        }
        if ("false".equals(System.getProperty("rse.enableSecureStoreAccess"))) {
            return;
        }
        IRSESystemType systemType = RSECoreRegistry.getInstance().getSystemType("org.eclipse.rse.systemtype.local");
        PasswordPersistenceManager ppm = PasswordPersistenceManager.getInstance();
        ppm.add(new SystemSignonInformation("myhost.mycompany.com", "me", "password", systemType), true, false);
        SystemSignonInformation info = ppm.find(systemType, "myhost.mycompany.com", null);
        PasswordsTest.assertNull((Object)info);
    }

    public void testDisabledSecureStore() {
        if (this.isTestDisabled()) {
            return;
        }
        String key = "rse.enableSecureStoreAccess";
        String valueOnEntry = System.getProperty(key);
        System.setProperty(key, "false");
        PasswordPersistenceManager ppm = PasswordPersistenceManager.getInstance();
        IRSESystemType systemType = RSECoreRegistry.getInstance().getSystemType("org.eclipse.rse.systemtype.unix");
        String hostAddress = "somesystem.mycompany.com";
        String password = "password";
        String userId = "me";
        SystemSignonInformation info = new SystemSignonInformation(hostAddress, userId, password, systemType);
        int result = ppm.add(info, true);
        PasswordsTest.assertEquals((String)"result of first add was not RC_DENIED", (int)2, (int)result);
        result = ppm.add(info, true, true);
        PasswordsTest.assertEquals((String)"result of second add was not RC_DENIED", (int)2, (int)result);
        SystemSignonInformation returnedInfo = ppm.find(systemType, hostAddress, userId);
        PasswordsTest.assertNull((String)"signon info was found and should not be", (Object)returnedInfo);
        PasswordsTest.assertFalse((String)"found signon information where none should exist (1)", (boolean)ppm.passwordExists(systemType, hostAddress, userId));
        PasswordsTest.assertFalse((String)"found signon information where none should exist (2)", (boolean)ppm.passwordExists(systemType, hostAddress, userId, false));
        PasswordsTest.assertFalse((String)"found signon information where none should exist (3)", (boolean)ppm.passwordExists(systemType, hostAddress, userId, true));
        returnedInfo = ppm.find(systemType, hostAddress, userId);
        PasswordsTest.assertNull((String)"signon info was found and should not be (1)", (Object)returnedInfo);
        returnedInfo = ppm.find(systemType, hostAddress, userId, false);
        PasswordsTest.assertNull((String)"signon info was found but should not be (2)", (Object)returnedInfo);
        returnedInfo = ppm.find(systemType, hostAddress, userId, true);
        PasswordsTest.assertNull((String)"signon info was found but should not be (3)", (Object)returnedInfo);
        ppm.remove(info);
        ppm.remove(systemType, hostAddress, userId);
        PasswordsTest.assertEquals((String)"passwords were removed but none should be (2)", (int)0, (int)ppm.remove(systemType, hostAddress));
        IRSESystemType[] systemTypes = ppm.getRegisteredSystemTypes();
        PasswordsTest.assertNotNull((String)"returned system types is null", (Object)systemTypes);
        PasswordsTest.assertTrue((String)"no system types were found", (systemTypes.length > 0 ? 1 : 0) != 0);
        List userInfo = ppm.getSavedUserIDs();
        PasswordsTest.assertTrue((String)"user info was found where none should exist", (userInfo.size() == 0 ? 1 : 0) != 0);
        if (valueOnEntry == null) {
            System.clearProperty(key);
        } else {
            System.setProperty(key, valueOnEntry);
        }
    }
}

