/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.tests.framework.actions;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.rse.internal.tests.framework.TestFrameworkPlugin;
import org.eclipse.rse.tests.framework.AbstractTestSuiteHolder;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.progress.IWorkbenchSiteProgressService;

public class RunHolderDelegate
implements IObjectActionDelegate {
    private IWorkbenchPart part;
    private ISelection selection;

    public void selectionChanged(IAction action, ISelection selection) {
        this.selection = selection;
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.part = targetPart;
    }

    public void run(IAction action) {
        IPreferenceStore store = TestFrameworkPlugin.getDefault().getPreferenceStore();
        boolean runInBackground = store.getBoolean("org.eclipse.rse.tests.runInBackground");
        if (runInBackground) {
            this.runInBackground();
        } else {
            this.runInUI();
        }
    }

    private void runInBackground() {
        Job job = new Job("Running JUnit Tests Suites"){

            protected IStatus run(IProgressMonitor monitor) {
                IStatus result = RunHolderDelegate.this.runTests(monitor);
                return result;
            }
        };
        job.setPriority(30);
        job.setUser(true);
        IWorkbenchPartSite site = this.part.getSite();
        IWorkbenchSiteProgressService siteService = (IWorkbenchSiteProgressService)site.getAdapter(IWorkbenchSiteProgressService.class);
        siteService.schedule(job, 0L, true);
    }

    private void runInUI() {
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) {
                RunHolderDelegate.this.runTests(monitor);
            }
        };
        IWorkbenchPartSite site = this.part.getSite();
        IWorkbenchSiteProgressService siteService = (IWorkbenchSiteProgressService)site.getAdapter(IWorkbenchSiteProgressService.class);
        try {
            siteService.runInUI((IRunnableContext)siteService, runnable, null);
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (InterruptedException interruptedException) {}
    }

    private IStatus runTests(IProgressMonitor monitor) {
        IStatus result = Status.OK_STATUS;
        if (this.selection instanceof IStructuredSelection) {
            IStructuredSelection ss = (IStructuredSelection)this.selection;
            monitor.beginTask("", ss.size());
            for (AbstractTestSuiteHolder holder : ss) {
                monitor.subTask(holder.getName());
                SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, 1);
                holder.run((IProgressMonitor)subMonitor);
                if (!monitor.isCanceled()) continue;
                result = Status.CANCEL_STATUS;
                break;
            }
            monitor.done();
        }
        return result;
    }
}

