/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.ui.propertypages;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.rse.core.IRSESystemType;
import org.eclipse.rse.core.RSECorePlugin;
import org.eclipse.rse.core.RSEPreferencesManager;
import org.eclipse.rse.core.subsystems.ISubSystemConfigurationProxy;
import org.eclipse.rse.internal.ui.SystemResources;
import org.eclipse.rse.ui.RSESystemTypeAdapter;
import org.eclipse.rse.ui.SystemWidgetHelpers;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class SystemTypeFieldEditor
extends FieldEditor
implements ICellModifier,
ITableLabelProvider,
IStructuredContentProvider {
    private Table table;
    private GridData tableData;
    private TableViewer tableViewer;
    private CellEditor enabledCellEditor;
    private CellEditor userIdCellEditor;
    private static final char KEYVALUE_DELIMITER = '=';
    private static final char KEYVALUEPAIR_DELIMITER = ';';
    public static final char EACHVALUE_DELIMITER = '+';
    private Hashtable keyValues;
    private IRSESystemType[] systemTypes;
    private boolean enabledStateChanged = false;
    private static final int COLUMN_NAME = 0;
    private static final int COLUMN_ENABLED = 1;
    private static final int COLUMN_USERID = 2;
    private static final String P_NAME = "name";
    private static final String P_ENABLED = "enabled";
    private static final String P_DESC = "desc";
    private static final String P_USERID = "userid";
    private static final String[] columnHeaders = new String[]{SystemResources.RESID_PREF_SYSTYPE_COLHDG_NAME, SystemResources.RESID_PREF_SYSTYPE_COLHDG_ENABLED, SystemResources.RESID_PREF_SYSTYPE_COLHDG_USERID, SystemResources.RESID_PREF_SYSTYPE_COLHDG_DESC};
    private static ColumnLayoutData[] columnLayouts = new ColumnLayoutData[]{new ColumnWeightData(20, 80, true), new ColumnWeightData(20, 15, true), new ColumnWeightData(20, 100, true), new ColumnWeightData(55, 280, true)};
    private static final String[] tableColumnProperties = new String[]{"name", "enabled", "userid", "desc"};
    private static final boolean[] enabledStates = new boolean[]{Boolean.TRUE, Boolean.FALSE};
    private static final String[] enabledStateStrings = new String[]{SystemResources.SystemTypeFieldEditor_true, SystemResources.SystemTypeFieldEditor_false};

    public SystemTypeFieldEditor(String name, String labelText, Composite parent) {
        super(name, labelText, parent);
    }

    protected void adjustForNumColumns(int numColumns) {
        ((GridData)this.table.getLayoutData()).horizontalSpan = numColumns;
    }

    protected void doFillIntoGrid(Composite parent, int numColumns) {
        this.table = this.createTable(parent);
        ((GridData)this.table.getLayoutData()).horizontalSpan = numColumns;
        this.tableViewer = new TableViewer(this.table);
        this.createColumns();
        this.tableViewer.setColumnProperties(tableColumnProperties);
        this.tableViewer.setCellModifier((ICellModifier)this);
        CellEditor[] editors = new CellEditor[columnHeaders.length];
        this.userIdCellEditor = new TextCellEditor((Composite)this.table);
        this.enabledCellEditor = new ComboBoxCellEditor((Composite)this.table, enabledStateStrings, 8);
        editors[2] = this.userIdCellEditor;
        editors[1] = this.enabledCellEditor;
        this.tableViewer.setCellEditors(editors);
        this.tableViewer.setLabelProvider((IBaseLabelProvider)this);
        this.tableViewer.setContentProvider((IContentProvider)this);
        this.tableViewer.setInput(new Object());
    }

    protected void doLoad() {
        if (this.systemTypes == null) {
            this.systemTypes = this.getSystemTypes(false);
        }
        String value = RSEPreferencesManager.getSystemTypeValues();
        this.keyValues = null;
        this.keyValues = value == null || value.length() == 0 ? new Hashtable() : SystemTypeFieldEditor.parseString(value);
    }

    protected void doLoadDefault() {
        this.systemTypes = this.getSystemTypes(true);
        this.keyValues.clear();
        this.tableViewer.refresh();
    }

    protected void doStore() {
        String s;
        if (this.systemTypes != null && (s = SystemTypeFieldEditor.createString(this.keyValues)) != null) {
            RSEPreferencesManager.setSystemTypeValues((String)s);
        }
    }

    public int getNumberOfControls() {
        return 1;
    }

    public void setEnabled(boolean enabled, Composite parent) {
        if (this.table != null) {
            this.table.setEnabled(enabled);
        }
    }

    public boolean isValid() {
        return true;
    }

    private Table createTable(Composite parent) {
        this.table = new Table(parent, 68356);
        this.table.setLinesVisible(true);
        this.tableData = new GridData();
        this.tableData.horizontalAlignment = 4;
        this.tableData.grabExcessHorizontalSpace = true;
        this.tableData.widthHint = 410;
        this.tableData.heightHint = 30;
        this.tableData.verticalAlignment = 4;
        this.tableData.grabExcessVerticalSpace = true;
        this.table.setLayoutData((Object)this.tableData);
        SystemWidgetHelpers.setHelp((Control)this.table, "org.eclipse.rse.ui.systype_preferences");
        return this.table;
    }

    private void createColumns() {
        TableLayout layout = new TableLayout();
        this.table.setLayout((Layout)layout);
        this.table.setHeaderVisible(true);
        int i = 0;
        while (i < columnHeaders.length) {
            layout.addColumnData(columnLayouts[i]);
            TableColumn tc = new TableColumn(this.table, 0, i);
            tc.setResizable(SystemTypeFieldEditor.columnLayouts[i].resizable);
            tc.setText(columnHeaders[i]);
            ++i;
        }
    }

    private static Hashtable parseString(String allvalues) {
        StringTokenizer tokens = new StringTokenizer(allvalues, SystemTypeFieldEditor.makeString('=', ';'));
        Hashtable<String, String> keyValues = new Hashtable<String, String>(10);
        int count = 0;
        String token1 = null;
        String token2 = null;
        while (tokens.hasMoreTokens()) {
            if (++count % 2 == 0) {
                token2 = tokens.nextToken();
                keyValues.put(token1, token2);
                continue;
            }
            token1 = tokens.nextToken();
        }
        return keyValues;
    }

    private static String makeString(char charOne, char charTwo) {
        StringBuffer s = new StringBuffer(2);
        s.append(charOne);
        s.append(charTwo);
        return s.toString();
    }

    public static String createString(Hashtable keyValues) {
        if (keyValues == null) {
            return null;
        }
        Enumeration keys = keyValues.keys();
        StringBuffer sb = new StringBuffer();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            String value = (String)keyValues.get(key);
            if (value == null || value.length() <= 0) continue;
            sb.append(key);
            sb.append('=');
            sb.append(value);
            sb.append(';');
        }
        return sb.toString();
    }

    private IRSESystemType[] getSystemTypes(boolean restoreDefaults) {
        IRSESystemType[] types = RSECorePlugin.getTheCoreRegistry().getSystemTypes();
        ArrayList<IRSESystemType> list = new ArrayList<IRSESystemType>();
        if (this.systemTypes == null || restoreDefaults) {
            ISubSystemConfigurationProxy[] proxies = RSECorePlugin.getTheSystemRegistry().getSubSystemConfigurationProxies();
            int i = 0;
            while (i < types.length) {
                int j = 0;
                while (j < proxies.length) {
                    if (proxies[j].appliesToSystemType(types[i])) {
                        list.add(types[i]);
                        break;
                    }
                    ++j;
                }
                ++i;
            }
        }
        types = new IRSESystemType[list.size()];
        int i = 0;
        while (i < list.size()) {
            types[i] = (IRSESystemType)list.get(i);
            ++i;
        }
        return types;
    }

    public boolean canModify(Object element, String property) {
        if (property.equals(P_ENABLED)) {
            return true;
        }
        return property.equals(P_USERID);
    }

    public Object getValue(Object element, String property) {
        IRSESystemType row = (IRSESystemType)element;
        RSESystemTypeAdapter adapter = (RSESystemTypeAdapter)row.getAdapter(RSESystemTypeAdapter.class);
        Object value = "";
        value = property.equals(P_NAME) ? row.getLabel() : (property.equals(P_ENABLED) ? (row.isEnabled() ? new Integer(0) : new Integer(1)) : (property.equals(P_USERID) ? (adapter.getDefaultUserId(row) == null ? "" : adapter.getDefaultUserId(row)) : (row.getDescription() == null ? "" : row.getDescription())));
        return value;
    }

    public boolean enabledStateChanged() {
        return this.enabledStateChanged;
    }

    public void modify(Object element, String property, Object value) {
        IRSESystemType row = (IRSESystemType)((TableItem)element).getData();
        if (property.equals(P_ENABLED)) {
            Integer val = (Integer)value;
            RSEPreferencesManager.setIsSystemTypeEnabled((IRSESystemType)row, (boolean)enabledStates[val]);
            this.enabledStateChanged = true;
        } else if (property.equals(P_USERID)) {
            RSEPreferencesManager.setDefaultUserId((IRSESystemType)row, (String)((String)value));
        } else {
            return;
        }
        this.keyValues.put(row.getId(), "");
        this.tableViewer.update((Object)row, null);
    }

    public Image getColumnImage(Object element, int columnIndex) {
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        IRSESystemType currType = (IRSESystemType)element;
        if (columnIndex == 0) {
            return currType.getLabel();
        }
        if (columnIndex == 1) {
            int n = 0;
            if (currType.isEnabled() == enabledStates[1]) {
                n = 1;
            }
            return enabledStateStrings[n];
        }
        if (columnIndex == 2) {
            RSESystemTypeAdapter adapter = (RSESystemTypeAdapter)currType.getAdapter(RSESystemTypeAdapter.class);
            return adapter.getDefaultUserId(currType) == null ? "" : adapter.getDefaultUserId(currType);
        }
        return currType.getDescription() == null ? "" : currType.getDescription();
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public boolean isLabelProperty(Object element, String property) {
        return true;
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    public Object[] getElements(Object inputElement) {
        if (this.systemTypes == null) {
            this.systemTypes = this.getSystemTypes(false);
        }
        return this.systemTypes;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public void setToolTipText(String tip) {
        this.table.setToolTipText(tip);
    }
}

