/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.terminal.connector.remote.launcher;

import java.text.DateFormat;
import java.util.Date;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.osgi.util.NLS;
import org.eclipse.tm.internal.terminal.provisional.api.ISettingsStore;
import org.eclipse.tm.internal.terminal.provisional.api.ITerminalConnector;
import org.eclipse.tm.internal.terminal.provisional.api.TerminalConnectorExtension;
import org.eclipse.tm.terminal.connector.remote.controls.RemoteWizardConfigurationPanel;
import org.eclipse.tm.terminal.connector.remote.internal.RemoteSettings;
import org.eclipse.tm.terminal.connector.remote.launcher.RemoteMementoHandler;
import org.eclipse.tm.terminal.connector.remote.nls.Messages;
import org.eclipse.tm.terminal.view.core.TerminalServiceFactory;
import org.eclipse.tm.terminal.view.core.interfaces.ITerminalService;
import org.eclipse.tm.terminal.view.ui.interfaces.IConfigurationPanel;
import org.eclipse.tm.terminal.view.ui.interfaces.IConfigurationPanelContainer;
import org.eclipse.tm.terminal.view.ui.interfaces.IMementoHandler;
import org.eclipse.tm.terminal.view.ui.internal.SettingsStore;
import org.eclipse.tm.terminal.view.ui.launcher.AbstractLauncherDelegate;

public class RemoteLauncherDelegate
extends AbstractLauncherDelegate {
    private final IMementoHandler mementoHandler = new RemoteMementoHandler();

    public boolean needsUserConfiguration() {
        return true;
    }

    public IConfigurationPanel getPanel(IConfigurationPanelContainer container) {
        return new RemoteWizardConfigurationPanel(container);
    }

    public void execute(Map<String, Object> properties, ITerminalService.Done done) {
        ITerminalService terminal;
        Assert.isNotNull(properties);
        String terminalTitle = this.getTerminalTitle(properties);
        if (terminalTitle != null) {
            properties.put("title", terminalTitle);
        }
        if (!properties.containsKey("terminal.forceNew")) {
            properties.put("terminal.forceNew", Boolean.TRUE);
        }
        if ((terminal = TerminalServiceFactory.getService()) != null) {
            terminal.openConsole(properties, done);
        }
    }

    private String getTerminalTitle(Map<String, Object> properties) {
        String connection = (String)properties.get("ConnectionName");
        if (connection != null) {
            DateFormat format = DateFormat.getDateTimeInstance(3, 3);
            String date = format.format(new Date(System.currentTimeMillis()));
            return NLS.bind((String)Messages.RemoteLauncherDelegate_terminalTitle, (Object[])new String[]{connection, date});
        }
        return Messages.RemoteLauncherDelegate_terminalTitle_default;
    }

    public Object getAdapter(Class adapter) {
        if (IMementoHandler.class.equals((Object)adapter)) {
            return this.mementoHandler;
        }
        return super.getAdapter(adapter);
    }

    public ITerminalConnector createTerminalConnector(Map<String, Object> properties) {
        Assert.isNotNull(properties);
        String connectorId = (String)properties.get("tm.terminal.connector.id");
        if (connectorId == null) {
            connectorId = "org.eclipse.tm.terminal.connector.remote.RemoteConnector";
        }
        String services = (String)properties.get("RemoteServices");
        String connection = (String)properties.get("ConnectionName");
        SettingsStore store = new SettingsStore();
        RemoteSettings remoteSettings = new RemoteSettings();
        remoteSettings.setRemoteServices(services);
        remoteSettings.setConnectionName(connection);
        remoteSettings.save((ISettingsStore)store);
        ITerminalConnector connector = TerminalConnectorExtension.makeTerminalConnector((String)connectorId);
        if (connector != null) {
            connector.setDefaultSettings();
            connector.load((ISettingsStore)store);
        }
        return connector;
    }
}

