/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.internal.terminal.connector;

import java.io.OutputStream;
import junit.framework.TestCase;
import org.eclipse.core.runtime.Platform;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tm.internal.terminal.connector.TerminalConnector;
import org.eclipse.tm.internal.terminal.provisional.api.ISettingsStore;
import org.eclipse.tm.internal.terminal.provisional.api.ITerminalControl;
import org.eclipse.tm.internal.terminal.provisional.api.TerminalState;
import org.eclipse.tm.internal.terminal.provisional.api.provider.TerminalConnectorImpl;

public class TerminalConnectorFactoryTest
extends TestCase {
    protected TerminalConnector makeTerminalConnector() {
        return this.makeTerminalConnector(new ConnectorMock());
    }

    protected TerminalConnector makeTerminalConnector(final TerminalConnectorImpl mock) {
        TerminalConnector c = new TerminalConnector(new TerminalConnector.Factory(){

            public TerminalConnectorImpl makeConnector() throws Exception {
                return mock;
            }
        }, "xID", "xName", false);
        return c;
    }

    public void testGetInitializationErrorMessage() {
        TerminalConnector c = this.makeTerminalConnector();
        c.connect((ITerminalControl)new TerminalControlMock());
        TerminalConnectorFactoryTest.assertNull((Object)c.getInitializationErrorMessage());
        c = this.makeTerminalConnector(new ConnectorMock(){

            public void initialize() throws Exception {
                throw new Exception("FAILED");
            }
        });
        c.connect((ITerminalControl)new TerminalControlMock());
        TerminalConnectorFactoryTest.assertEquals((String)"FAILED", (String)c.getInitializationErrorMessage());
    }

    public void testGetIdAndName() {
        TerminalConnector c = this.makeTerminalConnector();
        TerminalConnectorFactoryTest.assertEquals((String)"xID", (String)c.getId());
        TerminalConnectorFactoryTest.assertEquals((String)"xName", (String)c.getName());
    }

    public void testIsInitialized() {
        TerminalConnector c = this.makeTerminalConnector();
        TerminalConnectorFactoryTest.assertFalse((boolean)c.isInitialized());
        c.getId();
        TerminalConnectorFactoryTest.assertFalse((boolean)c.isInitialized());
        c.getName();
        TerminalConnectorFactoryTest.assertFalse((boolean)c.isInitialized());
        c.getSettingsSummary();
        TerminalConnectorFactoryTest.assertFalse((boolean)c.isInitialized());
        c.setTerminalSize(10, 10);
        TerminalConnectorFactoryTest.assertFalse((boolean)c.isInitialized());
        c.load(null);
        TerminalConnectorFactoryTest.assertFalse((boolean)c.isInitialized());
        c.save(null);
        TerminalConnectorFactoryTest.assertFalse((boolean)c.isInitialized());
        if (!Platform.isRunning()) {
            return;
        }
        c.getAdapter(ConnectorMock.class);
        TerminalConnectorFactoryTest.assertFalse((boolean)c.isInitialized());
    }

    public void testConnect() {
        TerminalConnector c = this.makeTerminalConnector();
        TerminalConnectorFactoryTest.assertFalse((boolean)c.isInitialized());
        c.connect((ITerminalControl)new TerminalControlMock());
        TerminalConnectorFactoryTest.assertTrue((boolean)c.isInitialized());
    }

    public void testDisconnect() {
        ConnectorMock mock = new ConnectorMock();
        TerminalConnector c = this.makeTerminalConnector(mock);
        TerminalControlMock control = new TerminalControlMock();
        c.connect((ITerminalControl)control);
        c.disconnect();
        TerminalConnectorFactoryTest.assertTrue((boolean)mock.fDisconnect);
    }

    public void testGetTerminalToRemoteStream() {
        ConnectorMock mock = new ConnectorMock();
        TerminalConnector c = this.makeTerminalConnector(mock);
        TerminalControlMock control = new TerminalControlMock();
        c.connect((ITerminalControl)control);
        TerminalConnectorFactoryTest.assertSame((Object)mock.fTerminalControl, (Object)control);
    }

    public void testGetSettingsSummary() {
        TerminalConnector c = this.makeTerminalConnector();
        TerminalConnectorFactoryTest.assertEquals((String)"Not Initialized", (String)c.getSettingsSummary());
        c.connect((ITerminalControl)new TerminalControlMock());
        TerminalConnectorFactoryTest.assertEquals((String)"Summary", (String)c.getSettingsSummary());
    }

    public void testIsLocalEcho() {
        ConnectorMock mock = new ConnectorMock();
        TerminalConnector c = this.makeTerminalConnector(mock);
        TerminalConnectorFactoryTest.assertFalse((boolean)c.isLocalEcho());
        mock.fEcho = true;
        TerminalConnectorFactoryTest.assertTrue((boolean)c.isLocalEcho());
    }

    public void testLoad() {
        ConnectorMock mock = new ConnectorMock();
        TerminalConnector c = this.makeTerminalConnector(mock);
        SettingsMock s = new SettingsMock();
        c.load((ISettingsStore)s);
        TerminalConnectorFactoryTest.assertNull((Object)mock.fLoadStore);
        c.connect((ITerminalControl)new TerminalControlMock());
        TerminalConnectorFactoryTest.assertSame((Object)s, (Object)mock.fLoadStore);
    }

    public void testSave() {
        ConnectorMock mock = new ConnectorMock();
        TerminalConnector c = this.makeTerminalConnector(mock);
        SettingsMock s = new SettingsMock();
        c.save((ISettingsStore)s);
        TerminalConnectorFactoryTest.assertNull((Object)mock.fSaveStore);
        c.connect((ITerminalControl)new TerminalControlMock());
        c.save((ISettingsStore)s);
        TerminalConnectorFactoryTest.assertSame((Object)s, (Object)mock.fSaveStore);
    }

    public void testSetDefaultSettings() {
        ConnectorMock mock = new ConnectorMock();
        TerminalConnector c = this.makeTerminalConnector(mock);
        c.setDefaultSettings();
    }

    public void testSetTerminalSize() {
        ConnectorMock mock = new ConnectorMock();
        TerminalConnector c = this.makeTerminalConnector(mock);
        c.setTerminalSize(100, 200);
    }

    public void testGetAdapter() {
        if (!Platform.isRunning()) {
            return;
        }
        ConnectorMock mock = new ConnectorMock();
        TerminalConnector c = this.makeTerminalConnector(mock);
        TerminalConnectorFactoryTest.assertNull((Object)c.getAdapter(ConnectorMock.class));
        c.connect((ITerminalControl)new TerminalControlMock());
        TerminalConnectorFactoryTest.assertSame((Object)((Object)mock), (Object)c.getAdapter(ConnectorMock.class));
    }

    static class ConnectorMock
    extends TerminalConnectorImpl {
        public boolean fEcho;
        public int fWidth;
        public int fHeight;
        public ITerminalControl fTerminalControl;
        public ISettingsStore fSaveStore;
        public ISettingsStore fLoadStore;
        public boolean fDisconnect;

        ConnectorMock() {
        }

        public boolean isLocalEcho() {
            return this.fEcho;
        }

        public void setTerminalSize(int newWidth, int newHeight) {
            this.fWidth = newWidth;
            this.fHeight = newHeight;
        }

        public void connect(ITerminalControl control) {
            super.connect(control);
            this.fTerminalControl = control;
        }

        public void doDisconnect() {
            this.fDisconnect = true;
        }

        public OutputStream getTerminalToRemoteStream() {
            return null;
        }

        public String getSettingsSummary() {
            return "Summary";
        }

        public void load(ISettingsStore store) {
            this.fLoadStore = store;
        }

        public void save(ISettingsStore store) {
            this.fSaveStore = store;
        }
    }

    public class SettingsMock
    implements ISettingsStore {
        public String get(String key) {
            return null;
        }

        public String get(String key, String defaultValue) {
            return null;
        }

        public void put(String key, String value) {
        }
    }

    public static class TerminalControlMock
    implements ITerminalControl {
        public void setEncoding(String encoding) {
        }

        public String getEncoding() {
            return "ISO-8859-1";
        }

        public void displayTextInTerminal(String text) {
        }

        public OutputStream getRemoteToTerminalOutputStream() {
            return null;
        }

        public Shell getShell() {
            return null;
        }

        public TerminalState getState() {
            return null;
        }

        public void setMsg(String msg) {
        }

        public void setState(TerminalState state) {
        }

        public void setTerminalTitle(String title) {
        }

        public void setupTerminal(Composite parent) {
        }

        public boolean isConnectOnEnterIfClosed() {
            return false;
        }

        public void setConnectOnEnterIfClosed(boolean on) {
        }

        public void setVT100LineWrapping(boolean enable) {
        }

        public boolean isVT100LineWrapping() {
            return false;
        }
    }
}

