/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.internal.terminal.test.ui;

import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import org.eclipse.tm.internal.terminal.control.impl.ITerminalControlForText;
import org.eclipse.tm.internal.terminal.emulator.VT100Emulator;
import org.eclipse.tm.internal.terminal.provisional.api.ITerminalConnector;
import org.eclipse.tm.internal.terminal.provisional.api.TerminalState;
import org.eclipse.tm.internal.terminal.test.ui.IDataSource;
import org.eclipse.tm.terminal.model.ITerminalTextData;

final class VT100DataSource
implements IDataSource {
    VT100Emulator fEmulator;
    volatile int fAvailable;
    volatile int fRead;
    private final String fFile;

    VT100DataSource(String file) {
        this.fFile = file;
    }

    void init(ITerminalTextData terminal) {
        InputStreamReader reader;
        try {
            reader = new InputStreamReader((InputStream)new InfiniteFileInputStream(), "ISO-8859-1");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.fEmulator = new VT100Emulator(terminal, new ITerminalControlForText(){

            public void disconnectTerminal() {
            }

            public OutputStream getOutputStream() {
                return new ByteArrayOutputStream();
            }

            public TerminalState getState() {
                return TerminalState.CONNECTED;
            }

            public ITerminalConnector getTerminalConnector() {
                return null;
            }

            public void setState(TerminalState state) {
            }

            public void setTerminalTitle(String title) {
            }

            public void enableApplicationCursorKeys(boolean enable) {
            }
        }, (Reader)reader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int step(ITerminalTextData terminal) {
        ITerminalTextData iTerminalTextData = terminal;
        synchronized (iTerminalTextData) {
            if (this.fEmulator == null) {
                this.init(terminal);
                this.fEmulator.setDimensions(24, 80);
                this.fEmulator.setCrAfterNewLine(true);
            }
            this.fAvailable = 80;
            this.fEmulator.processText();
        }
        return 80;
    }

    class InfiniteFileInputStream
    extends InputStream {
        private InputStream fInputStream;

        public InfiniteFileInputStream() {
            try {
                this.fInputStream = new FileInputStream(VT100DataSource.this.fFile);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        }

        @Override
        public int available() throws IOException {
            return VT100DataSource.this.fAvailable;
        }

        @Override
        public int read() throws IOException {
            throw new IOException();
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            while (VT100DataSource.this.fAvailable == 0) {
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
            len = VT100DataSource.this.fAvailable;
            int n = this.fInputStream.read(b, off, len);
            if (n <= 0) {
                this.fInputStream.close();
                this.fInputStream = new FileInputStream(VT100DataSource.this.fFile);
                n = this.fInputStream.read(b, off, len);
            }
            VT100DataSource.this.fAvailable -= n;
            return n;
        }
    }
}

