/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.internal.terminal.model;

import junit.framework.TestCase;
import org.eclipse.tm.internal.terminal.model.TerminalTextData;
import org.eclipse.tm.internal.terminal.model.TerminalTextTestHelper;
import org.eclipse.tm.terminal.model.ITerminalTextData;
import org.eclipse.tm.terminal.model.ITerminalTextDataReadOnly;
import org.eclipse.tm.terminal.model.ITerminalTextDataSnapshot;

public class TerminalTextDataSnapshotWindowTest
extends TestCase {
    String toMultiLineText(ITerminalTextDataReadOnly term) {
        return TerminalTextTestHelper.toMultiLineText(term);
    }

    String toSimpleText(ITerminalTextDataReadOnly term) {
        return TerminalTextTestHelper.toSimple(term);
    }

    protected ITerminalTextData makeITerminalTextData() {
        return new TerminalTextData();
    }

    ITerminalTextDataSnapshot snapshotSimple(String text, ITerminalTextData term) {
        TerminalTextTestHelper.fillSimple(term, text);
        ITerminalTextDataSnapshot snapshot = term.makeSnapshot();
        return snapshot;
    }

    void assertChangedLines(ITerminalTextDataSnapshot snapshot, String expected) {
        TerminalTextDataSnapshotWindowTest.assertEquals((int)expected.length(), (int)snapshot.getHeight());
        StringBuffer buffer = new StringBuffer();
        int line = 0;
        while (line < expected.length()) {
            if (snapshot.hasLineChanged(line)) {
                buffer.append('1');
            } else {
                buffer.append('0');
            }
            ++line;
        }
        TerminalTextDataSnapshotWindowTest.assertEquals((String)expected, (String)buffer.toString());
    }

    public void testSetInterestWindow() {
        ITerminalTextData term = this.makeITerminalTextData();
        ITerminalTextDataSnapshot snapshot = this.snapshotSimple("0123456789", term);
        TerminalTextDataSnapshotWindowTest.assertEquals((int)0, (int)snapshot.getInterestWindowStartLine());
        TerminalTextDataSnapshotWindowTest.assertEquals((int)-1, (int)snapshot.getInterestWindowSize());
        snapshot.setInterestWindow(2, 3);
        TerminalTextDataSnapshotWindowTest.assertEquals((int)2, (int)snapshot.getInterestWindowStartLine());
        TerminalTextDataSnapshotWindowTest.assertEquals((int)3, (int)snapshot.getInterestWindowSize());
        snapshot.updateSnapshot(false);
        this.assertChangedLines(snapshot, "0011100000");
    }

    public void testSetChar() {
        ITerminalTextData term = this.makeITerminalTextData();
        ITerminalTextDataSnapshot snapshot = this.snapshotSimple("0123456789", term);
        snapshot.setInterestWindow(2, 3);
        snapshot.updateSnapshot(false);
        TerminalTextDataSnapshotWindowTest.assertEquals((String)"  234     ", (String)this.toSimpleText((ITerminalTextDataReadOnly)snapshot));
        term.setChar(0, 0, 'x', null);
        TerminalTextDataSnapshotWindowTest.assertFalse((boolean)snapshot.isOutOfDate());
        snapshot.updateSnapshot(false);
        this.assertChangedLines(snapshot, "0000000000");
        term.setChar(1, 0, 'x', null);
        TerminalTextDataSnapshotWindowTest.assertFalse((boolean)snapshot.isOutOfDate());
        term.setChar(2, 0, 'x', null);
        TerminalTextDataSnapshotWindowTest.assertTrue((boolean)snapshot.isOutOfDate());
        snapshot.updateSnapshot(false);
        this.assertChangedLines(snapshot, "0010000000");
        term.setChar(3, 0, 'x', null);
        TerminalTextDataSnapshotWindowTest.assertTrue((boolean)snapshot.isOutOfDate());
        snapshot.updateSnapshot(false);
        this.assertChangedLines(snapshot, "0001000000");
        term.setChar(4, 0, 'x', null);
        TerminalTextDataSnapshotWindowTest.assertTrue((boolean)snapshot.isOutOfDate());
        snapshot.updateSnapshot(false);
        this.assertChangedLines(snapshot, "0000100000");
        term.setChar(5, 0, 'x', null);
        TerminalTextDataSnapshotWindowTest.assertFalse((boolean)snapshot.isOutOfDate());
        term.setChar(6, 0, 'x', null);
        TerminalTextDataSnapshotWindowTest.assertFalse((boolean)snapshot.isOutOfDate());
        int i = 0;
        while (i < 9) {
            term.setChar(i, 0, (char)(97 + i), null);
            ++i;
        }
        TerminalTextDataSnapshotWindowTest.assertTrue((boolean)snapshot.isOutOfDate());
        snapshot.updateSnapshot(false);
        this.assertChangedLines(snapshot, "0011100000");
    }

    public void testSetChars() {
        ITerminalTextData term = this.makeITerminalTextData();
        ITerminalTextDataSnapshot snapshot = this.snapshotSimple("0123456789", term);
        snapshot.setInterestWindow(2, 3);
        snapshot.updateSnapshot(false);
        TerminalTextDataSnapshotWindowTest.assertEquals((String)"  234     ", (String)this.toSimpleText((ITerminalTextDataReadOnly)snapshot));
        term.setChars(0, 0, "x".toCharArray(), null);
        TerminalTextDataSnapshotWindowTest.assertFalse((boolean)snapshot.isOutOfDate());
        snapshot.updateSnapshot(false);
        this.assertChangedLines(snapshot, "0000000000");
        term.setChars(1, 0, "x".toCharArray(), null);
        TerminalTextDataSnapshotWindowTest.assertFalse((boolean)snapshot.isOutOfDate());
        term.setChars(2, 0, "x".toCharArray(), null);
        TerminalTextDataSnapshotWindowTest.assertTrue((boolean)snapshot.isOutOfDate());
        snapshot.updateSnapshot(false);
        this.assertChangedLines(snapshot, "0010000000");
        term.setChars(3, 0, "x".toCharArray(), null);
        TerminalTextDataSnapshotWindowTest.assertTrue((boolean)snapshot.isOutOfDate());
        snapshot.updateSnapshot(false);
        this.assertChangedLines(snapshot, "0001000000");
        term.setChars(4, 0, "x".toCharArray(), null);
        TerminalTextDataSnapshotWindowTest.assertTrue((boolean)snapshot.isOutOfDate());
        snapshot.updateSnapshot(false);
        this.assertChangedLines(snapshot, "0000100000");
        term.setChars(5, 0, "x".toCharArray(), null);
        TerminalTextDataSnapshotWindowTest.assertFalse((boolean)snapshot.isOutOfDate());
        term.setChars(6, 0, "x".toCharArray(), null);
        TerminalTextDataSnapshotWindowTest.assertFalse((boolean)snapshot.isOutOfDate());
        int i = 0;
        while (i < 9) {
            term.setChars(i, 0, String.valueOf(i).toCharArray(), null);
            ++i;
        }
        TerminalTextDataSnapshotWindowTest.assertTrue((boolean)snapshot.isOutOfDate());
        snapshot.updateSnapshot(false);
        this.assertChangedLines(snapshot, "0011100000");
    }

    public void testSetChars2() {
        ITerminalTextData term = this.makeITerminalTextData();
        ITerminalTextDataSnapshot snapshot = this.snapshotSimple("0123456789", term);
        snapshot.setInterestWindow(2, 3);
        snapshot.updateSnapshot(false);
        TerminalTextDataSnapshotWindowTest.assertEquals((String)"  234     ", (String)this.toSimpleText((ITerminalTextDataReadOnly)snapshot));
        term.setChars(0, 0, "abcdef".toCharArray(), 2, 1, null);
        TerminalTextDataSnapshotWindowTest.assertFalse((boolean)snapshot.isOutOfDate());
        snapshot.updateSnapshot(false);
        this.assertChangedLines(snapshot, "0000000000");
        term.setChars(1, 0, "abcdef".toCharArray(), 2, 1, null);
        TerminalTextDataSnapshotWindowTest.assertFalse((boolean)snapshot.isOutOfDate());
        term.setChars(2, 0, "abcdef".toCharArray(), 2, 1, null);
        TerminalTextDataSnapshotWindowTest.assertTrue((boolean)snapshot.isOutOfDate());
        snapshot.updateSnapshot(false);
        this.assertChangedLines(snapshot, "0010000000");
        term.setChars(3, 0, "abcdef".toCharArray(), 2, 1, null);
        TerminalTextDataSnapshotWindowTest.assertTrue((boolean)snapshot.isOutOfDate());
        snapshot.updateSnapshot(false);
        this.assertChangedLines(snapshot, "0001000000");
        term.setChars(4, 0, "abcdef".toCharArray(), 2, 1, null);
        TerminalTextDataSnapshotWindowTest.assertTrue((boolean)snapshot.isOutOfDate());
        snapshot.updateSnapshot(false);
        this.assertChangedLines(snapshot, "0000100000");
        term.setChars(5, 0, "abcdef".toCharArray(), 2, 1, null);
        TerminalTextDataSnapshotWindowTest.assertFalse((boolean)snapshot.isOutOfDate());
        term.setChars(6, 0, "abcdef".toCharArray(), 2, 1, null);
        TerminalTextDataSnapshotWindowTest.assertFalse((boolean)snapshot.isOutOfDate());
        int i = 0;
        while (i < 9) {
            term.setChars(i, 0, ("ab" + i + "def").toCharArray(), 2, 1, null);
            ++i;
        }
        TerminalTextDataSnapshotWindowTest.assertTrue((boolean)snapshot.isOutOfDate());
        snapshot.updateSnapshot(false);
        this.assertChangedLines(snapshot, "0011100000");
    }
}

