/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.internal.terminal.emulator;

import junit.framework.TestCase;
import org.eclipse.tm.internal.terminal.emulator.IVT100EmulatorBackend;
import org.eclipse.tm.internal.terminal.emulator.VT100EmulatorBackend;
import org.eclipse.tm.internal.terminal.model.TerminalTextDataStore;
import org.eclipse.tm.internal.terminal.model.TerminalTextTestHelper;
import org.eclipse.tm.terminal.model.ITerminalTextData;
import org.eclipse.tm.terminal.model.ITerminalTextDataReadOnly;
import org.eclipse.tm.terminal.model.Style;

public class VT100EmulatorBackendTest
extends TestCase {
    protected IVT100EmulatorBackend makeBakend(ITerminalTextData term) {
        return new VT100EmulatorBackend(term);
    }

    protected ITerminalTextData makeITerminalTextData() {
        return new TerminalTextDataStore();
    }

    protected String toSimple(ITerminalTextData term) {
        return TerminalTextTestHelper.toSimple((ITerminalTextDataReadOnly)term);
    }

    protected String toMultiLineText(ITerminalTextDataReadOnly term) {
        return TerminalTextTestHelper.toMultiLineText(term);
    }

    protected void fill(ITerminalTextData term, String s) {
        TerminalTextTestHelper.fill(term, s);
    }

    protected void fillSimple(ITerminalTextData term, String s) {
        TerminalTextTestHelper.fillSimple(term, s);
    }

    protected void assertEqualsTerm(String expected, String actual) {
        VT100EmulatorBackendTest.assertEquals((String)expected.replace(' ', '.'), (String)actual.replace('\u0000', '.'));
    }

    protected void assertEqualsSimple(String expected, String actual) {
        VT100EmulatorBackendTest.assertEquals((int)-1, (int)actual.indexOf(10));
        VT100EmulatorBackendTest.assertEquals((String)expected, (String)actual);
    }

    public void testClearAll() {
        ITerminalTextData term = this.makeITerminalTextData();
        IVT100EmulatorBackend vt100 = this.makeBakend(term);
        vt100.setDimensions(3, 4);
        this.fill(term, "0000\n1111\n2222\n3333\n4444\n5555");
        vt100.clearAll();
        this.assertEqualsTerm("    \n    \n    ", this.toMultiLineText((ITerminalTextDataReadOnly)term));
    }

    public void testSetDimensions() {
        ITerminalTextData term = this.makeITerminalTextData();
        IVT100EmulatorBackend vt100 = this.makeBakend(term);
        String s = "0000\n1111\n2222\n3333\n4444\n5555";
        this.fill(term, s);
        vt100.setDimensions(3, 4);
        VT100EmulatorBackendTest.assertEquals((int)3, (int)vt100.getLines());
        VT100EmulatorBackendTest.assertEquals((int)4, (int)vt100.getColumns());
        this.assertEqualsTerm(s, this.toMultiLineText((ITerminalTextDataReadOnly)term));
        vt100.setCursor(0, 2);
        vt100.setDimensions(2, 4);
        VT100EmulatorBackendTest.assertEquals((int)0, (int)vt100.getCursorLine());
        VT100EmulatorBackendTest.assertEquals((int)2, (int)vt100.getCursorColumn());
        vt100.setCursor(0, 2);
        vt100.setDimensions(5, 4);
        VT100EmulatorBackendTest.assertEquals((int)3, (int)vt100.getCursorLine());
        VT100EmulatorBackendTest.assertEquals((int)2, (int)vt100.getCursorColumn());
        this.assertEqualsTerm(s, this.toMultiLineText((ITerminalTextDataReadOnly)term));
        vt100.setCursor(0, 3);
        vt100.setDimensions(5, 2);
        VT100EmulatorBackendTest.assertEquals((int)0, (int)vt100.getCursorLine());
        VT100EmulatorBackendTest.assertEquals((int)1, (int)vt100.getCursorColumn());
    }

    public void testToAbsoluteLine() {
        ITerminalTextData term = this.makeITerminalTextData();
        VT100EmulatorBackend vt100 = new VT100EmulatorBackend(term);
        vt100.setDimensions(2, 3);
        VT100EmulatorBackendTest.assertEquals((int)vt100.toAbsoluteLine(0), (int)0);
        term = this.makeITerminalTextData();
        vt100 = new VT100EmulatorBackend(term);
        vt100.setDimensions(1, 10);
        VT100EmulatorBackendTest.assertEquals((int)vt100.toAbsoluteLine(0), (int)0);
    }

    public void testInsertCharacters() {
        ITerminalTextData term = this.makeITerminalTextData();
        IVT100EmulatorBackend vt100 = this.makeBakend(term);
        vt100.setDimensions(3, 4);
        String s = "aaaa\nbbbb\ncccc\ndddd\neeee\nffff\n1234\n4567\n9012";
        this.fill(term, s);
        vt100.setCursor(0, 0);
        vt100.insertCharacters(1);
        this.assertEqualsTerm("aaaa\nbbbb\ncccc\ndddd\neeee\nffff\n 123\n4567\n9012", this.toMultiLineText((ITerminalTextDataReadOnly)term));
        this.fill(term, s);
        vt100.setCursor(1, 1);
        vt100.insertCharacters(1);
        this.assertEqualsTerm("aaaa\nbbbb\ncccc\ndddd\neeee\nffff\n1234\n4 56\n9012", this.toMultiLineText((ITerminalTextDataReadOnly)term));
        this.fill(term, s);
        vt100.setCursor(1, 1);
        vt100.insertCharacters(2);
        this.assertEqualsTerm("aaaa\nbbbb\ncccc\ndddd\neeee\nffff\n1234\n4  5\n9012", this.toMultiLineText((ITerminalTextDataReadOnly)term));
        vt100.setDimensions(1, 10);
        this.fill(term, "0123456789");
        vt100.setCursor(0, 0);
        vt100.insertCharacters(10);
        this.assertEqualsTerm("          ", this.toMultiLineText((ITerminalTextDataReadOnly)term));
        vt100.setDimensions(1, 10);
        this.fill(term, "0123456789");
        vt100.setCursor(0, 0);
        vt100.insertCharacters(14);
        this.assertEqualsTerm("          ", this.toMultiLineText((ITerminalTextDataReadOnly)term));
        vt100.setDimensions(1, 10);
        this.fill(term, "0123456789");
        vt100.setCursor(0, 3);
        vt100.insertCharacters(14);
        this.assertEqualsTerm("012       ", this.toMultiLineText((ITerminalTextDataReadOnly)term));
        vt100.setDimensions(1, 10);
        this.fill(term, "0123456789");
        vt100.setCursor(0, 3);
        vt100.insertCharacters(0);
        this.assertEqualsTerm("0123456789", this.toMultiLineText((ITerminalTextDataReadOnly)term));
        vt100.setDimensions(1, 10);
        this.fill(term, "0123456789");
        vt100.setCursor(0, 3);
        vt100.insertCharacters(2);
        this.assertEqualsTerm("012  34567", this.toMultiLineText((ITerminalTextDataReadOnly)term));
    }

    public void testEraseToEndOfScreen() {
        ITerminalTextData term = this.makeITerminalTextData();
        IVT100EmulatorBackend vt100 = this.makeBakend(term);
        vt100.setDimensions(3, 4);
        String s = "aaaa\nbbbb\ncccc\ndddd\neeee\nffff\n0123\n4567\n8901";
        this.fill(term, s);
        vt100.setCursor(0, 0);
        vt100.eraseToEndOfScreen();
        VT100EmulatorBackendTest.assertEquals((int)0, (int)vt100.getCursorLine());
        VT100EmulatorBackendTest.assertEquals((int)0, (int)vt100.getCursorColumn());
        this.assertEqualsTerm("aaaa\nbbbb\ncccc\ndddd\neeee\nffff\n    \n    \n    ", this.toMultiLineText((ITerminalTextDataReadOnly)term));
        this.fill(term, s);
        vt100.setCursor(1, 0);
        vt100.eraseToEndOfScreen();
        VT100EmulatorBackendTest.assertEquals((int)1, (int)vt100.getCursorLine());
        VT100EmulatorBackendTest.assertEquals((int)0, (int)vt100.getCursorColumn());
        this.assertEqualsTerm("aaaa\nbbbb\ncccc\ndddd\neeee\nffff\n0123\n    \n    ", this.toMultiLineText((ITerminalTextDataReadOnly)term));
        this.fill(term, s);
        vt100.setCursor(1, 1);
        vt100.eraseToEndOfScreen();
        VT100EmulatorBackendTest.assertEquals((int)1, (int)vt100.getCursorLine());
        VT100EmulatorBackendTest.assertEquals((int)1, (int)vt100.getCursorColumn());
        this.assertEqualsTerm("aaaa\nbbbb\ncccc\ndddd\neeee\nffff\n0123\n4   \n    ", this.toMultiLineText((ITerminalTextDataReadOnly)term));
        this.fill(term, s);
        vt100.setCursor(1, 4);
        VT100EmulatorBackendTest.assertEquals((int)1, (int)vt100.getCursorLine());
        VT100EmulatorBackendTest.assertEquals((int)3, (int)vt100.getCursorColumn());
        vt100.eraseToEndOfScreen();
        VT100EmulatorBackendTest.assertEquals((int)1, (int)vt100.getCursorLine());
        VT100EmulatorBackendTest.assertEquals((int)3, (int)vt100.getCursorColumn());
        this.assertEqualsTerm("aaaa\nbbbb\ncccc\ndddd\neeee\nffff\n0123\n456.\n    ", this.toMultiLineText((ITerminalTextDataReadOnly)term));
        this.fill(term, s);
        vt100.setCursor(1, 5);
        vt100.eraseToEndOfScreen();
        VT100EmulatorBackendTest.assertEquals((int)1, (int)vt100.getCursorLine());
        VT100EmulatorBackendTest.assertEquals((int)3, (int)vt100.getCursorColumn());
        this.assertEqualsTerm("aaaa\nbbbb\ncccc\ndddd\neeee\nffff\n0123\n456.\n    ", this.toMultiLineText((ITerminalTextDataReadOnly)term));
        this.fill(term, s);
        vt100.setCursor(2, 3);
        vt100.eraseToEndOfScreen();
        VT100EmulatorBackendTest.assertEquals((int)2, (int)vt100.getCursorLine());
        VT100EmulatorBackendTest.assertEquals((int)3, (int)vt100.getCursorColumn());
        this.assertEqualsTerm("aaaa\nbbbb\ncccc\ndddd\neeee\nffff\n0123\n4567\n890 ", this.toMultiLineText((ITerminalTextDataReadOnly)term));
        this.fill(term, s);
        vt100.setCursor(2, 5);
        vt100.eraseToEndOfScreen();
        VT100EmulatorBackendTest.assertEquals((int)2, (int)vt100.getCursorLine());
        VT100EmulatorBackendTest.assertEquals((int)3, (int)vt100.getCursorColumn());
        this.assertEqualsTerm("aaaa\nbbbb\ncccc\ndddd\neeee\nffff\n0123\n4567\n890.", this.toMultiLineText((ITerminalTextDataReadOnly)term));
    }

    public void testEraseToCursor() {
        ITerminalTextData term = this.makeITerminalTextData();
        IVT100EmulatorBackend vt100 = this.makeBakend(term);
        vt100.setDimensions(3, 4);
        String s = "aaaa\nbbbb\ncccc\ndddd\neeee\nffff\n0123\n4567\n8901";
        this.fill(term, s);
        vt100.setCursor(0, 0);
        vt100.eraseToCursor();
        VT100EmulatorBackendTest.assertEquals((int)0, (int)vt100.getCursorLine());
        VT100EmulatorBackendTest.assertEquals((int)0, (int)vt100.getCursorColumn());
        this.assertEqualsTerm("aaaa\nbbbb\ncccc\ndddd\neeee\nffff\n 123\n4567\n8901", this.toMultiLineText((ITerminalTextDataReadOnly)term));
        this.fill(term, s);
        vt100.setCursor(1, 0);
        vt100.eraseToCursor();
        VT100EmulatorBackendTest.assertEquals((int)1, (int)vt100.getCursorLine());
        VT100EmulatorBackendTest.assertEquals((int)0, (int)vt100.getCursorColumn());
        this.assertEqualsTerm("aaaa\nbbbb\ncccc\ndddd\neeee\nffff\n    \n 567\n8901", this.toMultiLineText((ITerminalTextDataReadOnly)term));
        this.fill(term, s);
        vt100.setCursor(1, 1);
        vt100.eraseToCursor();
        VT100EmulatorBackendTest.assertEquals((int)1, (int)vt100.getCursorLine());
        VT100EmulatorBackendTest.assertEquals((int)1, (int)vt100.getCursorColumn());
        this.assertEqualsTerm("aaaa\nbbbb\ncccc\ndddd\neeee\nffff\n    \n  67\n8901", this.toMultiLineText((ITerminalTextDataReadOnly)term));
        this.fill(term, s);
        vt100.setCursor(1, 4);
        vt100.eraseToCursor();
        VT100EmulatorBackendTest.assertEquals((int)1, (int)vt100.getCursorLine());
        VT100EmulatorBackendTest.assertEquals((int)3, (int)vt100.getCursorColumn());
        this.assertEqualsTerm("aaaa\nbbbb\ncccc\ndddd\neeee\nffff\n    \n    \n8901", this.toMultiLineText((ITerminalTextDataReadOnly)term));
        this.fill(term, s);
        vt100.setCursor(1, 5);
        vt100.eraseToCursor();
        VT100EmulatorBackendTest.assertEquals((int)1, (int)vt100.getCursorLine());
        VT100EmulatorBackendTest.assertEquals((int)3, (int)vt100.getCursorColumn());
        this.assertEqualsTerm("aaaa\nbbbb\ncccc\ndddd\neeee\nffff\n    \n    \n8901", this.toMultiLineText((ITerminalTextDataReadOnly)term));
        this.fill(term, s);
        vt100.setCursor(2, 3);
        vt100.eraseToCursor();
        VT100EmulatorBackendTest.assertEquals((int)2, (int)vt100.getCursorLine());
        VT100EmulatorBackendTest.assertEquals((int)3, (int)vt100.getCursorColumn());
        this.assertEqualsTerm("aaaa\nbbbb\ncccc\ndddd\neeee\nffff\n    \n    \n    ", this.toMultiLineText((ITerminalTextDataReadOnly)term));
        this.fill(term, s);
        vt100.setCursor(2, 5);
        vt100.eraseToCursor();
        VT100EmulatorBackendTest.assertEquals((int)2, (int)vt100.getCursorLine());
        VT100EmulatorBackendTest.assertEquals((int)3, (int)vt100.getCursorColumn());
        this.assertEqualsTerm("aaaa\nbbbb\ncccc\ndddd\neeee\nffff\n    \n    \n    ", this.toMultiLineText((ITerminalTextDataReadOnly)term));
    }

    public void testEraseAll() {
        ITerminalTextData term = this.makeITerminalTextData();
        IVT100EmulatorBackend vt100 = this.makeBakend(term);
        vt100.setDimensions(3, 4);
        this.fill(term, "0000\n1111\n2222\n3333\n4444\n5555");
        vt100.eraseAll();
        this.assertEqualsTerm("0000\n1111\n2222\n    \n    \n    ", this.toMultiLineText((ITerminalTextDataReadOnly)term));
    }

    public void testEraseLine() {
        String s = "abcde\nfghij\nklmno\npqrst\nuvwxy\nzABCD\nEFGHI";
        ITerminalTextData term = this.makeITerminalTextData();
        IVT100EmulatorBackend vt100 = this.makeBakend(term);
        vt100.setDimensions(3, 5);
        this.fill(term, s);
        vt100.setCursor(0, 3);
        vt100.eraseLine();
        VT100EmulatorBackendTest.assertEquals((int)0, (int)vt100.getCursorLine());
        VT100EmulatorBackendTest.assertEquals((int)3, (int)vt100.getCursorColumn());
        this.assertEqualsTerm("abcde\nfghij\nklmno\npqrst\n     \nzABCD\nEFGHI", this.toMultiLineText((ITerminalTextDataReadOnly)term));
        vt100.setDimensions(3, 5);
        this.fill(term, s);
        vt100.setCursor(2, 3);
        vt100.eraseLine();
        VT100EmulatorBackendTest.assertEquals((int)2, (int)vt100.getCursorLine());
        VT100EmulatorBackendTest.assertEquals((int)3, (int)vt100.getCursorColumn());
        this.assertEqualsTerm("abcde\nfghij\nklmno\npqrst\nuvwxy\nzABCD\n     ", this.toMultiLineText((ITerminalTextDataReadOnly)term));
    }

    public void testEraseLineToEnd() {
        String s = "abcde\nfghij\nklmno\npqrst\nuvwxy\nzABCD\nEFGHI";
        ITerminalTextData term = this.makeITerminalTextData();
        IVT100EmulatorBackend vt100 = this.makeBakend(term);
        vt100.setDimensions(3, 5);
        this.fill(term, s);
        vt100.setCursor(0, 3);
        vt100.eraseLineToEnd();
        VT100EmulatorBackendTest.assertEquals((int)0, (int)vt100.getCursorLine());
        VT100EmulatorBackendTest.assertEquals((int)3, (int)vt100.getCursorColumn());
        this.assertEqualsTerm("abcde\nfghij\nklmno\npqrst\nuvw  \nzABCD\nEFGHI", this.toMultiLineText((ITerminalTextDataReadOnly)term));
        vt100.setDimensions(3, 5);
        this.fill(term, s);
        vt100.setCursor(0, 0);
        vt100.eraseLineToEnd();
        VT100EmulatorBackendTest.assertEquals((int)0, (int)vt100.getCursorLine());
        VT100EmulatorBackendTest.assertEquals((int)0, (int)vt100.getCursorColumn());
        this.assertEqualsTerm("abcde\nfghij\nklmno\npqrst\n     \nzABCD\nEFGHI", this.toMultiLineText((ITerminalTextDataReadOnly)term));
        vt100.setDimensions(3, 5);
        this.fill(term, s);
        vt100.setCursor(2, 3);
        vt100.eraseLineToEnd();
        VT100EmulatorBackendTest.assertEquals((int)2, (int)vt100.getCursorLine());
        VT100EmulatorBackendTest.assertEquals((int)3, (int)vt100.getCursorColumn());
        this.assertEqualsTerm("abcde\nfghij\nklmno\npqrst\nuvwxy\nzABCD\nEFG  ", this.toMultiLineText((ITerminalTextDataReadOnly)term));
        vt100.setDimensions(3, 5);
        this.fill(term, s);
        vt100.setCursor(2, 4);
        vt100.eraseLineToEnd();
        VT100EmulatorBackendTest.assertEquals((int)2, (int)vt100.getCursorLine());
        VT100EmulatorBackendTest.assertEquals((int)4, (int)vt100.getCursorColumn());
        this.assertEqualsTerm("abcde\nfghij\nklmno\npqrst\nuvwxy\nzABCD\nEFGH ", this.toMultiLineText((ITerminalTextDataReadOnly)term));
        vt100.setCursor(2, 5);
        vt100.eraseLineToEnd();
        VT100EmulatorBackendTest.assertEquals((int)2, (int)vt100.getCursorLine());
        VT100EmulatorBackendTest.assertEquals((int)4, (int)vt100.getCursorColumn());
        this.assertEqualsTerm("abcde\nfghij\nklmno\npqrst\nuvwxy\nzABCD\nEFGH ", this.toMultiLineText((ITerminalTextDataReadOnly)term));
    }

    public void testEraseLineToCursor() {
        String s = "abcde\nfghij\nklmno\npqrst\nuvwxy\nzABCD\nEFGHI";
        ITerminalTextData term = this.makeITerminalTextData();
        IVT100EmulatorBackend vt100 = this.makeBakend(term);
        vt100.setDimensions(3, 5);
        this.fill(term, s);
        vt100.setCursor(0, 3);
        vt100.eraseLineToCursor();
        VT100EmulatorBackendTest.assertEquals((int)0, (int)vt100.getCursorLine());
        VT100EmulatorBackendTest.assertEquals((int)3, (int)vt100.getCursorColumn());
        this.assertEqualsTerm("abcde\nfghij\nklmno\npqrst\n    y\nzABCD\nEFGHI", this.toMultiLineText((ITerminalTextDataReadOnly)term));
        vt100.setDimensions(3, 5);
        this.fill(term, s);
        vt100.setCursor(0, 0);
        vt100.eraseLineToCursor();
        VT100EmulatorBackendTest.assertEquals((int)0, (int)vt100.getCursorLine());
        VT100EmulatorBackendTest.assertEquals((int)0, (int)vt100.getCursorColumn());
        this.assertEqualsTerm("abcde\nfghij\nklmno\npqrst\n vwxy\nzABCD\nEFGHI", this.toMultiLineText((ITerminalTextDataReadOnly)term));
        vt100.setDimensions(3, 5);
        this.fill(term, s);
        vt100.setCursor(2, 3);
        vt100.eraseLineToCursor();
        VT100EmulatorBackendTest.assertEquals((int)2, (int)vt100.getCursorLine());
        VT100EmulatorBackendTest.assertEquals((int)3, (int)vt100.getCursorColumn());
        this.assertEqualsTerm("abcde\nfghij\nklmno\npqrst\nuvwxy\nzABCD\n    I", this.toMultiLineText((ITerminalTextDataReadOnly)term));
        vt100.setDimensions(3, 5);
        this.fill(term, s);
        vt100.setCursor(2, 4);
        vt100.eraseLineToCursor();
        VT100EmulatorBackendTest.assertEquals((int)2, (int)vt100.getCursorLine());
        VT100EmulatorBackendTest.assertEquals((int)4, (int)vt100.getCursorColumn());
        this.assertEqualsTerm("abcde\nfghij\nklmno\npqrst\nuvwxy\nzABCD\n     ", this.toMultiLineText((ITerminalTextDataReadOnly)term));
        vt100.setCursor(2, 5);
        vt100.eraseLineToCursor();
        VT100EmulatorBackendTest.assertEquals((int)2, (int)vt100.getCursorLine());
        VT100EmulatorBackendTest.assertEquals((int)4, (int)vt100.getCursorColumn());
        this.assertEqualsTerm("abcde\nfghij\nklmno\npqrst\nuvwxy\nzABCD\n     ", this.toMultiLineText((ITerminalTextDataReadOnly)term));
    }

    public void testInsertLines() {
        ITerminalTextData term = this.makeITerminalTextData();
        IVT100EmulatorBackend vt100 = this.makeBakend(term);
        String s = "0000\n1111\n2222\n3333\n4444\n5555";
        vt100.setDimensions(3, 4);
        this.fill(term, s);
        vt100.setCursor(0, 0);
        vt100.insertLines(1);
        this.assertEqualsTerm("0000\n1111\n2222\n    \n3333\n4444", this.toMultiLineText((ITerminalTextDataReadOnly)term));
        this.fill(term, s);
        vt100.setCursor(1, 0);
        vt100.insertLines(1);
        this.assertEqualsTerm("0000\n1111\n2222\n3333\n    \n4444", this.toMultiLineText((ITerminalTextDataReadOnly)term));
        this.fill(term, s);
        vt100.setCursor(1, 0);
        vt100.insertLines(2);
        this.assertEqualsTerm("0000\n1111\n2222\n3333\n    \n    ", this.toMultiLineText((ITerminalTextDataReadOnly)term));
        this.fill(term, s);
        vt100.setCursor(1, 3);
        vt100.insertLines(2);
        this.assertEqualsTerm("0000\n1111\n2222\n3333\n    \n    ", this.toMultiLineText((ITerminalTextDataReadOnly)term));
        vt100.setDimensions(6, 4);
        this.fill(term, s);
        vt100.setCursor(1, 3);
        vt100.insertLines(2);
        this.assertEqualsTerm("0000\n    \n    \n1111\n2222\n3333", this.toMultiLineText((ITerminalTextDataReadOnly)term));
        vt100.setDimensions(6, 4);
        this.fill(term, s);
        vt100.setCursor(1, 3);
        vt100.insertLines(7);
        this.assertEqualsTerm("0000\n    \n    \n    \n    \n    ", this.toMultiLineText((ITerminalTextDataReadOnly)term));
        vt100.setDimensions(6, 4);
        this.fill(term, s);
        vt100.setCursor(0, 0);
        vt100.insertLines(7);
        this.assertEqualsTerm("    \n    \n    \n    \n    \n    ", this.toMultiLineText((ITerminalTextDataReadOnly)term));
        vt100.setDimensions(6, 4);
        this.fill(term, s);
        vt100.setCursor(0, 0);
        vt100.insertLines(5);
        this.assertEqualsTerm("    \n    \n    \n    \n    \n0000", this.toMultiLineText((ITerminalTextDataReadOnly)term));
    }

    public void testDeleteCharacters() {
        ITerminalTextData term = this.makeITerminalTextData();
        IVT100EmulatorBackend vt100 = this.makeBakend(term);
        vt100.setDimensions(3, 4);
        String s = "aaaa\nbbbb\ncccc\ndddd\neeee\nffff\n1234\n4567\n9012";
        this.fill(term, s);
        vt100.setCursor(0, 0);
        vt100.deleteCharacters(1);
        this.assertEqualsTerm("aaaa\nbbbb\ncccc\ndddd\neeee\nffff\n234 \n4567\n9012", this.toMultiLineText((ITerminalTextDataReadOnly)term));
        this.fill(term, s);
        vt100.setCursor(1, 1);
        vt100.deleteCharacters(1);
        this.assertEqualsTerm("aaaa\nbbbb\ncccc\ndddd\neeee\nffff\n1234\n467 \n9012", this.toMultiLineText((ITerminalTextDataReadOnly)term));
        this.fill(term, s);
        vt100.setCursor(1, 1);
        vt100.deleteCharacters(2);
        this.assertEqualsTerm("aaaa\nbbbb\ncccc\ndddd\neeee\nffff\n1234\n47  \n9012", this.toMultiLineText((ITerminalTextDataReadOnly)term));
        vt100.setDimensions(1, 10);
        this.fill(term, "0123456789");
        vt100.setCursor(0, 0);
        vt100.deleteCharacters(10);
        this.assertEqualsTerm("          ", this.toMultiLineText((ITerminalTextDataReadOnly)term));
        vt100.setDimensions(1, 10);
        this.fill(term, "0123456789");
        vt100.setCursor(0, 0);
        vt100.deleteCharacters(14);
        this.assertEqualsTerm("          ", this.toMultiLineText((ITerminalTextDataReadOnly)term));
        vt100.setDimensions(1, 10);
        this.fill(term, "0123456789");
        vt100.setCursor(0, 3);
        vt100.deleteCharacters(0);
        this.assertEqualsTerm("0123456789", this.toMultiLineText((ITerminalTextDataReadOnly)term));
        vt100.setDimensions(1, 10);
        this.fill(term, "0123456789");
        vt100.setCursor(0, 3);
        vt100.deleteCharacters(2);
        this.assertEqualsTerm("01256789  ", this.toMultiLineText((ITerminalTextDataReadOnly)term));
        vt100.setDimensions(1, 10);
        this.fill(term, "0123456789");
        vt100.setCursor(0, 3);
        vt100.deleteCharacters(14);
        this.assertEqualsTerm("012       ", this.toMultiLineText((ITerminalTextDataReadOnly)term));
    }

    public void testDeleteLines() {
        ITerminalTextData term = this.makeITerminalTextData();
        IVT100EmulatorBackend vt100 = this.makeBakend(term);
        String s = "0000\n1111\n2222\n3333\n4444\n5555";
        vt100.setDimensions(3, 4);
        this.fill(term, s);
        vt100.setCursor(0, 0);
        vt100.deleteLines(1);
        this.assertEqualsTerm("0000\n1111\n2222\n4444\n5555\n    ", this.toMultiLineText((ITerminalTextDataReadOnly)term));
        this.fill(term, s);
        vt100.setCursor(1, 0);
        vt100.deleteLines(1);
        this.assertEqualsTerm("0000\n1111\n2222\n3333\n5555\n    ", this.toMultiLineText((ITerminalTextDataReadOnly)term));
        this.fill(term, s);
        vt100.setCursor(1, 0);
        vt100.deleteLines(2);
        this.assertEqualsTerm("0000\n1111\n2222\n3333\n    \n    ", this.toMultiLineText((ITerminalTextDataReadOnly)term));
        this.fill(term, s);
        vt100.setCursor(1, 3);
        vt100.deleteLines(2);
        this.assertEqualsTerm("0000\n1111\n2222\n3333\n    \n    ", this.toMultiLineText((ITerminalTextDataReadOnly)term));
        vt100.setDimensions(6, 4);
        this.fill(term, s);
        vt100.setCursor(1, 3);
        vt100.deleteLines(2);
        this.assertEqualsTerm("0000\n3333\n4444\n5555\n    \n    ", this.toMultiLineText((ITerminalTextDataReadOnly)term));
        vt100.setDimensions(6, 4);
        this.fill(term, s);
        vt100.setCursor(1, 3);
        vt100.deleteLines(7);
        this.assertEqualsTerm("0000\n    \n    \n    \n    \n    ", this.toMultiLineText((ITerminalTextDataReadOnly)term));
        vt100.setDimensions(6, 4);
        this.fill(term, s);
        vt100.setCursor(0, 0);
        vt100.deleteLines(7);
        this.assertEqualsTerm("    \n    \n    \n    \n    \n    ", this.toMultiLineText((ITerminalTextDataReadOnly)term));
        vt100.setDimensions(6, 4);
        this.fill(term, s);
        vt100.setCursor(0, 0);
        vt100.deleteLines(5);
        this.assertEqualsTerm("5555\n    \n    \n    \n    \n    ", this.toMultiLineText((ITerminalTextDataReadOnly)term));
    }

    public void testGetDefaultStyle() {
        ITerminalTextData term = this.makeITerminalTextData();
        IVT100EmulatorBackend vt100 = this.makeBakend(term);
        Style style = Style.getStyle((String)"white", (String)"black");
        vt100.setDefaultStyle(style);
        VT100EmulatorBackendTest.assertSame((Object)style, (Object)vt100.getDefaultStyle());
        Style style2 = style.setBold(true);
        vt100.setDefaultStyle(style2);
        VT100EmulatorBackendTest.assertSame((Object)style2, (Object)vt100.getDefaultStyle());
    }

    public void testGetStyle() {
        ITerminalTextData term = this.makeITerminalTextData();
        IVT100EmulatorBackend vt100 = this.makeBakend(term);
        Style style = Style.getStyle((String)"white", (String)"black");
        vt100.setStyle(style);
        VT100EmulatorBackendTest.assertSame((Object)style, (Object)vt100.getStyle());
        Style style2 = style.setBold(true);
        vt100.setStyle(style2);
        VT100EmulatorBackendTest.assertSame((Object)style2, (Object)vt100.getStyle());
    }

    public void testAppendString() {
        ITerminalTextData term = this.makeITerminalTextData();
        IVT100EmulatorBackend vt100 = this.makeBakend(term);
        term.setMaxHeight(6);
        vt100.setDimensions(3, 4);
        vt100.setCursor(0, 0);
        this.assertEqualsTerm("    \n    \n    ", this.toMultiLineText((ITerminalTextDataReadOnly)term));
        vt100.appendString("012");
        this.assertEqualsTerm("012 \n    \n    ", this.toMultiLineText((ITerminalTextDataReadOnly)term));
        VT100EmulatorBackendTest.assertEquals((int)0, (int)vt100.getCursorLine());
        VT100EmulatorBackendTest.assertEquals((int)3, (int)vt100.getCursorColumn());
        vt100.appendString("3");
        this.assertEqualsTerm("0123\n    \n    ", this.toMultiLineText((ITerminalTextDataReadOnly)term));
        VT100EmulatorBackendTest.assertEquals((int)1, (int)vt100.getCursorLine());
        VT100EmulatorBackendTest.assertEquals((int)0, (int)vt100.getCursorColumn());
        vt100.appendString("567890");
        this.assertEqualsTerm("0123\n5678\n90  ", this.toMultiLineText((ITerminalTextDataReadOnly)term));
        VT100EmulatorBackendTest.assertEquals((int)2, (int)vt100.getCursorLine());
        VT100EmulatorBackendTest.assertEquals((int)2, (int)vt100.getCursorColumn());
        vt100.appendString("a");
        this.assertEqualsTerm("0123\n5678\n90a ", this.toMultiLineText((ITerminalTextDataReadOnly)term));
        VT100EmulatorBackendTest.assertEquals((int)2, (int)vt100.getCursorLine());
        VT100EmulatorBackendTest.assertEquals((int)3, (int)vt100.getCursorColumn());
        vt100.appendString("b");
        this.assertEqualsTerm("0123\n5678\n90ab\n    ", this.toMultiLineText((ITerminalTextDataReadOnly)term));
        VT100EmulatorBackendTest.assertEquals((int)2, (int)vt100.getCursorLine());
        VT100EmulatorBackendTest.assertEquals((int)0, (int)vt100.getCursorColumn());
        vt100.appendString("cd");
        this.assertEqualsTerm("0123\n5678\n90ab\ncd  ", this.toMultiLineText((ITerminalTextDataReadOnly)term));
        VT100EmulatorBackendTest.assertEquals((int)2, (int)vt100.getCursorLine());
        VT100EmulatorBackendTest.assertEquals((int)2, (int)vt100.getCursorColumn());
        vt100.appendString("efgh");
        this.assertEqualsTerm("0123\n5678\n90ab\ncdef\ngh  ", this.toMultiLineText((ITerminalTextDataReadOnly)term));
        VT100EmulatorBackendTest.assertEquals((int)2, (int)vt100.getCursorLine());
        VT100EmulatorBackendTest.assertEquals((int)2, (int)vt100.getCursorColumn());
        vt100.appendString("ijklmnopqrstuvwx");
        this.assertEqualsTerm("cdef\nghij\nklmn\nopqr\nstuv\nwx  ", this.toMultiLineText((ITerminalTextDataReadOnly)term));
        VT100EmulatorBackendTest.assertEquals((int)2, (int)vt100.getCursorLine());
        VT100EmulatorBackendTest.assertEquals((int)2, (int)vt100.getCursorColumn());
        vt100.setCursor(1, 1);
        vt100.appendString("123");
        this.assertEqualsTerm("cdef\nghij\nklmn\nopqr\ns123\nwx  ", this.toMultiLineText((ITerminalTextDataReadOnly)term));
        VT100EmulatorBackendTest.assertEquals((int)2, (int)vt100.getCursorLine());
        VT100EmulatorBackendTest.assertEquals((int)0, (int)vt100.getCursorColumn());
        vt100.setCursor(1, 1);
        vt100.appendString("ABCDEFGHIJKL");
        this.assertEqualsTerm("klmn\nopqr\nsABC\nDEFG\nHIJK\nL   ", this.toMultiLineText((ITerminalTextDataReadOnly)term));
        VT100EmulatorBackendTest.assertEquals((int)2, (int)vt100.getCursorLine());
        VT100EmulatorBackendTest.assertEquals((int)1, (int)vt100.getCursorColumn());
    }

    public void testProcessNewline() {
        ITerminalTextData term = this.makeITerminalTextData();
        IVT100EmulatorBackend vt100 = this.makeBakend(term);
        String s = "0000\n1111\n2222\n3333\n4444\n5555";
        term.setMaxHeight(6);
        vt100.setDimensions(3, 4);
        vt100.setCursor(0, 0);
        this.fill(term, s);
        VT100EmulatorBackendTest.assertEquals((int)0, (int)vt100.getCursorLine());
        VT100EmulatorBackendTest.assertEquals((int)0, (int)vt100.getCursorColumn());
        vt100.processNewline();
        this.assertEqualsTerm(s, this.toMultiLineText((ITerminalTextDataReadOnly)term));
        VT100EmulatorBackendTest.assertEquals((int)1, (int)vt100.getCursorLine());
        VT100EmulatorBackendTest.assertEquals((int)0, (int)vt100.getCursorColumn());
        vt100.setCursorColumn(3);
        vt100.processNewline();
        this.assertEqualsTerm(s, this.toMultiLineText((ITerminalTextDataReadOnly)term));
        VT100EmulatorBackendTest.assertEquals((int)2, (int)vt100.getCursorLine());
        VT100EmulatorBackendTest.assertEquals((int)3, (int)vt100.getCursorColumn());
        vt100.processNewline();
        this.assertEqualsTerm("1111\n2222\n3333\n4444\n5555\n    ", this.toMultiLineText((ITerminalTextDataReadOnly)term));
        VT100EmulatorBackendTest.assertEquals((int)2, (int)vt100.getCursorLine());
        VT100EmulatorBackendTest.assertEquals((int)3, (int)vt100.getCursorColumn());
        vt100.processNewline();
        this.assertEqualsTerm("2222\n3333\n4444\n5555\n    \n    ", this.toMultiLineText((ITerminalTextDataReadOnly)term));
        VT100EmulatorBackendTest.assertEquals((int)2, (int)vt100.getCursorLine());
        VT100EmulatorBackendTest.assertEquals((int)3, (int)vt100.getCursorColumn());
    }

    public void testSetCursorLine() {
        ITerminalTextData term = this.makeITerminalTextData();
        IVT100EmulatorBackend vt100 = this.makeBakend(term);
        term.setMaxHeight(6);
        vt100.setDimensions(3, 4);
        VT100EmulatorBackendTest.assertEquals((int)0, (int)vt100.getCursorLine());
        VT100EmulatorBackendTest.assertEquals((int)0, (int)vt100.getCursorColumn());
        vt100.setCursor(0, 2);
        vt100.setCursorLine(1);
        VT100EmulatorBackendTest.assertEquals((int)1, (int)vt100.getCursorLine());
        VT100EmulatorBackendTest.assertEquals((int)2, (int)vt100.getCursorColumn());
        vt100.setCursor(0, -2);
        vt100.setCursorLine(-1);
        VT100EmulatorBackendTest.assertEquals((int)0, (int)vt100.getCursorLine());
        VT100EmulatorBackendTest.assertEquals((int)0, (int)vt100.getCursorColumn());
        vt100.setCursor(0, 10);
        vt100.setCursorLine(10);
        VT100EmulatorBackendTest.assertEquals((int)2, (int)vt100.getCursorLine());
        VT100EmulatorBackendTest.assertEquals((int)3, (int)vt100.getCursorColumn());
    }

    public void testSetCursorAndSetDimensions() {
        ITerminalTextData term = this.makeITerminalTextData();
        IVT100EmulatorBackend vt100 = this.makeBakend(term);
        term.setMaxHeight(10);
        vt100.setDimensions(3, 4);
        VT100EmulatorBackendTest.assertEquals((int)0, (int)vt100.getCursorLine());
        VT100EmulatorBackendTest.assertEquals((int)0, (int)vt100.getCursorColumn());
        vt100.setDimensions(6, 4);
        VT100EmulatorBackendTest.assertEquals((int)0, (int)vt100.getCursorLine());
        VT100EmulatorBackendTest.assertEquals((int)0, (int)vt100.getCursorColumn());
        vt100.setCursor(2, 3);
        vt100.setDimensions(8, 4);
        VT100EmulatorBackendTest.assertEquals((int)2, (int)vt100.getCursorLine());
        VT100EmulatorBackendTest.assertEquals((int)3, (int)vt100.getCursorColumn());
    }

    public void testSetCursorColumn() {
        ITerminalTextData term = this.makeITerminalTextData();
        IVT100EmulatorBackend vt100 = this.makeBakend(term);
        term.setMaxHeight(6);
        vt100.setDimensions(3, 4);
        VT100EmulatorBackendTest.assertEquals((int)0, (int)vt100.getCursorLine());
        VT100EmulatorBackendTest.assertEquals((int)0, (int)vt100.getCursorColumn());
        vt100.setCursor(1, 0);
        vt100.setCursorColumn(2);
        VT100EmulatorBackendTest.assertEquals((int)1, (int)vt100.getCursorLine());
        VT100EmulatorBackendTest.assertEquals((int)2, (int)vt100.getCursorColumn());
        vt100.setCursor(-1, -2);
        vt100.setCursorColumn(-2);
        VT100EmulatorBackendTest.assertEquals((int)0, (int)vt100.getCursorLine());
        VT100EmulatorBackendTest.assertEquals((int)0, (int)vt100.getCursorColumn());
        vt100.setCursor(10, 0);
        vt100.setCursorColumn(10);
        VT100EmulatorBackendTest.assertEquals((int)2, (int)vt100.getCursorLine());
        VT100EmulatorBackendTest.assertEquals((int)3, (int)vt100.getCursorColumn());
    }

    public void testSetCursor() {
        ITerminalTextData term = this.makeITerminalTextData();
        IVT100EmulatorBackend vt100 = this.makeBakend(term);
        term.setMaxHeight(6);
        vt100.setDimensions(3, 4);
        VT100EmulatorBackendTest.assertEquals((int)0, (int)vt100.getCursorLine());
        VT100EmulatorBackendTest.assertEquals((int)0, (int)vt100.getCursorColumn());
        vt100.setCursor(0, 0);
        VT100EmulatorBackendTest.assertEquals((int)0, (int)vt100.getCursorLine());
        VT100EmulatorBackendTest.assertEquals((int)0, (int)vt100.getCursorColumn());
        vt100.setCursor(1, 2);
        VT100EmulatorBackendTest.assertEquals((int)1, (int)vt100.getCursorLine());
        VT100EmulatorBackendTest.assertEquals((int)2, (int)vt100.getCursorColumn());
        vt100.setCursor(-1, -2);
        VT100EmulatorBackendTest.assertEquals((int)0, (int)vt100.getCursorLine());
        VT100EmulatorBackendTest.assertEquals((int)0, (int)vt100.getCursorColumn());
        vt100.setCursor(10, 10);
        VT100EmulatorBackendTest.assertEquals((int)2, (int)vt100.getCursorLine());
        VT100EmulatorBackendTest.assertEquals((int)3, (int)vt100.getCursorColumn());
    }

    public void testVT100LineWrappingOn() {
        ITerminalTextData term = this.makeITerminalTextData();
        IVT100EmulatorBackend vt100 = this.makeBakend(term);
        term.setMaxHeight(10);
        vt100.setDimensions(6, 4);
        vt100.setVT100LineWrapping(true);
        vt100.appendString("abcd");
        vt100.setCursorColumn(0);
        vt100.processNewline();
        vt100.appendString("1234");
        vt100.setCursorColumn(0);
        vt100.processNewline();
        VT100EmulatorBackendTest.assertEquals((int)2, (int)vt100.getCursorLine());
    }

    public void testVT100LineWrappingOff() {
        ITerminalTextData term = this.makeITerminalTextData();
        IVT100EmulatorBackend vt100 = this.makeBakend(term);
        term.setMaxHeight(10);
        vt100.setDimensions(6, 4);
        vt100.setVT100LineWrapping(false);
        vt100.appendString("abcd");
        vt100.setCursorColumn(0);
        vt100.processNewline();
        vt100.appendString("1234");
        vt100.setCursorColumn(0);
        vt100.processNewline();
        VT100EmulatorBackendTest.assertEquals((int)4, (int)vt100.getCursorLine());
    }

    public void testWrappedLines() {
        ITerminalTextData term = this.makeITerminalTextData();
        IVT100EmulatorBackend vt100 = this.makeBakend(term);
        term.setMaxHeight(10);
        vt100.setDimensions(6, 4);
        vt100.setVT100LineWrapping(true);
        vt100.appendString("abcd123");
        vt100.setCursorColumn(0);
        vt100.processNewline();
        vt100.appendString("abc");
        vt100.setCursorColumn(0);
        vt100.processNewline();
        vt100.appendString("1234abcd");
        VT100EmulatorBackendTest.assertEquals((int)4, (int)vt100.getCursorLine());
        VT100EmulatorBackendTest.assertTrue((boolean)term.isWrappedLine(0));
        VT100EmulatorBackendTest.assertFalse((boolean)term.isWrappedLine(1));
        VT100EmulatorBackendTest.assertFalse((boolean)term.isWrappedLine(2));
        VT100EmulatorBackendTest.assertTrue((boolean)term.isWrappedLine(3));
    }

    public void testInsertMode() {
        ITerminalTextData term = this.makeITerminalTextData();
        IVT100EmulatorBackend vt100 = this.makeBakend(term);
        term.setMaxHeight(10);
        vt100.setDimensions(4, 6);
        vt100.appendString("123");
        vt100.setCursorColumn(0);
        vt100.appendString("abc");
        VT100EmulatorBackendTest.assertEquals((String)"abc", (String)new String(term.getChars(0)));
        vt100.clearAll();
        vt100.setCursorColumn(0);
        vt100.appendString("123");
        vt100.setCursorColumn(0);
        vt100.setInsertMode(true);
        vt100.appendString("abc");
        vt100.setInsertMode(false);
        VT100EmulatorBackendTest.assertEquals((String)"abc123", (String)new String(term.getChars(0)));
    }

    public void testScrollRegion() {
        ITerminalTextData term = this.makeITerminalTextData();
        IVT100EmulatorBackend vt100 = this.makeBakend(term);
        term.setMaxHeight(10);
        vt100.setDimensions(8, 6);
        vt100.appendString("123");
        vt100.setCursorColumn(0);
        vt100.processNewline();
        vt100.appendString("456");
        vt100.setCursorColumn(0);
        vt100.processNewline();
        vt100.appendString("789");
        vt100.setCursorColumn(0);
        vt100.processNewline();
        vt100.appendString("abc");
        vt100.setCursorColumn(0);
        vt100.processNewline();
        vt100.appendString("def");
        vt100.setCursorColumn(0);
        vt100.processNewline();
        vt100.appendString("ghi");
        vt100.setCursorLine(1);
        vt100.setScrollRegion(1, 4);
        vt100.scrollUp(1);
        VT100EmulatorBackendTest.assertEquals((String)"123", (String)new String(term.getChars(0)));
        VT100EmulatorBackendTest.assertEquals((String)"789", (String)new String(term.getChars(1)));
        VT100EmulatorBackendTest.assertEquals((String)"abc", (String)new String(term.getChars(2)));
        VT100EmulatorBackendTest.assertEquals((String)"def", (String)new String(term.getChars(3)));
        VT100EmulatorBackendTest.assertNull((Object)term.getChars(4));
        VT100EmulatorBackendTest.assertEquals((String)"ghi", (String)new String(term.getChars(5)));
        vt100.scrollDown(1);
        VT100EmulatorBackendTest.assertEquals((String)"123", (String)new String(term.getChars(0)));
        VT100EmulatorBackendTest.assertNull((Object)term.getChars(1));
        VT100EmulatorBackendTest.assertEquals((String)"789", (String)new String(term.getChars(2)));
        VT100EmulatorBackendTest.assertEquals((String)"abc", (String)new String(term.getChars(3)));
        VT100EmulatorBackendTest.assertEquals((String)"def", (String)new String(term.getChars(4)));
        VT100EmulatorBackendTest.assertEquals((String)"ghi", (String)new String(term.getChars(5)));
        vt100.setScrollRegion(-1, -1);
        vt100.scrollDown(1);
        VT100EmulatorBackendTest.assertNull((Object)term.getChars(0));
        VT100EmulatorBackendTest.assertEquals((String)"123", (String)new String(term.getChars(1)));
        VT100EmulatorBackendTest.assertNull((Object)term.getChars(2));
        VT100EmulatorBackendTest.assertEquals((String)"789", (String)new String(term.getChars(3)));
        VT100EmulatorBackendTest.assertEquals((String)"abc", (String)new String(term.getChars(4)));
        VT100EmulatorBackendTest.assertEquals((String)"def", (String)new String(term.getChars(5)));
        VT100EmulatorBackendTest.assertEquals((String)"ghi", (String)new String(term.getChars(6)));
        vt100.scrollUp(1);
        VT100EmulatorBackendTest.assertEquals((String)"123", (String)new String(term.getChars(0)));
        VT100EmulatorBackendTest.assertNull((Object)term.getChars(1));
        VT100EmulatorBackendTest.assertEquals((String)"789", (String)new String(term.getChars(2)));
        VT100EmulatorBackendTest.assertEquals((String)"abc", (String)new String(term.getChars(3)));
        VT100EmulatorBackendTest.assertEquals((String)"def", (String)new String(term.getChars(4)));
        VT100EmulatorBackendTest.assertEquals((String)"ghi", (String)new String(term.getChars(5)));
        vt100.setScrollRegion(1, 4);
        vt100.setCursorLine(4);
        vt100.processNewline();
        VT100EmulatorBackendTest.assertEquals((String)"123", (String)new String(term.getChars(0)));
        VT100EmulatorBackendTest.assertEquals((String)"789", (String)new String(term.getChars(1)));
        VT100EmulatorBackendTest.assertEquals((String)"abc", (String)new String(term.getChars(2)));
        VT100EmulatorBackendTest.assertEquals((String)"def", (String)new String(term.getChars(3)));
        VT100EmulatorBackendTest.assertNull((Object)term.getChars(4));
        VT100EmulatorBackendTest.assertEquals((String)"ghi", (String)new String(term.getChars(5)));
    }
}

