/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.internal.terminal.model;

import junit.framework.TestCase;
import org.eclipse.tm.internal.terminal.model.TerminalTextTestHelper;
import org.eclipse.tm.terminal.model.ITerminalTextData;
import org.eclipse.tm.terminal.model.ITerminalTextDataReadOnly;
import org.eclipse.tm.terminal.model.LineSegment;
import org.eclipse.tm.terminal.model.Style;
import org.eclipse.tm.terminal.model.StyleColor;

public abstract class AbstractITerminalTextDataTest
extends TestCase {
    protected abstract ITerminalTextData makeITerminalTextData();

    protected void setUp() throws Exception {
        try {
            assert (false);
            throw new Error("No Assertions! Run this code with assertions enabled! (vmargs: -ea)");
        }
        catch (AssertionError assertionError) {
            super.setUp();
            return;
        }
    }

    protected String toSimple(ITerminalTextData term) {
        return TerminalTextTestHelper.toSimple((ITerminalTextDataReadOnly)term);
    }

    protected String toMultiLineText(ITerminalTextDataReadOnly term) {
        return TerminalTextTestHelper.toMultiLineText(term);
    }

    protected void fill(ITerminalTextData term, String s) {
        TerminalTextTestHelper.fill(term, s);
    }

    protected void fill(ITerminalTextData term, int i, int j, String s) {
        TerminalTextTestHelper.fill(term, i, j, s);
    }

    protected void fillSimple(ITerminalTextData term, String s) {
        TerminalTextTestHelper.fillSimple(term, s);
    }

    protected void assertEqualsTerm(String expected, String actual) {
        AbstractITerminalTextDataTest.assertEquals((String)expected, (String)actual);
    }

    protected void assertEqualsSimple(String expected, String actual) {
        AbstractITerminalTextDataTest.assertEquals((int)-1, (int)actual.indexOf(10));
        AbstractITerminalTextDataTest.assertEquals((String)expected, (String)actual);
    }

    public void testGetWidth() {
        ITerminalTextData term = this.makeITerminalTextData();
        AbstractITerminalTextDataTest.assertEquals((int)0, (int)term.getWidth());
        term.setDimensions(term.getHeight(), 10);
        AbstractITerminalTextDataTest.assertEquals((int)10, (int)term.getWidth());
        term.setDimensions(term.getHeight(), 0);
        AbstractITerminalTextDataTest.assertEquals((int)0, (int)term.getWidth());
    }

    public void testAddLine() {
        String s = "111\n222\n333\n444\n555";
        ITerminalTextData term = this.makeITerminalTextData();
        this.fill(term, s);
        term.setMaxHeight(5);
        term.addLine();
        this.assertEqualsTerm("222\n333\n444\n555\n\u0000\u0000\u0000", this.toMultiLineText((ITerminalTextDataReadOnly)term));
    }

    public void testCleanLine() {
        String s = "111\n222\n333\n444\n555";
        ITerminalTextData term = this.makeITerminalTextData();
        this.fill(term, s);
        term.cleanLine(0);
        this.assertEqualsTerm("\u0000\u0000\u0000\n222\n333\n444\n555", this.toMultiLineText((ITerminalTextDataReadOnly)term));
        this.fill(term, s);
        term.cleanLine(4);
        this.assertEqualsTerm("111\n222\n333\n444\n\u0000\u0000\u0000", this.toMultiLineText((ITerminalTextDataReadOnly)term));
    }

    public void testMaxSize() {
        String s = "111\n222\n333\n444\n555";
        ITerminalTextData term = this.makeITerminalTextData();
        term.setMaxHeight(8);
        this.fill(term, s);
        AbstractITerminalTextDataTest.assertEquals((int)5, (int)term.getHeight());
        AbstractITerminalTextDataTest.assertEquals((int)8, (int)term.getMaxHeight());
        term.addLine();
        AbstractITerminalTextDataTest.assertEquals((int)6, (int)term.getHeight());
        this.assertEqualsTerm("111\n222\n333\n444\n555\n\u0000\u0000\u0000", this.toMultiLineText((ITerminalTextDataReadOnly)term));
        term.addLine();
        AbstractITerminalTextDataTest.assertEquals((int)7, (int)term.getHeight());
        this.assertEqualsTerm("111\n222\n333\n444\n555\n\u0000\u0000\u0000\n\u0000\u0000\u0000", this.toMultiLineText((ITerminalTextDataReadOnly)term));
        term.addLine();
        AbstractITerminalTextDataTest.assertEquals((int)8, (int)term.getHeight());
        this.assertEqualsTerm("111\n222\n333\n444\n555\n\u0000\u0000\u0000\n\u0000\u0000\u0000\n\u0000\u0000\u0000", this.toMultiLineText((ITerminalTextDataReadOnly)term));
        term.addLine();
        AbstractITerminalTextDataTest.assertEquals((int)8, (int)term.getHeight());
        this.assertEqualsTerm("222\n333\n444\n555\n\u0000\u0000\u0000\n\u0000\u0000\u0000\n\u0000\u0000\u0000\n\u0000\u0000\u0000", this.toMultiLineText((ITerminalTextDataReadOnly)term));
        term.addLine();
        AbstractITerminalTextDataTest.assertEquals((int)8, (int)term.getHeight());
        this.assertEqualsTerm("333\n444\n555\n\u0000\u0000\u0000\n\u0000\u0000\u0000\n\u0000\u0000\u0000\n\u0000\u0000\u0000\n\u0000\u0000\u0000", this.toMultiLineText((ITerminalTextDataReadOnly)term));
    }

    public void testGetHeight() {
        ITerminalTextData term = this.makeITerminalTextData();
        AbstractITerminalTextDataTest.assertEquals((int)0, (int)term.getHeight());
        term.setDimensions(10, term.getWidth());
        AbstractITerminalTextDataTest.assertEquals((int)10, (int)term.getHeight());
        term.setDimensions(0, term.getWidth());
        AbstractITerminalTextDataTest.assertEquals((int)0, (int)term.getHeight());
    }

    public void testSetDimensions() {
        ITerminalTextData term = this.makeITerminalTextData();
        AbstractITerminalTextDataTest.assertEquals((int)0, (int)term.getHeight());
        term.setDimensions(10, 5);
        AbstractITerminalTextDataTest.assertEquals((int)5, (int)term.getWidth());
        AbstractITerminalTextDataTest.assertEquals((int)10, (int)term.getHeight());
        term.setDimensions(5, 10);
        AbstractITerminalTextDataTest.assertEquals((int)10, (int)term.getWidth());
        AbstractITerminalTextDataTest.assertEquals((int)5, (int)term.getHeight());
        term.setDimensions(15, 0);
        AbstractITerminalTextDataTest.assertEquals((int)0, (int)term.getWidth());
        AbstractITerminalTextDataTest.assertEquals((int)15, (int)term.getHeight());
        term.setDimensions(0, 12);
        AbstractITerminalTextDataTest.assertEquals((int)12, (int)term.getWidth());
        AbstractITerminalTextDataTest.assertEquals((int)0, (int)term.getHeight());
        term.setDimensions(0, 0);
        AbstractITerminalTextDataTest.assertEquals((int)0, (int)term.getWidth());
        AbstractITerminalTextDataTest.assertEquals((int)0, (int)term.getHeight());
    }

    public void testResize() {
        ITerminalTextData term = this.makeITerminalTextData();
        term.setDimensions(3, 5);
        String s = "12345\nabcde\nABCDE";
        this.fill(term, 0, 0, s);
        this.assertEqualsTerm(s, this.toMultiLineText((ITerminalTextDataReadOnly)term));
        term.setDimensions(3, 4);
        this.assertEqualsTerm("1234\nabcd\nABCD", this.toMultiLineText((ITerminalTextDataReadOnly)term));
        term.setDimensions(3, 5);
        this.assertEqualsTerm("12345\nabcde\nABCDE", this.toMultiLineText((ITerminalTextDataReadOnly)term));
        term.setDimensions(3, 6);
        this.assertEqualsTerm("12345\u0000\nabcde\u0000\nABCDE\u0000", this.toMultiLineText((ITerminalTextDataReadOnly)term));
        term.setChar(0, 5, 'x', null);
        term.setChar(1, 5, 'y', null);
        term.setChar(2, 5, 'z', null);
        this.assertEqualsTerm("12345x\nabcdey\nABCDEz", this.toMultiLineText((ITerminalTextDataReadOnly)term));
        term.setDimensions(2, 4);
        this.assertEqualsTerm("1234\nabcd", this.toMultiLineText((ITerminalTextDataReadOnly)term));
    }

    public void testResizeFailure() {
        ITerminalTextData term = this.makeITerminalTextData();
        term.setDimensions(3, 5);
        String s = "12345\nabcde\nABCDE";
        this.fill(term, 0, 0, s);
        this.assertEqualsTerm(s, this.toMultiLineText((ITerminalTextDataReadOnly)term));
        try {
            term.setDimensions(-3, 4);
            AbstractITerminalTextDataTest.fail();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    public void testGetLineSegments() {
        Style s1 = this.getDefaultStyle();
        Style s2 = s1.setBold(true);
        Style s3 = s1.setUnderline(true);
        ITerminalTextData term = this.makeITerminalTextData();
        term.setDimensions(8, 8);
        term.setChars(0, 0, "0123".toCharArray(), s1);
        term.setChars(0, 4, "abcd".toCharArray(), null);
        LineSegment[] segments = term.getLineSegments(0, 0, term.getWidth());
        AbstractITerminalTextDataTest.assertEquals((int)2, (int)segments.length);
        this.assertSegment(0, "0123", s1, segments[0]);
        this.assertSegment(4, "abcd", null, segments[1]);
        segments = term.getLineSegments(0, 4, term.getWidth() - 4);
        AbstractITerminalTextDataTest.assertEquals((int)1, (int)segments.length);
        this.assertSegment(4, "abcd", null, segments[0]);
        segments = term.getLineSegments(0, 3, 2);
        AbstractITerminalTextDataTest.assertEquals((int)2, (int)segments.length);
        this.assertSegment(3, "3", s1, segments[0]);
        this.assertSegment(4, "a", null, segments[1]);
        segments = term.getLineSegments(0, 7, 1);
        AbstractITerminalTextDataTest.assertEquals((int)1, (int)segments.length);
        this.assertSegment(7, "d", null, segments[0]);
        segments = term.getLineSegments(0, 0, 1);
        AbstractITerminalTextDataTest.assertEquals((int)1, (int)segments.length);
        this.assertSegment(0, "0", s1, segments[0]);
        term.setChars(1, 0, "x".toCharArray(), s1);
        term.setChars(1, 1, "y".toCharArray(), s2);
        term.setChars(1, 2, "z".toCharArray(), s3);
        segments = term.getLineSegments(1, 0, term.getWidth());
        AbstractITerminalTextDataTest.assertEquals((int)4, (int)segments.length);
        this.assertSegment(0, "x", s1, segments[0]);
        this.assertSegment(1, "y", s2, segments[1]);
        this.assertSegment(2, "z", s3, segments[2]);
        this.assertSegment(3, "\u0000\u0000\u0000\u0000\u0000", null, segments[3]);
        term.setChars(2, 4, "klm".toCharArray(), s1);
        segments = term.getLineSegments(2, 0, term.getWidth());
        AbstractITerminalTextDataTest.assertEquals((int)3, (int)segments.length);
        this.assertSegment(0, "\u0000\u0000\u0000\u0000", null, segments[0]);
        this.assertSegment(4, "klm", s1, segments[1]);
        this.assertSegment(7, "\u0000", null, segments[2]);
        segments = term.getLineSegments(3, 0, term.getWidth());
        AbstractITerminalTextDataTest.assertEquals((int)1, (int)segments.length);
        this.assertSegment(0, "\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000", null, segments[0]);
    }

    public void testGetLineSegmentsNull() {
        ITerminalTextData term = this.makeITerminalTextData();
        term.setDimensions(8, 8);
        LineSegment[] segments = term.getLineSegments(0, 0, term.getWidth());
        AbstractITerminalTextDataTest.assertEquals((int)1, (int)segments.length);
    }

    public void testGetLineSegmentsOutOfBounds() {
        ITerminalTextData term = this.makeITerminalTextData();
        term.setDimensions(1, 8);
        term.setChars(0, 0, "xx".toCharArray(), null);
        LineSegment[] segments = term.getLineSegments(0, 5, 2);
        AbstractITerminalTextDataTest.assertEquals((int)1, (int)segments.length);
    }

    void assertSegment(int col, String text, Style style, LineSegment segment) {
        AbstractITerminalTextDataTest.assertEquals((int)col, (int)segment.getColumn());
        this.assertEqualsTerm(text, segment.getText());
        AbstractITerminalTextDataTest.assertEquals((Object)style, (Object)segment.getStyle());
    }

    public void testGetChar() {
        String s = "12345\nabcde\nABCDE";
        ITerminalTextData term = this.makeITerminalTextData();
        this.fill(term, s);
        AbstractITerminalTextDataTest.assertEquals((char)'1', (char)term.getChar(0, 0));
        AbstractITerminalTextDataTest.assertEquals((char)'2', (char)term.getChar(0, 1));
        AbstractITerminalTextDataTest.assertEquals((char)'3', (char)term.getChar(0, 2));
        AbstractITerminalTextDataTest.assertEquals((char)'4', (char)term.getChar(0, 3));
        AbstractITerminalTextDataTest.assertEquals((char)'5', (char)term.getChar(0, 4));
        AbstractITerminalTextDataTest.assertEquals((char)'a', (char)term.getChar(1, 0));
        AbstractITerminalTextDataTest.assertEquals((char)'b', (char)term.getChar(1, 1));
        AbstractITerminalTextDataTest.assertEquals((char)'c', (char)term.getChar(1, 2));
        AbstractITerminalTextDataTest.assertEquals((char)'d', (char)term.getChar(1, 3));
        AbstractITerminalTextDataTest.assertEquals((char)'e', (char)term.getChar(1, 4));
        AbstractITerminalTextDataTest.assertEquals((char)'A', (char)term.getChar(2, 0));
        AbstractITerminalTextDataTest.assertEquals((char)'B', (char)term.getChar(2, 1));
        AbstractITerminalTextDataTest.assertEquals((char)'C', (char)term.getChar(2, 2));
        AbstractITerminalTextDataTest.assertEquals((char)'D', (char)term.getChar(2, 3));
        AbstractITerminalTextDataTest.assertEquals((char)'E', (char)term.getChar(2, 4));
        try {
            term.getChar(0, -1);
            AbstractITerminalTextDataTest.fail();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        try {
            term.getChar(-1, -1);
            AbstractITerminalTextDataTest.fail();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        try {
            term.getChar(-1, 0);
            AbstractITerminalTextDataTest.fail();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        try {
            term.getChar(0, 5);
            AbstractITerminalTextDataTest.fail();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        try {
            term.getChar(3, 5);
            AbstractITerminalTextDataTest.fail();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        try {
            term.getChar(3, 0);
            AbstractITerminalTextDataTest.fail();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    public void testGetStyle() {
        char c;
        int column;
        ITerminalTextData term = this.makeITerminalTextData();
        Style style = this.getDefaultStyle();
        term.setDimensions(6, 3);
        int line = 0;
        while (line < term.getHeight()) {
            column = 0;
            while (column < term.getWidth()) {
                c = (char)(97 + column + line);
                term.setChar(line, column, c, style.setForground(StyleColor.getStyleColor((String)("" + c))));
                ++column;
            }
            ++line;
        }
        line = 0;
        while (line < term.getHeight()) {
            column = 0;
            while (column < term.getWidth()) {
                c = (char)(97 + column + line);
                AbstractITerminalTextDataTest.assertSame((Object)style.setForground(StyleColor.getStyleColor((String)("" + c))), (Object)term.getStyle(line, column));
                ++column;
            }
            ++line;
        }
    }

    protected Style getDefaultStyle() {
        return Style.getStyle((StyleColor)StyleColor.getStyleColor((String)"fg"), (StyleColor)StyleColor.getStyleColor((String)"bg"), (boolean)false, (boolean)false, (boolean)false, (boolean)false);
    }

    public void testSetChar() {
        int column;
        ITerminalTextData term = this.makeITerminalTextData();
        term.setDimensions(6, 3);
        int line = 0;
        while (line < term.getHeight()) {
            column = 0;
            while (column < term.getWidth()) {
                term.setChar(line, column, (char)(97 + column + line), null);
                ++column;
            }
            ++line;
        }
        line = 0;
        while (line < term.getHeight()) {
            column = 0;
            while (column < term.getWidth()) {
                char c = (char)(97 + column + line);
                AbstractITerminalTextDataTest.assertEquals((char)c, (char)term.getChar(line, column));
                ++column;
            }
            ++line;
        }
        this.assertEqualsTerm("abc\nbcd\ncde\ndef\nefg\nfgh", this.toMultiLineText((ITerminalTextDataReadOnly)term));
    }

    public void testSetChars() {
        ITerminalTextData term = this.makeITerminalTextData();
        term.setDimensions(6, 3);
        int line = 0;
        while (line < term.getHeight()) {
            char[] chars = new char[term.getWidth()];
            int column = 0;
            while (column < term.getWidth()) {
                chars[column] = (char)(97 + column + line);
                ++column;
            }
            term.setChars(line, 0, chars, null);
            ++line;
        }
        line = 0;
        while (line < term.getHeight()) {
            int column = 0;
            while (column < term.getWidth()) {
                char c = (char)(97 + column + line);
                AbstractITerminalTextDataTest.assertEquals((char)c, (char)term.getChar(line, column));
                ++column;
            }
            ++line;
        }
        this.assertEqualsTerm("abc\nbcd\ncde\ndef\nefg\nfgh", this.toMultiLineText((ITerminalTextDataReadOnly)term));
        term.setChars(3, 1, new char[]{'1', '2'}, null);
        this.assertEqualsTerm("abc\nbcd\ncde\nd12\nefg\nfgh", this.toMultiLineText((ITerminalTextDataReadOnly)term));
        try {
            term.setChars(4, 1, new char[]{'1', '2', '3', '4', '5'}, null);
            AbstractITerminalTextDataTest.fail();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    public void testSetCharsLen() {
        ITerminalTextData term = this.makeITerminalTextData();
        String s = "ZYXWVU\nabcdef\nABCDEF";
        this.fill(term, s);
        char[] chars = new char[]{'1', '2', '3', '4', '5', '6', '7', '8'};
        term.setChars(1, 0, chars, 0, 6, null);
        this.assertEqualsTerm("ZYXWVU\n123456\nABCDEF", this.toMultiLineText((ITerminalTextDataReadOnly)term));
        this.fill(term, s);
        term.setChars(1, 0, chars, 0, 5, null);
        this.assertEqualsTerm("ZYXWVU\n12345f\nABCDEF", this.toMultiLineText((ITerminalTextDataReadOnly)term));
        this.fill(term, s);
        term.setChars(1, 0, chars, 1, 5, null);
        this.assertEqualsTerm("ZYXWVU\n23456f\nABCDEF", this.toMultiLineText((ITerminalTextDataReadOnly)term));
        this.fill(term, s);
        term.setChars(1, 1, chars, 1, 4, null);
        this.assertEqualsTerm("ZYXWVU\na2345f\nABCDEF", this.toMultiLineText((ITerminalTextDataReadOnly)term));
        this.fill(term, s);
        term.setChars(1, 2, chars, 3, 4, null);
        this.assertEqualsTerm("ZYXWVU\nab4567\nABCDEF", this.toMultiLineText((ITerminalTextDataReadOnly)term));
        this.fill(term, s);
        try {
            term.setChars(1, 0, chars, 7, 10, null);
            AbstractITerminalTextDataTest.fail();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        this.fill(term, s);
        try {
            term.setChars(1, -1, chars, 0, 2, null);
            AbstractITerminalTextDataTest.fail();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        try {
            term.setChars(-1, 1, chars, 0, 2, null);
            AbstractITerminalTextDataTest.fail();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        try {
            term.setChars(1, 10, chars, 0, 2, null);
            AbstractITerminalTextDataTest.fail();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        try {
            term.setChars(10, 1, chars, 0, 2, null);
            AbstractITerminalTextDataTest.fail();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    public void testSetCopyInto() {
        ITerminalTextData term = this.makeITerminalTextData();
        term.setDimensions(3, 5);
        String s = "12345\nabcde\nABCDE";
        this.fill(term, 0, 0, s);
        ITerminalTextData termCopy = this.makeITerminalTextData();
        termCopy.copy(term);
        this.assertEqualsTerm(s, this.toMultiLineText((ITerminalTextDataReadOnly)termCopy));
        this.assertEqualsTerm(s, this.toMultiLineText((ITerminalTextDataReadOnly)term));
        termCopy.setChar(1, 1, 'X', null);
        this.assertEqualsTerm(s, this.toMultiLineText((ITerminalTextDataReadOnly)term));
        term.setDimensions(2, 4);
        AbstractITerminalTextDataTest.assertEquals((int)5, (int)termCopy.getWidth());
        AbstractITerminalTextDataTest.assertEquals((int)3, (int)termCopy.getHeight());
        this.assertEqualsTerm("12345\naXcde\nABCDE", this.toMultiLineText((ITerminalTextDataReadOnly)termCopy));
        AbstractITerminalTextDataTest.assertEquals((int)4, (int)term.getWidth());
        AbstractITerminalTextDataTest.assertEquals((int)2, (int)term.getHeight());
    }

    public void testSetCopyLines() {
        ITerminalTextData term = this.makeITerminalTextData();
        String s = "012345";
        this.fillSimple(term, s);
        ITerminalTextData termCopy = this.makeITerminalTextData();
        String sCopy = "abcde";
        this.fillSimple(termCopy, sCopy);
        termCopy.copyRange(term, 0, 0, 0);
        this.assertEqualsSimple(s, this.toSimple(term));
        this.assertEqualsSimple(sCopy, this.toSimple(termCopy));
        this.fillSimple(termCopy, sCopy);
        termCopy.copyRange(term, 0, 0, 5);
        this.assertEqualsSimple(s, this.toSimple(term));
        this.assertEqualsSimple("01234", this.toSimple(termCopy));
        this.fillSimple(termCopy, sCopy);
        termCopy.copyRange(term, 0, 0, 2);
        this.assertEqualsSimple(s, this.toSimple(term));
        this.assertEqualsSimple("01cde", this.toSimple(termCopy));
        this.fillSimple(termCopy, sCopy);
        termCopy.copyRange(term, 0, 1, 2);
        this.assertEqualsSimple(s, this.toSimple(term));
        this.assertEqualsSimple("a01de", this.toSimple(termCopy));
        this.fillSimple(termCopy, sCopy);
        termCopy.copyRange(term, 1, 1, 2);
        this.assertEqualsSimple(s, this.toSimple(term));
        this.assertEqualsSimple("a12de", this.toSimple(termCopy));
        this.fillSimple(termCopy, sCopy);
        termCopy.copyRange(term, 1, 1, 4);
        this.assertEqualsSimple(s, this.toSimple(term));
        this.assertEqualsSimple("a1234", this.toSimple(termCopy));
        this.fillSimple(termCopy, sCopy);
        termCopy.copyRange(term, 2, 1, 4);
        this.assertEqualsSimple(s, this.toSimple(term));
        this.assertEqualsSimple("a2345", this.toSimple(termCopy));
        try {
            this.fillSimple(termCopy, sCopy);
            termCopy.copyRange(term, 1, 1, 5);
            AbstractITerminalTextDataTest.fail();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        try {
            this.fillSimple(termCopy, sCopy);
            termCopy.copyRange(term, 0, 0, 6);
            AbstractITerminalTextDataTest.fail();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        try {
            this.fillSimple(termCopy, sCopy);
            termCopy.copyRange(term, 7, 0, 1);
            AbstractITerminalTextDataTest.fail();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        try {
            this.fillSimple(termCopy, sCopy);
            termCopy.copyRange(term, 0, 7, 1);
            AbstractITerminalTextDataTest.fail();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    public void testCopyLine() {
        ITerminalTextData term = this.makeITerminalTextData();
        String s = "111\n222\n333\n444\n555";
        this.fill(term, s);
        ITerminalTextData dest = this.makeITerminalTextData();
        String sCopy = "aaa\nbbb\nccc\nddd\neee";
        this.fill(dest, sCopy);
        boolean[] blArray = new boolean[5];
        blArray[0] = true;
        blArray[1] = true;
        blArray[4] = true;
        this.copySelective(dest, term, 0, 0, blArray);
        this.assertEqualsTerm(s, this.toMultiLineText((ITerminalTextDataReadOnly)term));
        this.assertEqualsTerm("111\n222\nccc\nddd\n555", this.toMultiLineText((ITerminalTextDataReadOnly)dest));
        this.fill(dest, sCopy);
        this.copySelective(dest, term, 0, 0, new boolean[]{true, true, true, true, true});
        this.assertEqualsTerm(s, this.toMultiLineText((ITerminalTextDataReadOnly)term));
        this.assertEqualsTerm(s, this.toMultiLineText((ITerminalTextDataReadOnly)dest));
        this.fill(dest, sCopy);
        this.copySelective(dest, term, 0, 0, new boolean[5]);
        this.assertEqualsTerm(s, this.toMultiLineText((ITerminalTextDataReadOnly)term));
        this.assertEqualsTerm(sCopy, this.toMultiLineText((ITerminalTextDataReadOnly)dest));
    }

    protected void copySelective(ITerminalTextData dest, ITerminalTextData source, int sourceStartLine, int destStartLine, boolean[] linesToCopy) {
        int i = 0;
        while (i < linesToCopy.length) {
            if (linesToCopy[i]) {
                dest.copyLine(source, i + sourceStartLine, i + destStartLine);
            }
            ++i;
        }
    }

    public void testCopyLineWithOffset() {
        ITerminalTextData term = this.makeITerminalTextData();
        String s = "111\n222\n333\n444\n555";
        this.fill(term, s);
        ITerminalTextData dest = this.makeITerminalTextData();
        String sCopy = "aaa\nbbb\nccc\nddd\neee";
        this.fill(dest, sCopy);
        boolean[] blArray = new boolean[4];
        blArray[0] = true;
        blArray[3] = true;
        this.copySelective(dest, term, 1, 0, blArray);
        this.assertEqualsTerm(s, this.toMultiLineText((ITerminalTextDataReadOnly)term));
        this.assertEqualsTerm("222\nbbb\nccc\n555\neee", this.toMultiLineText((ITerminalTextDataReadOnly)dest));
        this.fill(dest, sCopy);
        this.copySelective(dest, term, 2, 0, new boolean[]{true, true});
        this.assertEqualsTerm(s, this.toMultiLineText((ITerminalTextDataReadOnly)term));
        this.assertEqualsTerm("333\n444\nccc\nddd\neee", this.toMultiLineText((ITerminalTextDataReadOnly)dest));
        this.fill(dest, sCopy);
        this.copySelective(dest, term, 0, 0, new boolean[]{true, true, true, true, true});
        this.assertEqualsTerm(s, this.toMultiLineText((ITerminalTextDataReadOnly)term));
        this.assertEqualsTerm(s, this.toMultiLineText((ITerminalTextDataReadOnly)dest));
        this.fill(dest, sCopy);
        this.copySelective(dest, term, 0, 0, new boolean[5]);
        this.assertEqualsTerm(s, this.toMultiLineText((ITerminalTextDataReadOnly)term));
        this.assertEqualsTerm(sCopy, this.toMultiLineText((ITerminalTextDataReadOnly)dest));
    }

    public void testScrollNoop() {
        this.scrollTest(0, 0, 0, "012345", "012345");
        this.scrollTest(0, 1, 0, "012345", "012345");
        this.scrollTest(0, 6, 0, "012345", "012345");
    }

    public void testScrollAll() {
        this.scrollTest(0, 6, 1, "012345", " 01234");
        this.scrollTest(0, 6, -1, "012345", "12345 ");
        this.scrollTest(0, 6, 2, "012345", "  0123");
        this.scrollTest(0, 6, -2, "012345", "2345  ");
    }

    public void testScrollNegative() {
        this.scrollTest(0, 2, -1, "012345", "1 2345");
        this.scrollTest(0, 1, -1, "012345", " 12345");
        this.scrollTest(0, 6, -1, "012345", "12345 ");
        this.scrollTest(0, 6, -6, "012345", "      ");
        this.scrollTest(0, 6, -7, "012345", "      ");
        this.scrollTest(0, 6, -8, "012345", "      ");
        this.scrollTest(0, 6, -2, "012345", "2345  ");
        this.scrollTest(1, 1, -1, "012345", "0 2345");
        this.scrollTest(1, 1, -1, "012345", "0 2345");
        this.scrollTest(1, 2, -1, "012345", "02 345");
        this.scrollTest(5, 1, -1, "012345", "01234 ");
        this.scrollTest(5, 1, -1, "012345", "01234 ");
    }

    public void testScrollNegative2() {
        this.scrollTest(0, 2, -1, "  23  ", "  23  ");
        this.scrollTest(0, 1, -1, "  23  ", "  23  ");
        this.scrollTest(0, 6, -1, "  23  ", " 23   ");
        this.scrollTest(0, 6, -6, "  23  ", "      ");
        this.scrollTest(0, 6, -7, "  23  ", "      ");
        this.scrollTest(0, 6, -8, "  23  ", "      ");
        this.scrollTest(0, 6, -2, "  23  ", "23    ");
        this.scrollTest(1, 1, -1, "  23  ", "  23  ");
        this.scrollTest(1, 2, -1, "  23  ", " 2 3  ");
        this.scrollTest(5, 1, -1, "  23  ", "  23  ");
        this.scrollTest(5, 1, -1, "  23  ", "  23  ");
    }

    public void testScrollNegative3() {
        this.scrollTest(1, 5, -7, "012345", "0     ");
    }

    public void testScrollPositive2() {
        this.scrollTest(2, 8, 20, "0123456789", "01        ");
    }

    public void testScrollPositive() {
        this.scrollTest(0, 2, 1, "012345", " 02345");
        this.scrollTest(0, 2, 2, "012345", "  2345");
        this.scrollTest(2, 4, 2, "012345", "01  23");
        this.scrollTest(2, 4, 2, "0123456", "01  236");
        this.scrollTest(0, 7, 6, "0123456", "      0");
        this.scrollTest(0, 7, 8, "0123456", "       ");
        this.scrollTest(0, 7, 9, "0123456", "       ");
        this.scrollTest(2, 4, 2, "0123456", "01  236");
        this.scrollTest(2, 5, 3, "0123456789", "01   23789");
        this.scrollTest(2, 7, 3, "0123456789", "01   23459");
        this.scrollTest(2, 8, 3, "0123456789", "01   23456");
        this.scrollTest(2, 8, 5, "0123456789", "01     234");
        this.scrollTest(2, 8, 9, "0123456789", "01        ");
        this.scrollTest(0, 10, 9, "0123456789", "         0");
        this.scrollTest(0, 6, 6, "012345", "      ");
    }

    public void testScrollFail() {
        try {
            this.scrollTest(5, 2, -1, "012345", "012345");
            AbstractITerminalTextDataTest.fail();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        try {
            this.scrollTest(0, 7, 1, "012345", "      ");
            AbstractITerminalTextDataTest.fail();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    void scrollTest(int line, int n, int shift, String start, String result) {
        ITerminalTextData term = this.makeITerminalTextData();
        this.fillSimple(term, start);
        term.scroll(line, n, shift);
        this.assertEqualsSimple(result, this.toSimple(term));
    }

    public void testWrappedLines() {
        ITerminalTextData term = this.makeITerminalTextData();
        term.setDimensions(4, 4);
        int i = 0;
        while (i < term.getHeight()) {
            AbstractITerminalTextDataTest.assertFalse((boolean)term.isWrappedLine(i));
            ++i;
        }
        term.setWrappedLine(0);
        term.setWrappedLine(3);
        AbstractITerminalTextDataTest.assertTrue((boolean)term.isWrappedLine(0));
        AbstractITerminalTextDataTest.assertFalse((boolean)term.isWrappedLine(1));
        AbstractITerminalTextDataTest.assertFalse((boolean)term.isWrappedLine(2));
        AbstractITerminalTextDataTest.assertTrue((boolean)term.isWrappedLine(3));
        term.cleanLine(0);
        AbstractITerminalTextDataTest.assertFalse((boolean)term.isWrappedLine(0));
    }
}

