/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.internal.terminal.test.ui;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import org.eclipse.tm.internal.terminal.test.ui.AbstractLineOrientedDataSource;
import org.eclipse.tm.terminal.model.Style;
import org.eclipse.tm.terminal.model.StyleColor;

final class FileDataSource
extends AbstractLineOrientedDataSource {
    private final String fFile;
    BufferedReader reader;
    String line;
    Style style;
    Style styleNormal = Style.getStyle((StyleColor)StyleColor.getStyleColor((String)"black"), (StyleColor)StyleColor.getStyleColor((String)"white"));
    Style styleBold = this.styleNormal.setBold(true);

    FileDataSource(String file) {
        this.fFile = file;
    }

    @Override
    public char[] dataSource() {
        return this.line.toCharArray();
    }

    @Override
    public Style getStyle() {
        return this.style;
    }

    @Override
    public void next() {
        try {
            if (this.reader == null) {
                this.reader = new BufferedReader(new FileReader(this.fFile));
            }
            this.line = this.reader.readLine();
            if (this.line == null) {
                this.reader.close();
                this.reader = null;
                this.next();
                return;
            }
            this.style = this.line.lastIndexOf(120) > 0 ? this.styleBold : this.styleNormal;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

