/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.internal.terminal.model;

import junit.framework.TestCase;
import org.eclipse.tm.internal.terminal.model.ISnapshotChanges;
import org.eclipse.tm.internal.terminal.model.SnapshotChanges;
import org.eclipse.tm.internal.terminal.model.TerminalTextDataStore;
import org.eclipse.tm.internal.terminal.model.TerminalTextDataWindow;
import org.eclipse.tm.internal.terminal.model.TerminalTextTestHelper;
import org.eclipse.tm.terminal.model.ITerminalTextData;
import org.eclipse.tm.terminal.model.ITerminalTextDataReadOnly;

public class SnapshotChangesTest
extends TestCase {
    void assertChangedLines(ISnapshotChanges change, String expected) {
        StringBuffer buffer = new StringBuffer();
        int line = 0;
        while (line < expected.length()) {
            if (change.hasLineChanged(line)) {
                buffer.append('1');
            } else {
                buffer.append('0');
            }
            ++line;
        }
        SnapshotChangesTest.assertEquals((String)expected, (String)buffer.toString());
    }

    public void testSnapshotChanges() {
        SnapshotChanges changes = new SnapshotChanges(1);
        SnapshotChangesTest.assertEquals((int)0, (int)changes.getInterestWindowStartLine());
        SnapshotChangesTest.assertEquals((int)0, (int)changes.getInterestWindowSize());
    }

    public void testSnapshotChangesWithWindow() {
        SnapshotChanges changes = new SnapshotChanges(2, 5);
        SnapshotChangesTest.assertEquals((int)2, (int)changes.getInterestWindowStartLine());
        SnapshotChangesTest.assertEquals((int)5, (int)changes.getInterestWindowSize());
    }

    public void testIsInInterestWindowIntInt() {
        SnapshotChanges changes = new SnapshotChanges(2, 5);
        SnapshotChangesTest.assertFalse((boolean)changes.isInInterestWindow(0, 1));
        SnapshotChangesTest.assertFalse((boolean)changes.isInInterestWindow(0, 2));
        SnapshotChangesTest.assertTrue((boolean)changes.isInInterestWindow(0, 3));
        SnapshotChangesTest.assertTrue((boolean)changes.isInInterestWindow(0, 4));
        SnapshotChangesTest.assertTrue((boolean)changes.isInInterestWindow(0, 5));
        SnapshotChangesTest.assertTrue((boolean)changes.isInInterestWindow(0, 6));
        SnapshotChangesTest.assertTrue((boolean)changes.isInInterestWindow(0, 10));
        SnapshotChangesTest.assertTrue((boolean)changes.isInInterestWindow(2, 5));
        SnapshotChangesTest.assertTrue((boolean)changes.isInInterestWindow(6, 0));
        SnapshotChangesTest.assertTrue((boolean)changes.isInInterestWindow(6, 1));
        SnapshotChangesTest.assertTrue((boolean)changes.isInInterestWindow(6, 10));
        SnapshotChangesTest.assertFalse((boolean)changes.isInInterestWindow(7, 0));
        SnapshotChangesTest.assertFalse((boolean)changes.isInInterestWindow(7, 1));
        SnapshotChangesTest.assertFalse((boolean)changes.isInInterestWindow(8, 10));
    }

    public void testIsInInterestWindowIntIntNoWindow() {
        SnapshotChanges changes = new SnapshotChanges(3);
        int i = 0;
        while (i < 5) {
            int j = 0;
            while (j < 5) {
                SnapshotChangesTest.assertTrue((boolean)changes.isInInterestWindow(i, j));
                ++j;
            }
            ++i;
        }
    }

    public void testIsInInterestWindowInt() {
        SnapshotChanges changes = new SnapshotChanges(3, 1);
        SnapshotChangesTest.assertFalse((boolean)changes.isInInterestWindow(0));
        SnapshotChangesTest.assertFalse((boolean)changes.isInInterestWindow(1));
        SnapshotChangesTest.assertFalse((boolean)changes.isInInterestWindow(2));
        SnapshotChangesTest.assertTrue((boolean)changes.isInInterestWindow(3));
        SnapshotChangesTest.assertFalse((boolean)changes.isInInterestWindow(4));
        SnapshotChangesTest.assertFalse((boolean)changes.isInInterestWindow(5));
    }

    public void testIsInInterestWindowIntNoWindow() {
        SnapshotChanges changes = new SnapshotChanges(3);
        int i = 0;
        while (i < 10) {
            SnapshotChangesTest.assertTrue((boolean)changes.isInInterestWindow(i));
            ++i;
        }
    }

    public void testFitLineToWindow() {
        SnapshotChanges changes = new SnapshotChanges(2, 5);
        SnapshotChangesTest.assertEquals((int)2, (int)changes.fitLineToWindow(0));
        SnapshotChangesTest.assertEquals((int)2, (int)changes.fitLineToWindow(1));
        SnapshotChangesTest.assertEquals((int)2, (int)changes.fitLineToWindow(2));
        SnapshotChangesTest.assertEquals((int)3, (int)changes.fitLineToWindow(3));
        SnapshotChangesTest.assertTrue((boolean)changes.isInInterestWindow(4));
        SnapshotChangesTest.assertEquals((int)4, (int)changes.fitLineToWindow(4));
        SnapshotChangesTest.assertTrue((boolean)changes.isInInterestWindow(5));
        SnapshotChangesTest.assertEquals((int)5, (int)changes.fitLineToWindow(5));
        SnapshotChangesTest.assertTrue((boolean)changes.isInInterestWindow(6));
        SnapshotChangesTest.assertEquals((int)6, (int)changes.fitLineToWindow(6));
        SnapshotChangesTest.assertFalse((boolean)changes.isInInterestWindow(7));
        SnapshotChangesTest.assertEquals((int)7, (int)changes.fitLineToWindow(7));
        SnapshotChangesTest.assertFalse((boolean)changes.isInInterestWindow(8));
        SnapshotChangesTest.assertEquals((int)8, (int)changes.fitLineToWindow(8));
    }

    public void testFitLineToWindowNoWindow() {
        SnapshotChanges changes = new SnapshotChanges(5);
        SnapshotChangesTest.assertEquals((int)0, (int)changes.fitLineToWindow(0));
        SnapshotChangesTest.assertEquals((int)1, (int)changes.fitLineToWindow(1));
        SnapshotChangesTest.assertEquals((int)2, (int)changes.fitLineToWindow(2));
        SnapshotChangesTest.assertEquals((int)3, (int)changes.fitLineToWindow(3));
        SnapshotChangesTest.assertEquals((int)4, (int)changes.fitLineToWindow(4));
        SnapshotChangesTest.assertEquals((int)5, (int)changes.fitLineToWindow(5));
        SnapshotChangesTest.assertEquals((int)6, (int)changes.fitLineToWindow(6));
        SnapshotChangesTest.assertEquals((int)7, (int)changes.fitLineToWindow(7));
    }

    public void testFitSizeToWindow() {
        SnapshotChanges changes = new SnapshotChanges(2, 3);
        SnapshotChangesTest.assertFalse((boolean)changes.isInInterestWindow(0, 1));
        SnapshotChangesTest.assertFalse((boolean)changes.isInInterestWindow(0, 2));
        SnapshotChangesTest.assertTrue((boolean)changes.isInInterestWindow(0, 3));
        SnapshotChangesTest.assertEquals((int)1, (int)changes.fitSizeToWindow(0, 3));
        SnapshotChangesTest.assertEquals((int)2, (int)changes.fitSizeToWindow(0, 4));
        SnapshotChangesTest.assertEquals((int)3, (int)changes.fitSizeToWindow(0, 5));
        SnapshotChangesTest.assertEquals((int)3, (int)changes.fitSizeToWindow(0, 6));
        SnapshotChangesTest.assertEquals((int)3, (int)changes.fitSizeToWindow(0, 7));
        SnapshotChangesTest.assertEquals((int)3, (int)changes.fitSizeToWindow(0, 8));
        SnapshotChangesTest.assertEquals((int)3, (int)changes.fitSizeToWindow(0, 9));
        SnapshotChangesTest.assertEquals((int)3, (int)changes.fitSizeToWindow(1, 9));
        SnapshotChangesTest.assertEquals((int)3, (int)changes.fitSizeToWindow(2, 9));
        SnapshotChangesTest.assertEquals((int)3, (int)changes.fitSizeToWindow(2, 3));
        SnapshotChangesTest.assertEquals((int)2, (int)changes.fitSizeToWindow(2, 2));
        SnapshotChangesTest.assertEquals((int)1, (int)changes.fitSizeToWindow(2, 1));
        SnapshotChangesTest.assertEquals((int)2, (int)changes.fitSizeToWindow(3, 9));
        SnapshotChangesTest.assertEquals((int)2, (int)changes.fitSizeToWindow(3, 2));
        SnapshotChangesTest.assertEquals((int)1, (int)changes.fitSizeToWindow(3, 1));
        SnapshotChangesTest.assertEquals((int)2, (int)changes.fitSizeToWindow(3, 2));
        SnapshotChangesTest.assertEquals((int)2, (int)changes.fitSizeToWindow(3, 3));
        SnapshotChangesTest.assertEquals((int)1, (int)changes.fitSizeToWindow(4, 1));
        SnapshotChangesTest.assertEquals((int)1, (int)changes.fitSizeToWindow(4, 2));
        SnapshotChangesTest.assertFalse((boolean)changes.isInInterestWindow(5, 1));
    }

    public void testFitSizeToWindowNoWindow() {
        SnapshotChanges changes = new SnapshotChanges(3);
        SnapshotChangesTest.assertEquals((int)1, (int)changes.fitSizeToWindow(0, 1));
        SnapshotChangesTest.assertEquals((int)2, (int)changes.fitSizeToWindow(0, 2));
        SnapshotChangesTest.assertEquals((int)3, (int)changes.fitSizeToWindow(0, 3));
        SnapshotChangesTest.assertEquals((int)4, (int)changes.fitSizeToWindow(0, 4));
        SnapshotChangesTest.assertEquals((int)5, (int)changes.fitSizeToWindow(0, 5));
        SnapshotChangesTest.assertEquals((int)5, (int)changes.fitSizeToWindow(1, 5));
        SnapshotChangesTest.assertEquals((int)3, (int)changes.fitSizeToWindow(2, 3));
        SnapshotChangesTest.assertEquals((int)2, (int)changes.fitSizeToWindow(1, 2));
        SnapshotChangesTest.assertEquals((int)10, (int)changes.fitSizeToWindow(5, 10));
    }

    public void testMarkLineChanged() {
        SnapshotChanges changes = new SnapshotChanges(2, 3);
        SnapshotChangesTest.assertFalse((boolean)changes.hasChanged());
        changes.markLineChanged(0);
        SnapshotChangesTest.assertFalse((boolean)changes.hasChanged());
        changes.markLineChanged(1);
        SnapshotChangesTest.assertFalse((boolean)changes.hasChanged());
        changes.markLineChanged(2);
        SnapshotChangesTest.assertTrue((boolean)changes.hasChanged());
        changes = new SnapshotChanges(2, 3);
        SnapshotChangesTest.assertFalse((boolean)changes.hasChanged());
        changes.markLineChanged(3);
        SnapshotChangesTest.assertTrue((boolean)changes.hasChanged());
        this.assertLineChange(false, 2, 3, 0);
        this.assertLineChange(false, 2, 3, 1);
        this.assertLineChange(true, 2, 3, 2);
        this.assertLineChange(true, 2, 3, 3);
        this.assertLineChange(true, 2, 3, 4);
        this.assertLineChange(false, 2, 3, 5);
        this.assertLineChange(false, 2, 3, 6);
        this.assertLineChange(true, 2, 4, 5);
    }

    void assertLineChange(boolean expected, int windowStart, int windowSize, int changedLine) {
        SnapshotChanges changes = new SnapshotChanges(windowStart, windowSize);
        SnapshotChangesTest.assertFalse((boolean)changes.hasChanged());
        changes.markLineChanged(changedLine);
        if (expected) {
            SnapshotChangesTest.assertEquals((int)changedLine, (int)changes.getFirstChangedLine());
            SnapshotChangesTest.assertEquals((int)changedLine, (int)changes.getLastChangedLine());
        } else {
            SnapshotChangesTest.assertEquals((int)Integer.MAX_VALUE, (int)changes.getFirstChangedLine());
            SnapshotChangesTest.assertEquals((int)-1, (int)changes.getLastChangedLine());
        }
        SnapshotChangesTest.assertEquals((boolean)expected, (boolean)changes.hasChanged());
        int i = 0;
        while (i < windowStart + windowSize + 5) {
            boolean e = i == changedLine && i >= windowStart && i < windowStart + windowSize;
            SnapshotChangesTest.assertEquals((boolean)e, (boolean)changes.hasLineChanged(i));
            ++i;
        }
    }

    public void testMarkLinesChanged() {
        SnapshotChanges changes = new SnapshotChanges(2, 3);
        SnapshotChangesTest.assertFalse((boolean)changes.hasChanged());
        SnapshotChangesTest.assertEquals((int)Integer.MAX_VALUE, (int)changes.getFirstChangedLine());
        SnapshotChangesTest.assertEquals((int)-1, (int)changes.getLastChangedLine());
        changes.markLinesChanged(0, 1);
        this.assertChangedLines((ISnapshotChanges)changes, "00000000000");
        SnapshotChangesTest.assertFalse((boolean)changes.hasChanged());
        SnapshotChangesTest.assertEquals((int)Integer.MAX_VALUE, (int)changes.getFirstChangedLine());
        SnapshotChangesTest.assertEquals((int)-1, (int)changes.getLastChangedLine());
        changes.markLinesChanged(0, 2);
        this.assertChangedLines((ISnapshotChanges)changes, "00000000000");
        SnapshotChangesTest.assertFalse((boolean)changes.hasChanged());
        SnapshotChangesTest.assertEquals((int)Integer.MAX_VALUE, (int)changes.getFirstChangedLine());
        SnapshotChangesTest.assertEquals((int)-1, (int)changes.getLastChangedLine());
        changes.markLinesChanged(0, 3);
        SnapshotChangesTest.assertEquals((int)2, (int)changes.getFirstChangedLine());
        SnapshotChangesTest.assertEquals((int)2, (int)changes.getLastChangedLine());
        SnapshotChangesTest.assertTrue((boolean)changes.hasChanged());
        this.assertChangedLines((ISnapshotChanges)changes, "00100000000");
        changes = new SnapshotChanges(2, 3);
        changes.markLinesChanged(1, 3);
        SnapshotChangesTest.assertTrue((boolean)changes.hasChanged());
        SnapshotChangesTest.assertEquals((int)2, (int)changes.getFirstChangedLine());
        SnapshotChangesTest.assertEquals((int)3, (int)changes.getLastChangedLine());
        this.assertChangedLines((ISnapshotChanges)changes, "00110000000");
        changes = new SnapshotChanges(2, 3);
        changes.markLinesChanged(1, 4);
        SnapshotChangesTest.assertEquals((int)2, (int)changes.getFirstChangedLine());
        SnapshotChangesTest.assertEquals((int)4, (int)changes.getLastChangedLine());
        SnapshotChangesTest.assertTrue((boolean)changes.hasChanged());
        this.assertChangedLines((ISnapshotChanges)changes, "00111000000");
        changes = new SnapshotChanges(2, 3);
        changes.markLinesChanged(1, 4);
        SnapshotChangesTest.assertEquals((int)2, (int)changes.getFirstChangedLine());
        SnapshotChangesTest.assertEquals((int)4, (int)changes.getLastChangedLine());
        SnapshotChangesTest.assertTrue((boolean)changes.hasChanged());
        this.assertChangedLines((ISnapshotChanges)changes, "00111000000");
        changes = new SnapshotChanges(2, 3);
        changes.markLinesChanged(2, 4);
        SnapshotChangesTest.assertEquals((int)2, (int)changes.getFirstChangedLine());
        SnapshotChangesTest.assertEquals((int)4, (int)changes.getLastChangedLine());
        SnapshotChangesTest.assertTrue((boolean)changes.hasChanged());
        this.assertChangedLines((ISnapshotChanges)changes, "00111000000");
        changes = new SnapshotChanges(2, 3);
        changes.markLinesChanged(3, 4);
        SnapshotChangesTest.assertEquals((int)3, (int)changes.getFirstChangedLine());
        SnapshotChangesTest.assertEquals((int)4, (int)changes.getLastChangedLine());
        SnapshotChangesTest.assertTrue((boolean)changes.hasChanged());
        this.assertChangedLines((ISnapshotChanges)changes, "00011000000");
        changes = new SnapshotChanges(2, 3);
        changes.markLinesChanged(3, 1);
        SnapshotChangesTest.assertEquals((int)3, (int)changes.getFirstChangedLine());
        SnapshotChangesTest.assertEquals((int)3, (int)changes.getLastChangedLine());
        SnapshotChangesTest.assertTrue((boolean)changes.hasChanged());
        this.assertChangedLines((ISnapshotChanges)changes, "00010000000");
        changes = new SnapshotChanges(2, 3);
        changes.markLinesChanged(4, 1);
        SnapshotChangesTest.assertEquals((int)4, (int)changes.getFirstChangedLine());
        SnapshotChangesTest.assertEquals((int)4, (int)changes.getLastChangedLine());
        SnapshotChangesTest.assertTrue((boolean)changes.hasChanged());
        this.assertChangedLines((ISnapshotChanges)changes, "00001000000");
        changes = new SnapshotChanges(2, 3);
        changes.markLinesChanged(5, 1);
        SnapshotChangesTest.assertEquals((int)Integer.MAX_VALUE, (int)changes.getFirstChangedLine());
        SnapshotChangesTest.assertEquals((int)-1, (int)changes.getLastChangedLine());
        SnapshotChangesTest.assertFalse((boolean)changes.hasChanged());
        this.assertChangedLines((ISnapshotChanges)changes, "00000000000");
    }

    public void testMarkLinesChangedNoWindow() {
        SnapshotChanges changes = new SnapshotChanges(10);
        SnapshotChangesTest.assertFalse((boolean)changes.hasChanged());
        SnapshotChangesTest.assertEquals((int)Integer.MAX_VALUE, (int)changes.getFirstChangedLine());
        SnapshotChangesTest.assertEquals((int)-1, (int)changes.getLastChangedLine());
        changes.markLinesChanged(0, 1);
        SnapshotChangesTest.assertTrue((boolean)changes.hasChanged());
        SnapshotChangesTest.assertEquals((int)0, (int)changes.getFirstChangedLine());
        SnapshotChangesTest.assertEquals((int)0, (int)changes.getLastChangedLine());
        this.assertChangedLines((ISnapshotChanges)changes, "1000000000");
        changes = new SnapshotChanges(10);
        changes.markLinesChanged(0, 5);
        SnapshotChangesTest.assertTrue((boolean)changes.hasChanged());
        SnapshotChangesTest.assertEquals((int)0, (int)changes.getFirstChangedLine());
        SnapshotChangesTest.assertEquals((int)4, (int)changes.getLastChangedLine());
        this.assertChangedLines((ISnapshotChanges)changes, "1111100000");
        changes = new SnapshotChanges(3);
        changes.markLinesChanged(1, 6);
        SnapshotChangesTest.assertTrue((boolean)changes.hasChanged());
        SnapshotChangesTest.assertEquals((int)1, (int)changes.getFirstChangedLine());
        SnapshotChangesTest.assertEquals((int)6, (int)changes.getLastChangedLine());
        this.assertChangedLines((ISnapshotChanges)changes, "011");
        changes = new SnapshotChanges(10);
        changes.markLinesChanged(5, 6);
        SnapshotChangesTest.assertTrue((boolean)changes.hasChanged());
        SnapshotChangesTest.assertEquals((int)5, (int)changes.getFirstChangedLine());
        SnapshotChangesTest.assertEquals((int)10, (int)changes.getLastChangedLine());
        this.assertChangedLines((ISnapshotChanges)changes, "0000011111");
    }

    public void testHasChanged() {
        SnapshotChanges changes = new SnapshotChanges(0);
        SnapshotChangesTest.assertFalse((boolean)changes.hasChanged());
        changes = new SnapshotChanges(1);
        SnapshotChangesTest.assertFalse((boolean)changes.hasChanged());
        changes = new SnapshotChanges(1, 9);
        SnapshotChangesTest.assertFalse((boolean)changes.hasChanged());
    }

    public void testSetAllChanged() {
        SnapshotChanges changes = new SnapshotChanges(2, 3);
        changes.setAllChanged(10);
        SnapshotChangesTest.assertEquals((int)2, (int)changes.getFirstChangedLine());
        SnapshotChangesTest.assertEquals((int)4, (int)changes.getLastChangedLine());
        SnapshotChangesTest.assertTrue((boolean)changes.hasChanged());
        this.assertChangedLines((ISnapshotChanges)changes, "00111000000");
        changes = new SnapshotChanges(2, 3);
        changes.setAllChanged(3);
        SnapshotChangesTest.assertEquals((int)2, (int)changes.getFirstChangedLine());
        SnapshotChangesTest.assertEquals((int)2, (int)changes.getLastChangedLine());
        SnapshotChangesTest.assertTrue((boolean)changes.hasChanged());
        this.assertChangedLines((ISnapshotChanges)changes, "00111000000");
        changes = new SnapshotChanges(2, 3);
        changes.setAllChanged(4);
        SnapshotChangesTest.assertEquals((int)2, (int)changes.getFirstChangedLine());
        SnapshotChangesTest.assertEquals((int)3, (int)changes.getLastChangedLine());
        SnapshotChangesTest.assertTrue((boolean)changes.hasChanged());
        this.assertChangedLines((ISnapshotChanges)changes, "00111000000");
        changes = new SnapshotChanges(2, 3);
        changes.setAllChanged(5);
        SnapshotChangesTest.assertEquals((int)2, (int)changes.getFirstChangedLine());
        SnapshotChangesTest.assertEquals((int)4, (int)changes.getLastChangedLine());
        SnapshotChangesTest.assertTrue((boolean)changes.hasChanged());
        this.assertChangedLines((ISnapshotChanges)changes, "00111000000");
        changes = new SnapshotChanges(2, 3);
        changes.setAllChanged(6);
        SnapshotChangesTest.assertEquals((int)2, (int)changes.getFirstChangedLine());
        SnapshotChangesTest.assertEquals((int)4, (int)changes.getLastChangedLine());
        SnapshotChangesTest.assertTrue((boolean)changes.hasChanged());
        this.assertChangedLines((ISnapshotChanges)changes, "00111000000");
    }

    public void testSetAllChangedNoWindow() {
        SnapshotChanges changes = new SnapshotChanges(5);
        changes.setAllChanged(10);
        SnapshotChangesTest.assertEquals((int)0, (int)changes.getFirstChangedLine());
        SnapshotChangesTest.assertEquals((int)9, (int)changes.getLastChangedLine());
        SnapshotChangesTest.assertTrue((boolean)changes.hasChanged());
        this.assertChangedLines((ISnapshotChanges)changes, "1111111111");
        changes = new SnapshotChanges(5);
        changes.setAllChanged(3);
        SnapshotChangesTest.assertEquals((int)0, (int)changes.getFirstChangedLine());
        SnapshotChangesTest.assertEquals((int)2, (int)changes.getLastChangedLine());
        SnapshotChangesTest.assertTrue((boolean)changes.hasChanged());
        this.assertChangedLines((ISnapshotChanges)changes, "1111111111");
    }

    public void testConvertScrollingIntoChanges() {
        SnapshotChanges changes = new SnapshotChanges(2, 3);
        changes.scroll(0, 4, -1);
        SnapshotChangesTest.assertTrue((boolean)changes.hasChanged());
        this.assertChangedLines((ISnapshotChanges)changes, "000100");
        changes.convertScrollingIntoChanges();
        SnapshotChangesTest.assertEquals((int)2, (int)changes.getFirstChangedLine());
        SnapshotChangesTest.assertEquals((int)3, (int)changes.getLastChangedLine());
        SnapshotChangesTest.assertEquals((int)0, (int)changes.getScrollWindowStartLine());
        SnapshotChangesTest.assertEquals((int)0, (int)changes.getScrollWindowSize());
        SnapshotChangesTest.assertEquals((int)0, (int)changes.getScrollWindowShift());
        this.assertChangedLines((ISnapshotChanges)changes, "001100");
    }

    public void testConvertScrollingIntoChangesNoWindow() {
        SnapshotChanges changes = new SnapshotChanges(7);
        changes.scroll(0, 4, -1);
        SnapshotChangesTest.assertTrue((boolean)changes.hasChanged());
        this.assertChangedLines((ISnapshotChanges)changes, "000100");
        changes.convertScrollingIntoChanges();
        SnapshotChangesTest.assertEquals((int)0, (int)changes.getFirstChangedLine());
        SnapshotChangesTest.assertEquals((int)3, (int)changes.getLastChangedLine());
        SnapshotChangesTest.assertEquals((int)0, (int)changes.getScrollWindowStartLine());
        SnapshotChangesTest.assertEquals((int)0, (int)changes.getScrollWindowSize());
        SnapshotChangesTest.assertEquals((int)0, (int)changes.getScrollWindowShift());
        this.assertChangedLines((ISnapshotChanges)changes, "111100");
    }

    public void testScrollNoWindow() {
        SnapshotChanges changes = new SnapshotChanges(7);
        changes.scroll(0, 3, -2);
        SnapshotChangesTest.assertEquals((int)1, (int)changes.getFirstChangedLine());
        SnapshotChangesTest.assertEquals((int)2, (int)changes.getLastChangedLine());
        SnapshotChangesTest.assertEquals((int)0, (int)changes.getScrollWindowStartLine());
        SnapshotChangesTest.assertEquals((int)3, (int)changes.getScrollWindowSize());
        SnapshotChangesTest.assertEquals((int)-2, (int)changes.getScrollWindowShift());
        SnapshotChangesTest.assertTrue((boolean)changes.hasChanged());
        this.assertChangedLines((ISnapshotChanges)changes, "0110000");
        changes = new SnapshotChanges(7);
        changes.scroll(0, 3, -1);
        changes.scroll(0, 3, -1);
        SnapshotChangesTest.assertEquals((int)1, (int)changes.getFirstChangedLine());
        SnapshotChangesTest.assertEquals((int)2, (int)changes.getLastChangedLine());
        SnapshotChangesTest.assertEquals((int)0, (int)changes.getScrollWindowStartLine());
        SnapshotChangesTest.assertEquals((int)3, (int)changes.getScrollWindowSize());
        SnapshotChangesTest.assertEquals((int)-2, (int)changes.getScrollWindowShift());
        SnapshotChangesTest.assertTrue((boolean)changes.hasChanged());
        this.assertChangedLines((ISnapshotChanges)changes, "0110000");
        changes = new SnapshotChanges(7);
        changes.scroll(0, 7, -1);
        changes.scroll(0, 7, -1);
        SnapshotChangesTest.assertEquals((int)5, (int)changes.getFirstChangedLine());
        SnapshotChangesTest.assertEquals((int)6, (int)changes.getLastChangedLine());
        SnapshotChangesTest.assertEquals((int)0, (int)changes.getScrollWindowStartLine());
        SnapshotChangesTest.assertEquals((int)7, (int)changes.getScrollWindowSize());
        SnapshotChangesTest.assertEquals((int)-2, (int)changes.getScrollWindowShift());
        SnapshotChangesTest.assertTrue((boolean)changes.hasChanged());
        this.assertChangedLines((ISnapshotChanges)changes, "0000011");
        changes = new SnapshotChanges(7);
        changes.scroll(0, 7, 1);
        changes.scroll(0, 7, 1);
        SnapshotChangesTest.assertEquals((int)0, (int)changes.getFirstChangedLine());
        SnapshotChangesTest.assertEquals((int)6, (int)changes.getLastChangedLine());
        SnapshotChangesTest.assertEquals((int)0, (int)changes.getScrollWindowStartLine());
        SnapshotChangesTest.assertEquals((int)0, (int)changes.getScrollWindowSize());
        SnapshotChangesTest.assertEquals((int)0, (int)changes.getScrollWindowShift());
        SnapshotChangesTest.assertTrue((boolean)changes.hasChanged());
        this.assertChangedLines((ISnapshotChanges)changes, "1111111");
    }

    public void testScroll() {
        SnapshotChanges changes = new SnapshotChanges(2, 3);
        changes.scroll(0, 7, -1);
        SnapshotChangesTest.assertEquals((int)4, (int)changes.getFirstChangedLine());
        SnapshotChangesTest.assertEquals((int)4, (int)changes.getLastChangedLine());
        SnapshotChangesTest.assertEquals((int)2, (int)changes.getScrollWindowStartLine());
        SnapshotChangesTest.assertEquals((int)3, (int)changes.getScrollWindowSize());
        SnapshotChangesTest.assertEquals((int)-1, (int)changes.getScrollWindowShift());
        SnapshotChangesTest.assertTrue((boolean)changes.hasChanged());
        this.assertChangedLines((ISnapshotChanges)changes, "0000100000");
        changes = new SnapshotChanges(2, 3);
        changes.scroll(0, 7, -2);
        SnapshotChangesTest.assertEquals((int)3, (int)changes.getFirstChangedLine());
        SnapshotChangesTest.assertEquals((int)4, (int)changes.getLastChangedLine());
        SnapshotChangesTest.assertEquals((int)2, (int)changes.getScrollWindowStartLine());
        SnapshotChangesTest.assertEquals((int)3, (int)changes.getScrollWindowSize());
        SnapshotChangesTest.assertEquals((int)-2, (int)changes.getScrollWindowShift());
        SnapshotChangesTest.assertTrue((boolean)changes.hasChanged());
        this.assertChangedLines((ISnapshotChanges)changes, "0001100000");
    }

    public void testScrollNergative() {
        SnapshotChanges changes = new SnapshotChanges(2, 3);
        changes.scroll(0, 7, -1);
        changes.scroll(0, 7, -1);
        SnapshotChangesTest.assertEquals((int)3, (int)changes.getFirstChangedLine());
        SnapshotChangesTest.assertEquals((int)4, (int)changes.getLastChangedLine());
        SnapshotChangesTest.assertEquals((int)2, (int)changes.getScrollWindowStartLine());
        SnapshotChangesTest.assertEquals((int)3, (int)changes.getScrollWindowSize());
        SnapshotChangesTest.assertEquals((int)-2, (int)changes.getScrollWindowShift());
        SnapshotChangesTest.assertTrue((boolean)changes.hasChanged());
        this.assertChangedLines((ISnapshotChanges)changes, "0001100000");
    }

    public void testScrollPositive() {
        SnapshotChanges changes = new SnapshotChanges(2, 3);
        changes.scroll(0, 7, 1);
        changes.scroll(0, 7, 1);
        SnapshotChangesTest.assertEquals((int)2, (int)changes.getFirstChangedLine());
        SnapshotChangesTest.assertEquals((int)4, (int)changes.getLastChangedLine());
        SnapshotChangesTest.assertEquals((int)0, (int)changes.getScrollWindowStartLine());
        SnapshotChangesTest.assertEquals((int)0, (int)changes.getScrollWindowSize());
        SnapshotChangesTest.assertEquals((int)0, (int)changes.getScrollWindowShift());
        SnapshotChangesTest.assertTrue((boolean)changes.hasChanged());
        this.assertChangedLines((ISnapshotChanges)changes, "0011100000");
        changes = new SnapshotChanges(2, 3);
        changes.scroll(0, 3, 1);
        changes.scroll(0, 3, 1);
        SnapshotChangesTest.assertEquals((int)2, (int)changes.getFirstChangedLine());
        SnapshotChangesTest.assertEquals((int)2, (int)changes.getLastChangedLine());
        SnapshotChangesTest.assertEquals((int)0, (int)changes.getScrollWindowStartLine());
        SnapshotChangesTest.assertEquals((int)0, (int)changes.getScrollWindowSize());
        SnapshotChangesTest.assertEquals((int)0, (int)changes.getScrollWindowShift());
        SnapshotChangesTest.assertTrue((boolean)changes.hasChanged());
        this.assertChangedLines((ISnapshotChanges)changes, "0010000000");
        changes = new SnapshotChanges(2, 3);
        changes.scroll(0, 4, 1);
        changes.scroll(0, 4, 1);
        SnapshotChangesTest.assertEquals((int)2, (int)changes.getFirstChangedLine());
        SnapshotChangesTest.assertEquals((int)3, (int)changes.getLastChangedLine());
        SnapshotChangesTest.assertEquals((int)0, (int)changes.getScrollWindowStartLine());
        SnapshotChangesTest.assertEquals((int)0, (int)changes.getScrollWindowSize());
        SnapshotChangesTest.assertEquals((int)0, (int)changes.getScrollWindowShift());
        SnapshotChangesTest.assertTrue((boolean)changes.hasChanged());
        this.assertChangedLines((ISnapshotChanges)changes, "0011000000");
        changes = new SnapshotChanges(2, 3);
        changes.scroll(0, 5, 1);
        changes.scroll(0, 5, 1);
        SnapshotChangesTest.assertEquals((int)2, (int)changes.getFirstChangedLine());
        SnapshotChangesTest.assertEquals((int)4, (int)changes.getLastChangedLine());
        SnapshotChangesTest.assertEquals((int)0, (int)changes.getScrollWindowStartLine());
        SnapshotChangesTest.assertEquals((int)0, (int)changes.getScrollWindowSize());
        SnapshotChangesTest.assertEquals((int)0, (int)changes.getScrollWindowShift());
        SnapshotChangesTest.assertTrue((boolean)changes.hasChanged());
        this.assertChangedLines((ISnapshotChanges)changes, "0011100000");
        changes = new SnapshotChanges(2, 3);
        changes.scroll(3, 5, 1);
        changes.scroll(3, 5, 1);
        SnapshotChangesTest.assertEquals((int)3, (int)changes.getFirstChangedLine());
        SnapshotChangesTest.assertEquals((int)4, (int)changes.getLastChangedLine());
        SnapshotChangesTest.assertEquals((int)0, (int)changes.getScrollWindowStartLine());
        SnapshotChangesTest.assertEquals((int)0, (int)changes.getScrollWindowSize());
        SnapshotChangesTest.assertEquals((int)0, (int)changes.getScrollWindowShift());
        SnapshotChangesTest.assertTrue((boolean)changes.hasChanged());
        this.assertChangedLines((ISnapshotChanges)changes, "0001100000");
    }

    public void testCopyChangedLines() {
        SnapshotChanges changes = new SnapshotChanges(2, 3);
        changes.markLineChanged(3);
        TerminalTextDataStore source = new TerminalTextDataStore();
        TerminalTextTestHelper.fillSimple((ITerminalTextData)source, "01234567890");
        TerminalTextDataStore dest = new TerminalTextDataStore();
        TerminalTextTestHelper.fillSimple((ITerminalTextData)dest, "abcdefghijk");
        changes.copyChangedLines((ITerminalTextData)dest, (ITerminalTextData)source);
        SnapshotChangesTest.assertEquals((String)"abc3efghijk", (String)TerminalTextTestHelper.toSimple((ITerminalTextDataReadOnly)dest));
        changes = new SnapshotChanges(2, 3);
        changes.setAllChanged(7);
        source = new TerminalTextDataStore();
        TerminalTextTestHelper.fillSimple((ITerminalTextData)source, "01234567890");
        dest = new TerminalTextDataStore();
        TerminalTextTestHelper.fillSimple((ITerminalTextData)dest, "abcdefghijk");
        changes.copyChangedLines((ITerminalTextData)dest, (ITerminalTextData)source);
        SnapshotChangesTest.assertEquals((String)"ab234fghijk", (String)TerminalTextTestHelper.toSimple((ITerminalTextDataReadOnly)dest));
        changes = new SnapshotChanges(2, 3);
        changes.scroll(0, 7, -1);
        source = new TerminalTextDataStore();
        TerminalTextTestHelper.fillSimple((ITerminalTextData)source, "01234567890");
        dest = new TerminalTextDataStore();
        TerminalTextTestHelper.fillSimple((ITerminalTextData)dest, "abcdefghijk");
        this.assertChangedLines((ISnapshotChanges)changes, "00001000");
        changes.copyChangedLines((ITerminalTextData)dest, (ITerminalTextData)source);
        SnapshotChangesTest.assertEquals((String)"abcd4fghijk", (String)TerminalTextTestHelper.toSimple((ITerminalTextDataReadOnly)dest));
    }

    public void testCopyChangedLinesWithSmallSource() {
        SnapshotChanges changes = new SnapshotChanges(2, 3);
        changes.markLineChanged(3);
        TerminalTextDataStore source = new TerminalTextDataStore();
        source.setDimensions(2, 2);
        TerminalTextDataWindow dest = new TerminalTextDataWindow();
        dest.setWindow(2, 2);
        changes.copyChangedLines((ITerminalTextData)dest, (ITerminalTextData)source);
    }

    public void testCopyChangedLinesWithSmallSource1() {
        SnapshotChanges changes = new SnapshotChanges(2, 3);
        changes.markLineChanged(3);
        TerminalTextDataStore source = new TerminalTextDataStore();
        TerminalTextTestHelper.fillSimple((ITerminalTextData)source, "01");
        TerminalTextDataStore dest = new TerminalTextDataStore();
        changes.copyChangedLines((ITerminalTextData)dest, (ITerminalTextData)source);
    }

    public void testSetInterestWindowSize() {
        SnapshotChanges changes = new SnapshotChanges(2, 3);
        changes.setInterestWindow(3, 3);
        SnapshotChangesTest.assertEquals((int)3, (int)changes.getScrollWindowStartLine());
        SnapshotChangesTest.assertEquals((int)3, (int)changes.getScrollWindowSize());
        SnapshotChangesTest.assertEquals((int)-1, (int)changes.getScrollWindowShift());
        this.assertChangedLines((ISnapshotChanges)changes, "0000010");
        changes.convertScrollingIntoChanges();
        this.assertChangedLines((ISnapshotChanges)changes, "0001110");
        changes = new SnapshotChanges(2, 3);
        changes.setInterestWindow(3, 4);
        SnapshotChangesTest.assertEquals((int)3, (int)changes.getScrollWindowStartLine());
        SnapshotChangesTest.assertEquals((int)3, (int)changes.getScrollWindowSize());
        SnapshotChangesTest.assertEquals((int)-1, (int)changes.getScrollWindowShift());
        this.assertChangedLines((ISnapshotChanges)changes, "0000011");
        changes.convertScrollingIntoChanges();
        this.assertChangedLines((ISnapshotChanges)changes, "0001111");
        changes = new SnapshotChanges(2, 3);
        changes.setInterestWindow(6, 3);
        SnapshotChangesTest.assertEquals((int)0, (int)changes.getScrollWindowStartLine());
        SnapshotChangesTest.assertEquals((int)0, (int)changes.getScrollWindowSize());
        SnapshotChangesTest.assertEquals((int)0, (int)changes.getScrollWindowShift());
        this.assertChangedLines((ISnapshotChanges)changes, "000000111000");
        changes = new SnapshotChanges(2, 3);
        changes.setInterestWindow(2, 5);
        SnapshotChangesTest.assertEquals((int)0, (int)changes.getScrollWindowStartLine());
        SnapshotChangesTest.assertEquals((int)0, (int)changes.getScrollWindowSize());
        SnapshotChangesTest.assertEquals((int)0, (int)changes.getScrollWindowShift());
        this.assertChangedLines((ISnapshotChanges)changes, "0000011000");
    }

    public void testSetInterestWindowSize2() {
        SnapshotChanges changes = new SnapshotChanges(2, 3);
        changes.setInterestWindow(1, 3);
        this.assertChangedLines((ISnapshotChanges)changes, "0111000");
        changes = new SnapshotChanges(2, 3);
        changes.setInterestWindow(1, 4);
        this.assertChangedLines((ISnapshotChanges)changes, "01111000");
        changes = new SnapshotChanges(2, 3);
        changes.setInterestWindow(6, 3);
        this.assertChangedLines((ISnapshotChanges)changes, "000000111000");
        changes = new SnapshotChanges(2, 3);
        changes.setInterestWindow(1, 2);
        this.assertChangedLines((ISnapshotChanges)changes, "0110000");
    }
}

