/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.internal.terminal.model;

import junit.framework.TestCase;
import org.eclipse.tm.internal.terminal.model.TerminalTextData;
import org.eclipse.tm.terminal.model.ITerminalTextData;
import org.eclipse.tm.terminal.model.ITerminalTextDataSnapshot;
import org.eclipse.tm.terminal.model.Style;
import org.eclipse.tm.terminal.model.StyleColor;

public class TerminalTextDataPerformanceTest
extends TestCase {
    long TIME = 100L;
    int N = 0;

    private void initPerformance(ITerminalTextData term) {
        term.setDimensions(300, 200);
    }

    public void testPerformance0() {
        TerminalTextData term = new TerminalTextData();
        this.method0((ITerminalTextData)term, "0 ");
    }

    public void testPerformance0a() {
        TerminalTextData term = new TerminalTextData();
        ITerminalTextDataSnapshot snapshot = term.makeSnapshot();
        this.method0((ITerminalTextData)term, "0a");
        snapshot.updateSnapshot(true);
    }

    public void testPerformance0b() {
        TerminalTextData term = new TerminalTextData();
        ITerminalTextDataSnapshot snapshot = term.makeSnapshot();
        this.N = 0;
        snapshot.addListener(new ITerminalTextDataSnapshot.SnapshotOutOfDateListener(){

            public void snapshotOutOfDate(ITerminalTextDataSnapshot snapshot) {
                ++TerminalTextDataPerformanceTest.this.N;
            }
        });
        this.method0((ITerminalTextData)term, "0b");
        snapshot.updateSnapshot(true);
    }

    private void method0(ITerminalTextData term, String label) {
        Style style = Style.getStyle((StyleColor)StyleColor.getStyleColor((String)"fg"), (StyleColor)StyleColor.getStyleColor((String)"bg"), (boolean)false, (boolean)false, (boolean)false, (boolean)false);
        this.initPerformance(term);
        String s = "This is a test string";
        long n = 0L;
        long t0 = System.currentTimeMillis();
        int i = 0;
        while (i < 10000000) {
            char c = s.charAt(i % s.length());
            int line = 0;
            while (line < term.getHeight()) {
                int column = 0;
                while (column < term.getWidth()) {
                    term.setChar(line, column, c, style);
                    ++n;
                    ++column;
                }
                ++line;
            }
            if (System.currentTimeMillis() - t0 > this.TIME) {
                System.out.println(String.valueOf(label) + " " + n * 1000L / (System.currentTimeMillis() - t0) + " setChar()/sec " + this.N);
                break;
            }
            ++i;
        }
    }

    public void testPerformance1() {
        TerminalTextData term = new TerminalTextData();
        this.method1((ITerminalTextData)term, "1 ");
    }

    public void testPerformance1a() {
        TerminalTextData term = new TerminalTextData();
        ITerminalTextDataSnapshot snapshot = term.makeSnapshot();
        this.method1((ITerminalTextData)term, "1a");
        snapshot.updateSnapshot(true);
    }

    public void testPerformance1b() {
        TerminalTextData term = new TerminalTextData();
        ITerminalTextDataSnapshot snapshot = term.makeSnapshot();
        this.N = 0;
        snapshot.addListener(new ITerminalTextDataSnapshot.SnapshotOutOfDateListener(){

            public void snapshotOutOfDate(ITerminalTextDataSnapshot snapshot) {
                ++TerminalTextDataPerformanceTest.this.N;
            }
        });
        this.method1((ITerminalTextData)term, "1b");
        snapshot.updateSnapshot(true);
    }

    private void method1(ITerminalTextData term, String label) {
        Style style = Style.getStyle((StyleColor)StyleColor.getStyleColor((String)"fg"), (StyleColor)StyleColor.getStyleColor((String)"bg"), (boolean)false, (boolean)false, (boolean)false, (boolean)false);
        this.initPerformance(term);
        String s = "This is a test string";
        long n = 0L;
        long t0 = System.currentTimeMillis();
        char[] chars = new char[term.getWidth()];
        int i = 0;
        while (i < 10000000) {
            int j = 0;
            while (j < chars.length) {
                chars[j] = s.charAt((i + j) % s.length());
                ++j;
            }
            int line = 0;
            while (line < term.getHeight()) {
                term.setChars(line, 0, chars, style);
                n += (long)chars.length;
                ++line;
            }
            if (System.currentTimeMillis() - t0 > this.TIME) {
                System.out.println(String.valueOf(label) + " " + n * 1000L / (System.currentTimeMillis() - t0) + " setChars()/sec " + this.N);
                break;
            }
            ++i;
        }
    }

    public void testPerformance2() {
        TerminalTextData term = new TerminalTextData();
        Style style = Style.getStyle((StyleColor)StyleColor.getStyleColor((String)"fg"), (StyleColor)StyleColor.getStyleColor((String)"bg"), (boolean)false, (boolean)false, (boolean)false, (boolean)false);
        this.initPerformance((ITerminalTextData)term);
        TerminalTextData copy = new TerminalTextData();
        copy.copy((ITerminalTextData)term);
        String s = "This is a test string";
        long n = 0L;
        long t0 = System.currentTimeMillis();
        char[] chars = new char[term.getWidth()];
        int i = 0;
        while (i < 10000000) {
            int j = 0;
            while (j < chars.length) {
                chars[j] = s.charAt((i + j) % s.length());
                ++j;
            }
            int line = 0;
            while (line < term.getHeight()) {
                term.setChars(line, 0, chars, 0, 1, style);
                copy.copy((ITerminalTextData)term);
                ++n;
                if (System.currentTimeMillis() - t0 > this.TIME) {
                    System.out.println(String.valueOf(n * 1000L / (System.currentTimeMillis() - t0)) + " copy()/sec");
                    return;
                }
                ++line;
            }
            ++i;
        }
    }

    public void testPerformance2a() {
        TerminalTextData term = new TerminalTextData();
        ITerminalTextDataSnapshot snapshot = term.makeSnapshot();
        Style style = Style.getStyle((StyleColor)StyleColor.getStyleColor((String)"fg"), (StyleColor)StyleColor.getStyleColor((String)"bg"), (boolean)false, (boolean)false, (boolean)false, (boolean)false);
        this.initPerformance((ITerminalTextData)term);
        TerminalTextData copy = new TerminalTextData();
        copy.copy((ITerminalTextData)term);
        String s = "This is a test string";
        long n = 0L;
        long t0 = System.currentTimeMillis();
        char[] chars = new char[term.getWidth()];
        int i = 0;
        while (i < 10000000) {
            int j = 0;
            while (j < chars.length) {
                chars[j] = s.charAt((i + j) % s.length());
                ++j;
            }
            int line = 0;
            while (line < term.getHeight()) {
                term.setChars(line, 0, chars, 0, 1, style);
                copy.copy((ITerminalTextData)term);
                ++n;
                if (System.currentTimeMillis() - t0 > this.TIME) {
                    System.out.println(String.valueOf(n * 1000L / (System.currentTimeMillis() - t0)) + " copy()/sec");
                    return;
                }
                ++line;
            }
            ++i;
        }
        snapshot.updateSnapshot(true);
    }

    public void testPerformance2b() {
        TerminalTextData term = new TerminalTextData();
        ITerminalTextDataSnapshot snapshot = term.makeSnapshot();
        this.N = 0;
        snapshot.addListener(new ITerminalTextDataSnapshot.SnapshotOutOfDateListener(){

            public void snapshotOutOfDate(ITerminalTextDataSnapshot snapshot) {
                ++TerminalTextDataPerformanceTest.this.N;
            }
        });
        Style style = Style.getStyle((StyleColor)StyleColor.getStyleColor((String)"fg"), (StyleColor)StyleColor.getStyleColor((String)"bg"), (boolean)false, (boolean)false, (boolean)false, (boolean)false);
        this.initPerformance((ITerminalTextData)term);
        TerminalTextData copy = new TerminalTextData();
        copy.copy((ITerminalTextData)term);
        String s = "This is a test string";
        long n = 0L;
        long t0 = System.currentTimeMillis();
        char[] chars = new char[term.getWidth()];
        int i = 0;
        while (i < 10000000) {
            int j = 0;
            while (j < chars.length) {
                chars[j] = s.charAt((i + j) % s.length());
                ++j;
            }
            int line = 0;
            while (line < term.getHeight()) {
                term.setChars(line, 0, chars, 0, 1, style);
                copy.copy((ITerminalTextData)term);
                ++n;
                if (System.currentTimeMillis() - t0 > this.TIME) {
                    System.out.println(String.valueOf(n * 1000L / (System.currentTimeMillis() - t0)) + " copy()/sec " + n);
                    return;
                }
                ++line;
            }
            ++i;
        }
        snapshot.updateSnapshot(true);
    }

    public void testPerformance3() {
        TerminalTextData term = new TerminalTextData();
        Style style = Style.getStyle((StyleColor)StyleColor.getStyleColor((String)"fg"), (StyleColor)StyleColor.getStyleColor((String)"bg"), (boolean)false, (boolean)false, (boolean)false, (boolean)false);
        this.initPerformance((ITerminalTextData)term);
        TerminalTextData copy = new TerminalTextData();
        copy.copy((ITerminalTextData)term);
        String s = "This is a test string";
        long n = 0L;
        long t0 = System.currentTimeMillis();
        char[] chars = new char[term.getWidth()];
        int i = 0;
        while (i < 10000000) {
            boolean[] linesToCopy = new boolean[term.getHeight()];
            int j = 0;
            while (j < chars.length) {
                chars[j] = s.charAt((i + j) % s.length());
                ++j;
            }
            int line = 0;
            while (line < term.getHeight()) {
                term.setChars(line, 0, chars, 0, 1, style);
                linesToCopy[line] = true;
                copy.copyLine((ITerminalTextData)term, 0, 0);
                linesToCopy[line] = false;
                ++n;
                if (System.currentTimeMillis() - t0 > this.TIME) {
                    System.out.println(String.valueOf(n * 1000L / (System.currentTimeMillis() - t0)) + " copy()/sec");
                    return;
                }
                ++line;
            }
            ++i;
        }
    }
}

