/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.importexport.files;

import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.rse.internal.importexport.RemoteImportExportResources;
import org.eclipse.rse.ui.SystemBasePlugin;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.IOverwriteQuery;

public class RemoteFileOverwriteQuery
implements IOverwriteQuery {
    public String queryOverwrite(String pathString) {
        RemoteFileOverwriteQueryRunnable runnable = new RemoteFileOverwriteQueryRunnable(pathString);
        Display.getDefault().syncExec((Runnable)runnable);
        return runnable.getQueryRresponse();
    }

    private class RemoteFileOverwriteQueryRunnable
    implements Runnable {
        private String pathString;
        private String queryResponse;

        private RemoteFileOverwriteQueryRunnable(String pathString) {
            this.pathString = pathString;
        }

        public void run() {
            Path path = new Path(this.pathString);
            String messageString = path.getFileExtension() == null || path.segmentCount() < 2 ? NLS.bind((String)RemoteImportExportResources.WizardDataTransfer_existsQuestion, (Object)this.pathString) : NLS.bind((String)RemoteImportExportResources.WizardDataTransfer_overwriteNameAndPathQuestion, (Object)path.lastSegment(), (Object)path.removeLastSegments(1).toOSString());
            Shell shell = SystemBasePlugin.getActiveWorkbenchShell();
            MessageDialog dialog = new MessageDialog(shell, RemoteImportExportResources.Question, null, messageString, 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.YES_TO_ALL_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.NO_TO_ALL_LABEL, IDialogConstants.CANCEL_LABEL}, 0);
            String[] response = new String[]{"YES", "ALL", "NO", "NOALL", "CANCEL"};
            dialog.open();
            this.queryResponse = dialog.getReturnCode() < 0 ? "CANCEL" : response[dialog.getReturnCode()];
        }

        private String getQueryRresponse() {
            return this.queryResponse;
        }
    }
}

