/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.internal.terminal.model;

import junit.framework.TestCase;
import org.eclipse.tm.internal.terminal.model.TerminalTextData;
import org.eclipse.tm.internal.terminal.model.TerminalTextTestHelper;
import org.eclipse.tm.terminal.model.ITerminalTextData;
import org.eclipse.tm.terminal.model.ITerminalTextDataReadOnly;
import org.eclipse.tm.terminal.model.ITerminalTextDataSnapshot;
import org.eclipse.tm.terminal.model.Style;
import org.eclipse.tm.terminal.model.StyleColor;

public class TerminalTextDataSnapshotTest
extends TestCase {
    String toMultiLineText(ITerminalTextDataReadOnly term) {
        return TerminalTextTestHelper.toMultiLineText(term);
    }

    protected ITerminalTextData makeITerminalTextData() {
        return new TerminalTextData();
    }

    public void testTerminalTextDataSnapshot() {
        ITerminalTextData term = this.makeITerminalTextData();
        String s = "12345\nabcde\nABCDE\nvwxzy\nVWXYZ";
        TerminalTextTestHelper.fill(term, s);
        ITerminalTextDataSnapshot snapshot = term.makeSnapshot();
        snapshot.updateSnapshot(false);
        TerminalTextDataSnapshotTest.assertEquals((String)this.toMultiLineText((ITerminalTextDataReadOnly)term), (String)this.toMultiLineText((ITerminalTextDataReadOnly)snapshot));
        TerminalTextDataSnapshotTest.assertEquals((int)0, (int)snapshot.getFirstChangedLine());
        TerminalTextDataSnapshotTest.assertEquals((int)(term.getHeight() - 1), (int)snapshot.getLastChangedLine());
        int line = 0;
        while (line <= snapshot.getLastChangedLine()) {
            TerminalTextDataSnapshotTest.assertTrue((boolean)snapshot.hasLineChanged(line));
            ++line;
        }
        TerminalTextDataSnapshotTest.assertEquals((int)0, (int)snapshot.getScrollWindowSize());
    }

    public void testDetach() {
        ITerminalTextData term = this.makeITerminalTextData();
        String s = "12345\nabcde\nABCDE\nvwxzy\nVWXYZ";
        TerminalTextTestHelper.fill(term, s);
        ITerminalTextDataSnapshot snapshot = term.makeSnapshot();
        snapshot.updateSnapshot(false);
        TerminalTextDataSnapshotTest.assertEquals((String)this.toMultiLineText((ITerminalTextDataReadOnly)term), (String)this.toMultiLineText((ITerminalTextDataReadOnly)snapshot));
        snapshot.detach();
        term.setChar(0, 0, '?', null);
        TerminalTextDataSnapshotTest.assertEquals((String)s, (String)this.toMultiLineText((ITerminalTextDataReadOnly)snapshot));
        term.setDimensions(2, 2);
        TerminalTextDataSnapshotTest.assertEquals((String)s, (String)this.toMultiLineText((ITerminalTextDataReadOnly)snapshot));
    }

    public void testIsOutOfDate() {
        ITerminalTextData term = this.makeITerminalTextData();
        String s = "12345\nabcde\nABCDE\nvwxzy\nVWXYZ";
        TerminalTextTestHelper.fill(term, s);
        ITerminalTextDataSnapshot snapshot = term.makeSnapshot();
        TerminalTextDataSnapshotTest.assertTrue((boolean)snapshot.isOutOfDate());
        snapshot.updateSnapshot(false);
        TerminalTextDataSnapshotTest.assertFalse((boolean)snapshot.isOutOfDate());
        term.setChar(0, 0, '?', null);
        TerminalTextDataSnapshotTest.assertTrue((boolean)snapshot.isOutOfDate());
        snapshot.updateSnapshot(false);
        TerminalTextDataSnapshotTest.assertFalse((boolean)snapshot.isOutOfDate());
        term.setChars(1, 1, new char[]{'?', '!', '.'}, null);
        TerminalTextDataSnapshotTest.assertTrue((boolean)snapshot.isOutOfDate());
        snapshot.updateSnapshot(false);
        TerminalTextDataSnapshotTest.assertFalse((boolean)snapshot.isOutOfDate());
        term.scroll(1, 2, -1);
        TerminalTextDataSnapshotTest.assertTrue((boolean)snapshot.isOutOfDate());
        snapshot.updateSnapshot(false);
        TerminalTextDataSnapshotTest.assertFalse((boolean)snapshot.isOutOfDate());
        term.scroll(1, 2, 1);
        TerminalTextDataSnapshotTest.assertTrue((boolean)snapshot.isOutOfDate());
        snapshot.updateSnapshot(false);
        TerminalTextDataSnapshotTest.assertFalse((boolean)snapshot.isOutOfDate());
        term.scroll(1, 2, -1);
        TerminalTextDataSnapshotTest.assertTrue((boolean)snapshot.isOutOfDate());
        snapshot.updateSnapshot(true);
        TerminalTextDataSnapshotTest.assertFalse((boolean)snapshot.isOutOfDate());
        term.scroll(1, 2, 1);
        TerminalTextDataSnapshotTest.assertTrue((boolean)snapshot.isOutOfDate());
        snapshot.updateSnapshot(true);
        TerminalTextDataSnapshotTest.assertFalse((boolean)snapshot.isOutOfDate());
        term.setDimensions(2, 2);
        TerminalTextDataSnapshotTest.assertTrue((boolean)snapshot.isOutOfDate());
        snapshot.updateSnapshot(false);
        TerminalTextDataSnapshotTest.assertFalse((boolean)snapshot.isOutOfDate());
        term.setDimensions(20, 20);
        TerminalTextDataSnapshotTest.assertTrue((boolean)snapshot.isOutOfDate());
        snapshot.updateSnapshot(false);
        TerminalTextDataSnapshotTest.assertFalse((boolean)snapshot.isOutOfDate());
    }

    ITerminalTextDataSnapshot snapshot(String text, ITerminalTextData term) {
        TerminalTextTestHelper.fill(term, text);
        ITerminalTextDataSnapshot snapshot = term.makeSnapshot();
        snapshot.updateSnapshot(false);
        return snapshot;
    }

    public void testUpdateSnapshot() {
        ITerminalTextData term = this.makeITerminalTextData();
        String s = "12345\nabcde\nABCDE\nvwxzy\nVWXYZ";
        TerminalTextTestHelper.fill(term, s);
        String termString = this.toMultiLineText((ITerminalTextDataReadOnly)term);
        ITerminalTextDataSnapshot snapshot = term.makeSnapshot();
        snapshot.updateSnapshot(false);
        TerminalTextDataSnapshotTest.assertEquals((String)termString, (String)this.toMultiLineText((ITerminalTextDataReadOnly)snapshot));
        term.setChar(0, 0, '?', null);
        TerminalTextDataSnapshotTest.assertEquals((String)termString, (String)this.toMultiLineText((ITerminalTextDataReadOnly)snapshot));
        snapshot.updateSnapshot(false);
        termString = this.toMultiLineText((ITerminalTextDataReadOnly)term);
        TerminalTextDataSnapshotTest.assertEquals((String)termString, (String)this.toMultiLineText((ITerminalTextDataReadOnly)snapshot));
        term.setChars(1, 1, new char[]{'?', '!', '.'}, null);
        TerminalTextDataSnapshotTest.assertEquals((String)termString, (String)this.toMultiLineText((ITerminalTextDataReadOnly)snapshot));
        snapshot.updateSnapshot(false);
        termString = this.toMultiLineText((ITerminalTextDataReadOnly)term);
        TerminalTextDataSnapshotTest.assertEquals((String)termString, (String)this.toMultiLineText((ITerminalTextDataReadOnly)snapshot));
        term.scroll(1, 2, -1);
        TerminalTextDataSnapshotTest.assertEquals((String)termString, (String)this.toMultiLineText((ITerminalTextDataReadOnly)snapshot));
        snapshot.updateSnapshot(false);
        termString = this.toMultiLineText((ITerminalTextDataReadOnly)term);
        TerminalTextDataSnapshotTest.assertEquals((String)termString, (String)this.toMultiLineText((ITerminalTextDataReadOnly)snapshot));
        term.scroll(1, 2, 1);
        TerminalTextDataSnapshotTest.assertEquals((String)termString, (String)this.toMultiLineText((ITerminalTextDataReadOnly)snapshot));
        snapshot.updateSnapshot(false);
        termString = this.toMultiLineText((ITerminalTextDataReadOnly)term);
        TerminalTextDataSnapshotTest.assertEquals((String)termString, (String)this.toMultiLineText((ITerminalTextDataReadOnly)snapshot));
        term.scroll(1, 2, -1);
        TerminalTextDataSnapshotTest.assertEquals((String)termString, (String)this.toMultiLineText((ITerminalTextDataReadOnly)snapshot));
        snapshot.updateSnapshot(true);
        termString = this.toMultiLineText((ITerminalTextDataReadOnly)term);
        TerminalTextDataSnapshotTest.assertEquals((String)termString, (String)this.toMultiLineText((ITerminalTextDataReadOnly)snapshot));
        term.scroll(1, 2, 1);
        TerminalTextDataSnapshotTest.assertEquals((String)termString, (String)this.toMultiLineText((ITerminalTextDataReadOnly)snapshot));
        snapshot.updateSnapshot(true);
        termString = this.toMultiLineText((ITerminalTextDataReadOnly)term);
        TerminalTextDataSnapshotTest.assertEquals((String)termString, (String)this.toMultiLineText((ITerminalTextDataReadOnly)snapshot));
        term.setDimensions(2, 2);
        TerminalTextDataSnapshotTest.assertEquals((String)termString, (String)this.toMultiLineText((ITerminalTextDataReadOnly)snapshot));
        snapshot.updateSnapshot(false);
        termString = this.toMultiLineText((ITerminalTextDataReadOnly)term);
        TerminalTextDataSnapshotTest.assertEquals((String)termString, (String)this.toMultiLineText((ITerminalTextDataReadOnly)snapshot));
        term.setDimensions(20, 20);
        TerminalTextDataSnapshotTest.assertEquals((String)termString, (String)this.toMultiLineText((ITerminalTextDataReadOnly)snapshot));
        snapshot.updateSnapshot(false);
        termString = this.toMultiLineText((ITerminalTextDataReadOnly)term);
        TerminalTextDataSnapshotTest.assertEquals((String)termString, (String)this.toMultiLineText((ITerminalTextDataReadOnly)snapshot));
    }

    public void testMaxSize() {
        String s = "111\n222\n333\n444\n555";
        ITerminalTextData term = this.makeITerminalTextData();
        term.setMaxHeight(8);
        TerminalTextTestHelper.fill(term, s);
        ITerminalTextDataSnapshot snapshot = term.makeSnapshot();
        snapshot.updateSnapshot(false);
        term.addLine();
        TerminalTextDataSnapshotTest.assertTrue((boolean)snapshot.isOutOfDate());
        snapshot.updateSnapshot(false);
        TerminalTextDataSnapshotTest.assertEquals((String)this.toMultiLineText((ITerminalTextDataReadOnly)term), (String)this.toMultiLineText((ITerminalTextDataReadOnly)snapshot));
        term.addLine();
        TerminalTextDataSnapshotTest.assertTrue((boolean)snapshot.isOutOfDate());
        snapshot.updateSnapshot(false);
        TerminalTextDataSnapshotTest.assertEquals((String)this.toMultiLineText((ITerminalTextDataReadOnly)term), (String)this.toMultiLineText((ITerminalTextDataReadOnly)snapshot));
        term.addLine();
        TerminalTextDataSnapshotTest.assertTrue((boolean)snapshot.isOutOfDate());
        snapshot.updateSnapshot(false);
        TerminalTextDataSnapshotTest.assertEquals((String)this.toMultiLineText((ITerminalTextDataReadOnly)term), (String)this.toMultiLineText((ITerminalTextDataReadOnly)snapshot));
        term.addLine();
        TerminalTextDataSnapshotTest.assertTrue((boolean)snapshot.isOutOfDate());
        snapshot.updateSnapshot(false);
        TerminalTextDataSnapshotTest.assertEquals((String)this.toMultiLineText((ITerminalTextDataReadOnly)term), (String)this.toMultiLineText((ITerminalTextDataReadOnly)snapshot));
        term.addLine();
        TerminalTextDataSnapshotTest.assertTrue((boolean)snapshot.isOutOfDate());
        snapshot.updateSnapshot(false);
        TerminalTextDataSnapshotTest.assertEquals((String)this.toMultiLineText((ITerminalTextDataReadOnly)term), (String)this.toMultiLineText((ITerminalTextDataReadOnly)snapshot));
    }

    public void testGetChar() {
        int column;
        ITerminalTextData term = this.makeITerminalTextData();
        String s = "12345\nabcde\nABCDE\nvwxzy\nVWXYZ";
        TerminalTextTestHelper.fill(term, s);
        ITerminalTextData termUnchanged = this.makeITerminalTextData();
        TerminalTextTestHelper.fill(termUnchanged, s);
        ITerminalTextDataSnapshot snapshot = term.makeSnapshot();
        snapshot.updateSnapshot(false);
        int line = 0;
        while (line < snapshot.getHeight()) {
            column = 0;
            while (column < snapshot.getWidth()) {
                TerminalTextDataSnapshotTest.assertEquals((char)term.getChar(line, column), (char)snapshot.getChar(line, column));
                ++column;
            }
            ++line;
        }
        term.setChar(0, 0, '?', null);
        line = 0;
        while (line < snapshot.getHeight()) {
            column = 0;
            while (column < snapshot.getWidth()) {
                TerminalTextDataSnapshotTest.assertEquals((char)termUnchanged.getChar(line, column), (char)snapshot.getChar(line, column));
                ++column;
            }
            ++line;
        }
        snapshot.updateSnapshot(true);
        line = 0;
        while (line < snapshot.getHeight()) {
            column = 0;
            while (column < snapshot.getWidth()) {
                TerminalTextDataSnapshotTest.assertEquals((char)term.getChar(line, column), (char)snapshot.getChar(line, column));
                ++column;
            }
            ++line;
        }
    }

    public void testGetHeight() {
        ITerminalTextData term = this.makeITerminalTextData();
        String s = "12345\nabcde\nABCDE\nvwxzy\nVWXYZ";
        TerminalTextTestHelper.fill(term, s);
        ITerminalTextDataSnapshot snapshot = term.makeSnapshot();
        snapshot.updateSnapshot(false);
        int expectedHeight = term.getHeight();
        TerminalTextDataSnapshotTest.assertEquals((int)expectedHeight, (int)snapshot.getHeight());
        term.setDimensions(term.getHeight() - 1, term.getWidth());
        TerminalTextDataSnapshotTest.assertEquals((int)expectedHeight, (int)snapshot.getHeight());
        snapshot.updateSnapshot(false);
        expectedHeight = term.getHeight();
        TerminalTextDataSnapshotTest.assertEquals((int)expectedHeight, (int)snapshot.getHeight());
        term.setDimensions(term.getHeight() - 1, term.getWidth());
        TerminalTextDataSnapshotTest.assertEquals((int)expectedHeight, (int)snapshot.getHeight());
    }

    public void testGetStyle() {
        ITerminalTextData term = this.makeITerminalTextData();
        Style style = Style.getStyle((StyleColor)StyleColor.getStyleColor((String)"fg"), (StyleColor)StyleColor.getStyleColor((String)"bg"), (boolean)false, (boolean)false, (boolean)false, (boolean)false);
        term.setDimensions(6, 3);
        int line = 0;
        while (line < term.getHeight()) {
            int column = 0;
            while (column < term.getWidth()) {
                char c = (char)(97 + column + line);
                term.setChar(line, column, c, style.setForground(StyleColor.getStyleColor((String)("" + c))));
                ++column;
            }
            ++line;
        }
        ITerminalTextDataSnapshot snapshot = term.makeSnapshot();
        snapshot.updateSnapshot(false);
        int line2 = 0;
        while (line2 < term.getHeight()) {
            int column = 0;
            while (column < term.getWidth()) {
                char c = (char)(97 + column + line2);
                TerminalTextDataSnapshotTest.assertSame((Object)style.setForground(StyleColor.getStyleColor((String)("" + c))), (Object)snapshot.getStyle(line2, column));
                ++column;
            }
            ++line2;
        }
    }

    public void testGetWidth() {
        ITerminalTextData term = this.makeITerminalTextData();
        String s = "12345\nabcde\nABCDE\nvwxzy\nVWXYZ";
        TerminalTextTestHelper.fill(term, s);
        ITerminalTextDataSnapshot snapshot = term.makeSnapshot();
        snapshot.updateSnapshot(false);
        int expectedWidth = term.getWidth();
        TerminalTextDataSnapshotTest.assertEquals((int)expectedWidth, (int)snapshot.getWidth());
        term.setDimensions(term.getHeight(), term.getWidth() - 1);
        TerminalTextDataSnapshotTest.assertEquals((int)expectedWidth, (int)snapshot.getWidth());
        snapshot.updateSnapshot(false);
        expectedWidth = term.getWidth();
        TerminalTextDataSnapshotTest.assertEquals((int)expectedWidth, (int)snapshot.getWidth());
        term.setDimensions(term.getHeight(), term.getWidth() - 1);
        TerminalTextDataSnapshotTest.assertEquals((int)expectedWidth, (int)snapshot.getWidth());
    }

    public void testGetFirstChangedLine() {
        ITerminalTextData term = this.makeITerminalTextData();
        String s = "12345\nabcde\nABCDE\nvwxzy\nVWXYZ";
        ITerminalTextDataSnapshot snapshot = this.snapshot(s, term);
        TerminalTextDataSnapshotTest.assertEquals((int)0, (int)snapshot.getFirstChangedLine());
        snapshot.updateSnapshot(false);
        TerminalTextDataSnapshotTest.assertEquals((int)Integer.MAX_VALUE, (int)snapshot.getFirstChangedLine());
        snapshot = this.snapshot(s, term);
        term.setChar(0, 0, 'x', null);
        snapshot.updateSnapshot(false);
        TerminalTextDataSnapshotTest.assertEquals((int)0, (int)snapshot.getFirstChangedLine());
        snapshot = this.snapshot(s, term);
        term.setChar(3, 0, 'x', null);
        term.setChar(4, 0, 'x', null);
        snapshot.updateSnapshot(false);
        TerminalTextDataSnapshotTest.assertEquals((int)3, (int)snapshot.getFirstChangedLine());
        snapshot = this.snapshot(s, term);
        term.scroll(0, 1, -1);
        snapshot.updateSnapshot(false);
        TerminalTextDataSnapshotTest.assertEquals((int)0, (int)snapshot.getFirstChangedLine());
        snapshot = this.snapshot(s, term);
        term.scroll(2, 2, -1);
        snapshot.updateSnapshot(false);
        TerminalTextDataSnapshotTest.assertEquals((int)2, (int)snapshot.getFirstChangedLine());
        snapshot = this.snapshot(s, term);
        term.scroll(2, 2, -1);
        snapshot.updateSnapshot(true);
        TerminalTextDataSnapshotTest.assertEquals((int)3, (int)snapshot.getFirstChangedLine());
        snapshot = this.snapshot(s, term);
        term.scroll(2, 2, -1);
        term.setChar(1, 0, 'x', null);
        snapshot.updateSnapshot(true);
        TerminalTextDataSnapshotTest.assertEquals((int)1, (int)snapshot.getFirstChangedLine());
    }

    public void testGetLastChangedLine() {
        ITerminalTextData term = this.makeITerminalTextData();
        String s = "12345\nabcde\nABCDE\nvwxzy\nVWXYZ";
        ITerminalTextDataSnapshot snapshot = this.snapshot(s, term);
        TerminalTextDataSnapshotTest.assertEquals((int)4, (int)snapshot.getLastChangedLine());
        snapshot.updateSnapshot(false);
        TerminalTextDataSnapshotTest.assertEquals((int)-1, (int)snapshot.getLastChangedLine());
        snapshot = this.snapshot(s, term);
        term.setChar(0, 0, 'x', null);
        snapshot.updateSnapshot(false);
        TerminalTextDataSnapshotTest.assertEquals((int)0, (int)snapshot.getLastChangedLine());
        snapshot = this.snapshot(s, term);
        term.cleanLine(1);
        snapshot.updateSnapshot(false);
        TerminalTextDataSnapshotTest.assertEquals((int)1, (int)snapshot.getLastChangedLine());
        snapshot = this.snapshot(s, term);
        term.setChar(3, 0, 'x', null);
        term.setChar(4, 0, 'x', null);
        snapshot.updateSnapshot(false);
        TerminalTextDataSnapshotTest.assertEquals((int)4, (int)snapshot.getLastChangedLine());
        snapshot = this.snapshot(s, term);
        term.scroll(0, 1, -1);
        snapshot.updateSnapshot(false);
        TerminalTextDataSnapshotTest.assertEquals((int)0, (int)snapshot.getLastChangedLine());
        snapshot = this.snapshot(s, term);
        term.scroll(2, 2, -1);
        snapshot.updateSnapshot(false);
        TerminalTextDataSnapshotTest.assertEquals((int)3, (int)snapshot.getLastChangedLine());
        snapshot = this.snapshot(s, term);
        term.scroll(2, 2, -1);
        snapshot.updateSnapshot(true);
        TerminalTextDataSnapshotTest.assertEquals((int)3, (int)snapshot.getLastChangedLine());
        snapshot = this.snapshot(s, term);
        term.scroll(2, 2, -1);
        term.setChar(1, 0, 'x', null);
        snapshot.updateSnapshot(true);
        TerminalTextDataSnapshotTest.assertEquals((int)3, (int)snapshot.getLastChangedLine());
    }

    void assertChangedLines(ITerminalTextDataSnapshot snapshot, String expected) {
        TerminalTextDataSnapshotTest.assertEquals((int)expected.length(), (int)snapshot.getHeight());
        StringBuffer buffer = new StringBuffer();
        int line = 0;
        while (line < expected.length()) {
            if (snapshot.hasLineChanged(line)) {
                buffer.append('1');
            } else {
                buffer.append('0');
            }
            ++line;
        }
        TerminalTextDataSnapshotTest.assertEquals((String)expected, (String)buffer.toString());
    }

    public void testHasLineChangedScroll() {
        ITerminalTextData term = this.makeITerminalTextData();
        String s = "00\n11\n22\n33\n44\n55\n66\n77\n88\n99";
        ITerminalTextDataSnapshot snapshot = this.snapshot(s, term);
        term.scroll(2, 3, -1);
        snapshot.updateSnapshot(true);
        this.assertChangedLines(snapshot, "0000100000");
        snapshot = this.snapshot(s, term);
        term.scroll(2, 3, -2);
        snapshot.updateSnapshot(true);
        this.assertChangedLines(snapshot, "0001100000");
        snapshot = this.snapshot(s, term);
        term.scroll(2, 4, -1);
        term.scroll(2, 4, -1);
        snapshot.updateSnapshot(true);
        this.assertChangedLines(snapshot, "0000110000");
        term.scroll(2, 3, 1);
        snapshot.updateSnapshot(true);
        this.assertChangedLines(snapshot, "0011100000");
        snapshot = this.snapshot(s, term);
        term.scroll(2, 3, 2);
        snapshot.updateSnapshot(true);
        this.assertChangedLines(snapshot, "0011100000");
        snapshot = this.snapshot(s, term);
        term.scroll(2, 4, 1);
        term.scroll(2, 4, 1);
        snapshot.updateSnapshot(true);
        this.assertChangedLines(snapshot, "0011110000");
        snapshot = this.snapshot(s, term);
        term.scroll(2, 3, -1);
        snapshot.updateSnapshot(false);
        this.assertChangedLines(snapshot, "0011100000");
        snapshot = this.snapshot(s, term);
        term.scroll(2, 3, -2);
        snapshot.updateSnapshot(false);
        this.assertChangedLines(snapshot, "0011100000");
        snapshot = this.snapshot(s, term);
        term.scroll(2, 4, -1);
        term.scroll(2, 4, -1);
        snapshot.updateSnapshot(false);
        this.assertChangedLines(snapshot, "0011110000");
    }

    public void testMultiScrollWithDifferentSizes() {
        ITerminalTextData term = this.makeITerminalTextData();
        String s = "00\n11\n22\n33\n44\n55\n66\n77\n88\n99";
        ITerminalTextDataSnapshot snapshot = this.snapshot(s, term);
        term.scroll(2, 6, -1);
        term.scroll(2, 5, -1);
        snapshot.updateSnapshot(false);
        this.assertChangedLines(snapshot, "0011111100");
        TerminalTextDataSnapshotTest.assertEquals((int)2, (int)snapshot.getFirstChangedLine());
        TerminalTextDataSnapshotTest.assertEquals((int)7, (int)snapshot.getLastChangedLine());
        TerminalTextDataSnapshotTest.assertEquals((int)0, (int)snapshot.getScrollWindowSize());
        TerminalTextDataSnapshotTest.assertEquals((int)0, (int)snapshot.getScrollWindowStartLine());
        TerminalTextDataSnapshotTest.assertEquals((int)0, (int)snapshot.getScrollWindowShift());
        snapshot = this.snapshot(s, term);
        term.scroll(2, 6, -1);
        term.scroll(2, 5, -1);
        snapshot.updateSnapshot(true);
        this.assertChangedLines(snapshot, "0011111100");
        TerminalTextDataSnapshotTest.assertEquals((int)2, (int)snapshot.getFirstChangedLine());
        TerminalTextDataSnapshotTest.assertEquals((int)7, (int)snapshot.getLastChangedLine());
        TerminalTextDataSnapshotTest.assertEquals((int)0, (int)snapshot.getScrollWindowShift());
        TerminalTextDataSnapshotTest.assertEquals((int)0, (int)snapshot.getScrollWindowSize());
        TerminalTextDataSnapshotTest.assertEquals((int)0, (int)snapshot.getScrollWindowStartLine());
    }

    public void testHasLineChanged() {
        ITerminalTextData term = this.makeITerminalTextData();
        String s = "000000\n111111\n222222\n333333\n444444\n555555\n666666\n777777\n888888\n999999";
        ITerminalTextDataSnapshot snapshot = this.snapshot(s, term);
        term.scroll(2, 3, -1);
        term.setChar(7, 0, '.', null);
        snapshot.updateSnapshot(true);
        this.assertChangedLines(snapshot, "0000100100");
        snapshot = this.snapshot(s, term);
        term.scroll(2, 3, -2);
        term.setChar(9, 0, '.', null);
        term.setChars(0, 0, new char[]{'.', '!'}, null);
        snapshot.updateSnapshot(true);
        this.assertChangedLines(snapshot, "1001100001");
        snapshot = this.snapshot(s, term);
        term.scroll(2, 4, -1);
        term.scroll(2, 4, -1);
        term.setChars(2, 2, new char[]{'.', '!', '*'}, 1, 1, null);
        snapshot.updateSnapshot(true);
        this.assertChangedLines(snapshot, "0010110000");
        snapshot = this.snapshot(s, term);
        term.scroll(2, 7, -1);
        term.setChar(5, 2, '.', null);
        term.scroll(2, 7, -2);
        snapshot.updateSnapshot(true);
        this.assertChangedLines(snapshot, "0001001110");
        snapshot = this.snapshot(s, term);
        term.scroll(2, 7, -1);
        term.setChar(5, 2, '.', null);
        term.scroll(2, 7, -2);
        snapshot.updateSnapshot(false);
        this.assertChangedLines(snapshot, "0011111110");
    }

    public void testScroll() {
        ITerminalTextData term = this.makeITerminalTextData();
        String s = "00\n11\n22\n33\n44\n55\n66\n77\n88\n99";
        ITerminalTextDataSnapshot snapshot = this.snapshot(s, term);
        term.scroll(2, 3, -1);
        snapshot.updateSnapshot(true);
        TerminalTextDataSnapshotTest.assertEquals((int)2, (int)snapshot.getScrollWindowStartLine());
        TerminalTextDataSnapshotTest.assertEquals((int)3, (int)snapshot.getScrollWindowSize());
        TerminalTextDataSnapshotTest.assertEquals((int)-1, (int)snapshot.getScrollWindowShift());
        TerminalTextDataSnapshotTest.assertEquals((int)4, (int)snapshot.getFirstChangedLine());
        TerminalTextDataSnapshotTest.assertEquals((int)4, (int)snapshot.getLastChangedLine());
        term.scroll(2, 3, -2);
        snapshot.updateSnapshot(true);
        TerminalTextDataSnapshotTest.assertEquals((int)2, (int)snapshot.getScrollWindowStartLine());
        TerminalTextDataSnapshotTest.assertEquals((int)3, (int)snapshot.getScrollWindowSize());
        TerminalTextDataSnapshotTest.assertEquals((int)-2, (int)snapshot.getScrollWindowShift());
        TerminalTextDataSnapshotTest.assertEquals((int)3, (int)snapshot.getFirstChangedLine());
        TerminalTextDataSnapshotTest.assertEquals((int)4, (int)snapshot.getLastChangedLine());
        term.scroll(2, 4, -1);
        term.scroll(2, 4, -1);
        snapshot.updateSnapshot(true);
        TerminalTextDataSnapshotTest.assertEquals((int)2, (int)snapshot.getScrollWindowStartLine());
        TerminalTextDataSnapshotTest.assertEquals((int)4, (int)snapshot.getScrollWindowSize());
        TerminalTextDataSnapshotTest.assertEquals((int)-2, (int)snapshot.getScrollWindowShift());
        TerminalTextDataSnapshotTest.assertEquals((int)4, (int)snapshot.getFirstChangedLine());
        TerminalTextDataSnapshotTest.assertEquals((int)5, (int)snapshot.getLastChangedLine());
        snapshot = this.snapshot(s, term);
        term.scroll(2, 3, -1);
        snapshot.updateSnapshot(false);
        TerminalTextDataSnapshotTest.assertEquals((int)0, (int)snapshot.getScrollWindowStartLine());
        TerminalTextDataSnapshotTest.assertEquals((int)0, (int)snapshot.getScrollWindowSize());
        TerminalTextDataSnapshotTest.assertEquals((int)0, (int)snapshot.getScrollWindowShift());
        TerminalTextDataSnapshotTest.assertEquals((int)2, (int)snapshot.getFirstChangedLine());
        TerminalTextDataSnapshotTest.assertEquals((int)4, (int)snapshot.getLastChangedLine());
    }

    public void testDisjointScroll() {
        ITerminalTextData term = this.makeITerminalTextData();
        String s = "000000\n111111\n222222\n333333\n444444\n555555\n666666\n777777\n888888\n999999";
        ITerminalTextDataSnapshot snapshot = this.snapshot(s, term);
        term.scroll(0, 2, -1);
        term.scroll(4, 2, -1);
        snapshot.updateSnapshot(true);
        this.assertChangedLines(snapshot, "1100110000");
        TerminalTextDataSnapshotTest.assertEquals((int)0, (int)snapshot.getScrollWindowStartLine());
        TerminalTextDataSnapshotTest.assertEquals((int)0, (int)snapshot.getScrollWindowSize());
        TerminalTextDataSnapshotTest.assertEquals((int)0, (int)snapshot.getScrollWindowShift());
        snapshot = this.snapshot(s, term);
        term.scroll(0, 3, -1);
        term.scroll(2, 2, -2);
        snapshot.updateSnapshot(true);
        this.assertChangedLines(snapshot, "1111000000");
        TerminalTextDataSnapshotTest.assertEquals((int)0, (int)snapshot.getScrollWindowStartLine());
        TerminalTextDataSnapshotTest.assertEquals((int)0, (int)snapshot.getScrollWindowSize());
        TerminalTextDataSnapshotTest.assertEquals((int)0, (int)snapshot.getScrollWindowShift());
        snapshot = this.snapshot(s, term);
        term.scroll(0, 3, -1);
        term.scroll(2, 2, -2);
        term.scroll(0, 3, -1);
        snapshot.updateSnapshot(true);
        this.assertChangedLines(snapshot, "1111000000");
        TerminalTextDataSnapshotTest.assertEquals((int)0, (int)snapshot.getScrollWindowStartLine());
        TerminalTextDataSnapshotTest.assertEquals((int)0, (int)snapshot.getScrollWindowSize());
        TerminalTextDataSnapshotTest.assertEquals((int)0, (int)snapshot.getScrollWindowShift());
        snapshot = this.snapshot(s, term);
        term.scroll(0, 3, -1);
        term.scroll(2, 2, -2);
        term.scroll(0, 3, -10);
        snapshot.updateSnapshot(true);
        this.assertChangedLines(snapshot, "1111000000");
        TerminalTextDataSnapshotTest.assertEquals((int)0, (int)snapshot.getScrollWindowStartLine());
        TerminalTextDataSnapshotTest.assertEquals((int)0, (int)snapshot.getScrollWindowSize());
        TerminalTextDataSnapshotTest.assertEquals((int)0, (int)snapshot.getScrollWindowShift());
        snapshot = this.snapshot(s, term);
        term.scroll(1, 3, -1);
        term.scroll(1, 3, 1);
        snapshot.updateSnapshot(true);
        this.assertChangedLines(snapshot, "0111000000");
        TerminalTextDataSnapshotTest.assertEquals((int)0, (int)snapshot.getScrollWindowStartLine());
        TerminalTextDataSnapshotTest.assertEquals((int)0, (int)snapshot.getScrollWindowSize());
        TerminalTextDataSnapshotTest.assertEquals((int)0, (int)snapshot.getScrollWindowShift());
    }

    public void testResize() {
        ITerminalTextData term = this.makeITerminalTextData();
        String s = "000000\n111111\n222222\n333333";
        ITerminalTextDataSnapshot snapshot = this.snapshot(s, term);
        term.setDimensions(term.getHeight(), term.getWidth() + 1);
        snapshot.updateSnapshot(true);
        this.assertChangedLines(snapshot, "1111");
        TerminalTextDataSnapshotTest.assertEquals((int)0, (int)snapshot.getFirstChangedLine());
        TerminalTextDataSnapshotTest.assertEquals((int)3, (int)snapshot.getLastChangedLine());
        TerminalTextDataSnapshotTest.assertEquals((int)0, (int)snapshot.getScrollWindowStartLine());
        TerminalTextDataSnapshotTest.assertEquals((int)0, (int)snapshot.getScrollWindowSize());
        TerminalTextDataSnapshotTest.assertEquals((int)0, (int)snapshot.getScrollWindowShift());
        snapshot = this.snapshot(s, term);
        term.setDimensions(term.getHeight() + 1, term.getWidth());
        snapshot.updateSnapshot(true);
        this.assertChangedLines(snapshot, "11111");
        TerminalTextDataSnapshotTest.assertEquals((int)0, (int)snapshot.getFirstChangedLine());
        TerminalTextDataSnapshotTest.assertEquals((int)4, (int)snapshot.getLastChangedLine());
        TerminalTextDataSnapshotTest.assertEquals((int)0, (int)snapshot.getScrollWindowStartLine());
        TerminalTextDataSnapshotTest.assertEquals((int)0, (int)snapshot.getScrollWindowSize());
        TerminalTextDataSnapshotTest.assertEquals((int)0, (int)snapshot.getScrollWindowShift());
        snapshot = this.snapshot(s, term);
        term.setDimensions(term.getHeight() - 1, term.getWidth());
        snapshot.updateSnapshot(true);
        this.assertChangedLines(snapshot, "111");
        TerminalTextDataSnapshotTest.assertEquals((int)0, (int)snapshot.getFirstChangedLine());
        TerminalTextDataSnapshotTest.assertEquals((int)2, (int)snapshot.getLastChangedLine());
        TerminalTextDataSnapshotTest.assertEquals((int)0, (int)snapshot.getScrollWindowStartLine());
        TerminalTextDataSnapshotTest.assertEquals((int)0, (int)snapshot.getScrollWindowSize());
        TerminalTextDataSnapshotTest.assertEquals((int)0, (int)snapshot.getScrollWindowShift());
        snapshot = this.snapshot(s, term);
        term.setDimensions(0, 0);
        snapshot.updateSnapshot(true);
        this.assertChangedLines(snapshot, "");
        TerminalTextDataSnapshotTest.assertEquals((int)0, (int)snapshot.getFirstChangedLine());
        TerminalTextDataSnapshotTest.assertEquals((int)-1, (int)snapshot.getLastChangedLine());
        TerminalTextDataSnapshotTest.assertEquals((int)0, (int)snapshot.getScrollWindowStartLine());
        TerminalTextDataSnapshotTest.assertEquals((int)0, (int)snapshot.getScrollWindowSize());
        TerminalTextDataSnapshotTest.assertEquals((int)0, (int)snapshot.getScrollWindowShift());
    }

    public void testResizeAfterScroll() {
        ITerminalTextData term = this.makeITerminalTextData();
        String s = "000000\n111111\n222222\n333333\n444444\n555555\n666666\n777777\n888888\n999999";
        ITerminalTextDataSnapshot snapshot = this.snapshot(s, term);
        term.scroll(1, 2, -1);
        term.setDimensions(5, 4);
        snapshot.updateSnapshot(true);
        this.assertChangedLines(snapshot, "11111");
        TerminalTextDataSnapshotTest.assertEquals((int)0, (int)snapshot.getScrollWindowStartLine());
        TerminalTextDataSnapshotTest.assertEquals((int)0, (int)snapshot.getScrollWindowSize());
        TerminalTextDataSnapshotTest.assertEquals((int)0, (int)snapshot.getScrollWindowShift());
        snapshot = this.snapshot(s, term);
        term.scroll(1, 2, -1);
        term.setDimensions(7, 2);
        term.scroll(4, 2, -1);
        snapshot.updateSnapshot(true);
        this.assertChangedLines(snapshot, "1111111");
        TerminalTextDataSnapshotTest.assertEquals((int)0, (int)snapshot.getScrollWindowStartLine());
        TerminalTextDataSnapshotTest.assertEquals((int)0, (int)snapshot.getScrollWindowSize());
        TerminalTextDataSnapshotTest.assertEquals((int)0, (int)snapshot.getScrollWindowShift());
        snapshot = this.snapshot(s, term);
        term.scroll(1, 2, -1);
        term.setDimensions(term.getHeight(), term.getWidth() + 1);
        snapshot.updateSnapshot(true);
        this.assertChangedLines(snapshot, "1111111111");
        TerminalTextDataSnapshotTest.assertEquals((int)0, (int)snapshot.getScrollWindowStartLine());
        TerminalTextDataSnapshotTest.assertEquals((int)0, (int)snapshot.getScrollWindowSize());
        TerminalTextDataSnapshotTest.assertEquals((int)0, (int)snapshot.getScrollWindowShift());
    }

    public void testScrollAfterResize() {
        ITerminalTextData term = this.makeITerminalTextData();
        String s = "000000\n111111\n222222\n333333\n444444\n555555\n666666\n777777\n888888\n999999";
        ITerminalTextDataSnapshot snapshot = this.snapshot(s, term);
        term.setDimensions(14, 6);
        term.scroll(0, 14, -1);
        snapshot.updateSnapshot(true);
        this.assertChangedLines(snapshot, "11111111111111");
        TerminalTextDataSnapshotTest.assertEquals((int)0, (int)snapshot.getScrollWindowStartLine());
        TerminalTextDataSnapshotTest.assertEquals((int)0, (int)snapshot.getScrollWindowSize());
        TerminalTextDataSnapshotTest.assertEquals((int)0, (int)snapshot.getScrollWindowShift());
    }

    public void testAddListener() {
        ITerminalTextData term = this.makeITerminalTextData();
        String s = "12345\nabcde\nABCDE\nvwxzy\nVWXYZ";
        TerminalTextTestHelper.fill(term, s);
        ITerminalTextDataSnapshot snapshot = term.makeSnapshot();
        snapshot.updateSnapshot(false);
        SnapshotListener listener = new SnapshotListener();
        snapshot.addListener((ITerminalTextDataSnapshot.SnapshotOutOfDateListener)listener);
        TerminalTextDataSnapshotTest.assertEquals((int)0, (int)listener.N);
        term.setChar(0, 0, '?', null);
        TerminalTextDataSnapshotTest.assertEquals((int)1, (int)listener.N);
        term.setChar(1, 1, '?', null);
        TerminalTextDataSnapshotTest.assertEquals((int)1, (int)listener.N);
        snapshot.updateSnapshot(false);
        TerminalTextDataSnapshotTest.assertEquals((int)1, (int)listener.N);
        listener.reset();
        term.setChars(1, 1, new char[]{'?', '!', '.'}, null);
        TerminalTextDataSnapshotTest.assertEquals((int)1, (int)listener.N);
        term.setChars(2, 1, new char[]{'?', '!', '.'}, null);
        TerminalTextDataSnapshotTest.assertEquals((int)1, (int)listener.N);
        snapshot.updateSnapshot(false);
        TerminalTextDataSnapshotTest.assertEquals((int)1, (int)listener.N);
        listener.reset();
        term.scroll(1, 2, -1);
        TerminalTextDataSnapshotTest.assertEquals((int)1, (int)listener.N);
        term.scroll(1, 2, -1);
        TerminalTextDataSnapshotTest.assertEquals((int)1, (int)listener.N);
        snapshot.updateSnapshot(false);
        TerminalTextDataSnapshotTest.assertEquals((int)1, (int)listener.N);
        listener.reset();
        term.scroll(1, 2, 1);
        TerminalTextDataSnapshotTest.assertEquals((int)1, (int)listener.N);
        term.scroll(1, 2, 1);
        TerminalTextDataSnapshotTest.assertEquals((int)1, (int)listener.N);
        snapshot.updateSnapshot(false);
        TerminalTextDataSnapshotTest.assertEquals((int)1, (int)listener.N);
        listener.reset();
        term.scroll(1, 2, -1);
        TerminalTextDataSnapshotTest.assertEquals((int)1, (int)listener.N);
        term.scroll(1, 2, -1);
        TerminalTextDataSnapshotTest.assertEquals((int)1, (int)listener.N);
        snapshot.updateSnapshot(false);
        TerminalTextDataSnapshotTest.assertEquals((int)1, (int)listener.N);
        listener.reset();
        term.scroll(1, 2, 1);
        TerminalTextDataSnapshotTest.assertEquals((int)1, (int)listener.N);
        snapshot.updateSnapshot(false);
        TerminalTextDataSnapshotTest.assertEquals((int)1, (int)listener.N);
        listener.reset();
        term.setDimensions(2, 2);
        TerminalTextDataSnapshotTest.assertEquals((int)1, (int)listener.N);
        snapshot.updateSnapshot(false);
        TerminalTextDataSnapshotTest.assertEquals((int)1, (int)listener.N);
        listener.reset();
        term.setDimensions(20, 20);
        TerminalTextDataSnapshotTest.assertEquals((int)1, (int)listener.N);
        snapshot.updateSnapshot(false);
        TerminalTextDataSnapshotTest.assertFalse((boolean)snapshot.isOutOfDate());
    }

    public void testRemoveListener() {
        ITerminalTextData term = this.makeITerminalTextData();
        String s = "12345\nabcde\nABCDE\nvwxzy\nVWXYZ";
        TerminalTextTestHelper.fill(term, s);
        ITerminalTextDataSnapshot snapshot = term.makeSnapshot();
        snapshot.updateSnapshot(false);
        SnapshotListener listener1 = new SnapshotListener();
        SnapshotListener listener2 = new SnapshotListener();
        SnapshotListener listener3 = new SnapshotListener();
        snapshot.addListener((ITerminalTextDataSnapshot.SnapshotOutOfDateListener)listener1);
        snapshot.addListener((ITerminalTextDataSnapshot.SnapshotOutOfDateListener)listener2);
        snapshot.addListener((ITerminalTextDataSnapshot.SnapshotOutOfDateListener)listener3);
        TerminalTextDataSnapshotTest.assertEquals((int)0, (int)listener1.N);
        term.setChar(0, 0, '?', null);
        TerminalTextDataSnapshotTest.assertEquals((int)1, (int)listener1.N);
        TerminalTextDataSnapshotTest.assertEquals((int)1, (int)listener2.N);
        TerminalTextDataSnapshotTest.assertEquals((int)1, (int)listener3.N);
        term.setChar(1, 1, '?', null);
        TerminalTextDataSnapshotTest.assertEquals((int)1, (int)listener1.N);
        TerminalTextDataSnapshotTest.assertEquals((int)1, (int)listener2.N);
        TerminalTextDataSnapshotTest.assertEquals((int)1, (int)listener3.N);
        snapshot.updateSnapshot(false);
        TerminalTextDataSnapshotTest.assertEquals((int)1, (int)listener1.N);
        TerminalTextDataSnapshotTest.assertEquals((int)1, (int)listener2.N);
        TerminalTextDataSnapshotTest.assertEquals((int)1, (int)listener3.N);
        listener1.reset();
        listener2.reset();
        listener3.reset();
        term.setChars(1, 1, new char[]{'?', '!', '.'}, null);
        TerminalTextDataSnapshotTest.assertEquals((int)1, (int)listener1.N);
        TerminalTextDataSnapshotTest.assertEquals((int)1, (int)listener2.N);
        TerminalTextDataSnapshotTest.assertEquals((int)1, (int)listener3.N);
        term.setChars(2, 1, new char[]{'?', '!', '.'}, null);
        TerminalTextDataSnapshotTest.assertEquals((int)1, (int)listener1.N);
        TerminalTextDataSnapshotTest.assertEquals((int)1, (int)listener2.N);
        TerminalTextDataSnapshotTest.assertEquals((int)1, (int)listener3.N);
        snapshot.updateSnapshot(false);
        TerminalTextDataSnapshotTest.assertEquals((int)1, (int)listener1.N);
        TerminalTextDataSnapshotTest.assertEquals((int)1, (int)listener2.N);
        TerminalTextDataSnapshotTest.assertEquals((int)1, (int)listener3.N);
        listener1.reset();
        listener2.reset();
        listener3.reset();
        snapshot.removeListener((ITerminalTextDataSnapshot.SnapshotOutOfDateListener)listener2);
        term.scroll(1, 2, -1);
        TerminalTextDataSnapshotTest.assertEquals((int)1, (int)listener1.N);
        TerminalTextDataSnapshotTest.assertEquals((int)0, (int)listener2.N);
        TerminalTextDataSnapshotTest.assertEquals((int)1, (int)listener3.N);
        term.scroll(1, 2, -1);
        TerminalTextDataSnapshotTest.assertEquals((int)1, (int)listener1.N);
        TerminalTextDataSnapshotTest.assertEquals((int)0, (int)listener2.N);
        TerminalTextDataSnapshotTest.assertEquals((int)1, (int)listener3.N);
        snapshot.updateSnapshot(false);
        TerminalTextDataSnapshotTest.assertEquals((int)1, (int)listener1.N);
        TerminalTextDataSnapshotTest.assertEquals((int)0, (int)listener2.N);
        TerminalTextDataSnapshotTest.assertEquals((int)1, (int)listener3.N);
        snapshot.addListener((ITerminalTextDataSnapshot.SnapshotOutOfDateListener)listener2);
        listener1.reset();
        listener2.reset();
        listener3.reset();
        snapshot.removeListener((ITerminalTextDataSnapshot.SnapshotOutOfDateListener)listener3);
        term.scroll(1, 2, 1);
        TerminalTextDataSnapshotTest.assertEquals((int)1, (int)listener1.N);
        TerminalTextDataSnapshotTest.assertEquals((int)1, (int)listener2.N);
        TerminalTextDataSnapshotTest.assertEquals((int)0, (int)listener3.N);
        term.scroll(1, 2, 1);
        TerminalTextDataSnapshotTest.assertEquals((int)1, (int)listener1.N);
        TerminalTextDataSnapshotTest.assertEquals((int)1, (int)listener2.N);
        TerminalTextDataSnapshotTest.assertEquals((int)0, (int)listener3.N);
        snapshot.updateSnapshot(false);
        TerminalTextDataSnapshotTest.assertEquals((int)1, (int)listener1.N);
        TerminalTextDataSnapshotTest.assertEquals((int)1, (int)listener2.N);
        TerminalTextDataSnapshotTest.assertEquals((int)0, (int)listener3.N);
        snapshot.addListener((ITerminalTextDataSnapshot.SnapshotOutOfDateListener)listener3);
        listener1.reset();
        listener2.reset();
        listener3.reset();
        snapshot.addListener((ITerminalTextDataSnapshot.SnapshotOutOfDateListener)listener3);
        term.scroll(1, 2, -1);
        TerminalTextDataSnapshotTest.assertEquals((int)1, (int)listener1.N);
        TerminalTextDataSnapshotTest.assertEquals((int)1, (int)listener2.N);
        TerminalTextDataSnapshotTest.assertEquals((int)2, (int)listener3.N);
        term.scroll(1, 2, -1);
        TerminalTextDataSnapshotTest.assertEquals((int)1, (int)listener1.N);
        TerminalTextDataSnapshotTest.assertEquals((int)1, (int)listener2.N);
        TerminalTextDataSnapshotTest.assertEquals((int)2, (int)listener3.N);
        snapshot.updateSnapshot(false);
        TerminalTextDataSnapshotTest.assertEquals((int)1, (int)listener1.N);
        TerminalTextDataSnapshotTest.assertEquals((int)1, (int)listener2.N);
        TerminalTextDataSnapshotTest.assertEquals((int)2, (int)listener3.N);
        listener1.reset();
        listener2.reset();
        listener3.reset();
        snapshot.removeListener((ITerminalTextDataSnapshot.SnapshotOutOfDateListener)listener3);
        term.scroll(1, 2, 1);
        TerminalTextDataSnapshotTest.assertEquals((int)1, (int)listener1.N);
        TerminalTextDataSnapshotTest.assertEquals((int)1, (int)listener2.N);
        TerminalTextDataSnapshotTest.assertEquals((int)1, (int)listener3.N);
        snapshot.updateSnapshot(false);
        TerminalTextDataSnapshotTest.assertEquals((int)1, (int)listener1.N);
        TerminalTextDataSnapshotTest.assertEquals((int)1, (int)listener2.N);
        TerminalTextDataSnapshotTest.assertEquals((int)1, (int)listener3.N);
        listener1.reset();
        listener2.reset();
        listener3.reset();
        term.setDimensions(2, 2);
        TerminalTextDataSnapshotTest.assertEquals((int)1, (int)listener1.N);
        TerminalTextDataSnapshotTest.assertEquals((int)1, (int)listener2.N);
        TerminalTextDataSnapshotTest.assertEquals((int)1, (int)listener3.N);
        snapshot.updateSnapshot(false);
        TerminalTextDataSnapshotTest.assertEquals((int)1, (int)listener1.N);
        TerminalTextDataSnapshotTest.assertEquals((int)1, (int)listener2.N);
        TerminalTextDataSnapshotTest.assertEquals((int)1, (int)listener3.N);
        listener1.reset();
        listener2.reset();
        listener3.reset();
        term.setDimensions(20, 20);
        TerminalTextDataSnapshotTest.assertEquals((int)1, (int)listener1.N);
        TerminalTextDataSnapshotTest.assertEquals((int)1, (int)listener2.N);
        TerminalTextDataSnapshotTest.assertEquals((int)1, (int)listener3.N);
        snapshot.updateSnapshot(false);
        TerminalTextDataSnapshotTest.assertFalse((boolean)snapshot.isOutOfDate());
    }

    public void testWindowOfInterest() {
        ITerminalTextData term = this.makeITerminalTextData();
        TerminalTextTestHelper.fillSimple(term, "0123456789");
        ITerminalTextDataSnapshot snapshot = term.makeSnapshot();
        snapshot.updateSnapshot(false);
        snapshot.setInterestWindow(7, 4);
        snapshot.setInterestWindow(9, 4);
        snapshot.updateSnapshot(false);
    }

    public void testWindowOfInterest2() {
        ITerminalTextData term = this.makeITerminalTextData();
        TerminalTextTestHelper.fillSimple(term, "0123456789");
        ITerminalTextDataSnapshot snapshot = term.makeSnapshot();
        snapshot.updateSnapshot(false);
        term.scroll(7, 3, -1);
        snapshot.setInterestWindow(9, 4);
        snapshot.updateSnapshot(false);
    }

    public void testAddLine() {
        ITerminalTextData term = this.makeITerminalTextData();
        TerminalTextTestHelper.fillSimple(term, "0123456789");
        ITerminalTextDataSnapshot snapshot = term.makeSnapshot();
        term.setMaxHeight(20);
        snapshot.updateSnapshot(false);
        TerminalTextDataSnapshotTest.assertEquals((int)10, (int)term.getHeight());
        TerminalTextDataSnapshotTest.assertEquals((int)20, (int)term.getMaxHeight());
        TerminalTextDataSnapshotTest.assertFalse((boolean)snapshot.isOutOfDate());
        term.addLine();
        TerminalTextDataSnapshotTest.assertTrue((boolean)snapshot.isOutOfDate());
        TerminalTextDataSnapshotTest.assertEquals((int)11, (int)term.getHeight());
        TerminalTextDataSnapshotTest.assertEquals((int)10, (int)snapshot.getHeight());
        snapshot.updateSnapshot(false);
        TerminalTextDataSnapshotTest.assertEquals((int)11, (int)term.getHeight());
        TerminalTextDataSnapshotTest.assertEquals((int)11, (int)snapshot.getHeight());
        TerminalTextDataSnapshotTest.assertEquals((int)20, (int)term.getMaxHeight());
        term.addLine();
        term.addLine();
        TerminalTextDataSnapshotTest.assertEquals((int)11, (int)snapshot.getHeight());
        TerminalTextDataSnapshotTest.assertEquals((int)13, (int)term.getHeight());
        TerminalTextDataSnapshotTest.assertTrue((boolean)snapshot.isOutOfDate());
        snapshot.updateSnapshot(false);
        TerminalTextDataSnapshotTest.assertEquals((int)13, (int)snapshot.getHeight());
        TerminalTextDataSnapshotTest.assertEquals((int)13, (int)term.getHeight());
        TerminalTextDataSnapshotTest.assertEquals((int)20, (int)term.getMaxHeight());
    }

    public void testHasDimensionsChanged() {
        ITerminalTextData term = this.makeITerminalTextData();
        TerminalTextTestHelper.fillSimple(term, "0123456789");
        ITerminalTextDataSnapshot snapshot = term.makeSnapshot();
        term.setMaxHeight(20);
        snapshot.setInterestWindow(3, 4);
        snapshot.updateSnapshot(false);
        TerminalTextDataSnapshotTest.assertEquals((int)10, (int)term.getHeight());
        TerminalTextDataSnapshotTest.assertEquals((int)20, (int)term.getMaxHeight());
        TerminalTextDataSnapshotTest.assertFalse((boolean)snapshot.isOutOfDate());
        term.addLine();
        TerminalTextDataSnapshotTest.assertTrue((boolean)snapshot.isOutOfDate());
        TerminalTextDataSnapshotTest.assertEquals((int)11, (int)term.getHeight());
        TerminalTextDataSnapshotTest.assertEquals((int)10, (int)snapshot.getHeight());
        snapshot.updateSnapshot(false);
        TerminalTextDataSnapshotTest.assertTrue((boolean)snapshot.hasDimensionsChanged());
        TerminalTextDataSnapshotTest.assertEquals((int)11, (int)term.getHeight());
        TerminalTextDataSnapshotTest.assertEquals((int)11, (int)snapshot.getHeight());
        TerminalTextDataSnapshotTest.assertEquals((int)20, (int)term.getMaxHeight());
        term.addLine();
        term.addLine();
        TerminalTextDataSnapshotTest.assertEquals((int)11, (int)snapshot.getHeight());
        TerminalTextDataSnapshotTest.assertEquals((int)13, (int)term.getHeight());
        TerminalTextDataSnapshotTest.assertTrue((boolean)snapshot.isOutOfDate());
        snapshot.updateSnapshot(false);
        TerminalTextDataSnapshotTest.assertTrue((boolean)snapshot.hasDimensionsChanged());
        TerminalTextDataSnapshotTest.assertEquals((int)13, (int)snapshot.getHeight());
        TerminalTextDataSnapshotTest.assertEquals((int)13, (int)term.getHeight());
        TerminalTextDataSnapshotTest.assertEquals((int)20, (int)term.getMaxHeight());
    }

    public void testCursor() {
        ITerminalTextData term = this.makeITerminalTextData();
        TerminalTextTestHelper.fillSimple(term, "0123456789");
        ITerminalTextDataSnapshot snapshot = term.makeSnapshot();
        term.setMaxHeight(20);
        snapshot.setInterestWindow(3, 4);
        snapshot.updateSnapshot(false);
        term.setCursorLine(2);
        term.setCursorColumn(1);
        snapshot.updateSnapshot(false);
        TerminalTextDataSnapshotTest.assertEquals((int)2, (int)snapshot.getCursorLine());
        TerminalTextDataSnapshotTest.assertEquals((int)1, (int)snapshot.getCursorColumn());
        term.setCursorLine(3);
        term.setCursorColumn(2);
        snapshot.updateSnapshot(false);
        TerminalTextDataSnapshotTest.assertEquals((int)3, (int)snapshot.getCursorLine());
        TerminalTextDataSnapshotTest.assertEquals((int)2, (int)snapshot.getCursorColumn());
    }

    public void testCursor2() {
        ITerminalTextData term = this.makeITerminalTextData();
        TerminalTextTestHelper.fillSimple(term, "0123456789");
        ITerminalTextDataSnapshot snapshot = term.makeSnapshot();
        term.setMaxHeight(20);
        snapshot.setInterestWindow(3, 4);
        snapshot.updateSnapshot(false);
        term.setCursorLine(2);
        TerminalTextDataSnapshotTest.assertTrue((boolean)snapshot.isOutOfDate());
        snapshot.updateSnapshot(false);
        term.setCursorColumn(1);
        TerminalTextDataSnapshotTest.assertTrue((boolean)snapshot.isOutOfDate());
    }

    public void testHasTerminalChanged() {
        ITerminalTextData term = this.makeITerminalTextData();
        String s = "12345\nabcde\nABCDE\nvwxzy\nVWXYZ";
        TerminalTextTestHelper.fill(term, s);
        ITerminalTextDataSnapshot snapshot = term.makeSnapshot();
        TerminalTextDataSnapshotTest.assertTrue((boolean)snapshot.hasTerminalChanged());
        snapshot.updateSnapshot(false);
        TerminalTextDataSnapshotTest.assertTrue((boolean)snapshot.hasTerminalChanged());
        term.setChar(0, 0, '?', null);
        snapshot.updateSnapshot(false);
        TerminalTextDataSnapshotTest.assertTrue((boolean)snapshot.hasTerminalChanged());
        term.setChars(1, 1, new char[]{'?', '!', '.'}, null);
        snapshot.updateSnapshot(false);
        TerminalTextDataSnapshotTest.assertTrue((boolean)snapshot.hasTerminalChanged());
        term.scroll(1, 2, -1);
        snapshot.updateSnapshot(false);
        TerminalTextDataSnapshotTest.assertTrue((boolean)snapshot.hasTerminalChanged());
        term.scroll(1, 2, 1);
        snapshot.updateSnapshot(false);
        TerminalTextDataSnapshotTest.assertTrue((boolean)snapshot.hasTerminalChanged());
        term.scroll(1, 2, -1);
        snapshot.updateSnapshot(true);
        TerminalTextDataSnapshotTest.assertTrue((boolean)snapshot.hasTerminalChanged());
        term.scroll(1, 2, 1);
        snapshot.updateSnapshot(true);
        TerminalTextDataSnapshotTest.assertTrue((boolean)snapshot.hasTerminalChanged());
        term.setDimensions(2, 2);
        snapshot.updateSnapshot(false);
        TerminalTextDataSnapshotTest.assertTrue((boolean)snapshot.hasTerminalChanged());
        term.setDimensions(20, 20);
        snapshot.updateSnapshot(false);
        TerminalTextDataSnapshotTest.assertTrue((boolean)snapshot.hasTerminalChanged());
        snapshot.updateSnapshot(false);
        TerminalTextDataSnapshotTest.assertFalse((boolean)snapshot.hasTerminalChanged());
        snapshot.updateSnapshot(false);
        snapshot.setInterestWindow(7, 4);
        TerminalTextDataSnapshotTest.assertFalse((boolean)snapshot.hasTerminalChanged());
    }

    public void testGetTerminalTextData() {
        ITerminalTextData term = this.makeITerminalTextData();
        ITerminalTextDataSnapshot snapshot = term.makeSnapshot();
        TerminalTextDataSnapshotTest.assertSame((Object)term, (Object)snapshot.getTerminalTextData());
    }

    private final class SnapshotListener
    implements ITerminalTextDataSnapshot.SnapshotOutOfDateListener {
        int N;

        private SnapshotListener() {
        }

        public void snapshotOutOfDate(ITerminalTextDataSnapshot snapshot) {
            ++this.N;
        }

        public void reset() {
            this.N = 0;
        }
    }
}

