/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.internal.terminal.speedtest;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import org.eclipse.swt.widgets.Display;
import org.eclipse.tm.internal.terminal.provisional.api.ITerminalControl;
import org.eclipse.tm.internal.terminal.provisional.api.Logger;
import org.eclipse.tm.internal.terminal.provisional.api.TerminalState;
import org.eclipse.tm.internal.terminal.speedtest.SpeedTestSettings;

public class SpeedTestConnection
extends Thread {
    private static int fgNo;
    private final ITerminalControl fControl;
    private final InputStream fInputStream;
    private final SpeedTestSettings fSettings;

    protected SpeedTestConnection(InputStream inputStream, SpeedTestSettings settings, ITerminalControl control) {
        super("SpeedTestConnection-" + fgNo++);
        this.fControl = control;
        this.fInputStream = inputStream;
        this.fSettings = settings;
    }

    @Override
    public void run() {
        this.fControl.setState(TerminalState.CONNECTED);
        try {
            this.readDataForever(this.fInputStream, this.fControl.getRemoteToTerminalOutputStream());
        }
        catch (IOException e) {
            this.connectFailed(e.getMessage(), e.getMessage());
        }
        this.fControl.setState(TerminalState.CLOSED);
    }

    private void connectFailed(String terminalText, String msg) {
        Logger.log((String)terminalText);
        this.fControl.displayTextInTerminal(terminalText);
        this.fControl.setState(TerminalState.CLOSED);
        this.fControl.setMsg(msg);
    }

    private void readDataForever(InputStream in, OutputStream os) throws IOException {
        long N = 0L;
        long T = 0L;
        long tDisplay = 0L;
        int NCalls = 0;
        int bufferSize = this.fSettings.getBufferSize();
        int throttle = this.fSettings.getThrottle();
        BufferedReader reader = new BufferedReader(new InputStreamReader(in));
        String info = "";
        int n = 0;
        byte[] crnl = "\r\n".getBytes("UTF-8");
        long t0 = System.currentTimeMillis();
        String line = null;
        do {
            if ((line = reader.readLine()) != null) {
                os.write(line.getBytes("UTF-8"));
                os.write(crnl);
                n += line.length();
            }
            if (line != null && n <= bufferSize) continue;
            if (throttle > 0) {
                this.sleep(throttle);
            }
            long t = System.currentTimeMillis();
            N += (long)n;
            ++NCalls;
            if (t - tDisplay > 1000L && (T += t - t0) > 0L) {
                long rate = 1000L * N / T;
                info = String.valueOf(rate) + " byte/s = " + rate * 8L + " baud " + "bytes/call=" + N / (long)NCalls;
                info = String.valueOf(rate) + " byte/s with buffer size " + this.fSettings.getBufferSize();
                this.setTitle(info);
                tDisplay = System.currentTimeMillis();
            }
            n = 0;
            t0 = System.currentTimeMillis();
        } while (line != null);
    }

    private void sleep(int ms) {
        try {
            Thread.sleep(ms);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    private void setTitle(final String title) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                SpeedTestConnection.this.fControl.setTerminalTitle(title);
            }
        });
    }
}

