/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.internal.terminal.speedtest;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.tm.internal.terminal.provisional.api.ISettingsStore;
import org.eclipse.tm.internal.terminal.provisional.api.ITerminalControl;
import org.eclipse.tm.internal.terminal.provisional.api.Logger;
import org.eclipse.tm.internal.terminal.provisional.api.NullSettingsStore;
import org.eclipse.tm.internal.terminal.provisional.api.TerminalState;
import org.eclipse.tm.internal.terminal.provisional.api.provider.TerminalConnectorImpl;
import org.eclipse.tm.internal.terminal.speedtest.SpeedTestConnection;
import org.eclipse.tm.internal.terminal.speedtest.SpeedTestSettings;

public class SpeedTestConnector
extends TerminalConnectorImpl {
    final SpeedTestSettings fSettings = new SpeedTestSettings();
    InputStream fInputStream;
    OutputStream fOutputStream;
    SpeedTestConnection fConnection;

    public synchronized void connect(ITerminalControl control) {
        super.connect(control);
        this.fControl.setState(TerminalState.CONNECTING);
        String file = this.fSettings.getInputFile();
        try {
            this.fInputStream = new BufferedInputStream(new FileInputStream(file));
        }
        catch (FileNotFoundException e) {
            this.disconnect();
            this.fControl.setMsg(String.valueOf(file) + ": " + e.getLocalizedMessage());
            return;
        }
        this.fOutputStream = System.out;
        this.fControl.setTerminalTitle(this.fSettings.getInputFile());
        this.fConnection = new SpeedTestConnection(this.fInputStream, this.fSettings, this.fControl);
        this.fConnection.start();
    }

    public synchronized void doDisconnect() {
        if (this.fConnection != null) {
            this.fConnection.interrupt();
            this.fConnection = null;
        }
        if (this.fInputStream != null) {
            try {
                this.fInputStream.close();
            }
            catch (Exception exception) {
                Logger.logException((Exception)exception);
            }
        }
        this.fInputStream = null;
        if (this.fOutputStream != null) {
            try {
                this.fOutputStream.close();
            }
            catch (Exception exception) {
                Logger.logException((Exception)exception);
            }
        }
        this.fOutputStream = null;
    }

    public synchronized InputStream getInputStream() {
        return this.fInputStream;
    }

    public synchronized OutputStream getTerminalToRemoteStream() {
        return this.fOutputStream;
    }

    public String getSettingsSummary() {
        return this.fSettings.getInputFile();
    }

    public void setDefaultSettings() {
        this.fSettings.load((ISettingsStore)new NullSettingsStore());
    }

    public void load(ISettingsStore store) {
        this.fSettings.load(store);
    }

    public void save(ISettingsStore store) {
        this.fSettings.save(store);
    }

    public void setTerminalSize(int newWidth, int newHeight) {
    }
}

