/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.internal.terminal.test.ui;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.tm.internal.terminal.test.ui.DataReader;
import org.eclipse.tm.internal.terminal.test.ui.FastDataSource;
import org.eclipse.tm.internal.terminal.test.ui.IStatus;
import org.eclipse.tm.internal.terminal.test.ui.LineCountingDataSource;
import org.eclipse.tm.internal.terminal.test.ui.RandomDataSource;
import org.eclipse.tm.internal.terminal.test.ui.VT100DataSource;
import org.eclipse.tm.internal.terminal.textcanvas.ILinelRenderer;
import org.eclipse.tm.internal.terminal.textcanvas.ITextCanvasModel;
import org.eclipse.tm.internal.terminal.textcanvas.PollingTextCanvasModel;
import org.eclipse.tm.internal.terminal.textcanvas.TextCanvas;
import org.eclipse.tm.internal.terminal.textcanvas.TextLineRenderer;
import org.eclipse.tm.terminal.model.ITerminalTextData;
import org.eclipse.tm.terminal.model.ITerminalTextDataSnapshot;
import org.eclipse.tm.terminal.model.TerminalTextDataFactory;

public class TerminalTextUITest {
    static TextCanvas fgTextCanvas;
    static ITextCanvasModel fgModel;
    static ITerminalTextData fTerminalModel;
    static Label fStatusLabel;
    static volatile int fHeight;
    static volatile int fWidth;
    static DataReader fDataReader;
    static List fDataReaders;
    private static Text heightText;

    static {
        fDataReaders = new ArrayList();
    }

    public static void main(String[] args) {
        Display display = new Display();
        Shell shell = new Shell(display);
        shell.setLayout((Layout)new GridLayout());
        Composite composite = new Composite((Composite)shell, 0);
        composite.setLayoutData((Object)new GridData(768));
        RowLayout layout = new RowLayout(256);
        layout.wrap = true;
        layout.fill = false;
        fTerminalModel = TerminalTextDataFactory.makeTerminalTextData();
        fHeight = 24;
        fWidth = 80;
        fTerminalModel.setDimensions(fHeight, fWidth);
        fTerminalModel.setMaxHeight(fHeight);
        ITerminalTextDataSnapshot snapshot = fTerminalModel.makeSnapshot();
        snapshot.updateSnapshot(false);
        fgModel = new PollingTextCanvasModel(snapshot);
        fgTextCanvas = new TextCanvas((Composite)shell, fgModel, 0, (ILinelRenderer)new TextLineRenderer(fgTextCanvas, fgModel));
        fgTextCanvas.setLayoutData((Object)new GridData(1808));
        composite.setLayout((Layout)layout);
        TerminalTextUITest.addAutorevealCursorButton(composite);
        Text maxHeightText = TerminalTextUITest.addMaxHeightInput(composite);
        TerminalTextUITest.addHeightInput(composite, maxHeightText);
        TerminalTextUITest.addWidthText(composite);
        Text throttleText = TerminalTextUITest.addThrottleText(composite);
        Status status = new Status();
        DataReader reader = new DataReader("Line Count", fTerminalModel, new LineCountingDataSource(), status);
        TerminalTextUITest.addDataReader(composite, reader);
        reader = new DataReader("Fast", fTerminalModel, new FastDataSource(), status);
        TerminalTextUITest.addDataReader(composite, reader);
        reader = new DataReader("Random", fTerminalModel, new RandomDataSource(), status);
        TerminalTextUITest.addDataReader(composite, reader);
        int i = 0;
        while (i < args.length) {
            File file = new File(args[i]);
            reader = new DataReader(file.getName(), fTerminalModel, new VT100DataSource(args[i]), status);
            TerminalTextUITest.addDataReader(composite, reader);
            ++i;
        }
        TerminalTextUITest.addStopAllButton(composite, reader);
        fStatusLabel = new Label((Composite)shell, 0);
        fStatusLabel.setLayoutData((Object)new GridData(250, 15));
        throttleText.setText("100");
        TerminalTextUITest.setThrottleForAll(100);
        if (args.length == 0) {
            TerminalTextUITest.addLabel(composite, "[Files can be added via commandline]");
        }
        shell.setSize(600, 300);
        shell.open();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        display.dispose();
    }

    private static Text addMaxHeightInput(Composite composite) {
        TerminalTextUITest.addLabel(composite, "maxHeight:");
        final Text maxHeightText = new Text(composite, 2048);
        TerminalTextUITest.setLayoutData((Control)maxHeightText, 30);
        maxHeightText.addModifyListener(new ModifyListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void modifyText(ModifyEvent e) {
                ITerminalTextData iTerminalTextData = fTerminalModel;
                synchronized (iTerminalTextData) {
                    int height = TerminalTextUITest.textToInt(maxHeightText);
                    if (height < 1) {
                        return;
                    }
                    if (fTerminalModel.getHeight() > height) {
                        fTerminalModel.scroll(0, fTerminalModel.getHeight(), height - fTerminalModel.getHeight());
                        fTerminalModel.setDimensions(height, fTerminalModel.getWidth());
                        heightText.setText(String.valueOf(height));
                    }
                    fTerminalModel.setMaxHeight(height);
                }
            }
        });
        maxHeightText.setText(String.valueOf(fHeight));
        return maxHeightText;
    }

    private static void addHeightInput(Composite composite, final Text maxHeightText) {
        TerminalTextUITest.addLabel(composite, "heigth:");
        heightText = new Text(composite, 2048);
        TerminalTextUITest.setLayoutData((Control)heightText, 30);
        heightText.addModifyListener(new ModifyListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void modifyText(ModifyEvent e) {
                ITerminalTextData iTerminalTextData = fTerminalModel;
                synchronized (iTerminalTextData) {
                    int height = TerminalTextUITest.textToInt(heightText);
                    if (height < 1) {
                        return;
                    }
                    maxHeightText.setText("" + height);
                    fTerminalModel.setDimensions(height, fTerminalModel.getWidth());
                    fTerminalModel.setMaxHeight(height);
                }
            }
        });
        heightText.setText(String.valueOf(fHeight));
    }

    private static Text addWidthText(Composite composite) {
        TerminalTextUITest.addLabel(composite, "width:");
        final Text widthText = new Text(composite, 2048);
        TerminalTextUITest.setLayoutData((Control)widthText, 30);
        widthText.addModifyListener(new ModifyListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void modifyText(ModifyEvent e) {
                ITerminalTextData iTerminalTextData = fTerminalModel;
                synchronized (iTerminalTextData) {
                    int width = TerminalTextUITest.textToInt(widthText);
                    if (width > 1) {
                        fTerminalModel.setDimensions(fTerminalModel.getHeight(), width);
                    }
                }
            }
        });
        widthText.setText(String.valueOf(fWidth));
        return widthText;
    }

    private static Text addThrottleText(Composite composite) {
        TerminalTextUITest.addLabel(composite, "throttle:");
        final Text throttleText = new Text(composite, 2048);
        TerminalTextUITest.setLayoutData((Control)throttleText, 30);
        throttleText.addModifyListener(new ModifyListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void modifyText(ModifyEvent e) {
                ITerminalTextData iTerminalTextData = fTerminalModel;
                synchronized (iTerminalTextData) {
                    int throttle = TerminalTextUITest.textToInt(throttleText);
                    TerminalTextUITest.setThrottleForAll(throttle);
                }
            }
        });
        return throttleText;
    }

    private static void addStopAllButton(Composite composite, DataReader reader) {
        final Button stopAllButton = new Button(composite, 32);
        stopAllButton.setText("Stop ALL");
        stopAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean stop = stopAllButton.getSelection();
                for (DataReader reader : fDataReaders) {
                    reader.setStop(stop);
                }
            }
        });
        stopAllButton.setSelection(reader.isStart());
    }

    private static void addAutorevealCursorButton(Composite composite) {
        final Button button = new Button(composite, 32);
        button.setText("ScrollLock");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean scrollLock = button.getSelection();
                fgTextCanvas.setScrollLock(scrollLock);
            }
        });
        button.setSelection(fgTextCanvas.isScrollLock());
    }

    private static void addLabel(Composite composite, String message) {
        Label label = new Label(composite, 0);
        label.setText(message);
    }

    private static void addDataReader(Composite composite, final DataReader reader) {
        fDataReaders.add(reader);
        final Button button = new Button(composite, 32);
        button.setText(reader.getName());
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                reader.setStart(button.getSelection());
            }
        });
        button.setSelection(reader.isStart());
    }

    private static void setThrottleForAll(int throttle) {
        for (DataReader reader : fDataReaders) {
            reader.setThrottleTime(throttle);
        }
    }

    static void setLayoutData(Control c, int width) {
        c.setLayoutData((Object)new RowData(width, -1));
    }

    static int textToInt(Text text) {
        try {
            return Integer.valueOf(text.getText());
        }
        catch (Exception ex) {
            return 0;
        }
    }

    static class Status
    implements IStatus {
        Status() {
        }

        @Override
        public void setStatus(final String s) {
            if (!fStatusLabel.isDisposed()) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (!fStatusLabel.isDisposed()) {
                            fStatusLabel.setText(s);
                        }
                    }
                });
            }
        }
    }
}

