/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.internal.terminal.model;

import java.util.ArrayList;
import org.eclipse.tm.internal.terminal.model.AbstractITerminalTextDataTest;
import org.eclipse.tm.internal.terminal.model.TerminalTextData;
import org.eclipse.tm.internal.terminal.model.TerminalTextDataStore;
import org.eclipse.tm.internal.terminal.model.TerminalTextDataWindow;
import org.eclipse.tm.terminal.model.ITerminalTextData;
import org.eclipse.tm.terminal.model.ITerminalTextDataReadOnly;
import org.eclipse.tm.terminal.model.LineSegment;
import org.eclipse.tm.terminal.model.Style;
import org.eclipse.tm.terminal.model.StyleColor;

public class TerminalTextDataWindowTest
extends AbstractITerminalTextDataTest {
    int fOffset = 2;
    int fSize = 2;

    @Override
    protected ITerminalTextData makeITerminalTextData() {
        TerminalTextDataWindow term = new TerminalTextDataWindow();
        term.setWindow(this.fOffset, this.fSize);
        return term;
    }

    @Override
    protected void assertEqualsTerm(String expected, String actual) {
        TerminalTextDataWindowTest.assertEquals((String)this.stripMultiLine(expected), (String)this.stripMultiLine(actual));
    }

    private String stripMultiLine(String s) {
        StringBuffer b = new StringBuffer();
        ArrayList<String> l = new ArrayList<String>();
        int j = 0;
        int k = 0;
        while (k < s.length()) {
            if (s.charAt(k) == '\n') {
                l.add(s.substring(j, k));
                j = k;
            }
            ++k;
        }
        j = l.size() - 1;
        while (j >= 0 && "".equals(l.get(j))) {
            --j;
        }
        String[] lines = new String[j + 1];
        while (j >= 0) {
            lines[j] = (String)l.get(j);
            --j;
        }
        int i = 0;
        while (i < lines.length) {
            if (i > 0) {
                b.append("\n");
            }
            if (i >= this.fOffset && i < this.fOffset + this.fSize) {
                b.append(lines[i]);
            } else {
                b.append(new String(new char[lines[i].length()]));
            }
            ++i;
        }
        return b.toString();
    }

    @Override
    protected void assertEqualsSimple(String expected, String actual) {
        TerminalTextDataWindowTest.assertEquals((String)this.stripSimple(expected), (String)this.stripSimple(actual));
    }

    String stripSimple(String s) {
        StringBuffer b = new StringBuffer();
        int i = 0;
        while (i < s.length()) {
            if (i >= this.fOffset && i < this.fOffset + this.fSize) {
                b.append(s.charAt(i));
            } else {
                b.append(' ');
            }
            ++i;
        }
        return b.toString();
    }

    @Override
    public void testAddLine() {
        String s = "111\n222\n333\n444\n555";
        ITerminalTextData term = this.makeITerminalTextData();
        this.fill(term, s);
        term.addLine();
        this.assertEqualsTerm("222\n333\n444\n\u0000\u0000\u0000\n\u0000\u0000\u0000", this.toMultiLineText((ITerminalTextDataReadOnly)term));
    }

    @Override
    public void testMaxSize() {
        String s = "111\n222\n333\n444\n555";
        ITerminalTextData term = this.makeITerminalTextData();
        term.setMaxHeight(8);
        this.fill(term, s);
        TerminalTextDataWindowTest.assertEquals((int)5, (int)term.getHeight());
        TerminalTextDataWindowTest.assertEquals((int)8, (int)term.getMaxHeight());
        term.addLine();
        TerminalTextDataWindowTest.assertEquals((int)6, (int)term.getHeight());
        this.assertEqualsTerm("111\n222\n333\n444\n555\n\u0000\u0000\u0000", this.toMultiLineText((ITerminalTextDataReadOnly)term));
        term.addLine();
        TerminalTextDataWindowTest.assertEquals((int)7, (int)term.getHeight());
        this.assertEqualsTerm("111\n222\n333\n444\n555\n\u0000\u0000\u0000\n\u0000\u0000\u0000", this.toMultiLineText((ITerminalTextDataReadOnly)term));
        term.addLine();
        TerminalTextDataWindowTest.assertEquals((int)8, (int)term.getHeight());
        this.assertEqualsTerm("111\n222\n333\n444\n555\n\u0000\u0000\u0000\n\u0000\u0000\u0000\n\u0000\u0000\u0000", this.toMultiLineText((ITerminalTextDataReadOnly)term));
        term.addLine();
        TerminalTextDataWindowTest.assertEquals((int)8, (int)term.getHeight());
        this.assertEqualsTerm("222\n333\n444\n\u0000\u0000\u0000\n\u0000\u0000\u0000\n\u0000\u0000\u0000\n\u0000\u0000\u0000\n\u0000\u0000\u0000", this.toMultiLineText((ITerminalTextDataReadOnly)term));
    }

    @Override
    public void testGetLineSegments() {
        Style s1 = this.getDefaultStyle();
        Style s2 = s1.setBold(true);
        Style s3 = s1.setUnderline(true);
        ITerminalTextData term = this.makeITerminalTextData();
        term.setDimensions(8, 8);
        term.setChars(2, 0, "0123".toCharArray(), s1);
        term.setChars(2, 4, "abcd".toCharArray(), null);
        LineSegment[] segments = term.getLineSegments(2, 0, term.getWidth());
        TerminalTextDataWindowTest.assertEquals((int)2, (int)segments.length);
        this.assertSegment(0, "0123", s1, segments[0]);
        this.assertSegment(4, "abcd", null, segments[1]);
        segments = term.getLineSegments(2, 4, term.getWidth() - 4);
        TerminalTextDataWindowTest.assertEquals((int)1, (int)segments.length);
        this.assertSegment(4, "abcd", null, segments[0]);
        segments = term.getLineSegments(2, 3, 2);
        TerminalTextDataWindowTest.assertEquals((int)2, (int)segments.length);
        this.assertSegment(3, "3", s1, segments[0]);
        this.assertSegment(4, "a", null, segments[1]);
        segments = term.getLineSegments(2, 7, 1);
        TerminalTextDataWindowTest.assertEquals((int)1, (int)segments.length);
        this.assertSegment(7, "d", null, segments[0]);
        segments = term.getLineSegments(2, 0, 1);
        TerminalTextDataWindowTest.assertEquals((int)1, (int)segments.length);
        this.assertSegment(0, "0", s1, segments[0]);
        term.setChars(1, 0, "x".toCharArray(), s1);
        term.setChars(1, 1, "y".toCharArray(), s2);
        term.setChars(1, 2, "z".toCharArray(), s3);
        segments = term.getLineSegments(1, 0, term.getWidth());
        TerminalTextDataWindowTest.assertEquals((int)1, (int)segments.length);
        this.assertSegment(0, "\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000", null, segments[0]);
        segments = term.getLineSegments(3, 0, term.getWidth());
        TerminalTextDataWindowTest.assertEquals((int)1, (int)segments.length);
        this.assertSegment(0, "\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000", null, segments[0]);
    }

    @Override
    public void testGetChar() {
        String s = "12345\nabcde\nABCDE";
        ITerminalTextData term = this.makeITerminalTextData();
        this.fill(term, s);
        TerminalTextDataWindowTest.assertEquals((char)'\u0000', (char)term.getChar(0, 0));
        TerminalTextDataWindowTest.assertEquals((char)'\u0000', (char)term.getChar(0, 1));
        TerminalTextDataWindowTest.assertEquals((char)'\u0000', (char)term.getChar(0, 2));
        TerminalTextDataWindowTest.assertEquals((char)'\u0000', (char)term.getChar(0, 3));
        TerminalTextDataWindowTest.assertEquals((char)'\u0000', (char)term.getChar(0, 4));
        TerminalTextDataWindowTest.assertEquals((char)'\u0000', (char)term.getChar(1, 0));
        TerminalTextDataWindowTest.assertEquals((char)'\u0000', (char)term.getChar(1, 1));
        TerminalTextDataWindowTest.assertEquals((char)'\u0000', (char)term.getChar(1, 2));
        TerminalTextDataWindowTest.assertEquals((char)'\u0000', (char)term.getChar(1, 3));
        TerminalTextDataWindowTest.assertEquals((char)'\u0000', (char)term.getChar(1, 4));
        TerminalTextDataWindowTest.assertEquals((char)'A', (char)term.getChar(2, 0));
        TerminalTextDataWindowTest.assertEquals((char)'B', (char)term.getChar(2, 1));
        TerminalTextDataWindowTest.assertEquals((char)'C', (char)term.getChar(2, 2));
        TerminalTextDataWindowTest.assertEquals((char)'D', (char)term.getChar(2, 3));
        TerminalTextDataWindowTest.assertEquals((char)'E', (char)term.getChar(2, 4));
    }

    @Override
    public void testGetStyle() {
        char c;
        int column;
        ITerminalTextData term = this.makeITerminalTextData();
        Style style = this.getDefaultStyle();
        term.setDimensions(6, 3);
        int line = 0;
        while (line < term.getHeight()) {
            column = 0;
            while (column < term.getWidth()) {
                c = (char)(97 + column + line);
                term.setChar(line, column, c, style.setForground(StyleColor.getStyleColor((String)("" + c))));
                ++column;
            }
            ++line;
        }
        line = 0;
        while (line < term.getHeight()) {
            column = 0;
            while (column < term.getWidth()) {
                c = (char)(97 + column + line);
                Style s = null;
                if (line >= this.fOffset && line < this.fOffset + this.fSize) {
                    s = style.setForground(StyleColor.getStyleColor((String)("" + c)));
                }
                TerminalTextDataWindowTest.assertSame(s, (Object)term.getStyle(line, column));
                ++column;
            }
            ++line;
        }
    }

    @Override
    public void testSetChar() {
        int column;
        ITerminalTextData term = this.makeITerminalTextData();
        term.setDimensions(6, 3);
        int line = 0;
        while (line < term.getHeight()) {
            column = 0;
            while (column < term.getWidth()) {
                term.setChar(line, column, (char)(97 + column + line), null);
                ++column;
            }
            ++line;
        }
        line = 0;
        while (line < term.getHeight()) {
            column = 0;
            while (column < term.getWidth()) {
                char c = '\u0000';
                if (line >= this.fOffset && line < this.fOffset + this.fSize) {
                    c = (char)(97 + column + line);
                }
                TerminalTextDataWindowTest.assertEquals((char)c, (char)term.getChar(line, column));
                ++column;
            }
            ++line;
        }
        this.assertEqualsTerm("abc\nbcd\ncde\ndef\nefg\nfgh", this.toMultiLineText((ITerminalTextDataReadOnly)term));
    }

    @Override
    public void testSetChars() {
        ITerminalTextData term = this.makeITerminalTextData();
        term.setDimensions(6, 3);
        int line = 0;
        while (line < term.getHeight()) {
            char[] chars = new char[term.getWidth()];
            int column = 0;
            while (column < term.getWidth()) {
                chars[column] = (char)(97 + column + line);
                ++column;
            }
            term.setChars(line, 0, chars, null);
            ++line;
        }
        line = 0;
        while (line < term.getHeight()) {
            int column = 0;
            while (column < term.getWidth()) {
                char c = '\u0000';
                if (line >= this.fOffset && line < this.fOffset + this.fSize) {
                    c = (char)(97 + column + line);
                }
                TerminalTextDataWindowTest.assertEquals((char)c, (char)term.getChar(line, column));
                ++column;
            }
            ++line;
        }
        this.assertEqualsTerm("abc\nbcd\ncde\ndef\nefg\nfgh", this.toMultiLineText((ITerminalTextDataReadOnly)term));
        term.setChars(3, 1, new char[]{'1', '2'}, null);
        this.assertEqualsTerm("abc\nbcd\ncde\nd12\nefg\nfgh", this.toMultiLineText((ITerminalTextDataReadOnly)term));
        term.setChars(4, 1, new char[]{'1', '2', '3', '4', '5'}, null);
        this.assertEqualsTerm("abc\nbcd\ncde\nd12\ne12\nfgh", this.toMultiLineText((ITerminalTextDataReadOnly)term));
    }

    @Override
    public void testSetCharsLen() {
        ITerminalTextData term = this.makeITerminalTextData();
        String s = "ZYXWVU\nabcdef\nABCDEF";
        this.fill(term, s);
        char[] chars = new char[]{'1', '2', '3', '4', '5', '6', '7', '8'};
        term.setChars(1, 0, chars, 0, 6, null);
        this.assertEqualsTerm("ZYXWVU\n123456\nABCDEF", this.toMultiLineText((ITerminalTextDataReadOnly)term));
        this.fill(term, s);
        term.setChars(1, 0, chars, 0, 5, null);
        this.assertEqualsTerm("ZYXWVU\n12345f\nABCDEF", this.toMultiLineText((ITerminalTextDataReadOnly)term));
        this.fill(term, s);
        term.setChars(1, 0, chars, 1, 5, null);
        this.assertEqualsTerm("ZYXWVU\n23456f\nABCDEF", this.toMultiLineText((ITerminalTextDataReadOnly)term));
        this.fill(term, s);
        term.setChars(1, 1, chars, 1, 4, null);
        this.assertEqualsTerm("ZYXWVU\na2345f\nABCDEF", this.toMultiLineText((ITerminalTextDataReadOnly)term));
        this.fill(term, s);
        term.setChars(1, 2, chars, 3, 4, null);
        this.assertEqualsTerm("ZYXWVU\nab4567\nABCDEF", this.toMultiLineText((ITerminalTextDataReadOnly)term));
        this.fill(term, s);
    }

    @Override
    public void testSetCopyLines() {
        TerminalTextDataStore term = new TerminalTextDataStore();
        String s = "012345";
        this.fillSimple((ITerminalTextData)term, s);
        ITerminalTextData termCopy = this.makeITerminalTextData();
        String sCopy = "abcde";
        this.fillSimple(termCopy, sCopy);
        termCopy.copyRange((ITerminalTextData)term, 0, 0, 0);
        this.assertEqualsSimple(s, this.toSimple((ITerminalTextData)term));
        this.assertEqualsSimple(sCopy, this.toSimple(termCopy));
        this.fillSimple(termCopy, sCopy);
        termCopy.copyRange((ITerminalTextData)term, 0, 0, 5);
        this.assertEqualsSimple(s, this.toSimple((ITerminalTextData)term));
        this.assertEqualsSimple("01234", this.toSimple(termCopy));
        this.fillSimple(termCopy, sCopy);
        termCopy.copyRange((ITerminalTextData)term, 0, 0, 2);
        this.assertEqualsSimple(s, this.toSimple((ITerminalTextData)term));
        this.assertEqualsSimple("01cde", this.toSimple(termCopy));
        this.fillSimple(termCopy, sCopy);
        termCopy.copyRange((ITerminalTextData)term, 0, 1, 2);
        this.assertEqualsSimple(s, this.toSimple((ITerminalTextData)term));
        this.assertEqualsSimple("a01de", this.toSimple(termCopy));
        this.fillSimple(termCopy, sCopy);
        termCopy.copyRange((ITerminalTextData)term, 1, 1, 2);
        this.assertEqualsSimple(s, this.toSimple((ITerminalTextData)term));
        this.assertEqualsSimple("a12de", this.toSimple(termCopy));
        this.fillSimple(termCopy, sCopy);
        termCopy.copyRange((ITerminalTextData)term, 1, 1, 4);
        this.assertEqualsSimple(s, this.toSimple((ITerminalTextData)term));
        this.assertEqualsSimple("a1234", this.toSimple(termCopy));
        this.fillSimple(termCopy, sCopy);
        termCopy.copyRange((ITerminalTextData)term, 2, 1, 4);
        this.assertEqualsSimple(s, this.toSimple((ITerminalTextData)term));
        this.assertEqualsSimple("a2345", this.toSimple(termCopy));
    }

    @Override
    public void testScrollNegative() {
        this.scrollTest(0, 2, -1, "  23  ", "  23  ");
        this.scrollTest(0, 1, -1, "  23  ", "  23  ");
        this.scrollTest(0, 6, -1, "  23  ", "  3   ");
        this.scrollTest(0, 6, -6, "  23  ", "      ");
        this.scrollTest(0, 6, -7, "  23  ", "      ");
        this.scrollTest(0, 6, -8, "  23  ", "      ");
        this.scrollTest(0, 6, -2, "  23  ", "      ");
        this.scrollTest(1, 1, -1, "  23  ", "  23  ");
        this.scrollTest(1, 2, -1, "  23  ", "   3  ");
        this.scrollTest(5, 1, -1, "  23  ", "  23  ");
        this.scrollTest(5, 1, -1, "  23  ", "  23  ");
    }

    @Override
    public void testScrollAll() {
        this.scrollTest(0, 6, 1, "  2345", "   2  ");
        this.scrollTest(0, 6, -1, "  2345", "  3   ");
        this.scrollTest(0, 6, 2, "  2345", "      ");
        this.scrollTest(0, 6, -2, "  2345", "      ");
    }

    @Override
    public void testCopyLineWithOffset() {
        ITerminalTextData term = this.makeITerminalTextData();
        String s = "111\n222\n333\n444\n555";
        this.fill(term, s);
        ITerminalTextData dest = this.makeITerminalTextData();
        String sCopy = "aaa\nbbb\nccc\nddd\neee";
        this.fill(dest, sCopy);
        boolean[] blArray = new boolean[4];
        blArray[0] = true;
        blArray[3] = true;
        this.copySelective(dest, term, 1, 0, blArray);
        this.assertEqualsTerm(s, this.toMultiLineText((ITerminalTextDataReadOnly)term));
        this.assertEqualsTerm("222\nbbb\nccc\n\u0000\u0000\u0000\neee", this.toMultiLineText((ITerminalTextDataReadOnly)dest));
        this.fill(dest, sCopy);
        this.copySelective(dest, term, 2, 0, new boolean[]{true, true});
        this.assertEqualsTerm(s, this.toMultiLineText((ITerminalTextDataReadOnly)term));
        this.assertEqualsTerm("333\n444\nccc\nddd\neee", this.toMultiLineText((ITerminalTextDataReadOnly)dest));
        this.fill(dest, sCopy);
        this.copySelective(dest, term, 0, 0, new boolean[]{true, true, true, true, true});
        this.assertEqualsTerm(s, this.toMultiLineText((ITerminalTextDataReadOnly)term));
        this.assertEqualsTerm(s, this.toMultiLineText((ITerminalTextDataReadOnly)dest));
        this.fill(dest, sCopy);
        this.copySelective(dest, term, 0, 0, new boolean[5]);
        this.assertEqualsTerm(s, this.toMultiLineText((ITerminalTextDataReadOnly)term));
        this.assertEqualsTerm(sCopy, this.toMultiLineText((ITerminalTextDataReadOnly)dest));
    }

    public void testCopy() {
        ITerminalTextData term = this.makeITerminalTextData();
        term.setDimensions(3, 1);
        TerminalTextData data = new TerminalTextData();
        this.fillSimple((ITerminalTextData)data, "abcd");
        term.copy((ITerminalTextData)data);
    }

    @Override
    public void testWrappedLines() {
        ITerminalTextData term = this.makeITerminalTextData();
        term.setDimensions(4, 4);
        int i = 0;
        while (i < term.getHeight()) {
            TerminalTextDataWindowTest.assertFalse((boolean)term.isWrappedLine(i));
            ++i;
        }
        term.setWrappedLine(0);
        term.setWrappedLine(3);
        TerminalTextDataWindowTest.assertFalse((boolean)term.isWrappedLine(0));
        TerminalTextDataWindowTest.assertFalse((boolean)term.isWrappedLine(1));
        TerminalTextDataWindowTest.assertFalse((boolean)term.isWrappedLine(2));
        TerminalTextDataWindowTest.assertTrue((boolean)term.isWrappedLine(3));
        term.cleanLine(3);
        TerminalTextDataWindowTest.assertFalse((boolean)term.isWrappedLine(3));
    }
}

