/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.internal.terminal.model;

import org.eclipse.tm.terminal.model.ITerminalTextData;
import org.eclipse.tm.terminal.model.ITerminalTextDataReadOnly;
import org.eclipse.tm.terminal.model.Style;
import org.eclipse.tm.terminal.model.StyleColor;

public class TerminalTextTestHelper {
    public static String toSimple(ITerminalTextDataReadOnly term) {
        return TerminalTextTestHelper.toSimple(TerminalTextTestHelper.toMultiLineText(term));
    }

    public static String toMultiLineText(ITerminalTextDataReadOnly term) {
        StringBuffer buff = new StringBuffer();
        int width = term.getWidth();
        int line = 0;
        while (line < term.getHeight()) {
            if (line > 0) {
                buff.append("\n");
            }
            int column = 0;
            while (column < width) {
                buff.append(term.getChar(line, column));
                ++column;
            }
            ++line;
        }
        return buff.toString();
    }

    public static String toSimple(String str) {
        StringBuffer buf = new StringBuffer(str.length());
        int i = 0;
        while (i < str.length()) {
            char c = str.charAt(i);
            switch (c) {
                case '\u0000': {
                    buf.append(' ');
                    break;
                }
                case '\n': {
                    break;
                }
                default: {
                    buf.append(c);
                }
            }
            ++i;
        }
        return buf.toString();
    }

    public static void fillSimple(ITerminalTextData term, String s) {
        Style style = Style.getStyle((StyleColor)StyleColor.getStyleColor((String)"fg"), (StyleColor)StyleColor.getStyleColor((String)"bg"), (boolean)false, (boolean)false, (boolean)false, (boolean)false);
        term.setDimensions(s.length(), 1);
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            term.setChar(i, 0, c, style.setForground(StyleColor.getStyleColor((String)("" + c))));
            ++i;
        }
    }

    public static void fill(ITerminalTextData term, String s) {
        int width = 0;
        int len = 0;
        int height = 0;
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            if (c == '\n') {
                width = Math.max(width, len);
                len = 0;
            } else {
                if (len == 0) {
                    ++height;
                }
                ++len;
            }
            ++i;
        }
        width = Math.max(width, len);
        term.setDimensions(height, width);
        TerminalTextTestHelper.fill(term, 0, 0, s);
    }

    public static void fill(ITerminalTextData term, int column, int line, String s) {
        int xx = column;
        int yy = line;
        Style style = Style.getStyle((StyleColor)StyleColor.getStyleColor((String)"fg"), (StyleColor)StyleColor.getStyleColor((String)"bg"), (boolean)false, (boolean)false, (boolean)false, (boolean)false);
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            if (c == '\n') {
                ++yy;
                xx = column;
            } else {
                term.setChar(yy, xx, c, style.setForground(StyleColor.getStyleColor((String)("" + c))));
                ++xx;
            }
            ++i;
        }
    }
}

