/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.internal.terminal.textcanvas;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedOutputStream;
import org.eclipse.tm.internal.terminal.textcanvas.PipedInputStream;

class PipedStreamTest {
    PipedStreamTest() {
    }

    public static void main(String[] args) throws IOException, InterruptedException {
        while (true) {
            PipedStreamTest.runSunTest();
            PipedStreamTest.runMyTest();
        }
    }

    private static void runSunTest() throws IOException, InterruptedException {
        java.io.PipedInputStream in = new java.io.PipedInputStream();
        PipedOutputStream out = new PipedOutputStream(in);
        PipedStreamTest.runPipe("Sun ", in, out, 10);
    }

    private static void runMyTest() throws IOException, InterruptedException {
        PipedInputStream in = new PipedInputStream(4096);
        OutputStream out = in.getOutputStream();
        PipedStreamTest.runPipe("My  ", (InputStream)in, out, 99);
    }

    public static void runPipe(String what, InputStream writeIn, OutputStream readOut, int N) throws InterruptedException {
        FakeInputStream in = new FakeInputStream(N * 1000 * 1000);
        FakeOutputStream out = new FakeOutputStream();
        ReadThread rt = new ReadThread("reader", in, readOut);
        ReadThread wt = new ReadThread("writer", writeIn, out);
        long t0 = System.currentTimeMillis();
        rt.start();
        wt.start();
        wt.join();
        long t = System.currentTimeMillis();
        long n = out.N;
        System.out.println(String.valueOf(what) + n + " byte in " + (t - t0) + " ms -> " + 1000L * n / ((t - t0 + 1L) * 1024L) + " kb/sec");
    }

    static class FakeInputStream
    extends InputStream {
        int N;

        FakeInputStream(int n) {
            this.N = n;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            if (this.N == 0) {
                return -1;
            }
            int n = Math.min(len, this.N);
            int i = off;
            while (i < off + n) {
                b[i] = 120;
                ++i;
            }
            this.N -= n;
            return n;
        }

        @Override
        public int read() throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public int available() throws IOException {
            return this.N;
        }
    }

    static class FakeOutputStream
    extends OutputStream {
        long N;

        FakeOutputStream() {
        }

        @Override
        public void write(int b) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.N += (long)len;
        }
    }

    static class ReadThread
    extends Thread
    implements Runnable {
        InputStream pi = null;
        OutputStream po = null;

        ReadThread(String process, InputStream pi, OutputStream po) {
            this.pi = pi;
            this.po = po;
            this.setDaemon(true);
        }

        @Override
        public void run() {
            byte[] buffer = new byte[2048];
            try {
                while (true) {
                    int bytes_read;
                    if ((bytes_read = this.pi.read(buffer)) == -1) {
                        this.po.close();
                        this.pi.close();
                        return;
                    }
                    this.po.write(buffer, 0, bytes_read);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                return;
            }
        }
    }
}

