/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.internal.terminal.connector;

import java.io.OutputStream;
import junit.framework.TestCase;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tm.internal.terminal.connector.TerminalConnector;
import org.eclipse.tm.internal.terminal.provisional.api.ISettingsStore;
import org.eclipse.tm.internal.terminal.provisional.api.ITerminalControl;
import org.eclipse.tm.internal.terminal.provisional.api.TerminalState;
import org.eclipse.tm.internal.terminal.provisional.api.provider.TerminalConnectorImpl;

public class TerminalConnectorTest
extends TestCase {
    public void testGetInitializationErrorMessage() {
        TerminalConnector c = new TerminalConnector((TerminalConnector.Factory)new SimpleFactory(new ConnectorMock()), "xID", "xName", false);
        c.connect((ITerminalControl)new TerminalControlMock());
        TerminalConnectorTest.assertNull((Object)c.getInitializationErrorMessage());
        c = new TerminalConnector((TerminalConnector.Factory)new SimpleFactory(new ConnectorMock(){

            public void initialize() throws Exception {
                throw new Exception("FAILED");
            }
        }), "xID", "xName", false);
        c.connect((ITerminalControl)new TerminalControlMock());
        TerminalConnectorTest.assertEquals((String)"FAILED", (String)c.getInitializationErrorMessage());
    }

    public void testGetIdAndName() {
        TerminalConnector c = new TerminalConnector((TerminalConnector.Factory)new SimpleFactory(new ConnectorMock()), "xID", "xName", false);
        TerminalConnectorTest.assertEquals((String)"xID", (String)c.getId());
        TerminalConnectorTest.assertEquals((String)"xName", (String)c.getName());
    }

    public void testConnect() {
        TerminalConnector c = new TerminalConnector((TerminalConnector.Factory)new SimpleFactory(new ConnectorMock()), "xID", "xName", false);
        TerminalConnectorTest.assertFalse((boolean)c.isInitialized());
        c.connect((ITerminalControl)new TerminalControlMock());
        TerminalConnectorTest.assertTrue((boolean)c.isInitialized());
    }

    public void testDisconnect() {
        ConnectorMock mock = new ConnectorMock();
        TerminalConnector c = new TerminalConnector((TerminalConnector.Factory)new SimpleFactory(mock), "xID", "xName", false);
        TerminalControlMock control = new TerminalControlMock();
        c.connect((ITerminalControl)control);
        c.disconnect();
        TerminalConnectorTest.assertTrue((boolean)mock.fDisconnect);
    }

    public void testGetTerminalToRemoteStream() {
        ConnectorMock mock = new ConnectorMock();
        TerminalConnector c = new TerminalConnector((TerminalConnector.Factory)new SimpleFactory(mock), "xID", "xName", false);
        TerminalControlMock control = new TerminalControlMock();
        c.connect((ITerminalControl)control);
        TerminalConnectorTest.assertSame((Object)mock.fTerminalControl, (Object)control);
    }

    public void testGetSettingsSummary() {
        TerminalConnector c = new TerminalConnector((TerminalConnector.Factory)new SimpleFactory(new ConnectorMock()), "xID", "xName", false);
        TerminalConnectorTest.assertEquals((String)"Not Initialized", (String)c.getSettingsSummary());
        c.connect((ITerminalControl)new TerminalControlMock());
        TerminalConnectorTest.assertEquals((String)"Summary", (String)c.getSettingsSummary());
    }

    public void testIsLocalEcho() {
        ConnectorMock mock = new ConnectorMock();
        TerminalConnector c = new TerminalConnector((TerminalConnector.Factory)new SimpleFactory(mock), "xID", "xName", false);
        TerminalConnectorTest.assertFalse((boolean)c.isLocalEcho());
        mock.fEcho = true;
        TerminalConnectorTest.assertTrue((boolean)c.isLocalEcho());
    }

    public void testLoad() {
        ConnectorMock mock = new ConnectorMock();
        TerminalConnector c = new TerminalConnector((TerminalConnector.Factory)new SimpleFactory(mock), "xID", "xName", false);
        SettingsMock s = new SettingsMock();
        c.load((ISettingsStore)s);
        TerminalConnectorTest.assertNull((Object)mock.fLoadStore);
        c.connect((ITerminalControl)new TerminalControlMock());
        TerminalConnectorTest.assertSame((Object)s, (Object)mock.fLoadStore);
    }

    public void testSave() {
        ConnectorMock mock = new ConnectorMock();
        TerminalConnector c = new TerminalConnector((TerminalConnector.Factory)new SimpleFactory(mock), "xID", "xName", false);
        SettingsMock s = new SettingsMock();
        c.save((ISettingsStore)s);
        TerminalConnectorTest.assertNull((Object)mock.fSaveStore);
        c.connect((ITerminalControl)new TerminalControlMock());
        c.save((ISettingsStore)s);
        TerminalConnectorTest.assertSame((Object)s, (Object)mock.fSaveStore);
    }

    public void testSetDefaultSettings() {
        ConnectorMock mock = new ConnectorMock();
        TerminalConnector c = new TerminalConnector((TerminalConnector.Factory)new SimpleFactory(mock), "xID", "xName", false);
        c.setDefaultSettings();
    }

    public void testSetTerminalSize() {
        ConnectorMock mock = new ConnectorMock();
        TerminalConnector c = new TerminalConnector((TerminalConnector.Factory)new SimpleFactory(mock), "xID", "xName", false);
        c.setTerminalSize(100, 200);
    }

    static class ConnectorMock
    extends TerminalConnectorImpl {
        public boolean fEcho;
        public int fWidth;
        public int fHeight;
        public ITerminalControl fTerminalControl;
        public ISettingsStore fSaveStore;
        public ISettingsStore fLoadStore;
        public boolean fDisconnect;

        ConnectorMock() {
        }

        public boolean isLocalEcho() {
            return this.fEcho;
        }

        public void setTerminalSize(int newWidth, int newHeight) {
            this.fWidth = newWidth;
            this.fHeight = newHeight;
        }

        public void connect(ITerminalControl control) {
            super.connect(control);
            this.fTerminalControl = control;
        }

        public void doDisconnect() {
            this.fDisconnect = true;
        }

        public OutputStream getTerminalToRemoteStream() {
            return null;
        }

        public String getSettingsSummary() {
            return "Summary";
        }

        public void load(ISettingsStore store) {
            this.fLoadStore = store;
        }

        public void save(ISettingsStore store) {
            this.fSaveStore = store;
        }
    }

    public class SettingsMock
    implements ISettingsStore {
        public String get(String key) {
            return null;
        }

        public String get(String key, String defaultValue) {
            return null;
        }

        public void put(String key, String value) {
        }
    }

    static class SimpleFactory
    implements TerminalConnector.Factory {
        final TerminalConnectorImpl fConnector;

        public SimpleFactory(TerminalConnectorImpl connector) {
            this.fConnector = connector;
        }

        public TerminalConnectorImpl makeConnector() throws Exception {
            return this.fConnector;
        }
    }

    public static class TerminalControlMock
    implements ITerminalControl {
        public void setEncoding(String encoding) {
        }

        public String getEncoding() {
            return "ISO-8859-1";
        }

        public void displayTextInTerminal(String text) {
        }

        public OutputStream getRemoteToTerminalOutputStream() {
            return null;
        }

        public Shell getShell() {
            return null;
        }

        public TerminalState getState() {
            return null;
        }

        public void setMsg(String msg) {
        }

        public void setState(TerminalState state) {
        }

        public void setTerminalTitle(String title) {
        }

        public void setupTerminal(Composite parent) {
        }

        public boolean isConnectOnEnterIfClosed() {
            return false;
        }

        public void setConnectOnEnterIfClosed(boolean on) {
        }

        public void setVT100LineWrapping(boolean enable) {
        }

        public boolean isVT100LineWrapping() {
            return false;
        }
    }
}

