/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.internal.terminal.test.terminalcanvas;

import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ScrollBar;

public class TerminalTextCanvas
extends Canvas {
    Image image;
    Point origin = new Point(0, 0);

    public TerminalTextCanvas(Composite parent, int style) {
        super(parent, 0x140300 | style);
        this.loadImage(parent);
        final ScrollBar hBar = this.getHorizontalBar();
        hBar.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                int hSelection = hBar.getSelection();
                int destX = -hSelection - TerminalTextCanvas.this.origin.x;
                Rectangle rect = TerminalTextCanvas.this.image.getBounds();
                TerminalTextCanvas.this.scroll(destX, 0, 0, 0, rect.width, rect.height, false);
                TerminalTextCanvas.this.origin.x = -hSelection;
            }
        });
        final ScrollBar vBar = this.getVerticalBar();
        vBar.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                int vSelection = vBar.getSelection();
                int destY = -vSelection - TerminalTextCanvas.this.origin.y;
                Rectangle rect = TerminalTextCanvas.this.image.getBounds();
                TerminalTextCanvas.this.scroll(0, destY, 0, 0, rect.width, rect.height, false);
                TerminalTextCanvas.this.origin.y = -vSelection;
            }
        });
        this.addListener(11, new Listener(){

            public void handleEvent(Event e) {
                Rectangle rect = TerminalTextCanvas.this.image.getBounds();
                Rectangle client = TerminalTextCanvas.this.getClientArea();
                hBar.setMaximum(rect.width);
                vBar.setMaximum(rect.height);
                hBar.setThumb(Math.min(rect.width, client.width));
                vBar.setThumb(Math.min(rect.height, client.height));
                int hPage = rect.width - client.width;
                int vPage = rect.height - client.height;
                int hSelection = hBar.getSelection();
                int vSelection = vBar.getSelection();
                if (hSelection >= hPage) {
                    if (hPage <= 0) {
                        hSelection = 0;
                    }
                    TerminalTextCanvas.this.origin.x = -hSelection;
                }
                if (vSelection >= vPage) {
                    if (vPage <= 0) {
                        vSelection = 0;
                    }
                    TerminalTextCanvas.this.origin.y = -vSelection;
                }
                TerminalTextCanvas.this.redraw();
            }
        });
        this.addListener(9, new Listener(){

            public void handleEvent(Event e) {
                int marginHeight;
                GC gc = e.gc;
                System.out.println(gc.getClipping() + " " + TerminalTextCanvas.this.origin);
                gc.drawImage(TerminalTextCanvas.this.image, TerminalTextCanvas.this.origin.x, TerminalTextCanvas.this.origin.y);
                Rectangle rect = TerminalTextCanvas.this.image.getBounds();
                Rectangle client = TerminalTextCanvas.this.getClientArea();
                int marginWidth = client.width - rect.width;
                if (marginWidth > 0) {
                    gc.fillRectangle(rect.width, 0, marginWidth, client.height);
                }
                if ((marginHeight = client.height - rect.height) > 0) {
                    gc.fillRectangle(0, rect.height, client.width, marginHeight);
                }
            }
        });
    }

    private void loadImage(Composite parent) {
        FileDialog dialog = new FileDialog(parent.getShell(), 4096);
        dialog.setText("Open an image file or cancel");
        String string = dialog.open();
        if (string != null) {
            this.image = new Image((Device)this.getDisplay(), string);
        }
    }
}

