/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.internal.terminal.connector;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import junit.framework.TestCase;
import org.eclipse.tm.internal.terminal.connector.TerminalToRemoteInjectionOutputStream;

public class TerminalToRemoteInjectionOutputStreamTest
extends TestCase {
    static final String ENCODING = "UTF-8";

    public void testClose() throws UnsupportedEncodingException, IOException {
        ByteArrayOutputStream bs = new ByteArrayOutputStream();
        TerminalToRemoteInjectionOutputStream s = new TerminalToRemoteInjectionOutputStream((OutputStream)bs);
        s.write("begin:".getBytes(ENCODING));
        TerminalToRemoteInjectionOutputStreamTest.assertEquals((String)"begin:", (String)new String(bs.toByteArray(), ENCODING));
        OutputStream os1 = s.grabOutput();
        os1.write(120);
        s.write(65);
        os1.write(121);
        s.write(66);
        os1.close();
        s.write(45);
        OutputStream os = s.grabOutput();
        try {
            os1.write(107);
            TerminalToRemoteInjectionOutputStreamTest.fail((String)"...");
        }
        catch (Exception exception) {
            // empty catch block
        }
        os.write(88);
        s.write(97);
        os.write(89);
        try {
            os1.write(108);
            TerminalToRemoteInjectionOutputStreamTest.fail((String)"...");
        }
        catch (Exception exception) {
            // empty catch block
        }
        s.write(98);
        os.close();
        TerminalToRemoteInjectionOutputStreamTest.assertEquals((String)"begin:xyAB-XYab", (String)new String(bs.toByteArray(), ENCODING));
    }

    public void testFlush() {
    }

    public void testWriteInt() throws UnsupportedEncodingException, IOException {
        ByteArrayOutputStream bs = new ByteArrayOutputStream();
        TerminalToRemoteInjectionOutputStream s = new TerminalToRemoteInjectionOutputStream((OutputStream)bs);
        s.write("begin:".getBytes(ENCODING));
        TerminalToRemoteInjectionOutputStreamTest.assertEquals((String)"begin:", (String)new String(bs.toByteArray(), ENCODING));
        OutputStream os = s.grabOutput();
        os.write(120);
        s.write(65);
        os.write(121);
        s.write(66);
        s.close();
        TerminalToRemoteInjectionOutputStreamTest.assertEquals((String)"begin:xyAB", (String)new String(bs.toByteArray(), ENCODING));
    }

    public void testWriteByteArray() {
    }

    public void testWriteByteArrayIntInt() {
    }

    public void testGrabOutput() throws UnsupportedEncodingException, IOException {
        OutputStream os2;
        ByteArrayOutputStream bs = new ByteArrayOutputStream();
        TerminalToRemoteInjectionOutputStream s = new TerminalToRemoteInjectionOutputStream((OutputStream)bs);
        s.write("begin:".getBytes(ENCODING));
        TerminalToRemoteInjectionOutputStreamTest.assertEquals((String)"begin:", (String)new String(bs.toByteArray(), ENCODING));
        OutputStream os1 = s.grabOutput();
        try {
            os2 = s.grabOutput();
            TerminalToRemoteInjectionOutputStreamTest.fail((String)"should fail until the foirst output is closed");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        os1.close();
        os2 = s.grabOutput();
        TerminalToRemoteInjectionOutputStreamTest.assertEquals((String)"begin:", (String)new String(bs.toByteArray(), ENCODING));
        os2.write("Test".getBytes(ENCODING));
        TerminalToRemoteInjectionOutputStreamTest.assertEquals((String)"begin:Test", (String)new String(bs.toByteArray(), ENCODING));
        s.write(" west".getBytes(ENCODING));
        TerminalToRemoteInjectionOutputStreamTest.assertEquals((String)"begin:Test", (String)new String(bs.toByteArray(), ENCODING));
        os2.write(" the".getBytes(ENCODING));
        TerminalToRemoteInjectionOutputStreamTest.assertEquals((String)"begin:Test the", (String)new String(bs.toByteArray(), ENCODING));
        os2.close();
        TerminalToRemoteInjectionOutputStreamTest.assertEquals((String)"begin:Test the west", (String)new String(bs.toByteArray(), ENCODING));
        s.write(33);
        TerminalToRemoteInjectionOutputStreamTest.assertEquals((String)"begin:Test the west!", (String)new String(bs.toByteArray(), ENCODING));
    }

    public void testGrabOutputWithCleverInterceptor() throws UnsupportedEncodingException, IOException {
        ByteArrayOutputStream bs = new ByteArrayOutputStream();
        TerminalToRemoteInjectionOutputStream s = new TerminalToRemoteInjectionOutputStream((OutputStream)bs);
        s.write("begin:".getBytes(ENCODING));
        TerminalToRemoteInjectionOutputStreamTest.assertEquals((String)"begin:", (String)new String(bs.toByteArray(), ENCODING));
        OutputStream os = s.grabOutput((TerminalToRemoteInjectionOutputStream.Interceptor)new CleverInterceptor());
        TerminalToRemoteInjectionOutputStreamTest.assertEquals((String)"begin:", (String)new String(bs.toByteArray(), ENCODING));
        os.write("Test".getBytes(ENCODING));
        TerminalToRemoteInjectionOutputStreamTest.assertEquals((String)"begin:Test", (String)new String(bs.toByteArray(), ENCODING));
        s.write(" west".getBytes(ENCODING));
        TerminalToRemoteInjectionOutputStreamTest.assertEquals((String)"begin:Test[ west]", (String)new String(bs.toByteArray(), ENCODING));
        os.write(" the".getBytes(ENCODING));
        TerminalToRemoteInjectionOutputStreamTest.assertEquals((String)"begin:Test[ west] the", (String)new String(bs.toByteArray(), ENCODING));
        s.write(120);
        TerminalToRemoteInjectionOutputStreamTest.assertEquals((String)"begin:Test[ west] the[x]", (String)new String(bs.toByteArray(), ENCODING));
        os.close();
        TerminalToRemoteInjectionOutputStreamTest.assertEquals((String)"begin:Test[ west] the[x]", (String)new String(bs.toByteArray(), ENCODING));
        s.write(33);
        TerminalToRemoteInjectionOutputStreamTest.assertEquals((String)"begin:Test[ west] the[x]!", (String)new String(bs.toByteArray(), ENCODING));
    }

    public void testGrabOutputWithNullInterceptor() throws UnsupportedEncodingException, IOException {
        ByteArrayOutputStream bs = new ByteArrayOutputStream();
        TerminalToRemoteInjectionOutputStream s = new TerminalToRemoteInjectionOutputStream((OutputStream)bs);
        s.write("begin:".getBytes(ENCODING));
        TerminalToRemoteInjectionOutputStreamTest.assertEquals((String)"begin:", (String)new String(bs.toByteArray(), ENCODING));
        OutputStream os = s.grabOutput((TerminalToRemoteInjectionOutputStream.Interceptor)new NullInterceptor());
        TerminalToRemoteInjectionOutputStreamTest.assertEquals((String)"begin:", (String)new String(bs.toByteArray(), ENCODING));
        os.write("Test".getBytes(ENCODING));
        TerminalToRemoteInjectionOutputStreamTest.assertEquals((String)"begin:Test", (String)new String(bs.toByteArray(), ENCODING));
        s.write(" west".getBytes(ENCODING));
        TerminalToRemoteInjectionOutputStreamTest.assertEquals((String)"begin:Test", (String)new String(bs.toByteArray(), ENCODING));
        os.write(" the".getBytes(ENCODING));
        TerminalToRemoteInjectionOutputStreamTest.assertEquals((String)"begin:Test the", (String)new String(bs.toByteArray(), ENCODING));
        s.write(120);
        TerminalToRemoteInjectionOutputStreamTest.assertEquals((String)"begin:Test the", (String)new String(bs.toByteArray(), ENCODING));
        os.close();
        TerminalToRemoteInjectionOutputStreamTest.assertEquals((String)"begin:Test the", (String)new String(bs.toByteArray(), ENCODING));
        s.write(33);
        TerminalToRemoteInjectionOutputStreamTest.assertEquals((String)"begin:Test the!", (String)new String(bs.toByteArray(), ENCODING));
    }

    class CleverInterceptor
    extends TerminalToRemoteInjectionOutputStream.Interceptor {
        CleverInterceptor() {
        }

        public void close() throws IOException {
        }

        public void write(int b) throws IOException {
            this.fOriginal.write(91);
            this.fOriginal.write(b);
            this.fOriginal.write(93);
        }

        public void write(byte[] b, int off, int len) throws IOException {
            this.fOriginal.write(91);
            this.fOriginal.write(b, off, len);
            this.fOriginal.write(93);
        }
    }

    class NullInterceptor
    extends TerminalToRemoteInjectionOutputStream.Interceptor {
        NullInterceptor() {
        }
    }
}

