/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.internal.terminal.speedtest;

import org.eclipse.tm.internal.terminal.provisional.api.ISettingsStore;

public class SpeedTestSettings {
    String fInputFile = "";
    String fBufferSize = "";
    String fThrottle;

    String getInputFile() {
        return this.fInputFile;
    }

    public String getBufferSizeString() {
        return String.valueOf(this.getBufferSize());
    }

    public void setBufferSizeString(String bufferSize) {
        this.fBufferSize = bufferSize;
    }

    public int getBufferSize() {
        try {
            return Integer.parseInt(this.fBufferSize);
        }
        catch (RuntimeException e) {
            return 1024;
        }
    }

    void setInputFile(String testFile) {
        this.fInputFile = testFile;
    }

    public void load(ISettingsStore store) {
        this.fInputFile = store.get("inputFile", "");
        this.fBufferSize = store.get("bufferSize", "");
        this.fThrottle = store.get("throttle", "0");
    }

    public void save(ISettingsStore store) {
        store.put("inputFile", this.fInputFile);
        store.put("bufferSize", this.fBufferSize);
        store.put("throttle", this.fThrottle);
    }

    public String getThrottleString() {
        return this.fThrottle;
    }

    public int getThrottle() {
        try {
            return Integer.parseInt(this.fThrottle);
        }
        catch (RuntimeException e) {
            return 0;
        }
    }

    public void setThrottleString(String throttle) {
        this.fThrottle = throttle;
    }
}

