/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dstore.core.util.ssl;

import java.security.KeyStore;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import org.eclipse.dstore.core.util.ssl.DStoreKeyStore;
import org.eclipse.dstore.core.util.ssl.DataStoreTrustManager;

public class DStoreSSLContext {
    public static SSLContext getServerSSLContext(String filePath, String password) {
        SSLContext serverContext = null;
        try {
            KeyStore ks = DStoreKeyStore.getKeyStore(filePath, password);
            String keymgrAlgorithm = KeyManagerFactory.getDefaultAlgorithm();
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(keymgrAlgorithm);
            kmf.init(ks, password.toCharArray());
            serverContext = SSLContext.getInstance("SSL");
            serverContext.init(kmf.getKeyManagers(), null, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return serverContext;
    }

    public static SSLContext getClientSSLContext(String filePath, String password, DataStoreTrustManager trustManager) {
        SSLContext clientContext = null;
        try {
            trustManager.setKeystore(filePath, password);
            clientContext = SSLContext.getInstance("SSL");
            TrustManager[] mgrs = new TrustManager[]{trustManager};
            clientContext.init(null, mgrs, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return clientContext;
    }
}

