/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.core;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.rse.core.IRSECoreRegistry;
import org.eclipse.rse.core.internal.RSECoreRegistry;
import org.eclipse.rse.core.model.ISystemRegistry;
import org.eclipse.rse.internal.persistence.RSEPersistenceManager;
import org.eclipse.rse.logging.Logger;
import org.eclipse.rse.logging.LoggerFactory;
import org.eclipse.rse.persistence.IRSEPersistenceManager;
import org.osgi.framework.BundleContext;

public class RSECorePlugin
extends Plugin {
    private static RSECorePlugin plugin;
    private Logger logger = null;
    private ISystemRegistry _registry;
    private IRSEPersistenceManager _persistenceManager = null;

    public static IRSEPersistenceManager getThePersistenceManager() {
        return RSECorePlugin.getDefault().getPersistenceManager();
    }

    public IRSEPersistenceManager getPersistenceManager() {
        if (this._persistenceManager == null) {
            this._persistenceManager = new RSEPersistenceManager(this._registry);
        }
        return this._persistenceManager;
    }

    public static String getLocalMachineName() {
        String machineName = null;
        try {
            machineName = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            RSECorePlugin.getDefault().log(e);
        }
        return machineName;
    }

    public static String getLocalMachineIPAddress() {
        String machineAddress = null;
        try {
            machineAddress = InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException e) {
            RSECorePlugin.getDefault().log(e);
        }
        return machineAddress;
    }

    public RSECorePlugin() {
        plugin = this;
    }

    public void setSystemRegistry(ISystemRegistry registry) {
        this._registry = registry;
    }

    public ISystemRegistry getSystemRegistry() {
        return this._registry;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.logger = LoggerFactory.getLogger((Plugin)this);
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        LoggerFactory.freeLogger((Plugin)this);
        this.logger = null;
        plugin = null;
    }

    public static RSECorePlugin getDefault() {
        return plugin;
    }

    public IRSECoreRegistry getRegistry() {
        return RSECoreRegistry.getDefault();
    }

    public Logger getLogger() {
        return this.logger;
    }

    private void log(Throwable t) {
        String pluginId = this.getBundle().getSymbolicName();
        Status status = new Status(4, pluginId, 0, "Unexpected Exception", t);
        this.getLog().log((IStatus)status);
    }
}

