/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.eclipse.filesystem;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.provider.FileInfo;
import org.eclipse.core.filesystem.provider.FileStore;
import org.eclipse.core.internal.filesystem.Messages;
import org.eclipse.core.internal.filesystem.Policy;
import org.eclipse.core.internal.resources.ModelObjectWriter;
import org.eclipse.core.internal.resources.ProjectDescription;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.osgi.util.NLS;
import org.eclipse.rse.core.model.ISystemContentsType;
import org.eclipse.rse.core.subsystems.RemoteChildrenContentsType;
import org.eclipse.rse.eclipse.filesystem.FileStoreConversionUtility;
import org.eclipse.rse.files.ui.resources.SystemEditableRemoteFile;
import org.eclipse.rse.files.ui.resources.UniversalFileTransferUtility;
import org.eclipse.rse.services.clientserver.messages.SystemMessageException;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFile;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFileSubSystem;
import org.eclipse.rse.subsystems.files.core.subsystems.RemoteFileEmpty;
import org.eclipse.rse.ui.RSEUIPlugin;

public class RSEFileStoreRemoteFileWrapper
extends FileStore
implements IFileStore {
    private IRemoteFile _remoteFile;
    private IRemoteFileSubSystem _subSystem;
    private IFileStore _parent;

    public RSEFileStoreRemoteFileWrapper(IFileStore parent, IRemoteFile remoteFile) {
        this._remoteFile = remoteFile;
        this._parent = parent;
        this._subSystem = this._remoteFile.getParentRemoteFileSubSystem();
    }

    public IRemoteFileSubSystem getRemoteFileSubSystem() {
        return this._subSystem;
    }

    public String[] childNames(int options, IProgressMonitor monitor) {
        String[] names;
        IPreferenceStore prefStore = RSEUIPlugin.getDefault().getPreferenceStore();
        prefStore.setValue("org.eclipse.rse.preferences.showhidden", true);
        if (!this._remoteFile.isStale() && this._remoteFile.hasContents((ISystemContentsType)RemoteChildrenContentsType.getInstance())) {
            Object[] children = this._remoteFile.getContents((ISystemContentsType)RemoteChildrenContentsType.getInstance());
            names = new String[children.length];
            int i = 0;
            while (i < children.length) {
                names[i] = ((IRemoteFile)children[i]).getName();
                ++i;
            }
        } else {
            try {
                IRemoteFile[] children = this._subSystem.listFoldersAndFiles(this._remoteFile, monitor);
                names = new String[children.length];
                int i = 0;
                while (i < children.length) {
                    names[i] = children[i].getName();
                    ++i;
                }
            }
            catch (SystemMessageException systemMessageException) {
                names = new String[]{};
            }
        }
        prefStore.setValue("org.eclipse.rse.preferences.showhidden", false);
        return names;
    }

    public IFileInfo fetchInfo(int options, IProgressMonitor monitor) throws CoreException {
        if (this._remoteFile.isStale()) {
            try {
                this._remoteFile = this._subSystem.getRemoteFileObject(this._remoteFile.getAbsolutePath());
            }
            catch (Exception exception) {}
        }
        FileInfo info = new FileInfo(this.getName());
        boolean exists = this._remoteFile.exists();
        info.setExists(exists);
        if (exists) {
            info.setLastModified(this._remoteFile.getLastModified());
            boolean isDir = this._remoteFile.isDirectory();
            info.setDirectory(isDir);
            info.setAttribute(2, !this._remoteFile.canWrite());
            info.setAttribute(4, this._remoteFile.isExecutable());
            info.setAttribute(8, this._remoteFile.isArchive());
            info.setAttribute(16, this._remoteFile.isHidden());
            if (!isDir) {
                info.setLength(this._remoteFile.getLength());
            }
        }
        info.setName(this.getName());
        return info;
    }

    public String getName() {
        return this._remoteFile.getName();
    }

    public IFileStore getParent() {
        if (this._parent == null) {
            this._parent = new RSEFileStoreRemoteFileWrapper(null, this._remoteFile.getParentRemoteFile());
        }
        return this._parent;
    }

    public boolean isParentOf(IFileStore other) {
        if (other instanceof RSEFileStoreRemoteFileWrapper) {
            RSEFileStoreRemoteFileWrapper otherWrapper = (RSEFileStoreRemoteFileWrapper)other;
            RSEFileStoreRemoteFileWrapper parent = (RSEFileStoreRemoteFileWrapper)otherWrapper.getParent();
            return this._remoteFile == parent._remoteFile;
        }
        return false;
    }

    public synchronized InputStream openInputStream(int options, IProgressMonitor monitor) throws CoreException {
        if (this._remoteFile.exists()) {
            IFile file = null;
            if (this._remoteFile.isFile() && this._subSystem.isConnected()) {
                if (this._remoteFile.getName().equals(".project") && this._remoteFile.getLength() == 0L) {
                    System.out.println("reading empty .project");
                    InputStream stream = this.getDummyProjectFileStream();
                    try {
                        int size = stream.available();
                        this._subSystem.upload(stream, (long)size, this._remoteFile, "utf8", monitor);
                        this._remoteFile = this._subSystem.getRemoteFileObject(this._remoteFile.getAbsolutePath());
                    }
                    catch (Exception exception) {}
                }
                if (!(file != null && file.exists() || (file = (IFile)UniversalFileTransferUtility.copyRemoteResourceToWorkspace((IRemoteFile)this._remoteFile, (IProgressMonitor)monitor)) == null)) {
                    file.isSynchronized(0);
                }
            } else {
                file = (IFile)UniversalFileTransferUtility.getTempFileFor((IRemoteFile)this._remoteFile);
            }
            if (!file.isSynchronized(0) && !this._remoteFile.getName().equals(".project")) {
                try {
                    file.refreshLocal(0, monitor);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (file != null) {
                if (file.isSynchronized(0)) {
                    return file.getContents();
                }
                File osFile = file.getLocation().toFile();
                try {
                    FileInputStream instream = new FileInputStream(osFile);
                    return instream;
                }
                catch (Exception exception) {}
            }
        }
        return null;
    }

    private InputStream getDummyProjectFileStream() {
        ProjectDescription description = new ProjectDescription();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            new ModelObjectWriter().write((Object)description, (OutputStream)out);
        }
        catch (IOException iOException) {}
        byte[] newContents = out.toByteArray();
        ByteArrayInputStream in = new ByteArrayInputStream(newContents);
        return in;
    }

    public URI toURI() {
        try {
            String path = this._remoteFile.getAbsolutePath();
            if (path.charAt(0) != '/') {
                path = "/" + path.replace('\\', '/');
            }
            return new URI("rse", this._subSystem.getHost().getHostName(), path, null);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public IFileStore mkdir(int options, IProgressMonitor monitor) throws CoreException {
        if (!this._remoteFile.exists()) {
            try {
                this._subSystem.createFolder(this._remoteFile);
                this._remoteFile = this._subSystem.getRemoteFileObject(this._remoteFile.getAbsolutePath());
            }
            catch (Exception exception) {}
        }
        return this;
    }

    public OutputStream openOutputStream(int options, IProgressMonitor monitor) throws CoreException {
        monitor = Policy.monitorFor((IProgressMonitor)monitor);
        File file = null;
        try {
            if (!this._remoteFile.exists()) {
                this._subSystem.createFile(this._remoteFile);
                this._remoteFile = this._subSystem.getRemoteFileObject(this._remoteFile.getAbsolutePath());
            }
            SystemEditableRemoteFile editable = new SystemEditableRemoteFile(this._remoteFile);
            editable.download(monitor);
            IFile localFile = editable.getLocalResource();
            file = localFile.getLocation().toFile();
            monitor.beginTask(null, 1);
            FileOutputStream fileOutputStream = new FileOutputStream(file, (options & 1) != 0);
            return fileOutputStream;
        }
        catch (FileNotFoundException e) {
            String path = this._remoteFile.getAbsolutePath();
            String message = file.isDirectory() ? NLS.bind((String)Messages.notAFile, (Object)path) : NLS.bind((String)Messages.couldNotWrite, (Object)path);
            Policy.error((int)272, (String)message, (Throwable)e);
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            monitor.done();
        }
        return null;
    }

    public IFileStore getChild(IPath path) {
        RSEFileStoreRemoteFileWrapper result = this;
        int i = 0;
        int imax = path.segmentCount();
        while (i < imax) {
            String segment = path.segment(i);
            result = result.getChild(segment);
            ++i;
        }
        return result;
    }

    public IFileStore getChild(String name) {
        if (!this._remoteFile.isStale() && this._remoteFile.hasContents((ISystemContentsType)RemoteChildrenContentsType.getInstance(), name)) {
            Object[] children = this._remoteFile.getContents((ISystemContentsType)RemoteChildrenContentsType.getInstance(), name);
            if (children != null && children.length > 0) {
                return FileStoreConversionUtility.convert(this._parent, (IRemoteFile)children[0]);
            }
            try {
                IRemoteFile child = this._subSystem.getRemoteFileObject(this._remoteFile, name);
                return FileStoreConversionUtility.convert(this._parent, child);
            }
            catch (Exception exception) {}
        } else if (this._remoteFile.isDirectory()) {
            try {
                IRemoteFile child = this._subSystem.getRemoteFileObject(this._remoteFile, name);
                return FileStoreConversionUtility.convert(this._parent, child);
            }
            catch (Exception exception) {}
        }
        return null;
    }

    public File toLocalFile(int options, IProgressMonitor monitor) throws CoreException {
        IResource file = null;
        if (this._remoteFile.exists()) {
            file = this._remoteFile.isFile() && this._subSystem.isConnected() ? (IResource)UniversalFileTransferUtility.copyRemoteResourceToWorkspace((IRemoteFile)this._remoteFile, (IProgressMonitor)monitor) : UniversalFileTransferUtility.getTempFileFor((IRemoteFile)this._remoteFile);
            return file.getLocation().toFile();
        }
        if (this._remoteFile.getName().equals(".project")) {
            file = UniversalFileTransferUtility.getTempFileFor((IRemoteFile)this._remoteFile);
            return file.getLocation().toFile();
        }
        if (this._remoteFile instanceof RemoteFileEmpty) {
            try {
                return File.createTempFile(this._remoteFile.getName(), "empty");
            }
            catch (Exception exception) {}
        }
        return null;
    }

    public void delete(int options, IProgressMonitor monitor) throws CoreException {
        try {
            this._subSystem.delete(this._remoteFile, monitor);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

