/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.eclipse.filesystem;

import java.net.URI;
import java.util.HashMap;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.provider.FileSystem;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.subsystems.IConnectorService;
import org.eclipse.rse.eclipse.filesystem.FileStoreConversionUtility;
import org.eclipse.rse.eclipse.filesystem.RSEFileStoreRemoteFileWrapper;
import org.eclipse.rse.model.SystemRegistry;
import org.eclipse.rse.subsystems.files.core.model.RemoteFileUtility;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFile;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFileSubSystem;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.ui.PlatformUI;

public class RSEFileSystem
extends FileSystem {
    private static RSEFileSystem _instance = new RSEFileSystem();
    private HashMap _fileStoreMap = new HashMap();

    public static RSEFileSystem getInstance() {
        return _instance;
    }

    public boolean canDelete() {
        return true;
    }

    public boolean canWrite() {
        return true;
    }

    public static IHost getConnectionFor(String hostName) {
        SystemRegistry sr = RSEUIPlugin.getTheSystemRegistry();
        IHost[] connections = sr.getHosts();
        IHost unconnected = null;
        int i = 0;
        while (i < connections.length) {
            IHost con = connections[i];
            if (con.getHostName().equalsIgnoreCase(hostName)) {
                boolean isConnected = false;
                IConnectorService[] connectorServices = con.getConnectorServices();
                int c = 0;
                while (c < connectorServices.length && !isConnected) {
                    IConnectorService serv = connectorServices[c];
                    isConnected = serv.isConnected();
                    ++c;
                }
                if (isConnected) {
                    return con;
                }
                unconnected = con;
            }
            ++i;
        }
        return unconnected;
    }

    public static IRemoteFileSubSystem getRemoteFileSubSystem(IHost host) {
        return RemoteFileUtility.getFileSubSystem((IHost)host);
    }

    public URI getURIFor(IRemoteFile file) {
        IFileStore fstore = FileStoreConversionUtility.convert(null, file);
        return fstore.toURI();
    }

    public IFileStore getStore(URI uri) {
        Object obj = this._fileStoreMap.get(uri);
        if (obj != null) {
            RSEFileStoreRemoteFileWrapper store = (RSEFileStoreRemoteFileWrapper)((Object)obj);
            IRemoteFileSubSystem ss = store.getRemoteFileSubSystem();
            if (!ss.isConnected()) {
                if (PlatformUI.isWorkbenchRunning()) {
                    PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                }
                try {
                    ss.connect();
                }
                catch (Exception exception) {
                    return null;
                }
            }
            return store;
        }
        try {
            IRemoteFileSubSystem fs;
            String path = uri.getPath();
            String hostName = uri.getHost();
            IHost con = RSEFileSystem.getConnectionFor(hostName);
            if (con != null && (fs = RSEFileSystem.getRemoteFileSubSystem(con)) != null) {
                if (!fs.isConnected()) {
                    fs.getConnectorService().promptForPassword(false);
                    fs.getConnectorService().connect((IProgressMonitor)new NullProgressMonitor());
                }
                if (fs.isConnected()) {
                    IFileStore fstore = FileStoreConversionUtility.convert(null, fs.getRemoteFileObject(path));
                    this._fileStoreMap.put(uri, fstore);
                    return fstore;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return EFS.getNullFileSystem().getStore(uri);
        }
        return null;
    }
}

