/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.services.ssh.shell;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.rse.services.clientserver.messages.SystemMessage;
import org.eclipse.rse.services.shells.IHostShell;
import org.eclipse.rse.services.shells.IShellService;
import org.eclipse.rse.services.ssh.ISshService;
import org.eclipse.rse.services.ssh.ISshSessionProvider;
import org.eclipse.rse.services.ssh.SshServiceResources;
import org.eclipse.rse.services.ssh.shell.SshHostShell;

public class SshShellService
implements ISshService,
IShellService {
    private ISshSessionProvider fSessionProvider;

    public SshShellService(ISshSessionProvider sessionProvider) {
        this.fSessionProvider = sessionProvider;
    }

    public IHostShell launchShell(IProgressMonitor monitor, String initialWorkingDirectory, String[] environment) {
        String defaultEncoding = System.getProperty("file.encoding");
        return this.launchShell(monitor, initialWorkingDirectory, defaultEncoding, environment);
    }

    public IHostShell launchShell(IProgressMonitor monitor, String initialWorkingDirectory, String encoding, String[] environment) {
        SshHostShell hostShell = new SshHostShell(this.fSessionProvider, initialWorkingDirectory, ">", encoding, environment);
        return hostShell;
    }

    public IHostShell runCommand(IProgressMonitor monitor, String initialWorkingDirectory, String command, String[] environment) {
        String defaultEncoding = System.getProperty("file.encoding");
        return this.runCommand(monitor, initialWorkingDirectory, command, defaultEncoding, environment);
    }

    public IHostShell runCommand(IProgressMonitor monitor, String initialWorkingDirectory, String command, String encoding, String[] environment) {
        SshHostShell hostShell = new SshHostShell(this.fSessionProvider, initialWorkingDirectory, command, encoding, environment);
        return hostShell;
    }

    public String[] getHostEnvironment() {
        return new String[0];
    }

    public String getName() {
        return SshServiceResources.SshShellService_Name;
    }

    public String getDescription() {
        return SshServiceResources.SshShellService_Description;
    }

    public void initService(IProgressMonitor monitor) {
    }

    public void uninitService(IProgressMonitor monitor) {
    }

    public SystemMessage getMessage(String messageID) {
        return null;
    }
}

