/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.services.clientserver.processes.handlers;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.SortedSet;
import java.util.TreeSet;
import org.eclipse.rse.services.clientserver.processes.HostProcessFilterImpl;
import org.eclipse.rse.services.clientserver.processes.IHostProcess;
import org.eclipse.rse.services.clientserver.processes.IHostProcessFilter;
import org.eclipse.rse.services.clientserver.processes.ISystemProcessRemoteConstants;
import org.eclipse.rse.services.clientserver.processes.handlers.ProcessComparator;
import org.eclipse.rse.services.clientserver.processes.handlers.ProcessHandler;
import org.eclipse.rse.services.clientserver.processes.handlers.UniversalServerProcessImpl;

public class UniversalAIXProcessHandler
implements ProcessHandler,
ISystemProcessRemoteConstants {
    private static final String[] processAttributes = new String[]{"pid", "ppid", "comm", "uid", "user", "gid", "vsz", "s", "rss"};
    private static final String firstColumnHeader = "PID";
    protected HashMap _usernamesByUid;
    protected HashMap _uidsByUserName;
    private HashMap stateMap = new HashMap();

    public UniversalAIXProcessHandler() {
        int i = 0;
        while (i < 9) {
            this.stateMap.put(new Character(ALL_STATES[i]), ALL_STATES_STR[i]);
            ++i;
        }
    }

    public SortedSet lookupProcesses(IHostProcessFilter rpfs) throws Exception {
        TreeSet<UniversalServerProcessImpl> results = new TreeSet<UniversalServerProcessImpl>(new ProcessComparator());
        String cmdLine = "/usr/sysv/bin/ps -Alf -o ";
        int i = 0;
        while (i < processAttributes.length) {
            cmdLine = String.valueOf(cmdLine) + processAttributes[i];
            if (processAttributes.length - i > 1) {
                cmdLine = String.valueOf(cmdLine) + ",";
            }
            ++i;
        }
        Process ps = Runtime.getRuntime().exec(cmdLine);
        InputStreamReader isr = new InputStreamReader(ps.getInputStream());
        if (isr == null) {
            return null;
        }
        BufferedReader reader = new BufferedReader(isr);
        if (reader == null) {
            return null;
        }
        String nextLine = reader.readLine();
        if (nextLine != null && nextLine.trim().startsWith(firstColumnHeader)) {
            nextLine = reader.readLine();
        }
        while (nextLine != null) {
            String statusLine = "";
            HashMap psLineContents = this.getPSOutput(nextLine);
            if (psLineContents == null) {
                nextLine = reader.readLine();
                continue;
            }
            String pid = (String)psLineContents.get("pid");
            statusLine = String.valueOf(pid) + "|";
            String name = (String)psLineContents.get("comm");
            if (name == null) {
                name = " ";
            }
            statusLine = String.valueOf(statusLine) + name + "|";
            String state = (String)psLineContents.get("s");
            if (state == null) {
                state = " ";
            }
            String stateCode = this.convertToStateCode(state);
            statusLine = String.valueOf(statusLine) + stateCode + "|";
            String tgid = (String)psLineContents.get("tgid");
            if (tgid == null) {
                tgid = " ";
            }
            statusLine = String.valueOf(statusLine) + tgid + "|";
            String pPid = (String)psLineContents.get("ppid");
            if (pPid == null) {
                pPid = " ";
            }
            statusLine = String.valueOf(statusLine) + pPid + "|";
            String tracerpid = (String)psLineContents.get("tracerpid");
            if (tracerpid == null) {
                tracerpid = " ";
            }
            statusLine = String.valueOf(statusLine) + tracerpid + "|";
            String uid = (String)psLineContents.get("uid");
            if (uid == null) {
                uid = " ";
            }
            statusLine = String.valueOf(statusLine) + uid + "|";
            String username = (String)psLineContents.get("user");
            if (username == null) {
                username = " ";
            }
            statusLine = String.valueOf(statusLine) + username + "|";
            String gid = (String)psLineContents.get("gid");
            if (gid == null) {
                gid = " ";
            }
            statusLine = String.valueOf(statusLine) + gid + "|";
            String vmsize = (String)psLineContents.get("vsz");
            if (vmsize == null) {
                vmsize = " ";
            }
            statusLine = String.valueOf(statusLine) + vmsize + "|";
            String vmrss = (String)psLineContents.get("rss");
            if (vmrss == null) {
                vmrss = " ";
            }
            if (rpfs.allows(statusLine = String.valueOf(statusLine) + vmrss)) {
                UniversalServerProcessImpl usp = new UniversalServerProcessImpl(statusLine);
                results.add(usp);
            }
            nextLine = reader.readLine();
        }
        reader.close();
        isr.close();
        if (results.size() == 0) {
            return null;
        }
        return results;
    }

    protected HashMap getPSOutput(String nextLine) {
        HashMap<String, String> contents = new HashMap<String, String>();
        String[] values = nextLine.trim().split("\\s+");
        if (values == null || values.length < processAttributes.length) {
            return null;
        }
        int i = 0;
        while (i < processAttributes.length) {
            contents.put(processAttributes[i], values[i]);
            ++i;
        }
        return contents;
    }

    public IHostProcess kill(IHostProcess process, String type) throws Exception {
        type = type.equals("default") ? "" : "-" + type;
        String cmdLine = "kill " + type + " " + process.getPid();
        Runtime.getRuntime().exec(cmdLine);
        HostProcessFilterImpl rpfs = new HostProcessFilterImpl();
        rpfs.setPid("" + process.getPid());
        SortedSet results = this.lookupProcesses(rpfs);
        if (results == null || results.size() == 0) {
            return null;
        }
        return (IHostProcess)results.first();
    }

    protected String convertToStateCode(String state) {
        String stateCode = " ";
        if (state == null) {
            return stateCode;
        }
        if (state.trim().equals("")) {
            return stateCode;
        }
        int i = 0;
        while (i < state.length()) {
            String nextState = (String)this.stateMap.get(new Character(state.charAt(i)));
            if (nextState != null) {
                stateCode = String.valueOf(stateCode) + nextState;
                if (i < state.length() - 1) {
                    stateCode = String.valueOf(stateCode) + ",";
                }
            }
            ++i;
        }
        if (stateCode.trim().equals("")) {
            return " ";
        }
        return stateCode.trim();
    }
}

