/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.shells.ui.propertypages;

import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.rse.core.SystemBasePlugin;
import org.eclipse.rse.core.subsystems.IRemoteSystemEnvVar;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.shells.ui.RemoteCommandHelpers;
import org.eclipse.rse.subsystems.shells.core.subsystems.IRemoteCmdSubSystem;
import org.eclipse.rse.ui.propertypages.SystemBasePropertyPage;
import org.eclipse.rse.ui.widgets.EnvironmentVariablesForm;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class EnvironmentVariablesPropertyPage
extends SystemBasePropertyPage {
    private EnvironmentVariablesForm _form;

    protected Control createContentArea(Composite parent) {
        IRemoteCmdSubSystem cmdSubSystem = this.getCmdSubSystem();
        if (cmdSubSystem != null) {
            this._form = new EnvironmentVariablesForm(this.getShell(), this.getMessageLine(), (Object)this.getElement(), cmdSubSystem.getInvalidEnvironmentVariableNameCharacters());
            IRemoteSystemEnvVar[] envVars = this.getCmdSubSystem().getEnvironmentVariableList();
            Vector<EnvironmentVariablesForm.EnvironmentVariable> envVarsVector = new Vector<EnvironmentVariablesForm.EnvironmentVariable>();
            int idx = 0;
            while (idx < envVars.length) {
                EnvironmentVariablesForm environmentVariablesForm = this._form;
                environmentVariablesForm.getClass();
                envVarsVector.add(new EnvironmentVariablesForm.EnvironmentVariable(environmentVariablesForm, envVars[idx].getName(), envVars[idx].getValue()));
                ++idx;
            }
            this._form.setEnvVars(envVarsVector);
            this._form.createContents(parent);
        } else {
            this._form = new EnvironmentVariablesForm(this.getShell(), this.getMessageLine(), null, null);
            this._form.createContents(parent);
        }
        return parent;
    }

    protected boolean verifyPageContents() {
        return true;
    }

    private IRemoteCmdSubSystem getCmdSubSystem() {
        IAdaptable subsystem = this.getElement();
        if (subsystem instanceof ISubSystem) {
            return RemoteCommandHelpers.getCmdSubSystem(((ISubSystem)subsystem).getHost());
        }
        SystemBasePlugin.logError((String)("EnvironmentVariablesPropertyPage.getCmdSubSystem:  input element for property page is not an instanceof SubSystem: " + subsystem));
        return null;
    }

    public boolean performOk() {
        Collection envVars = this._form.getEnvVars();
        String[] names = new String[envVars.size()];
        String[] values = new String[envVars.size()];
        Iterator i = envVars.iterator();
        int idx = 0;
        while (i.hasNext()) {
            EnvironmentVariablesForm.EnvironmentVariable variable = (EnvironmentVariablesForm.EnvironmentVariable)i.next();
            names[idx] = variable.getName();
            values[idx] = variable.getValue();
            ++idx;
        }
        this.getCmdSubSystem().setEnvironmentVariableList(names, values);
        return true;
    }
}

