/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.shells.ui.view;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.CompletionProposal;
import org.eclipse.jface.text.contentassist.ContextInformation;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.model.ISystemContentsType;
import org.eclipse.rse.core.subsystems.RemoteChildrenContentsType;
import org.eclipse.rse.internal.subsystems.shells.subsystems.RemoteCmdSubSystem;
import org.eclipse.rse.services.clientserver.messages.SystemMessageException;
import org.eclipse.rse.shells.ui.view.CommandEntryViewerConfiguration;
import org.eclipse.rse.subsystems.files.core.model.RemoteFileUtility;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFile;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFileSubSystem;
import org.eclipse.rse.subsystems.files.core.subsystems.RemoteFile;
import org.eclipse.rse.subsystems.files.core.subsystems.RemoteFileChildrenContentsType;
import org.eclipse.rse.subsystems.files.core.subsystems.RemoteFolderChildrenContentsType;
import org.eclipse.rse.subsystems.shells.core.subsystems.ICandidateCommand;
import org.eclipse.rse.subsystems.shells.core.subsystems.IRemoteCmdSubSystem;
import org.eclipse.rse.subsystems.shells.core.subsystems.IRemoteCommandShell;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.rse.ui.view.ISystemViewElementAdapter;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;

public class CommandEntryContentAssistProcessor
implements IContentAssistProcessor {
    private CommandEntryViewerConfiguration _configurator;
    private HashMap _imageMap;
    private IRemoteCommandShell _remoteCommand;
    private char _fileSeparator;
    private char _foreignFileSeparator;
    private IRemoteFile _lastFolderContext;
    private boolean _isWindows;
    private Image _envImage;
    private static int FILES_ONLY = 0;
    private static int FOLDERS_ONLY = 1;
    private static int FILES_AND_FOLDERS = 2;
    static /* synthetic */ Class class$0;

    public CommandEntryContentAssistProcessor(CommandEntryViewerConfiguration configurator) {
        this._configurator = configurator;
        this._imageMap = new HashMap();
    }

    public void setRemoteCommand(IRemoteCommandShell cmd) {
        if (cmd != this._remoteCommand) {
            this._remoteCommand = cmd;
            if (this._remoteCommand != null) {
                RemoteCmdSubSystem cmdSubsystem = (RemoteCmdSubSystem)this._remoteCommand.getCommandSubSystem();
                if (cmdSubsystem.isWindows()) {
                    this._isWindows = true;
                    this._fileSeparator = (char)92;
                    this._foreignFileSeparator = (char)47;
                } else {
                    this._isWindows = false;
                    this._fileSeparator = (char)47;
                    this._foreignFileSeparator = (char)92;
                }
                this._remoteCommand.getCandidateCommands();
            }
        }
    }

    public IRemoteCommandShell getRemoteCommand() {
        return this._remoteCommand;
    }

    private boolean isDeliminator(char c) {
        return c == ' ' || c == ';' || c == ':' || c == '&' || c == '|' || c == '=';
    }

    private String getCurrentText(ITextViewer viewer, int documentOffset) {
        StringBuffer currentText = new StringBuffer();
        String text = viewer.getDocument().get();
        if (documentOffset > -1) {
            boolean noWhiteSpace = true;
            int firstChar = documentOffset - 1;
            while (firstChar > -1 && noWhiteSpace) {
                char c = text.charAt(firstChar);
                if (this.isDeliminator(c)) {
                    noWhiteSpace = false;
                } else {
                    currentText.insert(0, c);
                }
                --firstChar;
            }
        }
        return currentText.toString();
    }

    private boolean isAtFirstToken(IDocument document) {
        int spaceIndex;
        String text = document.get();
        return text.length() <= 0 || (spaceIndex = text.indexOf(32)) <= 0;
    }

    private String getFirstToken(IDocument document) {
        StringBuffer buf = new StringBuffer();
        String text = document.get();
        int index = 0;
        while (index < text.length()) {
            char c = text.charAt(index);
            if (c == ' ') {
                return buf.toString();
            }
            buf.append(c);
            ++index;
        }
        return buf.toString();
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int documentOffset) {
        String currentText;
        boolean atFirstToken = this.isAtFirstToken(viewer.getDocument());
        String firstToken = this.getFirstToken(viewer.getDocument());
        CompletionResults completions = this.getCompletions(firstToken, currentText = this.getCurrentText(viewer, documentOffset), atFirstToken);
        if (completions != null && completions.size() > 0) {
            ICompletionProposal[] proposalList = new ICompletionProposal[completions.size()];
            int replacementOffset = documentOffset - currentText.length();
            int replacementLength = 0;
            replacementLength = documentOffset - replacementOffset;
            int idx = 0;
            while (idx < proposalList.length) {
                String name = completions.getNameAt(idx);
                String proposal = completions.getTextAt(idx);
                String help = completions.getHelpAt(idx);
                Image image = completions.getImageAt(idx);
                ContextInformation info = new ContextInformation(proposal, help);
                proposalList[idx] = new CompletionProposal(proposal, replacementOffset, replacementLength, documentOffset + proposal.length(), image, name, (IContextInformation)info, help);
                ++idx;
            }
            return proposalList;
        }
        return new ICompletionProposal[0];
    }

    private Image getImageFor(Object object) {
        ImageDescriptor descriptor = null;
        Image image = null;
        if (object instanceof ICandidateCommand) {
            ICandidateCommand cmd = (ICandidateCommand)object;
            descriptor = cmd.getImageDescriptor();
            if (descriptor == null) {
                String type = cmd.getType();
                descriptor = type.equals("file") ? PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJ_FILE") : RSEUIPlugin.getDefault().getImageDescriptor("org.eclipse.rse.ui.runIcon");
            }
        } else if (object instanceof IAdaptable) {
            IAdaptable iAdaptable = (IAdaptable)object;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.rse.ui.view.ISystemViewElementAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            ISystemViewElementAdapter adapter = (ISystemViewElementAdapter)iAdaptable.getAdapter((Class)clazz);
            descriptor = adapter.getImageDescriptor(object);
        }
        if (descriptor != null && (image = (Image)this._imageMap.get(descriptor)) == null) {
            image = descriptor.createImage();
            this._imageMap.put(descriptor, image);
        }
        return image;
    }

    private Image getEnvironmentVariableImage() {
        if (this._envImage == null) {
            this._envImage = RSEUIPlugin.getDefault().getImageDescriptor("org.eclipse.rse.ui.full/obj16/systemenvvar.gifIcon").createImage();
        }
        return this._envImage;
    }

    private CompletionResults getCompletions(String firstToken, String currentText, boolean atFirstToken) {
        CompletionResults results = new CompletionResults();
        if (this._remoteCommand != null && this._remoteCommand.isActive()) {
            Object context = this._remoteCommand.getContext();
            if (context instanceof IRemoteFile) {
                IRemoteFile workingDirectory = (IRemoteFile)context;
                int separatorIndex = currentText.lastIndexOf(this._fileSeparator);
                int foreignseparatorIndex = currentText.lastIndexOf(this._foreignFileSeparator);
                if (foreignseparatorIndex > separatorIndex) {
                    separatorIndex = foreignseparatorIndex;
                }
                if (separatorIndex > 0) {
                    String previousText = currentText.substring(0, separatorIndex + 1).replace(this._foreignFileSeparator, this._fileSeparator);
                    String nextText = "";
                    if (separatorIndex < currentText.length()) {
                        nextText = currentText.substring(separatorIndex + 1, currentText.length());
                    }
                    IRemoteFile contextDirectory = null;
                    String contextPath = null;
                    contextPath = !this._isWindows && currentText.charAt(0) == this._fileSeparator ? previousText : String.valueOf(workingDirectory.getAbsolutePath()) + this._fileSeparator + previousText;
                    if (this._lastFolderContext != null && this._lastFolderContext.getAbsolutePath().equals(contextPath)) {
                        contextDirectory = this._lastFolderContext;
                    } else {
                        try {
                            this._lastFolderContext = contextDirectory = RemoteFileUtility.getFileSubSystem((IHost)this._remoteCommand.getCommandSubSystem().getHost()).getRemoteFileObject(contextPath);
                        }
                        catch (Exception exception) {}
                    }
                    this.getFileCompletions(contextDirectory, previousText, nextText, results, FILES_AND_FOLDERS);
                } else if (atFirstToken) {
                    if (!this._isWindows && currentText.length() > 0 && currentText.charAt(0) == this._fileSeparator) {
                        this.getAbsoluteFileCompletions("", currentText, results, FILES_AND_FOLDERS);
                    } else {
                        this.getFileCompletions(workingDirectory, "", currentText, results, FILES_ONLY);
                        this.getCommandCompletions(currentText, results);
                    }
                } else {
                    int flag = FILES_AND_FOLDERS;
                    if (firstToken.equals("cd")) {
                        flag = FOLDERS_ONLY;
                    } else if (this._isWindows) {
                        if (firstToken.equals("set") || currentText.startsWith("%")) {
                            this.getEnvironmentCompletions(currentText, results);
                            return results;
                        }
                    } else if (firstToken.equals("export") || currentText.startsWith("$")) {
                        this.getEnvironmentCompletions(currentText, results);
                        return results;
                    }
                    this.getFileCompletions(workingDirectory, "", currentText, results, flag);
                }
            } else {
                this.getCommandCompletions(currentText, results);
            }
        }
        return results;
    }

    private void getEnvironmentCompletions(String currentText, CompletionResults results) {
        List vars;
        IRemoteCmdSubSystem cmdSubsystem = this._remoteCommand.getCommandSubSystem();
        if (cmdSubsystem != null && (vars = cmdSubsystem.getHostEnvironmentVariables()) != null) {
            int i = 0;
            while (i < vars.size()) {
                boolean hasPercent;
                String var = (String)vars.get(i);
                int eqSepIndex = var.indexOf(61);
                String name = var.substring(0, eqSepIndex);
                String value = var.substring(eqSepIndex + 1, var.length());
                boolean hasDollars = currentText.startsWith("$");
                String compareName = name;
                if (hasDollars) {
                    compareName = "$" + name;
                }
                if (hasPercent = currentText.startsWith("%")) {
                    compareName = "%" + name + "%";
                }
                if (compareName.toLowerCase().startsWith(currentText.toLowerCase())) {
                    results.addResult(name, compareName, value, this.getEnvironmentVariableImage());
                }
                ++i;
            }
        }
    }

    private void getCommandCompletions(String currentText, CompletionResults results) {
        ICandidateCommand[] cmds;
        IRemoteCmdSubSystem cmdSubsystem = this._remoteCommand.getCommandSubSystem();
        if (cmdSubsystem != null && (cmds = cmdSubsystem.getCandidateCommands((Object)this._remoteCommand)) != null) {
            int i = 0;
            while (i < cmds.length) {
                ICandidateCommand cmd = cmds[i];
                String name = cmd.getName();
                if (name.toLowerCase().startsWith(currentText.toLowerCase())) {
                    results.addResult(name, name, cmd.getDescription(), this.getImageFor(cmd));
                }
                ++i;
            }
        }
    }

    private void getAbsoluteFileCompletions(String prefix, String currentText, CompletionResults results, int flag) {
        if (!this._isWindows) {
            int lastSlashIndex = currentText.lastIndexOf("/");
            String parentPath = currentText.substring(0, lastSlashIndex);
            IRemoteFileSubSystem fs = RemoteFileUtility.getFileSubSystem((IHost)this._remoteCommand.getCommandSubSystem().getHost());
            try {
                IRemoteFile parent = fs.getRemoteFileObject(parentPath);
                Object[] fileList = null;
                fileList = parent.hasContents((ISystemContentsType)RemoteChildrenContentsType.getInstance()) ? parent.getContents((ISystemContentsType)RemoteChildrenContentsType.getInstance()) : parent.getParentRemoteFileSubSystem().listFoldersAndFiles(parent, String.valueOf(currentText) + "*", null);
                int f1 = 0;
                while (f1 < fileList.length) {
                    if (fileList[f1] instanceof IRemoteFile) {
                        RemoteFile file = (RemoteFile)fileList[f1];
                        if (flag == FILES_ONLY && file.isFile() || flag == FOLDERS_ONLY && file.isDirectory() || flag == FILES_AND_FOLDERS) {
                            String name = file.getName();
                            String proposal = String.valueOf(prefix) + name;
                            if (name.startsWith(currentText)) {
                                results.addResult(name, proposal, file.getAbsolutePath(), this.getImageFor(file));
                            } else if (this._isWindows && name.toLowerCase().startsWith(currentText.toLowerCase())) {
                                results.addResult(name, proposal, file.getAbsolutePath(), this.getImageFor(file));
                            }
                        }
                    }
                    ++f1;
                }
            }
            catch (Exception exception) {}
        }
    }

    private void getFileCompletions(IRemoteFile workingDirectory, String prefix, String currentText, CompletionResults results, int flag) {
        Object[] fileList = null;
        String filterString = String.valueOf(currentText) + "*";
        if (workingDirectory.hasContents((ISystemContentsType)RemoteChildrenContentsType.getInstance()) && !workingDirectory.isStale()) {
            fileList = flag == FILES_ONLY ? workingDirectory.getContents((ISystemContentsType)RemoteFileChildrenContentsType.getInstance(), filterString) : (flag == FOLDERS_ONLY ? workingDirectory.getContents((ISystemContentsType)RemoteFolderChildrenContentsType.getInstance(), filterString) : workingDirectory.getContents((ISystemContentsType)RemoteChildrenContentsType.getInstance(), filterString));
        }
        if (fileList == null || fileList.length == 0) {
            try {
                fileList = workingDirectory.getParentRemoteFileSubSystem().listFoldersAndFiles(workingDirectory, filterString, null);
            }
            catch (SystemMessageException systemMessageException) {}
        }
        if (fileList != null && fileList.length > 0) {
            int f1 = 0;
            while (f1 < fileList.length) {
                if (fileList[f1] instanceof IRemoteFile) {
                    RemoteFile file = (RemoteFile)fileList[f1];
                    if (flag == FILES_ONLY && file.isFile() || flag == FOLDERS_ONLY && file.isDirectory() || flag == FILES_AND_FOLDERS) {
                        String name = file.getName();
                        String proposal = String.valueOf(prefix) + name;
                        if (name.startsWith(currentText)) {
                            results.addResult(name, proposal, file.getAbsolutePath(), this.getImageFor(file));
                        } else if (this._isWindows && name.toLowerCase().startsWith(currentText.toLowerCase())) {
                            results.addResult(name, proposal, file.getAbsolutePath(), this.getImageFor(file));
                        }
                    }
                }
                ++f1;
            }
        }
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int documentOffset) {
        return null;
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return this._configurator.getCompletionProposalAutoActivationCharacters();
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return null;
    }

    public String getErrorMessage() {
        return null;
    }

    public IContextInformationValidator getContextInformationValidator() {
        return null;
    }

    private class CompletionResults {
        private List _nameResults = new ArrayList();
        private List _proposalResults = new ArrayList();
        private List _proposalHelpResults = new ArrayList();
        private List _images = new ArrayList();

        public int size() {
            return this._nameResults.size();
        }

        public void addResult(String name, String text, String help, Image image) {
            this._nameResults.add(name);
            this._proposalResults.add(text);
            this._proposalHelpResults.add(help);
            this._images.add(image);
        }

        public String getNameAt(int i) {
            return (String)this._nameResults.get(i);
        }

        public String getTextAt(int i) {
            return (String)this._proposalResults.get(i);
        }

        public String getHelpAt(int i) {
            return (String)this._proposalHelpResults.get(i);
        }

        public Image getImageAt(int i) {
            return (Image)this._images.get(i);
        }
    }
}

