/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.shells.ui.view;

import java.io.UnsupportedEncodingException;
import java.util.Collections;
import java.util.List;
import org.eclipse.rse.shells.ui.ShellResources;
import org.eclipse.rse.ui.SystemBaseForm;
import org.eclipse.rse.ui.messages.ISystemMessageLine;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class EncodingForm
extends SystemBaseForm {
    private String _encoding;
    private String _defaultEncoding = ShellResources.RESID_SHELL_PROPERTYPAGE_DEFAULT_ENCODING;
    private Button _defaultEncodingButton;
    private Button _otherEncodingButton;
    private Combo _encodingCombo;

    public EncodingForm(Shell shell, ISystemMessageLine line) {
        super(shell, line);
    }

    public Control createContents(Composite group) {
        SelectionAdapter buttonListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EncodingForm.this.updateEncodingState(EncodingForm.this._defaultEncodingButton.getSelection());
                EncodingForm.this.updateValidState();
            }
        };
        this._defaultEncodingButton = new Button(group, 16);
        this._defaultEncodingButton.setText(ShellResources.RESID_SHELL_PROPERTYPAGE_HOST_ENCODING);
        GridData data = new GridData();
        Font font = group.getFont();
        data.horizontalSpan = 2;
        this._defaultEncodingButton.setLayoutData((Object)data);
        this._defaultEncodingButton.addSelectionListener((SelectionListener)buttonListener);
        this._defaultEncodingButton.setFont(font);
        this._otherEncodingButton = new Button(group, 16);
        this._otherEncodingButton.setText(ShellResources.RESID_SHELL_PROPERTYPAGE_OTHER_ENCODING);
        this._otherEncodingButton.addSelectionListener((SelectionListener)buttonListener);
        this._otherEncodingButton.setFont(font);
        this._encodingCombo = new Combo(group, 0);
        data = new GridData();
        this._encodingCombo.setFont(font);
        this._encodingCombo.setLayoutData((Object)data);
        this._encodingCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                EncodingForm.this.updateValidState();
            }
        });
        return this._encodingCombo;
    }

    public void initialize(List defaults, String encoding) {
        boolean isDefault;
        this._encoding = encoding;
        boolean bl = isDefault = this._encoding == null || this._encoding.length() == 0 || encoding.equals(this._defaultEncoding);
        if (!isDefault && !defaults.contains(this._encoding)) {
            defaults.add(this._encoding);
        }
        Collections.sort(defaults);
        int i = 0;
        while (i < defaults.size()) {
            this._encodingCombo.add((String)defaults.get(i));
            ++i;
        }
        this._encodingCombo.setText(isDefault ? this._defaultEncoding : this._encoding);
        this.updateEncodingState(isDefault);
    }

    public Control getDefaultControl() {
        return this._encodingCombo;
    }

    public boolean usingDefault() {
        return this._defaultEncodingButton.getSelection();
    }

    public String getEncoding() {
        if (this.usingDefault()) {
            return "";
        }
        return this._encodingCombo.getText();
    }

    protected void updateValidState() {
        if (!this.isEncodingValid()) {
            this.getMessageLine().setErrorMessage(ShellResources.RESID_UNSUPPORTED_ENCODING);
        } else {
            this.getMessageLine().clearErrorMessage();
        }
    }

    private boolean isEncodingValid() {
        return this._defaultEncodingButton.getSelection() || this.isValidEncoding(this._encodingCombo.getText());
    }

    private boolean isValidEncoding(String enc) {
        try {
            new String(new byte[0], enc);
            return true;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return false;
        }
    }

    private void updateEncodingState(boolean useDefault) {
        this._defaultEncodingButton.setSelection(useDefault);
        this._otherEncodingButton.setSelection(!useDefault);
        this._encodingCombo.setEnabled(!useDefault);
        this.updateValidState();
    }
}

