/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.subsystems.files.core.model;

import java.util.ArrayList;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.core.subsystems.ISubSystemConfiguration;
import org.eclipse.rse.model.SystemRegistry;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFileSubSystem;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFileSubSystemConfiguration;
import org.eclipse.rse.ui.RSEUIPlugin;

public class RemoteFileUtility {
    public static IRemoteFileSubSystem getFileSubSystem(IHost connection) {
        SystemRegistry sr = RSEUIPlugin.getTheSystemRegistry();
        ISubSystem[] sses = sr.getSubSystems(connection);
        int i = 0;
        while (i < sses.length) {
            if (sses[i] instanceof IRemoteFileSubSystem) {
                IRemoteFileSubSystem subSystem = (IRemoteFileSubSystem)sses[i];
                return subSystem;
            }
            ++i;
        }
        return null;
    }

    public static IRemoteFileSubSystem[] getFileSubSystems(IHost connection) {
        ArrayList<IRemoteFileSubSystem> results = new ArrayList<IRemoteFileSubSystem>();
        SystemRegistry sr = RSEUIPlugin.getTheSystemRegistry();
        ISubSystem[] sses = sr.getSubSystems(connection);
        int i = 0;
        while (i < sses.length) {
            if (sses[i] instanceof IRemoteFileSubSystem) {
                IRemoteFileSubSystem subSystem = (IRemoteFileSubSystem)sses[i];
                results.add(subSystem);
            }
            ++i;
        }
        return results.toArray(new IRemoteFileSubSystem[results.size()]);
    }

    public static IRemoteFileSubSystemConfiguration getFileSubSystemConfiguration(String systemType) {
        SystemRegistry sr = RSEUIPlugin.getTheSystemRegistry();
        ISubSystemConfiguration[] sses = sr.getSubSystemConfigurationsBySystemType(systemType);
        int i = 0;
        while (i < sses.length) {
            if (sses[i] instanceof IRemoteFileSubSystemConfiguration) {
                return (IRemoteFileSubSystemConfiguration)sses[i];
            }
            ++i;
        }
        return null;
    }
}

