/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.subsystems.files.core.servicesubsystem;

import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.services.files.IHostFile;
import org.eclipse.rse.subsystems.files.core.servicesubsystem.FileServiceSubSystem;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFile;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFileContext;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFileSubSystem;
import org.eclipse.rse.subsystems.files.core.subsystems.RemoteFile;

public abstract class AbstractRemoteFile
extends RemoteFile
implements IRemoteFile {
    protected IHostFile _hostFile;
    protected FileServiceSubSystem _subSystem;
    protected String _classiciation;

    public AbstractRemoteFile(FileServiceSubSystem subSystem, IRemoteFileContext context, IRemoteFile parent, IHostFile hostFile) {
        super(context);
        this._subSystem = subSystem;
        this._hostFile = hostFile;
        this.setParentRemoteFile(parent);
    }

    public IRemoteFileSubSystem getParentRemoteFileSubSystem() {
        return this._subSystem;
    }

    public IHost getSystemConnection() {
        return this._subSystem.getHost();
    }

    public String getAbsolutePath() {
        return this._hostFile.getAbsolutePath();
    }

    public String getLabel() {
        return this._hostFile.getName();
    }

    public String getName() {
        return this._hostFile.getName();
    }

    public String getParentPath() {
        return this._hostFile.getParentPath();
    }

    public boolean isRoot() {
        return this._hostFile.isRoot();
    }

    public boolean isDirectory() {
        return this._hostFile.isDirectory();
    }

    public boolean isFile() {
        return this._hostFile.isFile();
    }

    public boolean exists() {
        return this._hostFile.exists();
    }

    public long getLastModified() {
        return this._hostFile.getModifiedDate();
    }

    public long getLength() {
        return this._hostFile.getSize();
    }

    public int compareTo(Object other) throws ClassCastException {
        IRemoteFile otherFile = (IRemoteFile)other;
        if (otherFile.isFile()) {
            if (this.isFile()) {
                String otherPath = otherFile.getAbsolutePath();
                String thisPath = this.getAbsolutePath();
                return thisPath.compareToIgnoreCase(otherPath);
            }
            return -1;
        }
        if (this.isDirectory()) {
            String otherPath = otherFile.getAbsolutePath();
            String thisPath = this.getAbsolutePath();
            return thisPath.compareToIgnoreCase(otherPath);
        }
        return 1;
    }

    public boolean showBriefPropertySet() {
        return false;
    }

    public String getParentNoRoot() {
        String parentPath = this.getParentPath();
        return parentPath;
    }

    public String getRoot() {
        return null;
    }

    public String getParentName() {
        return null;
    }

    public boolean isHidden() {
        return this._hostFile.isHidden();
    }

    public boolean isVirtual() {
        return false;
    }

    public boolean canRead() {
        return this._hostFile.canRead();
    }

    public boolean canWrite() {
        return this._hostFile.canWrite();
    }

    public boolean showReadOnlyProperty() {
        return false;
    }

    public IHostFile getHostFile() {
        return this._hostFile;
    }
}

