/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.core.subsystems;

import java.lang.reflect.InvocationTargetException;
import java.net.UnknownHostException;
import java.util.Vector;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.rse.core.SystemBasePlugin;
import org.eclipse.rse.core.SystemPreferencesManager;
import org.eclipse.rse.core.filters.ISystemFilter;
import org.eclipse.rse.core.filters.ISystemFilterPool;
import org.eclipse.rse.core.filters.ISystemFilterPoolManager;
import org.eclipse.rse.core.filters.ISystemFilterPoolReference;
import org.eclipse.rse.core.filters.ISystemFilterPoolReferenceManager;
import org.eclipse.rse.core.filters.ISystemFilterPoolReferenceManagerProvider;
import org.eclipse.rse.core.filters.ISystemFilterReference;
import org.eclipse.rse.core.filters.ISystemFilterString;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.model.IPropertySet;
import org.eclipse.rse.core.model.ISystemProfile;
import org.eclipse.rse.core.model.RSEModelObject;
import org.eclipse.rse.core.subsystems.ICacheManager;
import org.eclipse.rse.core.subsystems.IConnectorService;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.core.subsystems.ISubSystemConfiguration;
import org.eclipse.rse.core.subsystems.SubSystemConfiguration;
import org.eclipse.rse.model.ISystemResourceChangeEvents;
import org.eclipse.rse.model.SystemRegistry;
import org.eclipse.rse.model.SystemResourceChangeEvent;
import org.eclipse.rse.services.clientserver.messages.SystemMessage;
import org.eclipse.rse.services.clientserver.messages.SystemMessageException;
import org.eclipse.rse.ui.GenericMessages;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.rse.ui.dialogs.SystemPromptDialog;
import org.eclipse.rse.ui.messages.SystemMessageDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.ui.progress.WorkbenchJob;

public abstract class SubSystem
extends RSEModelObject
implements IAdaptable,
ISystemFilterPoolReferenceManagerProvider,
ISystemResourceChangeEvents,
ISubSystem {
    protected static final String SUBSYSTEM_FILE_NAME = "subsystem";
    protected static final int OPERATION_RESOLVE_ABSOLUTE = 0;
    protected static final int OPERATION_RESOLVE_ABSOLUTES = 1;
    protected static final int OPERATION_RESOLVE_RELATIVE = 2;
    protected static final int OPERATION_RUN_COMMAND = 3;
    protected static final int OPERATION_GET_PROPERTY = 4;
    protected static final int OPERATION_SET_PROPERTY = 5;
    protected static final int OPERATION_GET_PROPERTIES = 6;
    protected static final int OPERATION_SET_PROPERTIES = 7;
    protected static final int OPERATION_CONNECT = 8;
    protected static final int OPERATION_DISCONNECT = 9;
    protected static final int OPERATION_RUN_SHELL = 10;
    protected static final int OPERATION_SEND_COMMAND_TO_SHELL = 11;
    protected static final int OPERATION_CANCEL_SHELL = 12;
    protected static final int OPERATION_REMOVE_SHELL = 13;
    protected ISubSystemConfiguration parentSubSystemConfiguration;
    protected String previousUserIdKey;
    protected Shell shell = null;
    protected boolean supportsConnecting = true;
    protected boolean sortResults = true;
    protected boolean runInThread = true;
    protected boolean cancelable = true;
    protected boolean doConnection = false;
    protected ProgressMonitorDialog pmDialog;
    protected String saveFileName;
    protected IConnectorService _connectorService = null;
    protected boolean _connectionError = false;
    protected boolean _disconnecting = false;
    protected IHost _host;
    protected String _name = null;
    protected String _subsystemConfigurationId = null;
    protected boolean _hidden = false;
    protected ISystemFilterPoolReferenceManager filterPoolReferenceManager = null;

    protected SubSystem(IHost host, IConnectorService connectorService) {
        this._host = host;
        this._connectorService = connectorService;
        this._connectorService.registerSubSystem((ISubSystem)this);
    }

    protected ISubSystem selectCommandSubSystem(ISubSystem[] allCmdSubSystems) {
        if (allCmdSubSystems != null && allCmdSubSystems.length > 0) {
            return allCmdSubSystems[0];
        }
        return null;
    }

    public ISubSystemConfiguration getSubSystemConfiguration() {
        return this.parentSubSystemConfiguration;
    }

    public void setSubSystemConfiguration(ISubSystemConfiguration ssf) {
        this.parentSubSystemConfiguration = ssf;
        this.supportsConnecting = ssf.supportsSubSystemConnect();
    }

    public void setHost(IHost conn) {
        this._host = conn;
        this.previousUserIdKey = this.getPreferencesKey();
    }

    public boolean forceUserIdToUpperCase() {
        IHost currConn = this.getHost();
        if (currConn != null) {
            return currConn.getForceUserIdToUpperCase();
        }
        return false;
    }

    public void renamingProfile(String oldName, String newName) {
        String userIdValue = null;
        if (this.previousUserIdKey != null) {
            userIdValue = this.getLocalUserId(this.previousUserIdKey);
        }
        String newKey = this.getPreferencesKey(newName, this.getHostAliasName());
        if (userIdValue != null && userIdValue.length() > 0) {
            SystemPreferencesManager prefMgr = this.getPreferencesManager();
            prefMgr.clearUserId(this.previousUserIdKey);
            prefMgr.setUserId(newKey, userIdValue);
        }
        this.previousUserIdKey = newKey;
        ISystemProfile profile = this.getSystemProfile();
        ISystemFilterPoolManager mgr = this.getSubSystemConfiguration().getFilterPoolManager(profile);
        ISystemFilterPool[] pools = mgr.getSystemFilterPools();
        boolean done = false;
        if (pools != null) {
            int idx = 0;
            while (!done && idx < pools.length) {
                if (pools[idx].getOwningParentName() != null && pools[idx].getOwningParentName().equals(this.getHostAliasName())) {
                    done = true;
                    try {
                        mgr.renameSystemFilterPool(pools[idx], this.getConnectionOwnedFilterPoolName(newName, this.getHostAliasName()));
                    }
                    catch (Exception exc) {
                        String msg = "Unexpected error renaming connection-specific filter pool " + this.getConnectionOwnedFilterPoolName(newName, this.getHostAliasName());
                        SystemBasePlugin.logError(msg, exc);
                        System.err.println(String.valueOf(msg) + ": " + exc);
                    }
                }
                ++idx;
            }
        }
    }

    public void renamingConnection(String newName) {
        String userIdValue = null;
        if (this.previousUserIdKey != null) {
            userIdValue = this.getLocalUserId(this.previousUserIdKey);
        }
        String newKey = this.getPreferencesKey(this.getSystemProfileName(), newName);
        if (userIdValue != null && userIdValue.length() > 0) {
            SystemPreferencesManager prefMgr = this.getPreferencesManager();
            prefMgr.clearUserId(this.previousUserIdKey);
            prefMgr.setUserId(newKey, userIdValue);
        }
        this.previousUserIdKey = newKey;
        ISystemFilterPool privatePool = this.getConnectionPrivateFilterPool(false);
        if (privatePool != null) {
            ISystemFilterPoolManager mgr = this.getSubSystemConfiguration().getFilterPoolManager(this.getSystemProfile());
            privatePool.setOwningParentName(newName);
            try {
                mgr.renameSystemFilterPool(privatePool, this.getConnectionOwnedFilterPoolName(this.getSystemProfileName(), newName));
            }
            catch (Exception exc) {
                SystemBasePlugin.logError("Error renaming conection-private pool to: " + newName, exc);
            }
        }
    }

    public void deletingConnection() {
        ISystemFilterPool privatePool;
        String oldUserId = null;
        if (this.previousUserIdKey != null) {
            oldUserId = this.getLocalUserId(this.previousUserIdKey);
        }
        if (oldUserId != null) {
            SystemPreferencesManager prefMgr = this.getPreferencesManager();
            prefMgr.clearUserId(this.previousUserIdKey);
        }
        if ((privatePool = this.getConnectionPrivateFilterPool(false)) != null) {
            ISystemFilterPoolManager mgr = this.getSubSystemConfiguration().getFilterPoolManager(this.getSystemProfile());
            try {
                mgr.deleteSystemFilterPool(privatePool);
            }
            catch (Exception exc) {
                SystemBasePlugin.logError("Error deleting conection-private pool for: " + this.getHostAliasName(), exc);
            }
        }
    }

    public String getUserId() {
        String uid = this.getLocalUserId();
        if (uid == null || uid.length() == 0) {
            IHost conn = this.getHost();
            uid = conn.getDefaultUserId();
        }
        return uid;
    }

    protected SystemPreferencesManager getPreferencesManager() {
        return SystemPreferencesManager.getPreferencesManager();
    }

    protected String getPreferencesKey() {
        if (this._host == null || this.getName() == null) {
            return null;
        }
        return this.getPreferencesKey(this.getSystemProfileName(), this.getHostAliasName());
    }

    protected String getPreferencesKey(String profileName, String connectionName) {
        String key = String.valueOf(profileName) + "." + connectionName + "." + this.getName();
        return key;
    }

    protected String getLocalUserId(String key) {
        String uid = null;
        if (key != null && key.length() > 0) {
            SystemPreferencesManager prefMgr = this.getPreferencesManager();
            uid = prefMgr.getUserId(key);
        }
        return uid;
    }

    public String getLocalUserId() {
        return this.getLocalUserId(this.getPreferencesKey());
    }

    public void clearLocalUserId() {
        IConnectorService system;
        if (this.previousUserIdKey != null) {
            this.getPreferencesManager().clearUserId(this.previousUserIdKey);
        }
        if ((system = this.getConnectorService()) != null) {
            system.clearUserIdCache();
        }
    }

    public void checkIsConnected() throws SystemMessageException {
        if (!this.isConnected()) {
            try {
                Display display = Display.getCurrent();
                if (display != null) {
                    Shell shell = display.getActiveShell();
                    if (shell != null && !shell.isDisposed()) {
                        this.connect();
                    } else {
                        this.connect();
                    }
                } else {
                    this.connect();
                }
            }
            catch (Exception e) {
                if (e instanceof SystemMessageException) {
                    throw (SystemMessageException)e;
                }
                if (e instanceof InterruptedException) {
                    SystemMessage msg = RSEUIPlugin.getPluginMessage("RSEG1058");
                    msg.makeSubstitution((Object)this.getHost().getAliasName());
                    throw new SystemMessageException(msg);
                }
                SystemMessage msg = RSEUIPlugin.getPluginMessage("RSEG1056");
                throw new SystemMessageException(msg);
            }
        }
    }

    public Object getAdapter(Class adapterType) {
        return Platform.getAdapterManager().getAdapter((Object)this, adapterType);
    }

    public ISystemProfile getSystemProfile() {
        if (this._host != null) {
            return this._host.getSystemProfile();
        }
        return null;
    }

    public String getSystemProfileName() {
        ISystemProfile profile = this.getSystemProfile();
        if (profile != null) {
            return profile.getName();
        }
        return null;
    }

    public IHost getHost() {
        return this._host;
    }

    public String getHostAliasName() {
        IHost connection = this.getHost();
        if (connection != null) {
            return connection.getAliasName();
        }
        return null;
    }

    public ISystemFilterPool getUniqueOwningSystemFilterPool(boolean createIfNotFound) {
        return this.getConnectionPrivateFilterPool(createIfNotFound);
    }

    public ISystemFilterPool getConnectionPrivateFilterPool(boolean createIfNotFound) {
        ISystemFilterPool pool = null;
        ISubSystemConfiguration config = this.getSubSystemConfiguration();
        ISystemProfile profile = this.getSystemProfile();
        ISystemFilterPoolManager fpm = config.getFilterPoolManager(profile);
        ISystemFilterPool[] allPoolsInProfile = fpm.getSystemFilterPools();
        IHost host = this.getHost();
        String hostName = host.getAliasName();
        if (allPoolsInProfile != null) {
            int idx = 0;
            while (idx < allPoolsInProfile.length) {
                String poolOwnerName = allPoolsInProfile[idx].getOwningParentName();
                if (poolOwnerName != null && poolOwnerName.equals(hostName)) {
                    pool = allPoolsInProfile[idx];
                }
                ++idx;
            }
        }
        if (pool == null && createIfNotFound) {
            try {
                String profileName = profile.getName();
                pool = fpm.createSystemFilterPool(this.getConnectionOwnedFilterPoolName(profileName, hostName), true);
                if (pool != null) {
                    pool.setNonRenamable(true);
                    pool.setOwningParentName(hostName);
                    pool.commit();
                    ISystemFilterPoolReferenceManager fprm = this.getSystemFilterPoolReferenceManager();
                    if (fprm.getReferenceToSystemFilterPool(pool) == null) {
                        fprm.addReferenceToSystemFilterPool(pool);
                    }
                }
            }
            catch (Exception exc) {
                SystemBasePlugin.logError("Error creating connection-private filter pool for connection: " + hostName, exc);
            }
        }
        return pool;
    }

    public String getConnectionOwnedFilterPoolName(String profileName, String connectionName) {
        String name = "CN-" + connectionName;
        return name;
    }

    protected boolean doesFilterTypeMatch(ISystemFilter filter, String remoteObjectAbsoluteName) {
        return true;
    }

    public boolean doesFilterListContentsOf(ISystemFilter filter, String remoteObjectAbsoluteName) {
        if (filter.isPromptable()) {
            return false;
        }
        boolean would = false;
        ISystemFilterString[] strings = filter.getSystemFilterStrings();
        if (strings != null) {
            int idx = 0;
            while (!would && idx < strings.length) {
                would = this.doesFilterStringListContentsOf(strings[idx], remoteObjectAbsoluteName);
                ++idx;
            }
        }
        return would;
    }

    public boolean doesFilterStringListContentsOf(ISystemFilterString filterString, String remoteObjectAbsoluteName) {
        return false;
    }

    public boolean doesFilterMatch(ISystemFilter filter, String remoteObjectAbsoluteName) {
        if (filter.isPromptable() || !this.doesFilterTypeMatch(filter, remoteObjectAbsoluteName)) {
            return false;
        }
        boolean would = false;
        String[] strings = filter.getFilterStrings();
        if (strings != null) {
            int idx = 0;
            while (!would && idx < strings.length) {
                would = strings[idx].equals("*") ? true : (strings[idx].equals("./*") ? true : this.doesFilterStringMatch(strings[idx], remoteObjectAbsoluteName, filter.areStringsCaseSensitive()));
                ++idx;
            }
        }
        return would;
    }

    public boolean doesFilterStringMatch(String filterString, String remoteObjectAbsoluteName, boolean caseSensitive) {
        return true;
    }

    public PropertyPage getPropertyPage(Composite parent) {
        return null;
    }

    public Object getObjectWithAbsoluteName(String key) throws Exception {
        Object filterRef = this.getFilterReferenceWithAbsoluteName(key);
        if (filterRef != null) {
            return filterRef;
        }
        return null;
    }

    protected Object getFilterReferenceWithAbsoluteName(String key) {
        String filterID = key;
        try {
            ISystemFilterPoolReferenceManager filterMgr = this.getFilterPoolReferenceManager();
            SystemRegistry registry = RSEUIPlugin.getTheSystemRegistry();
            ISubSystemConfiguration factory = registry.getSubSystemConfiguration(this);
            int indexOfDot = filterID.indexOf(46);
            if (indexOfDot > 0) {
                String mgrName = filterID.substring(0, indexOfDot);
                ISystemFilterPoolManager mgr = factory.getSystemFilterPoolManager(mgrName);
                int indexOfDot2 = filterID.indexOf(46, indexOfDot + 1);
                if (mgr != null && indexOfDot2 > 0) {
                    ISystemFilter filter;
                    ISystemFilterReference ref;
                    String filterPoolName = filterID.substring(indexOfDot + 1, indexOfDot2);
                    ISystemFilterPool filterPool = mgr.getSystemFilterPool(filterPoolName);
                    String filterName = filterID.substring(indexOfDot2 + 1, filterID.length());
                    if (filterPool != null && (ref = filterMgr.getSystemFilterReference((ISubSystem)this, filter = filterPool.getSystemFilter(filterName))) != null) {
                        return ref;
                    }
                }
            }
        }
        catch (Exception exception) {}
        return null;
    }

    public void setVendorAttribute(String vendor, String attributeName, String attributeValue) {
        IPropertySet set = this.getPropertySet(vendor);
        if (set == null) {
            set = this.createPropertySet(vendor, "");
        }
        set.addProperty(attributeName, attributeValue);
    }

    public String getVendorAttribute(String vendor, String attributeName) {
        IPropertySet set = this.getPropertySet(vendor);
        if (set != null) {
            return set.getPropertyValue(attributeName);
        }
        return null;
    }

    public void setRemoteAttribute(String attributeName, String attributeValue) {
        IPropertySet set = this.getPropertySet("Remote");
        if (set == null) {
            set = this.createPropertySet("Remote", this.getDescription());
        }
        set.addProperty(attributeName, attributeValue);
    }

    public String getRemoteAttribute(String attributeName) {
        IPropertySet set = this.getPropertySet("Remote");
        if (set != null) {
            return set.getPropertyValue(attributeName);
        }
        return null;
    }

    public String getSystemType() {
        IHost conn = this.getHost();
        if (conn == null) {
            return null;
        }
        return conn.getSystemType();
    }

    public String getHostName() {
        IHost conn = this.getHost();
        if (conn == null) {
            return null;
        }
        return conn.getHostName();
    }

    protected void displayAsyncMsg(SystemMessageException msg) {
        DisplayErrorMessageJob job = new DisplayErrorMessageJob(this.getShell(), msg);
        job.setPriority(10);
        job.setSystem(true);
        job.schedule();
    }

    public ISystemFilterPoolReferenceManager getSystemFilterPoolReferenceManager() {
        return this.getFilterPoolReferenceManager();
    }

    protected void fireEvent(SystemResourceChangeEvent event) {
        RSEUIPlugin.getTheSystemRegistry().fireEvent(event);
    }

    protected void fireEvent(SystemResourceChangeEvent event, Object grandParent) {
        event.setGrandParent(grandParent);
        RSEUIPlugin.getTheSystemRegistry().fireEvent(event);
    }

    protected void fireEvent(Object src, int eventId, Object parent) {
        this.fireEvent(new SystemResourceChangeEvent(src, eventId, parent));
    }

    protected void fireEvent(Object[] multiSrc, int eventId, Object parent) {
        this.fireEvent(new SystemResourceChangeEvent(multiSrc, eventId, parent));
    }

    protected void fireEvent(Object[] src, int eventId, Object parent, int position) {
        SystemResourceChangeEvent event = new SystemResourceChangeEvent(src, eventId, parent);
        event.setPosition(position);
        this.fireEvent(event);
    }

    protected void fireEvent(Object src, int eventId, Object parent, Object grandParent) {
        this.fireEvent(new SystemResourceChangeEvent(src, eventId, parent), grandParent);
    }

    public void filterEventFilterPoolReferenceCreated(ISystemFilterPoolReference newPoolRef) {
        if (this.getSubSystemConfiguration().showFilterPools()) {
            this.fireEvent(newPoolRef, 50, (Object)this);
            this.fireEvent(newPoolRef, 52, (Object)this);
        } else {
            ISystemFilterPool pool = newPoolRef.getReferencedFilterPool();
            if (pool != null && pool.getSystemFilterCount() > 0) {
                Object[] filterRefs = newPoolRef.getSystemFilterReferences((ISubSystem)this);
                this.fireEvent(filterRefs, 51, (Object)this, -1);
            }
        }
        try {
            this.getSubSystemConfiguration().saveSubSystem((ISubSystem)this);
            RSEUIPlugin.getTheSystemRegistry().fireModelChangeEvent(1, 16, newPoolRef, null);
        }
        catch (Exception exc) {
            SystemBasePlugin.logError("Error saving subsystem " + this.getName(), exc);
        }
    }

    public void filterEventFilterPoolReferenceDeleted(ISystemFilterPoolReference filterPoolRef) {
        if (this.getSubSystemConfiguration().showFilterPools()) {
            this.fireEvent(filterPoolRef, 55, (Object)this);
        } else if (filterPoolRef.getReferencedFilterPool().getSystemFilterCount() > 0) {
            Object[] filterRefs = filterPoolRef.getSystemFilterReferences((ISubSystem)this);
            this.fireEvent(filterRefs, 60, (Object)this);
        }
        try {
            this.getSubSystemConfiguration().saveSubSystem((ISubSystem)this);
            RSEUIPlugin.getTheSystemRegistry().fireModelChangeEvent(2, 16, filterPoolRef, null);
        }
        catch (Exception exc) {
            SystemBasePlugin.logError("Error saving subsystem " + this.getName(), exc);
        }
    }

    public void filterEventFilterPoolReferenceReset(ISystemFilterPoolReference filterPoolRef) {
        this.fireEvent(filterPoolRef, 87, (Object)this);
        try {
            this.getSubSystemConfiguration().saveSubSystem((ISubSystem)this);
            RSEUIPlugin.getTheSystemRegistry().fireModelChangeEvent(4, 16, filterPoolRef, null);
        }
        catch (Exception exc) {
            SystemBasePlugin.logError("Error saving subsystem " + this.getName(), exc);
        }
    }

    public void filterEventFilterPoolReferencesReset() {
        this.fireEvent(this, 95, (Object)this);
        try {
            this.getSubSystemConfiguration().saveSubSystem((ISubSystem)this);
            ISystemFilterPoolReference[] poolRefs = this.getFilterPoolReferenceManager().getSystemFilterPoolReferences();
            int idx = 0;
            while (idx < poolRefs.length) {
                RSEUIPlugin.getTheSystemRegistry().fireModelChangeEvent(4, 16, poolRefs[idx], null);
                ++idx;
            }
        }
        catch (Exception exc) {
            SystemBasePlugin.logError("Error saving subsystem " + this.getName(), exc);
        }
    }

    public void filterEventFilterPoolReferenceRenamed(ISystemFilterPoolReference poolRef, String oldName) {
        if (this.getSubSystemConfiguration().showFilterPools()) {
            this.fireEvent(poolRef, 65, (Object)this);
        }
        try {
            this.getSubSystemConfiguration().saveSubSystem((ISubSystem)this);
        }
        catch (Exception exc) {
            SystemBasePlugin.logError("Error saving subsystem " + this.getName(), exc);
        }
    }

    public void filterEventFilterPoolReferencesRePositioned(ISystemFilterPoolReference[] poolRefs, int delta) {
        this.fireEvent(poolRefs, 75, (Object)this, delta);
        try {
            this.getSubSystemConfiguration().saveSubSystem((ISubSystem)this);
            int idx = 0;
            while (idx < poolRefs.length) {
                RSEUIPlugin.getTheSystemRegistry().fireModelChangeEvent(16, 16, poolRefs[idx], null);
                ++idx;
            }
        }
        catch (Exception exc) {
            SystemBasePlugin.logError("Error saving subsystem " + this.getName(), exc);
        }
    }

    public void filterEventFilterCreated(Object selectedObject, ISystemFilter newFilter) {
        this.fireEvent(newFilter, 52, selectedObject);
    }

    public void filterEventFilterStringCreated(Object selectedObject, ISystemFilterString newFilterString) {
        this.fireEvent(newFilterString, 52, selectedObject);
    }

    protected boolean implicitConnect(boolean isConnectOperation, IProgressMonitor mon, String msg, int totalWorkUnits) throws SystemMessageException, InvocationTargetException, InterruptedException {
        boolean didConnection = false;
        if (this.doConnection && !this.isConnected()) {
            if (this.isOffline() || this.supportsCaching() && this.getCacheManager().isRestoreFromMemento()) {
                if (!this.supportsCaching()) {
                    SystemMessage sMsg = RSEUIPlugin.getPluginMessage("RSEC3001");
                    sMsg.makeSubstitution((Object)this.getHost().getAliasName());
                    throw new SystemMessageException(sMsg);
                }
                this.doConnection = false;
            } else {
                this.doConnection = false;
                didConnection = true;
                mon.beginTask(SubSystemConfiguration.getConnectingMessage(this.getHostName(), this.getConnectorService().getPort()), totalWorkUnits);
                this.internalConnect(mon);
                mon.worked(1);
                ChangeStatusJob job = new ChangeStatusJob(this);
                job.setSystem(true);
                job.setPriority(10);
                job.schedule();
            }
        } else {
            this.doConnection = false;
        }
        if (this.isConnected() || isConnectOperation || this.isOffline() || this.supportsCaching() && this.getCacheManager().isRestoreFromMemento()) {
            if (!didConnection) {
                mon.beginTask(msg, totalWorkUnits == 1 ? -1 : totalWorkUnits);
            } else {
                mon.setTaskName(msg);
            }
            return true;
        }
        mon.done();
        return false;
    }

    protected void showOperationMessage(Exception exc, Shell shell) {
        if (exc instanceof InterruptedException) {
            this.showOperationCancelledMessage(shell);
        } else if (exc instanceof InvocationTargetException) {
            this.showOperationErrorMessage(shell, ((InvocationTargetException)exc).getTargetException());
        } else {
            this.showOperationErrorMessage(shell, exc);
        }
    }

    protected void showConnectErrorMessage(Shell shell, String hostName, int port, Throwable exc) {
        SystemMessage msg = null;
        if (exc instanceof SystemMessageException) {
            SystemBasePlugin.logError("Connection error", exc);
            msg = ((SystemMessageException)exc).getSystemMessage();
        } else if (exc instanceof UnknownHostException) {
            SystemBasePlugin.logError("Connection error", exc);
            msg = RSEUIPlugin.getPluginMessage("RSEG1057");
            msg.makeSubstitution((Object)hostName);
        } else {
            SystemBasePlugin.logError("Connection error", exc);
            msg = RSEUIPlugin.getPluginMessage("RSEG1056");
            msg.makeSubstitution((Object)hostName, (Object)exc);
        }
        SystemMessageDialog msgDlg = new SystemMessageDialog(shell, msg);
        msgDlg.setException(exc);
        msgDlg.open();
    }

    protected void showConnectCancelledMessage(Shell shell, String hostName, int port) {
        SystemMessage msg = RSEUIPlugin.getPluginMessage("RSEG1058");
        msg.makeSubstitution((Object)hostName);
        SystemMessageDialog msgDlg = new SystemMessageDialog(shell, msg);
        msgDlg.open();
    }

    protected void showDisconnectErrorMessage(Shell shell, String hostName, int port, Exception exc) {
        SystemMessageDialog msgDlg = new SystemMessageDialog(shell, RSEUIPlugin.getPluginMessage("RSEG1061").makeSubstitution((Object)hostName, (Object)exc));
        msgDlg.setException(exc);
        msgDlg.open();
    }

    protected void showDisconnectCancelledMessage(Shell shell, String hostName, int port) {
        SystemMessageDialog msgDlg = new SystemMessageDialog(shell, RSEUIPlugin.getPluginMessage("RSEG1062").makeSubstitution((Object)hostName));
        msgDlg.open();
    }

    protected static String getResolvingMessage(String filterString) {
        String msg = RSEUIPlugin.getPluginMessage("RSEG1070").makeSubstitution((Object)filterString).getLevelOneText();
        return msg;
    }

    protected static String getRunningMessage(String cmd) {
        return RSEUIPlugin.getPluginMessage("RSEG1071").makeSubstitution((Object)cmd).getLevelOneText();
    }

    protected static String getQueryingMessage(String key) {
        return RSEUIPlugin.getPluginMessage("RSEG1095").makeSubstitution((Object)key).getLevelOneText();
    }

    protected static String getSettingMessage(String key) {
        return RSEUIPlugin.getPluginMessage("RSEG1093").makeSubstitution((Object)key).getLevelOneText();
    }

    protected static String getQueryingMessage() {
        return RSEUIPlugin.getPluginMessage("RSEG1096").getLevelOneText();
    }

    protected static String getSettingMessage() {
        return RSEUIPlugin.getPluginMessage("RSEG1094").getLevelOneText();
    }

    protected void showOperationErrorMessage(Shell shell, Throwable exc) {
        SystemMessage sysMsg = null;
        if (exc instanceof SystemMessageException) {
            this.displayAsyncMsg((SystemMessageException)exc);
        } else {
            String excMsg = exc.getMessage();
            if (excMsg == null || excMsg.length() == 0) {
                excMsg = "Exception " + exc.getClass().getName();
            }
            sysMsg = RSEUIPlugin.getPluginMessage("RSEG1066");
            sysMsg.makeSubstitution((Object)excMsg);
            SystemMessageDialog msgDlg = new SystemMessageDialog(shell, sysMsg);
            msgDlg.setException(exc);
            msgDlg.open();
        }
    }

    protected void showOperationCancelledMessage(Shell shell) {
        SystemMessageDialog msgDlg = new SystemMessageDialog(shell, RSEUIPlugin.getPluginMessage("RSEG1067"));
        msgDlg.open();
    }

    public boolean isConnected() {
        IConnectorService system = this.getConnectorService();
        if (system != null) {
            return system.isConnected();
        }
        return !this.supportsConnecting;
    }

    public boolean isOffline() {
        return this.getHost().isOffline();
    }

    public boolean hasChildren() {
        if (this.getSubSystemConfiguration().supportsFilters()) {
            ISystemFilterPoolReferenceManager mgr = this.getSystemFilterPoolReferenceManager();
            if (mgr == null) {
                return false;
            }
            return mgr.getSystemFilterPoolReferenceCount() > 0;
        }
        return false;
    }

    public Object[] getChildren() {
        if (this.getSubSystemConfiguration().supportsFilters()) {
            ISystemFilterPoolReferenceManager mgr = this.getSystemFilterPoolReferenceManager();
            if (mgr == null) {
                return null;
            }
            boolean showFilterPools = this.getSubSystemConfiguration().showFilterPools();
            if (showFilterPools) {
                return mgr.getSystemFilterPoolReferences();
            }
            Object[] allRefs = mgr.getSystemFilterReferences((ISubSystem)this);
            return allRefs;
        }
        return null;
    }

    public Object[] resolveFilterString(String filterString) throws Exception {
        boolean ok = true;
        if (!this.isConnected()) {
            ok = this.promptForPassword();
        }
        if (ok) {
            Display display = Display.getCurrent();
            if (display != null) {
                return this.internalResolveFilterString((IProgressMonitor)new NullProgressMonitor(), filterString);
            }
            try {
                ResolveAbsoluteJob job = new ResolveAbsoluteJob(filterString);
                IStatus status = this.scheduleJob(job, null, this.shell != null);
                if (status.isOK()) {
                    if (this.sortResults && job.getOutputs() != null) {
                        return this.sortResolvedFilterStringObjects(job.getOutputs());
                    }
                    return job.getOutputs();
                }
            }
            catch (InterruptedException exc) {
                if (this.shell == null) {
                    throw exc;
                }
                this.showOperationCancelledMessage(this.shell);
            }
        } else {
            System.out.println("in SubSystemImpl.resolveFilterString: isConnected() returning false!");
        }
        return null;
    }

    public Object[] resolveFilterStrings(String[] filterStrings) throws Exception {
        boolean ok = true;
        if (filterStrings == null || filterStrings.length == 0) {
            SystemBasePlugin.logInfo("Filter strings are null");
            return null;
        }
        if (!this.isConnected()) {
            ok = this.promptForPassword();
        }
        if (ok) {
            Display display = Display.getCurrent();
            if (display != null) {
                return this.internalResolveFilterStrings((IProgressMonitor)new NullProgressMonitor(), filterStrings);
            }
            try {
                ResolveAbsolutesJob job = new ResolveAbsolutesJob(filterStrings[0], filterStrings);
                IStatus status = this.scheduleJob(job, null, true);
                if (status.isOK()) {
                    if (this.sortResults && job.getOutputs() != null) {
                        return this.sortResolvedFilterStringObjects(job.getOutputs());
                    }
                    return job.getOutputs();
                }
            }
            catch (InterruptedException exc) {
                if (this.shell == null) {
                    throw exc;
                }
                this.showOperationCancelledMessage(this.shell);
            }
        } else {
            System.out.println("in SubSystemImpl.resolveFilterString: isConnected() returning false!");
        }
        return null;
    }

    protected IStatus scheduleJob(SubSystemOperationJob job, ISchedulingRule rule, boolean synch) throws InterruptedException {
        IRunnableContext context = this.getRunnableContext();
        if (context instanceof SystemPromptDialog) {
            IStatus status = job.runInContext(context);
            if (!status.isOK()) {
                this.showOperationErrorMessage(this.shell, status.getException());
            }
            return status;
        }
        job.setPriority(10);
        if (rule != null) {
            job.setRule(rule);
        }
        job.schedule();
        if (synch) {
            Display display = Display.getCurrent();
            while (!job.hasStarted()) {
                while (display != null && display.readAndDispatch()) {
                }
                if (job.hasStarted()) continue;
                Thread.sleep(200L);
            }
            while (job.getResult() == null) {
                while (display != null && display.readAndDispatch()) {
                }
                if (job.getResult() != null) continue;
                Thread.sleep(200L);
            }
            return job.getResult();
        }
        return Status.OK_STATUS;
    }

    protected Object[] sortResolvedFilterStringObjects(Object[] input) {
        return input;
    }

    public Object[] resolveFilterString(IProgressMonitor monitor, String filterString) throws Exception {
        boolean ok = true;
        if (!this.isConnected()) {
            ok = this.promptForPassword();
        }
        if (ok) {
            Object[] results = this.internalResolveFilterString(monitor, filterString);
            if (this.sortResults && results != null) {
                results = this.sortResolvedFilterStringObjects(results);
            }
            return results;
        }
        return null;
    }

    public Object[] resolveFilterStrings(IProgressMonitor monitor, String[] filterStrings) throws Exception {
        boolean ok = true;
        if (!this.isConnected()) {
            ok = this.promptForPassword();
        }
        if (ok) {
            Object[] results = this.internalResolveFilterStrings(monitor, filterStrings);
            if (this.sortResults && results != null) {
                results = this.sortResolvedFilterStringObjects(results);
            }
            return results;
        }
        return null;
    }

    public Object[] resolveFilterString(IProgressMonitor monitor, Object parent, String filterString) throws Exception {
        boolean ok = true;
        if (!this.isConnected()) {
            ok = this.promptForPassword();
        }
        if (ok) {
            Object[] results = this.internalResolveFilterString(monitor, parent, filterString);
            if (this.sortResults && results != null) {
                results = this.sortResolvedFilterStringObjects(results);
            }
            return results;
        }
        return null;
    }

    public Object[] resolveFilterString(Object parent, String filterString) throws Exception {
        boolean ok = true;
        if (!this.isConnected()) {
            ok = this.promptForPassword();
        }
        if (ok) {
            Display display = Display.getCurrent();
            if (display != null) {
                return this.internalResolveFilterString((IProgressMonitor)new NullProgressMonitor(), parent, filterString);
            }
            try {
                ResolveRelativeJob job = new ResolveRelativeJob(filterString, parent);
                IStatus status = this.scheduleJob(job, null, true);
                if (status.isOK()) {
                    if (job.getOutputs() != null && job.getOutputs().length > 1) {
                        return this.sortResolvedFilterStringObjects(job.getOutputs());
                    }
                    return job.getOutputs();
                }
            }
            catch (InterruptedException exc) {
                if (this.shell == null) {
                    throw exc;
                }
                this.showOperationCancelledMessage(this.shell);
            }
        } else {
            SystemBasePlugin.logDebugMessage(this.getClass().getName(), "in SubSystemImpl.resolveFilterString: isConnected() returning false!");
        }
        return null;
    }

    public String[] getExecutedCommands() {
        return null;
    }

    public Object setProperty(Object subject, String key, String value) throws Exception {
        boolean ok = true;
        if (!this.isConnected()) {
            ok = this.promptForPassword();
        }
        if (ok) {
            try {
                SetPropertyJob job = new SetPropertyJob(subject, key, value);
                IStatus status = this.scheduleJob(job, null, true);
                if (status.isOK()) {
                    return job.getOutputs()[0];
                }
            }
            catch (InterruptedException exc) {
                if (this.shell == null) {
                    throw exc;
                }
                this.showOperationCancelledMessage(this.shell);
            }
        } else {
            System.out.println("in SubSystemImpl.setProperty: isConnected() returning false!");
        }
        return null;
    }

    public String getProperty(Object subject, String key) throws Exception {
        boolean ok = true;
        if (!this.isConnected()) {
            ok = this.promptForPassword();
        }
        if (ok) {
            try {
                GetPropertyJob job = new GetPropertyJob(subject, key);
                this.scheduleJob(job, null, true);
                IStatus status = job.getResult();
                if (status.isOK()) {
                    return job.getOutputStrings()[0];
                }
            }
            catch (InterruptedException exc) {
                if (this.shell == null) {
                    throw exc;
                }
                this.showOperationCancelledMessage(this.shell);
            }
        } else {
            System.out.println("in SubSystemImpl.getProperty: isConnected() returning false!");
        }
        return null;
    }

    public Object setProperties(Object subject, String[] keys, String[] values) throws Exception {
        boolean ok = true;
        if (!this.isConnected()) {
            ok = this.promptForPassword();
        }
        if (ok) {
            try {
                SetPropertiesJob job = new SetPropertiesJob(subject, keys, values);
                IStatus status = this.scheduleJob(job, null, true);
                if (status.isOK()) {
                    return job.getOutputs()[0];
                }
            }
            catch (InterruptedException exc) {
                if (this.shell == null) {
                    throw exc;
                }
                this.showOperationCancelledMessage(this.shell);
            }
        } else {
            System.out.println("in SubSystemImpl.setProperties: isConnected() returning false!");
        }
        return null;
    }

    public void initializeSubSystem(IProgressMonitor monitor) {
    }

    public void uninitializeSubSystem(IProgressMonitor monitor) {
    }

    public void connect() throws Exception {
        if (!this.isConnected()) {
            if (Display.getCurrent() == null) {
                ConnectFromBackgroundJob job = new ConnectFromBackgroundJob();
                job.setPriority(10);
                job.schedule();
                job.join();
            } else {
                this.connect(false);
            }
        }
    }

    public void connect(boolean forcePrompt) throws Exception {
        SystemRegistry registry = RSEUIPlugin.getTheSystemRegistry();
        IHost host = this.getHost();
        String hostName = host.getAliasName();
        ISystemProfile profile = this.getSystemProfile();
        if (registry.getHost(profile, hostName) == null) {
            SystemMessage msg = RSEUIPlugin.getPluginMessage("RSEF5011");
            msg.makeSubstitution((Object)hostName);
            throw new SystemMessageException(msg);
        }
        if (this.isOffline()) {
            SystemMessage msg = RSEUIPlugin.getPluginMessage("RSEC3001");
            msg.makeSubstitution((Object)hostName);
            throw new SystemMessageException(msg);
        }
        if (!this.isConnected() && this.supportsConnecting) {
            this.getRunnableContext();
            this.getConnectorService().promptForPassword(forcePrompt);
            ConnectJob job = new ConnectJob();
            this.scheduleJob(job, null, this.shell != null);
            IStatus status = job.getResult();
            if (status != null && status.isOK()) {
                registry.connectedStatusChange(this, true, false);
            }
        }
    }

    public boolean promptForPassword() throws Exception {
        return this.promptForPassword(false);
    }

    public boolean promptForPassword(boolean force) throws Exception {
        boolean ok = false;
        if (!this.supportsConnecting) {
            return true;
        }
        if (this.isOffline()) {
            this.doConnection = true;
            return true;
        }
        if (this.supportsCaching() && this.getCacheManager().isRestoreFromMemento()) {
            this.doConnection = true;
            return true;
        }
        try {
            this.getConnectorService().promptForPassword(force);
            this.doConnection = true;
            ok = true;
        }
        catch (InterruptedException exc) {
            throw exc;
        }
        catch (Exception exc) {
            this.showConnectErrorMessage(this.shell, this.getHostName(), this.getConnectorService().getPort(), exc);
        }
        return ok;
    }

    public void disconnect() throws Exception {
        this.disconnect(true);
    }

    public void disconnect(boolean collapseTree) throws Exception {
        this._disconnecting = true;
        if (!this.isConnected() || !this.supportsConnecting) {
            SystemRegistry sr = RSEUIPlugin.getDefault().getSystemRegistry();
            sr.connectedStatusChange(this, false, true, collapseTree);
            return;
        }
        DisconnectJob job = new DisconnectJob(collapseTree, this);
        job.schedule();
    }

    public String[] getProperties(Object subject, String[] keys) throws Exception {
        boolean ok = true;
        if (!this.isConnected()) {
            ok = this.promptForPassword();
        }
        if (ok) {
            try {
                GetPropertiesJob job = new GetPropertiesJob(subject, keys);
                IStatus status = this.scheduleJob(job, null, true);
                if (status.isOK()) {
                    return job.getOutputStrings();
                }
            }
            catch (InterruptedException exc) {
                if (this.shell == null) {
                    throw exc;
                }
                this.showOperationCancelledMessage(this.shell);
            }
        }
        return null;
    }

    public IConnectorService getConnectorService() {
        return this._connectorService;
    }

    public void setConnectorService(IConnectorService connectorService) {
        if (this._connectorService != connectorService) {
            this._connectorService = connectorService;
            this._connectorService.registerSubSystem((ISubSystem)this);
            this.setDirty(true);
        }
    }

    public boolean supportsCaching() {
        return false;
    }

    public ICacheManager getCacheManager() {
        return null;
    }

    protected void internalConnect(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        try {
            this.getConnectorService().connect(monitor);
        }
        catch (InvocationTargetException exc) {
            throw exc;
        }
        catch (InterruptedException exc) {
            throw exc;
        }
        catch (Exception exc) {
            throw new InvocationTargetException(exc);
        }
    }

    protected void internalDisconnect(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        try {
            this.getConnectorService().disconnect(monitor);
        }
        catch (InterruptedException exc) {
            throw exc;
        }
        catch (InvocationTargetException exc) {
            throw exc;
        }
        catch (Exception exc) {
            throw new InvocationTargetException(exc);
        }
    }

    protected Object[] internalResolveFilterString(IProgressMonitor monitor, String filterString) throws InvocationTargetException, InterruptedException {
        return null;
    }

    public Object[] internalResolveFilterStrings(IProgressMonitor monitor, String[] filterStrings) throws InvocationTargetException, InterruptedException {
        Object[] children = null;
        Vector vChildren = new Vector();
        int idx = 0;
        while (idx < filterStrings.length) {
            if (monitor != null) {
                monitor.setTaskName(SubSystem.getResolvingMessage(filterStrings[idx]));
            }
            if ((children = this.internalResolveFilterString(monitor, filterStrings[idx])) != null) {
                this.addResolvedFilterStringObjects(vChildren, children, filterStrings, idx);
            }
            ++idx;
        }
        int nbrChildren = vChildren.size();
        children = new Object[nbrChildren];
        int idx2 = 0;
        while (idx2 < nbrChildren) {
            children[idx2] = vChildren.elementAt(idx2);
            ++idx2;
        }
        return children;
    }

    protected void addResolvedFilterStringObjects(Vector allChildrenSoFar, Object[] childrenForThisFilterString, String[] allFilterStrings, int currFilterStringIndex) {
        int jdx = 0;
        while (jdx < childrenForThisFilterString.length) {
            allChildrenSoFar.addElement(childrenForThisFilterString[jdx]);
            ++jdx;
        }
    }

    protected Object[] internalResolveFilterString(IProgressMonitor monitor, Object parent, String filterString) throws InvocationTargetException, InterruptedException {
        return null;
    }

    protected String getFirstParentFilterString(Object parent) {
        return "*";
    }

    protected String internalGetProperty(IProgressMonitor monitor, Object subject, String key) throws InvocationTargetException, InterruptedException {
        return null;
    }

    protected Object internalSetProperty(IProgressMonitor monitor, Object subject, String key, String value) throws InvocationTargetException, InterruptedException {
        return null;
    }

    protected String[] internalGetProperties(IProgressMonitor monitor, Object subject, String[] keys) throws InvocationTargetException, InterruptedException {
        return null;
    }

    protected Object internalSetProperties(IProgressMonitor monitor, Object subject, String[] keys, String[] values) throws InvocationTargetException, InterruptedException {
        return null;
    }

    protected IRunnableContext getRunnableContext() {
        Shell winShell;
        if (Display.getCurrent() == null) {
            return new NullRunnableContext();
        }
        IRunnableContext irc = RSEUIPlugin.getTheSystemRegistry().getRunnableContext();
        if (irc != null) {
            SystemBasePlugin.logInfo("Got runnable context from system registry");
            return irc;
        }
        IWorkbenchWindow win = SystemBasePlugin.getActiveWorkbenchWindow();
        if (win != null && (winShell = SubSystem.getActiveWorkbenchShell()) != null && !winShell.isDisposed() && winShell.isVisible()) {
            SystemBasePlugin.logInfo("Using active workbench window as runnable context");
            this.shell = winShell;
            return win;
        }
        ProgressMonitorDialog dlg = new ProgressMonitorDialog(this.shell);
        return dlg;
    }

    protected Shell getShell() {
        return this.shell;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Shell getActiveWorkbenchShell() {
        Shell result = null;
        if (!PlatformUI.isWorkbenchRunning()) return null;
        try {
            IWorkbenchWindow window = SubSystem.getActiveWorkbenchWindow();
            if (window == null) return result;
            return window.getShell();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static IWorkbenchWindow getActiveWorkbenchWindow() {
        return RSEUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
    }

    public String getName() {
        return this._name;
    }

    public void setName(String newName) {
        String oldName = this._name;
        if (oldName == null || !oldName.equals(newName)) {
            this._name = newName;
            this.setDirty(true);
        }
    }

    public String getConfigurationId() {
        return this._subsystemConfigurationId;
    }

    public void setConfigurationId(String newConfigurationId) {
        String oldFactoryId = this._subsystemConfigurationId;
        if (oldFactoryId == null || !oldFactoryId.equals(newConfigurationId)) {
            this._subsystemConfigurationId = newConfigurationId;
            this.setDirty(true);
        }
    }

    public boolean isHidden() {
        return this._hidden;
    }

    public void setHidden(boolean newHidden) {
        boolean oldHidden = this._hidden;
        if (oldHidden != newHidden) {
            this._hidden = newHidden;
            this.setDirty(true);
        }
    }

    public ISystemFilterPoolReferenceManager getFilterPoolReferenceManager() {
        return this.filterPoolReferenceManager;
    }

    public void setFilterPoolReferenceManager(ISystemFilterPoolReferenceManager newFilterPoolReferenceManager) {
        this.filterPoolReferenceManager = newFilterPoolReferenceManager;
    }

    public boolean isPrimarySubSystem() {
        return false;
    }

    public ISubSystem getPrimarySubSystem() {
        SubSystem firstSS = null;
        SystemRegistry registry = RSEUIPlugin.getTheSystemRegistry();
        ISubSystem[] sses = registry.getSubSystems(this.getHost(), false);
        int i = 0;
        while (i < sses.length) {
            ISubSystem ss = sses[i];
            if (ss.getConnectorService() == this.getConnectorService()) {
                if (firstSS == null) {
                    firstSS = ss;
                }
                if (ss.isPrimarySubSystem()) {
                    return ss;
                }
            }
            ++i;
        }
        if (firstSS == null) {
            firstSS = this;
        }
        return firstSS;
    }

    public Object getTargetForFilter(ISystemFilterReference filterRef) {
        return null;
    }

    public boolean isConnectionError() {
        return this._connectionError;
    }

    public void setConnectionError(boolean error) {
        this._connectionError = error;
    }

    public Object[] getTargetsForFilter(ISystemFilterReference filterRef) {
        return null;
    }

    public boolean contains(ISchedulingRule rule) {
        if (this.equals(rule)) {
            return true;
        }
        return rule instanceof IResource;
    }

    public boolean isConflicting(ISchedulingRule rule) {
        return this == rule;
    }

    public boolean commit() {
        return RSEUIPlugin.getThePersistenceManager().commit((ISubSystem)this);
    }

    protected class ChangeStatusJob
    extends UIJob {
        private final ISubSystem _subsystem;

        public ChangeStatusJob(ISubSystem ss) {
            super(GenericMessages.RSESubSystemOperation_Notifying_registry_message);
            this._subsystem = ss;
        }

        public IStatus runInUIThread(IProgressMonitor monitor) {
            SystemRegistry sr = RSEUIPlugin.getDefault().getSystemRegistry();
            sr.connectedStatusChange(this._subsystem, true, false);
            return Status.OK_STATUS;
        }
    }

    private class ConnectFromBackgroundJob
    extends UIJob {
        public ConnectFromBackgroundJob() {
            super(GenericMessages.RSESubSystemOperation_Connect_message);
        }

        public IStatus runInUIThread(IProgressMonitor monitor) {
            IStatus result = Status.OK_STATUS;
            try {
                SubSystem.this.connect(false);
            }
            catch (InterruptedException interruptedException) {
                result = Status.CANCEL_STATUS;
            }
            catch (Exception e) {
                e.printStackTrace();
                String excMsg = e.getMessage();
                if (excMsg == null || excMsg.length() == 0) {
                    excMsg = "Exception " + e.getClass().getName();
                }
                SystemMessage sysMsg = RSEUIPlugin.getPluginMessage("RSEG1056");
                sysMsg.makeSubstitution((Object)SubSystem.this.getHostName(), (Object)excMsg);
                result = new Status(4, "org.eclipse.rse.ui", 0, sysMsg.getLevelOneText(), (Throwable)e);
            }
            return result;
        }
    }

    public class ConnectJob
    extends SubSystemOperationJob {
        public ConnectJob() {
            super(GenericMessages.RSESubSystemOperation_Connect_message);
        }

        public void performOperation(IProgressMonitor mon) throws InterruptedException, Exception {
            String msg = null;
            int totalWorkUnits = -1;
            msg = SubSystemConfiguration.getConnectingMessage(SubSystem.this.getHostName(), SubSystem.this.getConnectorService().getPort());
            SystemBasePlugin.logInfo(msg);
            if (!SubSystem.this.implicitConnect(true, mon, msg, totalWorkUnits)) {
                throw new Exception(RSEUIPlugin.getPluginMessage("RSEG1056").makeSubstitution((Object)SubSystem.this.getHostName()).getLevelOneText());
            }
            SubSystem.this.internalConnect(mon);
        }
    }

    protected class DisconnectJob
    extends SubSystemOperationJob {
        private boolean _collapseTree;
        private SubSystem _subsystem;

        public DisconnectJob(boolean collapseTree, SubSystem subsystem) {
            super(GenericMessages.RSESubSystemOperation_Disconnect_message);
            this._collapseTree = collapseTree;
            this._subsystem = subsystem;
        }

        public void performOperation(IProgressMonitor mon) throws InterruptedException, Exception {
            SubSystem.this.internalDisconnect(mon);
            SubSystem.this._disconnecting = false;
            SubSystem.this._connectionError = false;
            Display.getDefault().asyncExec((Runnable)new PostDisconnect());
        }

        public class PostDisconnect
        implements Runnable {
            public void run() {
                SubSystem.this.getConnectorService().reset();
                SystemRegistry sr = RSEUIPlugin.getDefault().getSystemRegistry();
                sr.connectedStatusChange(DisconnectJob.this._subsystem, false, true, DisconnectJob.this._collapseTree);
            }
        }
    }

    public static class DisplayErrorMessageJob
    extends WorkbenchJob {
        private Shell shell;
        private SystemMessageException msgExc;

        public DisplayErrorMessageJob(Shell shell, SystemMessageException msgExc) {
            super("");
            this.shell = shell;
            this.msgExc = msgExc;
        }

        public IStatus runInUIThread(IProgressMonitor monitor) {
            if (!(this.shell == null || !this.shell.isDisposed() && this.shell.isEnabled() && this.shell.isVisible())) {
                this.shell = null;
            }
            if (this.shell == null) {
                Shell[] shells = Display.getCurrent().getShells();
                int i = 0;
                while (i < shells.length && this.shell == null) {
                    if (!shells[i].isDisposed() && shells[i].isVisible() && shells[i].isEnabled()) {
                        this.shell = shells[i];
                    }
                    ++i;
                }
            }
            if (this.shell != null) {
                SystemMessageDialog.displayMessage(this.shell, this.msgExc);
            }
            return Status.OK_STATUS;
        }
    }

    protected class GetPropertiesJob
    extends SubSystemOperationJob {
        protected Object _subject;
        protected String[] _keys;

        public GetPropertiesJob(Object subject, String[] keys) {
            super(GenericMessages.RSESubSystemOperation_Get_properties_message);
            this._subject = subject;
            this._keys = keys;
        }

        public void performOperation(IProgressMonitor mon) throws InterruptedException, InvocationTargetException, Exception {
            String msg = null;
            int totalWorkUnits = -1;
            msg = SubSystem.getQueryingMessage();
            if (!SubSystem.this.implicitConnect(false, mon, msg, totalWorkUnits)) {
                throw new Exception(RSEUIPlugin.getPluginMessage("RSEG1056").makeSubstitution((Object)SubSystem.this.getHostName()).getLevelOneText());
            }
            this.runOutputStrings = SubSystem.this.internalGetProperties(mon, this._subject, this._keys);
        }
    }

    protected class GetPropertyJob
    extends SubSystemOperationJob {
        protected Object _subject;
        protected String _key;

        public GetPropertyJob(Object subject, String key) {
            super(GenericMessages.RSESubSystemOperation_Get_property_message);
            this._subject = subject;
            this._key = key;
        }

        public void performOperation(IProgressMonitor mon) throws InterruptedException, InvocationTargetException, Exception {
            String msg = null;
            int totalWorkUnits = -1;
            msg = SubSystem.getQueryingMessage(this._key);
            if (!SubSystem.this.implicitConnect(false, mon, msg, totalWorkUnits)) {
                throw new Exception(RSEUIPlugin.getPluginMessage("RSEG1056").makeSubstitution((Object)SubSystem.this.getHostName()).getLevelOneText());
            }
            this.runOutputStrings = new String[]{SubSystem.this.internalGetProperty(mon, this._subject, this._key)};
        }
    }

    private class NullRunnableContext
    implements IRunnableContext {
        private NullRunnableContext() {
        }

        public void run(boolean fork, boolean cancelable, IRunnableWithProgress runnable) throws InvocationTargetException, InterruptedException {
            NullProgressMonitor monitor = new NullProgressMonitor();
            runnable.run((IProgressMonitor)monitor);
        }
    }

    protected class ResolveAbsoluteJob
    extends SubSystemOperationJob {
        protected String _filterString;

        public ResolveAbsoluteJob(String filterString) {
            super(GenericMessages.RSESubSystemOperation_Resolve_filter_strings_message);
            this._filterString = filterString;
        }

        public void performOperation(IProgressMonitor mon) throws InterruptedException, InvocationTargetException, Exception {
            String msg = null;
            int totalWorkUnits = -1;
            msg = SubSystem.getResolvingMessage(this._filterString);
            if (!SubSystem.this.implicitConnect(false, mon, msg, totalWorkUnits)) {
                throw new Exception(RSEUIPlugin.getPluginMessage("RSEG1056").makeSubstitution((Object)SubSystem.this.getHostName()).getLevelOneText());
            }
            this.runOutputs = SubSystem.this.internalResolveFilterString(mon, this._filterString);
        }
    }

    protected class ResolveAbsolutesJob
    extends SubSystemOperationJob {
        protected String _filterString;
        protected String[] _filterStrings;

        public ResolveAbsolutesJob(String filterString, String[] filterStrings) {
            super(GenericMessages.RSESubSystemOperation_Resolve_filter_strings_message);
            this._filterString = filterString;
            this._filterStrings = filterStrings;
        }

        public void performOperation(IProgressMonitor mon) throws InterruptedException, InvocationTargetException, Exception {
            String msg = null;
            int totalWorkUnits = -1;
            msg = SubSystem.getResolvingMessage(this._filterString);
            if (!SubSystem.this.implicitConnect(false, mon, msg, totalWorkUnits)) {
                throw new Exception(RSEUIPlugin.getPluginMessage("RSEG1056").makeSubstitution((Object)SubSystem.this.getHostName()).getLevelOneText());
            }
            this.runOutputs = SubSystem.this.internalResolveFilterStrings(mon, this._filterStrings);
        }
    }

    protected class ResolveRelativeJob
    extends SubSystemOperationJob {
        protected String _filterString;
        protected Object _parent;

        public ResolveRelativeJob(String filterString, Object parent) {
            super(GenericMessages.RSESubSystemOperation_Resolve_filter_strings_message);
            this._filterString = filterString;
            this._parent = parent;
        }

        public void performOperation(IProgressMonitor mon) throws InterruptedException, InvocationTargetException, Exception {
            String msg = null;
            int totalWorkUnits = -1;
            if (this._filterString == null) {
                this._filterString = "*";
            }
            if (!SubSystem.this.implicitConnect(false, mon, msg = SubSystem.getResolvingMessage(this._filterString), totalWorkUnits)) {
                throw new Exception(RSEUIPlugin.getPluginMessage("RSEG1056").makeSubstitution((Object)SubSystem.this.getHostName()).getLevelOneText());
            }
            this.runOutputs = SubSystem.this.internalResolveFilterString(mon, this._parent, this._filterString);
        }
    }

    protected class SetPropertiesJob
    extends SubSystemOperationJob {
        protected Object _subject;
        protected String[] _keys;
        protected String[] _values;

        public SetPropertiesJob(Object subject, String[] keys, String[] values) {
            super(GenericMessages.RSESubSystemOperation_Set_properties_message);
            this._subject = subject;
            this._keys = keys;
            this._values = values;
        }

        public void performOperation(IProgressMonitor mon) throws InterruptedException, InvocationTargetException, Exception {
            String msg = null;
            int totalWorkUnits = -1;
            msg = SubSystem.getSettingMessage();
            if (!SubSystem.this.implicitConnect(false, mon, msg, totalWorkUnits)) {
                throw new Exception(RSEUIPlugin.getPluginMessage("RSEG1056").makeSubstitution((Object)SubSystem.this.getHostName()).getLevelOneText());
            }
            this.runOutputs = new Object[]{SubSystem.this.internalSetProperties(mon, this._subject, this._keys, this._values)};
        }
    }

    protected class SetPropertyJob
    extends SubSystemOperationJob {
        protected Object _subject;
        protected String _key;
        protected String _value;

        public SetPropertyJob(Object subject, String key, String value) {
            super(GenericMessages.RSESubSystemOperation_Set_property_message);
            this._subject = subject;
            this._key = key;
            this._value = value;
        }

        public void performOperation(IProgressMonitor mon) throws InterruptedException, InvocationTargetException, Exception {
            String msg = null;
            int totalWorkUnits = -1;
            msg = SubSystem.getSettingMessage(this._key);
            if (!SubSystem.this.implicitConnect(false, mon, msg, totalWorkUnits)) {
                throw new Exception(RSEUIPlugin.getPluginMessage("RSEG1056").makeSubstitution((Object)SubSystem.this.getHostName()).getLevelOneText());
            }
            this.runOutputs = new Object[]{SubSystem.this.internalSetProperty(mon, this._subject, this._key, this._value)};
        }
    }

    protected abstract class SubSystemOperationJob
    extends Job {
        protected Object[] runOutputs;
        protected String[] runOutputStrings;
        protected boolean _hasStarted = false;

        public SubSystemOperationJob(String operationName) {
            super(String.valueOf(operationName) + " (" + GenericMessages.RSESubSystemOperation_message + ")");
        }

        public abstract void performOperation(IProgressMonitor var1) throws InterruptedException, InvocationTargetException, Exception;

        public Object[] getOutputs() {
            return this.runOutputs;
        }

        public String[] getOutputStrings() {
            return this.runOutputStrings;
        }

        public IStatus runInContext(IRunnableContext context) {
            this._hasStarted = true;
            ContextRunnable conRun = new ContextRunnable(this);
            try {
                context.run(false, true, (IRunnableWithProgress)conRun);
                return conRun.getStatus();
            }
            catch (Exception e) {
                String excMsg = e.getMessage();
                if (excMsg == null || excMsg.length() == 0) {
                    excMsg = "Exception " + e.getClass().getName();
                }
                SystemMessage sysMsg = RSEUIPlugin.getPluginMessage("RSEG1066");
                sysMsg.makeSubstitution((Object)excMsg);
                return new Status(4, "org.eclipse.rse.ui", 0, sysMsg.getLevelOneText(), (Throwable)e);
            }
        }

        public boolean hasStarted() {
            return this._hasStarted;
        }

        public IStatus run(IProgressMonitor monitor) {
            this._hasStarted = true;
            try {
                this.performOperation(monitor);
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                monitor.done();
                return Status.OK_STATUS;
            }
            catch (InterruptedException interruptedException) {
                monitor.done();
                return Status.CANCEL_STATUS;
            }
            catch (InvocationTargetException exc) {
                monitor.done();
                String excMsg = exc.getTargetException().getMessage();
                if (excMsg == null || excMsg.length() == 0) {
                    excMsg = "Exception " + exc.getTargetException().getClass().getName();
                }
                return new Status(4, "org.eclipse.rse.ui", 0, excMsg, exc.getTargetException());
            }
            catch (Exception exc) {
                monitor.done();
                String excMsg = exc.getMessage();
                if (excMsg == null || excMsg.length() == 0) {
                    excMsg = "Exception " + exc.getClass().getName();
                }
                SystemMessage sysMsg = RSEUIPlugin.getPluginMessage("RSEG1066");
                sysMsg.makeSubstitution((Object)excMsg);
                return new Status(4, "org.eclipse.rse.ui", 0, sysMsg.getLevelOneText(), (Throwable)exc);
            }
        }

        public class ContextRunnable
        implements IRunnableWithProgress {
            private SubSystemOperationJob _job;
            private IStatus _status;

            public ContextRunnable(SubSystemOperationJob job) {
                this._job = job;
            }

            public void run(IProgressMonitor monitor) {
                this._status = this._job.run(monitor);
            }

            public IStatus getStatus() {
                return this._status;
            }
        }
    }

    public class SystemMessageDialogRunnable
    implements Runnable {
        private SystemMessageDialog _dlg;

        public SystemMessageDialogRunnable(SystemMessageDialog dlg) {
            this._dlg = dlg;
        }

        public void run() {
            this._dlg.open();
        }
    }
}

