/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.filters;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.rse.core.filters.IRSEFilterNamingPolicy;
import org.eclipse.rse.core.filters.ISystemFilter;
import org.eclipse.rse.core.filters.ISystemFilterContainer;
import org.eclipse.rse.core.filters.ISystemFilterPool;
import org.eclipse.rse.core.filters.ISystemFilterPoolManager;
import org.eclipse.rse.core.filters.ISystemFilterPoolManagerProvider;
import org.eclipse.rse.core.filters.ISystemFilterString;
import org.eclipse.rse.core.references.IRSEReferencedObject;
import org.eclipse.rse.internal.filters.SystemFilterContainerCommonMethods;
import org.eclipse.rse.internal.filters.SystemFilterString;
import org.eclipse.rse.internal.references.SystemReferencedObject;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.rse.ui.SystemResources;

public class SystemFilter
extends SystemReferencedObject
implements ISystemFilter,
IRSEReferencedObject,
ISystemFilterContainer,
IAdaptable {
    protected static final String NAME_EDEFAULT = null;
    private SystemFilterContainerCommonMethods helpers = null;
    private ISystemFilterPool parentPool = null;
    protected String[] filterStringArray = null;
    protected ISystemFilterString[] filterStringObjectArray = null;
    protected Vector filterStringVector = null;
    protected static boolean debug = true;
    protected String name = NAME_EDEFAULT;
    protected static final String TYPE_EDEFAULT = null;
    protected String type = TYPE_EDEFAULT;
    protected static final boolean SUPPORTS_NESTED_FILTERS_EDEFAULT = false;
    protected boolean supportsNestedFilters = false;
    protected static final int RELATIVE_ORDER_EDEFAULT = 0;
    protected int relativeOrder = 0;
    protected static final boolean DEFAULT_EDEFAULT = false;
    protected boolean default_ = false;
    protected static final boolean STRINGS_CASE_SENSITIVE_EDEFAULT = false;
    protected boolean stringsCaseSensitive = false;
    protected static final boolean PROMPTABLE_EDEFAULT = false;
    protected boolean promptable = false;
    protected static final boolean SUPPORTS_DUPLICATE_FILTER_STRINGS_EDEFAULT = false;
    protected boolean supportsDuplicateFilterStrings = false;
    protected static final boolean NON_DELETABLE_EDEFAULT = false;
    protected boolean nonDeletable = false;
    protected static final boolean NON_RENAMABLE_EDEFAULT = false;
    protected boolean nonRenamable = false;
    protected static final boolean NON_CHANGABLE_EDEFAULT = false;
    protected boolean nonChangable = false;
    protected static final boolean STRINGS_NON_CHANGABLE_EDEFAULT = false;
    protected boolean stringsNonChangable = false;
    protected static final int RELEASE_EDEFAULT = 0;
    protected int release = 0;
    protected static final boolean SINGLE_FILTER_STRING_ONLY_EDEFAULT = false;
    protected boolean singleFilterStringOnly = false;
    protected List nestedFilters = null;
    protected List strings = null;
    protected ISystemFilter _parentFilter;

    protected SystemFilter() {
        this.helpers = new SystemFilterContainerCommonMethods();
    }

    protected List internalGetFilters() {
        return this.getNestedFilters();
    }

    public String getType() {
        String type = this.getTypeGen();
        if (type == null) {
            return "default";
        }
        return type;
    }

    public String getTypeGen() {
        return this.type;
    }

    public ISystemFilter createSystemFilter(String aliasName, Vector filterStrings) {
        ISystemFilter newFilter = this.helpers.createSystemFilter(this.internalGetFilters(), this.getParentFilterPool(), aliasName, filterStrings);
        newFilter.setSupportsNestedFilters(true);
        newFilter.setSupportsDuplicateFilterStrings(this.supportsDuplicateFilterStrings());
        newFilter.setStringsCaseSensitive(this.areStringsCaseSensitive());
        return newFilter;
    }

    public void initializeFilterStrings() {
        List filterStrings = this.getStrings();
        Iterator i = filterStrings.iterator();
        while (i.hasNext()) {
            ((ISystemFilterString)i.next()).setParentSystemFilter((ISystemFilter)this);
        }
    }

    public void clone(ISystemFilter targetFilter) {
        ISystemFilter[] filters;
        ISystemFilterString[] strings;
        targetFilter.setDefault(this.isDefault());
        targetFilter.setType(this.getType());
        targetFilter.setPromptable(this.isPromptable());
        targetFilter.setRelativeOrder(this.getRelativeOrder());
        targetFilter.setSupportsNestedFilters(this.isSupportsNestedFilters());
        targetFilter.setSupportsDuplicateFilterStrings(this.isSupportsDuplicateFilterStrings());
        targetFilter.setStringsNonChangable(this.isStringsNonChangable());
        targetFilter.setNonChangable(this.isNonChangable());
        targetFilter.setNonDeletable(this.isNonDeletable());
        targetFilter.setNonRenamable(this.isNonRenamable());
        if (this.isSetSingleFilterStringOnly()) {
            targetFilter.setSingleFilterStringOnly(this.isSingleFilterStringOnly());
        }
        if (this.isSetStringsCaseSensitive()) {
            targetFilter.setStringsCaseSensitive(this.isStringsCaseSensitive());
        }
        if ((strings = this.getSystemFilterStrings()) != null) {
            int idx = 0;
            while (idx < strings.length) {
                this.copySystemFilterString(targetFilter, strings[idx]);
                ++idx;
            }
        }
        if ((filters = this.getSystemFilters()) != null) {
            int idx = 0;
            while (idx < filters.length) {
                ISystemFilter newFilter = targetFilter.createSystemFilter(filters[idx].getName(), null);
                filters[idx].clone(newFilter);
                ++idx;
            }
        }
    }

    public ISystemFilterString copySystemFilterString(ISystemFilter targetFilter, ISystemFilterString oldFilterString) {
        ISystemFilterString newString = targetFilter.addFilterString(null);
        oldFilterString.clone(newString);
        return newString;
    }

    public ISystemFilterPool getSystemFilterPool() {
        return this.getParentFilterPool();
    }

    public boolean isTransient() {
        return false;
    }

    public boolean supportsNestedFilters() {
        return this.isSupportsNestedFilters();
    }

    public boolean supportsDuplicateFilterStrings() {
        return this.isSupportsDuplicateFilterStrings();
    }

    public boolean isNested() {
        return this.getParentFilter() != null;
    }

    public boolean isStringsCaseSensitive() {
        if (!this.isSetStringsCaseSensitive()) {
            return this.getParentFilterPool().isStringsCaseSensitive();
        }
        return this.stringsCaseSensitive;
    }

    public boolean areStringsCaseSensitive() {
        return this.isStringsCaseSensitive();
    }

    public Vector getSystemFilterNames() {
        return this.helpers.getSystemFilterNames(this.internalGetFilters());
    }

    public Vector getSystemFiltersVector() {
        return this.helpers.getSystemFiltersVector(this.internalGetFilters());
    }

    public ISystemFilter[] getSystemFilters() {
        return this.helpers.getSystemFilters(this.internalGetFilters());
    }

    public int getSystemFilterCount() {
        return this.internalGetFilters().size();
    }

    public ISystemFilter getSystemFilter(String aliasName) {
        return this.helpers.getSystemFilter(this.internalGetFilters(), aliasName);
    }

    public boolean addSystemFilter(ISystemFilter filter) {
        return this.helpers.addSystemFilter(this.internalGetFilters(), filter);
    }

    public void deleteSystemFilter(ISystemFilter filter) {
        this.helpers.deleteSystemFilter(this.internalGetFilters(), filter);
    }

    public void renameSystemFilter(ISystemFilter filter, String newName) {
        this.helpers.renameSystemFilter(this.internalGetFilters(), filter, newName);
    }

    public void updateSystemFilter(ISystemFilter filter, String newName, String[] newStrings) {
        this.helpers.updateSystemFilter(this.internalGetFilters(), filter, newName, newStrings);
    }

    public ISystemFilter cloneSystemFilter(ISystemFilter filter, String aliasName) {
        return this.helpers.cloneSystemFilter(this.internalGetFilters(), filter, aliasName);
    }

    public int getSystemFilterPosition(ISystemFilter filter) {
        return this.helpers.getSystemFilterPosition(this.internalGetFilters(), filter);
    }

    public void moveSystemFilter(int pos, ISystemFilter filter) {
        this.helpers.moveSystemFilter(this.internalGetFilters(), pos, filter);
    }

    public ISystemFilterPool getParentFilterPool() {
        return this.parentPool;
    }

    public void setParentFilterPool(ISystemFilterPool parentPool) {
        this.parentPool = parentPool;
        ISystemFilter[] filters = this.getSystemFilters();
        if (filters != null) {
            int idx = 0;
            while (idx < filters.length) {
                filters[idx].setParentFilterPool(parentPool);
                ++idx;
            }
        }
    }

    public ISystemFilterContainer getParentFilterContainer() {
        ISystemFilter parentFilter = this.getParentFilter();
        return parentFilter != null ? parentFilter : this.getParentFilterPool();
    }

    private List internalGetFilterStrings() {
        return this.getStrings();
    }

    protected void invalidateCache() {
        this.filterStringArray = null;
        this.filterStringObjectArray = null;
        this.filterStringVector = null;
        this.setDirty(true);
    }

    public String[] getFilterStrings() {
        if (this.filterStringArray == null) {
            List el = this.internalGetFilterStrings();
            this.filterStringArray = new String[el.size()];
            Iterator i = el.iterator();
            int idx = 0;
            while (i.hasNext()) {
                this.filterStringArray[idx++] = ((ISystemFilterString)i.next()).getString();
            }
        }
        return this.filterStringArray;
    }

    public Vector getFilterStringsVector() {
        if (this.filterStringVector == null) {
            List el = this.internalGetFilterStrings();
            Iterator i = el.iterator();
            this.filterStringVector = new Vector();
            while (i.hasNext()) {
                this.filterStringVector.addElement(((ISystemFilterString)i.next()).getString());
            }
        }
        return this.filterStringVector;
    }

    public Vector getFilterStringObjectsVector() {
        List el = this.internalGetFilterStrings();
        Iterator i = el.iterator();
        Vector filterStringVector = new Vector();
        while (i.hasNext()) {
            filterStringVector.addElement(i.next());
        }
        return filterStringVector;
    }

    public int getFilterStringCount() {
        return this.internalGetFilterStrings().size();
    }

    public ISystemFilterString getSystemFilterString(String string) {
        ISystemFilterString[] strings = this.getSystemFilterStrings();
        ISystemFilterString match = null;
        boolean cs = this.areStringsCaseSensitive();
        if (strings != null) {
            int idx = 0;
            while (match == null && idx < strings.length) {
                if (cs) {
                    if (string.equals(strings[idx].getString())) {
                        match = strings[idx];
                    }
                } else if (string.equalsIgnoreCase(strings[idx].getString())) {
                    match = strings[idx];
                }
                ++idx;
            }
        }
        return match;
    }

    public void setFilterStrings(Vector newStrings) {
        List strings = this.internalGetFilterStrings();
        strings.clear();
        int idx = 0;
        while (idx < newStrings.size()) {
            String currString = (String)newStrings.elementAt(idx);
            SystemFilterString string = new SystemFilterString();
            string.setString(currString);
            string.setParentSystemFilter(this);
            strings.add(string);
            ++idx;
        }
        this.invalidateCache();
    }

    public ISystemFilterString[] getSystemFilterStrings() {
        if (this.filterStringObjectArray == null) {
            List el = this.internalGetFilterStrings();
            this.filterStringObjectArray = new ISystemFilterString[el.size()];
            Iterator i = el.iterator();
            int idx = 0;
            while (i.hasNext()) {
                this.filterStringObjectArray[idx++] = (ISystemFilterString)i.next();
            }
        }
        return this.filterStringObjectArray;
    }

    public void setFilterStrings(String[] newStrings) {
        List strings = this.internalGetFilterStrings();
        strings.clear();
        int idx = 0;
        while (idx < newStrings.length) {
            this.addFilterString(newStrings[idx]);
            ++idx;
        }
    }

    private ISystemFilterString createFilterString(String string) {
        SystemFilterString filterstring = new SystemFilterString();
        filterstring.setString(string);
        filterstring.setParentSystemFilter(this);
        return filterstring;
    }

    public ISystemFilterString addFilterString(String newString) {
        List strings = this.internalGetFilterStrings();
        ISystemFilterString newFilterString = this.createFilterString(newString);
        strings.add(newFilterString);
        this.invalidateCache();
        return newFilterString;
    }

    public ISystemFilterString addFilterString(String newString, int position) {
        List strings = this.internalGetFilterStrings();
        ISystemFilterString newFilterString = this.createFilterString(newString);
        strings.add(position, newFilterString);
        this.invalidateCache();
        return newFilterString;
    }

    public void updateFilterString(ISystemFilterString filterString, String newValue) {
        filterString.setString(newValue);
    }

    public ISystemFilterString removeFilterString(String oldString) {
        List strings = this.internalGetFilterStrings();
        ISystemFilterString match = null;
        Iterator i = strings.iterator();
        while (match == null && i.hasNext()) {
            ISystemFilterString currstring = (ISystemFilterString)i.next();
            if (!currstring.getString().equals(oldString)) continue;
            match = currstring;
        }
        if (match != null) {
            strings.remove(match);
            this.invalidateCache();
        }
        return match;
    }

    public ISystemFilterString removeFilterString(int position) {
        List strings = this.internalGetFilterStrings();
        if (position >= strings.size()) {
            return null;
        }
        ISystemFilterString filterString = (ISystemFilterString)strings.get(position);
        strings.remove(position);
        this.invalidateCache();
        return filterString;
    }

    public boolean removeFilterString(ISystemFilterString filterString) {
        List strings = this.internalGetFilterStrings();
        if (strings.contains(filterString)) {
            strings.remove(filterString);
            this.invalidateCache();
            return true;
        }
        return false;
    }

    public void moveSystemFilterString(int pos, ISystemFilterString filterString) {
        this.invalidateCache();
    }

    public Object getAdapter(Class adapterType) {
        return Platform.getAdapterManager().getAdapter((Object)this, adapterType);
    }

    public Object[] getChildren() {
        Vector strings = this.getFilterStringsVector();
        Vector filters = this.getSystemFiltersVector();
        Vector vChildren = new Vector();
        int idx = 0;
        while (idx < filters.size()) {
            vChildren.addElement(filters.elementAt(idx));
            ++idx;
        }
        idx = 0;
        while (idx < strings.size()) {
            String filterString = (String)strings.elementAt(idx);
            vChildren.addElement(filterString);
            ++idx;
        }
        Object[] children = new Object[vChildren.size()];
        int idx2 = 0;
        while (idx2 < vChildren.size()) {
            children[idx2] = vChildren.elementAt(idx2);
            ++idx2;
        }
        return children;
    }

    public boolean hasChildren() {
        if (this.internalGetFilterStrings().size() > 0) {
            return true;
        }
        return this.helpers.hasSystemFilters(this.internalGetFilters());
    }

    public ISystemFilterPoolManagerProvider getProvider() {
        ISystemFilterPoolManager mgr = this.getSystemFilterPoolManager();
        if (mgr != null) {
            return mgr.getProvider();
        }
        return null;
    }

    public ISystemFilterPoolManager getSystemFilterPoolManager() {
        ISystemFilterPool pool = this.getParentFilterPool();
        if (pool != null) {
            return pool.getSystemFilterPoolManager();
        }
        return null;
    }

    public static ISystemFilter restore(IFolder folder, String name, ISystemFilterPool parentPool, IRSEFilterNamingPolicy namingPolicy) throws Exception {
        return null;
    }

    protected static String getRootSaveFileName(ISystemFilter filter) {
        return SystemFilter.getRootSaveFileName(SystemFilter.getNamingPolicy(filter), filter.getName());
    }

    protected static String getRootSaveFileName(IRSEFilterNamingPolicy namingPolicy, String name) {
        return namingPolicy.getFilterSaveFileName(name);
    }

    protected static IRSEFilterNamingPolicy getNamingPolicy(ISystemFilter filter) {
        return filter.getParentFilterPool().getNamingPolicy();
    }

    public static String addPathTerminator(String path) {
        if (!path.endsWith(File.separator)) {
            path = String.valueOf(path) + File.separatorChar;
        }
        return path;
    }

    public String toString() {
        return this.getName();
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return SystemResources.RESID_MODELOBJECTS_FILTER_DESCRIPTION;
    }

    public void setName(String newName) {
        this.name = newName;
    }

    public void setType(String newType) {
        this.type = newType;
        this._isDirty = true;
    }

    public boolean isSupportsNestedFilters() {
        return this.supportsNestedFilters;
    }

    public void setSupportsNestedFilters(boolean newSupportsNestedFilters) {
        boolean oldSupportsNestedFilters = this.supportsNestedFilters;
        if (oldSupportsNestedFilters != newSupportsNestedFilters) {
            this.supportsNestedFilters = newSupportsNestedFilters;
            this.setDirty(true);
        }
    }

    public int getRelativeOrder() {
        return this.relativeOrder;
    }

    public void setRelativeOrder(int newRelativeOrder) {
        this.relativeOrder = newRelativeOrder;
    }

    public boolean isDefault() {
        return this.default_;
    }

    public void setDefault(boolean newDefault) {
        this.default_ = newDefault;
    }

    public void setStringsCaseSensitive(boolean newStringsCaseSensitive) {
        boolean oldStringsCaseSensitive = this.stringsCaseSensitive;
        if (oldStringsCaseSensitive != newStringsCaseSensitive) {
            this.stringsCaseSensitive = newStringsCaseSensitive;
            this.setDirty(true);
        }
    }

    public void unsetStringsCaseSensitive() {
        boolean oldStringsCaseSensitive = this.stringsCaseSensitive;
        if (oldStringsCaseSensitive) {
            this.stringsCaseSensitive = false;
            this.setDirty(true);
        }
    }

    public boolean isSetStringsCaseSensitive() {
        return this.stringsCaseSensitive;
    }

    public boolean isPromptable() {
        return this.promptable;
    }

    public void setPromptable(boolean newPromptable) {
        this.promptable = newPromptable;
    }

    public ISystemFilter getParentFilter() {
        return this._parentFilter;
    }

    public void setParentFilter(ISystemFilter newParentFilter) {
        this._parentFilter = newParentFilter;
    }

    public List getNestedFilters() {
        if (this.nestedFilters == null) {
            this.nestedFilters = new ArrayList();
        }
        return this.nestedFilters;
    }

    public List getStrings() {
        if (this.strings == null) {
            this.strings = new ArrayList();
        }
        return this.strings;
    }

    public boolean isSupportsDuplicateFilterStrings() {
        return this.supportsDuplicateFilterStrings;
    }

    public void setSupportsDuplicateFilterStrings(boolean newSupportsDuplicateFilterStrings) {
        boolean oldSupportsDuplicateFilterStrings = this.supportsDuplicateFilterStrings;
        if (oldSupportsDuplicateFilterStrings != newSupportsDuplicateFilterStrings) {
            this.supportsDuplicateFilterStrings = newSupportsDuplicateFilterStrings;
            this.setDirty(true);
        }
    }

    public boolean isNonDeletable() {
        return this.nonDeletable;
    }

    public void setNonDeletable(boolean newNonDeletable) {
        this.nonDeletable = newNonDeletable;
    }

    public boolean isNonRenamable() {
        return this.nonRenamable;
    }

    public void setNonRenamable(boolean newNonRenamable) {
        this.nonRenamable = newNonRenamable;
    }

    public boolean isNonChangable() {
        return this.nonChangable;
    }

    public void setNonChangable(boolean newNonChangable) {
        this.nonChangable = newNonChangable;
    }

    public boolean isStringsNonChangable() {
        return this.stringsNonChangable;
    }

    public void setStringsNonChangable(boolean newStringsNonChangable) {
        boolean oldStringsNonChangable = this.stringsNonChangable;
        if (oldStringsNonChangable != newStringsNonChangable) {
            this.stringsNonChangable = newStringsNonChangable;
            this.setDirty(true);
        }
    }

    public int getRelease() {
        return this.release;
    }

    public void setRelease(int newRelease) {
        this.release = newRelease;
    }

    public boolean isSingleFilterStringOnly() {
        if (this.isSetSingleFilterStringOnly()) {
            return this.singleFilterStringOnly;
        }
        return this.getSystemFilterPool().isSingleFilterStringOnly();
    }

    public boolean isSingleFilterStringOnlyGen() {
        return this.singleFilterStringOnly;
    }

    public void setSingleFilterStringOnly(boolean newSingleFilterStringOnly) {
        boolean oldSingleFilterStringOnly = this.singleFilterStringOnly;
        if (oldSingleFilterStringOnly != newSingleFilterStringOnly) {
            this.singleFilterStringOnly = newSingleFilterStringOnly;
            this.setDirty(true);
        }
    }

    public void unsetSingleFilterStringOnly() {
        boolean oldSingleFilterStringOnly = this.singleFilterStringOnly;
        if (oldSingleFilterStringOnly) {
            this.singleFilterStringOnly = false;
            this.setDirty(true);
        }
    }

    public boolean isSetSingleFilterStringOnly() {
        return this.singleFilterStringOnly;
    }

    public boolean commit() {
        return RSEUIPlugin.getThePersistenceManager().commit((ISystemFilter)this);
    }
}

